> * 原文地址：[Top Node.js Frameworks to use in 2021](https://javascript.plainenglish.io/top-node-js-frameworks-to-use-in-2021-4951ee5940b8)
> * 原文作者：[Ronak Patel](https://medium.com/@ronakataglowid)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/top-node-js-frameworks-to-use-in-2021.md](https://github.com/xitu/gold-miner/blob/master/article/2021/top-node-js-frameworks-to-use-in-2021.md)
> * 译者：[洛竹](https://github.com/youngjuning)
> * 校对者：[PassionPenguin](https://github.com/PassionPenguin)、[xilihuasi](https://github.com/xilihuasi)

# 2021 年最值得使用的 Node.js 框架

![最值得使用的 Node.js 框架](https://cdn-images-1.medium.com/max/2400/1*9lmHM-CypCHEOtNd_dfRRw.png)

Node.js 是最敏捷的服务端 web 应用平台，因为它为应用开发公司提供了构建可扩展的单一编程语言 web 平台的便利。它是最热门的开源的 JavaScript 运行时框架之一，具有跨平台属性，让我们可以在浏览器以外的环境运行代码。

## Node.js 的特别之处是什么？

1. 它有一个干净简洁的代码库。
2. 它最适合敏捷开发和原型设计。
3. 它有一个庞大的生态系统以提供开源库。
4. 它可以用于更快地开发企业级可扩展的应用程序。
5. 它基于最常用的编程语言 —— JavaScript。

## 市场对 Node.js 的反应如何？

![NPM 趋势](https://cdn-images-1.medium.com/max/2366/1*4kohl3kB8tfsqcJY-f3xlA.png)

图片来源：[npmtrends](https://www.npmtrends.com/nodejs)

**下面是一些关于 Node.js 的更多信息：**

* Amazon、Netflix、LinkedIn、eBay、PayPal 和 Reddit 使用 Node.js 作为他们的后端框架。
* 43% 的 Node.js 开发者使用这个框架创建企业级应用
* Paypal 注意到改用 Node.js 后，平均响应时间显著缩短了 35%。
* Node.js 可以将任何现有应用的性能提高 50%。
* Node.js 降低了 58% 的应用开发成本。
* Statista 提到，截至 2020 年初，Node 是开发者中使用最多的框架，占 51.4%。

## 使用 Node.js 框架的收益

* 易扩展性
* 学习曲线低
* JavaScript 全栈开发
* 庞大而活跃的社区
* 使用单一的代码库，以提高整体 web 性能。

## 2021 年最值得用的 Node.js 框架

我们已经介绍了 Node.js，并详细地了解了它的功能，现在我们可以讨论 2021 年最值得使用的 Node.js 框架啦。

### 1. Hapi.js

- **GitHub**
  - **Stars**：13.1k
  - **Forks**：1.3k
  - **版本**：v20.1.0
  - **贡献者**：208
  - **使用人数**：16.5k
- **NPM 周下载量**：105,065
- **License**：BSD-3-Clause

![Hapi.js 框架流行度](https://cdn-images-1.medium.com/max/2316/1*bnq7cugj6hQYaLYlY2a53w.png)

Hapi.js 是众多开发者信赖的最简单、安全、可靠的框架之一。你可以使用 Hapi.js 来创建可扩展和健壮的应用程序，它具有最小的开销和开箱即用的功能。它是开发 JSON API 的顶级[Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/)框架。

**Hapi.js 可以被用于：**

* 网站
* HTTP 代理应用
* 应用程序接口服务

**Hapi.js 主要特性：**

* 输入验证
* 日志
* 错误处理
* 代码可重用性
* 缓存
* 没有外部依赖
* 基于配置的功能
* 集成框架：在 Node 框架中提供全面的认证和授权 API 支持。

**什么时候使用 Hapi.js：**

Hapi.js 是开发安全、实时、可扩展和社交媒体应用的理想选择。大多数移动应用开发者都喜欢用 Hapi.js 来创建代理和 API 服务器。

**谁在使用 Hapi.js：**

* Commercetools
* Main Stack
* Beam
* Taggun
* Artifakt

### 2. Express.js

- **GitHub**
  - **Stars**：52.3k
  - **Forks**：8.8k
  - **版本**：v4.17.1
  - **贡献者**：262
  - **使用人数**：9.2m
- **NPM 周下载量**：17,193,915
- **License**：MIT

![Express.js 流行度](https://cdn-images-1.medium.com/max/2080/1*oV-DuccRP7WvxgSabkTNqQ.png)

Express.js 是一个灵活而简约的 Node.js 应用框架。这个插件并不是围绕着特定的组件构建的，因此它并不限制你使用什么技术。这就给了开发者尝试的自由。他们还可以获得闪电般的配置和纯 JavaScript 体验，这些特性使 Express.js 成为快速原型设计和敏捷开发市场的有力竞争者。

**Express.js 可以被用于：**

* 单页应用
* 多页应用
* 混合应用

**Express.js 主要特性：**

* 更快的服务端开发
* 赋能开发者更快地构建 RESTful API
* Express 支持 MVC 架构，但需要开发者做一些额外工作
* 开箱支持 NoSQL 数据库

**什么时候使用 Express.js：**

Express.js 是快速创建 Web 应用程序和服务的理想选择，因为它有现成的 API 生成工具。它是基于 JavaScript 的全栈方案 MEAN 的一部分。这意味着你可以使用 Express.js 来制作任何基于浏览器的企业级应用。

**谁在使用 Express.js：**

* FindHotel
* Omnipresent
* Okay
* SiHub
* TheDoe

### 3. Nest.js

- **Github**
  - **Stars**：35.5k
  - **Forks**：3.4k
  - **版本**：7.5.0
  - **贡献者**：226
  - **使用人数**：60.4k
- **NPM 周下载量**：508,214
- **License**：MIT

![Nest.js 流行度](https://cdn-images-1.medium.com/max/2000/1*uTZrckIaqRi2BolefxaVTg.png)

Nest.js 是一个服务器端应用框架，它是为了解放开发者的生产力，让他们的生活变得更轻松而打造的。开发者通常为了更好地组织和管理代码而使用这个 Node.js 框架。

**Nest.js 可以被用于：**

* 编写更清晰和可重用的代码。
* 编写具有更高层次结构的代码，如拦截器、过滤器、管道等；
* 编写可扩展、可测试和松散型应用程序。

**Nest.js 主要特性**

* 易于扩展：可与其他库一起使用。
* 允许开发人员完全使用纯 JavaScript 进行编码。
* 结合了函数式编程、面向对象编程和响应式编程的特点。
* 公开框架 API，帮助开发者使用各平台上的各种第三方模块。
* 它有一个详细且维护良好的文档。

**什么时候使用 Nest.js：**

Nest.js 主要用于编写具有可扩展、可测试和松散耦合特点的应用。它将 Node.js 的扩展潜力提高到了一个全新的水平。它提供了结构和灵活性的适当平衡，可以高效地管理你的大型项目的代码，并且仍然有结构感可循。

**谁在使用 Nest.js：**

* Roche
* Adidas
* Decathlon
* Capgemini

### 4. Koa.js

- **GitHub**
  - **Stars**：30.9k
  - **Forks**：3k
  - **版本**：2.13.1
  - **贡献者**：219
  - **使用人数**：160k
- **NPM 周下载量**：870,944
- **License**：MIT

![Koa.js 框架流行度](https://cdn-images-1.medium.com/max/2078/1*lKpRVNszZ6gVbTF_blVJRQ.png)

Koa.js 是一个开源的 Node web 框架，由 Express.js 原班人马创建。通过 Koa，他们的目标是为 Web 应用和 API 创建一个更小、更有价值、更强大的平台。它提供了多种高效的方法，以让构建服务的过程更快速。

**Koa.js 可以被用于：**

* 前台系统
* 后台系统
* 混合系统

**Koa.js 主要特性：**

* 代表现代和未来
* 与所有 Node.js 框架相比，体积更小。
* 有一个内置的错误捕捉器，防止网站崩溃。
* 使用 context 对象，该对象同时拥有请求和响应对象。

**什么时候使用 Koa.js：**

Koa.js 最适合用于创建服务器、路由、处理响应和处理错误。

**谁在使用 Koa.js：**

* Paralect
* LetzChange
* BrainHub
* Bulb

### 5. Socket.io

- **GitHub**
  - **Stars**：52.7k
  - **Forks**：9.6k
  - **版本**：4.0.0
  - **贡献者**：189
  - **使用人数**：2.2m
- **NPM 周下载量**：3,617,636
- **License**：MIT

![socket.io 流行度](https://cdn-images-1.medium.com/max/2046/1*5zUKf_Dt48W00aWfkAs84g.png)

Socket.io 是用来在客户端和服务器端之间创建实时双向通信的框架。要做到这一点，客户端需要在浏览器中安装 Socket.io，服务器也要集成 Socket.io 包。这使得数据可以在数百万种形式中共享。然而，最受欢迎的方法仍然是 JSON。

**Socket.io 由以下两个部分组成：**

1. JavaScript 服务：Node.js
2. JavaScript 客户端库：Node.js

> **注意：** Socket.io 还兼容许多其他语言，如 Java、C+、Swift、Dart、.Net 和 Python。

**Socket.io 可以被用于：**

* 各种命名空间
* 广播
* 事件处理
* 错误处理
* 日志和调试
* 聊天应用
* 内部

**Socket.io 主要特性：**

* 将信息编码为命名的 JSON 或二进制事件。
* 在应用程序中添加“实时”能力。
* 支持自动重新连接
* 出色的速度和可靠性
* 即时通讯和聊天

**什么时候使用 Socket.io：**

Socket.io 是最好的基于事件的实时双向通信工具之一。任何想要在应用中添加实时分析功能的人都应该使用它。Socket.io 对于实时游戏应用也很有用。在实时游戏中使用基本的 HTTP 或 HTTPS 协议是不可行的，因为这些文件很大，建立通信需要时间。在这里，我们使用体积更小的 socket 包，几乎是实时地完成工作，以获得更流畅和更好的体验。

**谁在使用 Socket.io：**

* Alibaba Travels
* Patreon
* Trello
* Justmop
* Plaid

### 6. Meteor.js

- **Github**
  — **Stars**：42.3k
  - **Forks**：5.2k
  - **版本**：4.0.0
  - **贡献者**：452
- NPM：不可用
- **License**：MIT

Meteor.js 是一个开源的全栈 JavaScript 平台，JavaScript 根据意图不同运行在不同的地方。JavaScript 运行在 Web 浏览器内部；然后 JavaScript 运行在 Node.js 容器内的 Meteor 服务器上，支持 HTML 片段、静态资源和 CSS 规则。

**Meteor.js 可以被用于：**

* 移动应用程序全流程
* web 应用程序全流程

**Meteor.js 主要特性：**

* 纯 JavaScript
* 干净、稳健的数据同步
* 互操作性
* 智能套件
* 代码热更新

**什么时候使用 Meteor.js：**

Meteor.js 具有快速原型设计的能力，并能生成跨平台（Android、iOS、Web）的代码。它也是最直接的学习框架之一，因为它不遵循任何严格的结构规则。因此，Meteor.js 应该被任何希望以最少的学习曲线为多个平台创建应用程序的初级或中级开发人员使用。

**谁在使用 Meteor.js：**

* Accenture
* NetApp
* Rocket Chat
* Esri
* NordStorm

### 7. Adonis.js

- **Github**
  - **Stars**：9.7k
  - **Forks**：498
  - **版本**：5.0.13
  - **贡献者**：47
  - **使用人数**：754
- **周下载数**：3808
- **License**：MIT

![adoni.js 流行度](https://cdn-images-1.medium.com/max/2052/1*QVu2Z2wbudWv06tBwkJ8mQ.png)

Adonis.js 是一个 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 的 MVC 框架，可以运行在所有的操作系统上。它为编写服务器端 Web 应用程序提供了一个稳定的生态系统，以让开发者专注于业务需求，如最终确定选择或排除哪个包。对于想要换个口味，正在尝试 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 框架的 Laravel 开发者来说，它是理想的选择。Adonis.js为 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 提供了与Laravel自然具有的相同的功能和能力。

**Adonis.js 可以被用于：**

* 构建 web 应用
* 应用程序接口服务

**Adonis.js 主要特性：**

* 强大的 ORM，帮助进行安全的 SQL 查询。
* API 和基于会话的认证系统
* 验证和给每一个用户的输入做卫生处理。
* 高度强调安全问题
* 可扩展的应用分层

**什么时候使用 Adonis.js：**

如果你是一个正在寻找 MVC 工具的 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 开发者，Adonis.js 是你的首选 Node.js 框架。然而，如果你是一个 Laravel 开发者或任何其他移动应用框架开发者，你仍然可以给 Adonis.js 一个机会，甚至从 PHP 迁移到 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 也可以尝试一下 Adonis.js。

**谁在使用 Adonis.js：**

* Dotgroup
* DORMshed
* Nina
* Zelo
* FindUp

### 8. Sails.js

- **Github**
  - **Stars**：21.9k
  - **Forks**：1.9k
  - **版本**：1.4.0
  - **贡献者**：229
  - **使用人数**：23.3k
- **周下载数**：20,457
- **License**：MIT

![sails.js 框架流行度](https://cdn-images-1.medium.com/max/2000/1*nYu5aJOd4f933c6WZkX8eA.png)

Sails.js 是又一个实时 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) MVC 框架。它基于 Express 构建，其 MVC 架构与 Ruby on Rails 相似。它与 Ruby on Rails 的不同之处在于，它提供了对更现代的、以数据为中心的 API 和 Web 应用开发风格的支持。

**Sails.js 可以被用于：**

* 构建企业级 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 应用
* 构建前端应用
* 构建处理 HTTP 请求的后端应用

**Sails.js 主要特性：**

* 支持自动生成 REST APIs
* 具有简单的 WebSocket 集成
* 兼容任何流行的前端框架：Angular、Android、React、iOS、Windows 或任何自定义硬件。
* 它还具有实时功能支持

**什么时候使用 Sails.js：**

任何想要一个模拟 MVC 模式的 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 框架（如 Laravel 和 Ruby on Rails）、想要实现现代应用架构，并构建以数据为中心的 API 和实时应用的开发者都应该在他们的下一个项目中使用 Sails.js。

**谁在使用 Sails.js：**

* Tutor Platform
* Redox Engine
* Brainhub
* Created Informed
* People Grove

## 总结一下

市场上有很多新的 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 框架。不同的 [Node.js](https://aglowiditsolutions.com/blog/hidden-cost-of-app-development/) 框架会在不同阶段帮助你开发项目，并带来很多价值和功能。合理利用这些框架，妈妈再也不用担心你的应用开发啦。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
