> * 原文地址：[Top 5 Icon Packs for Web Apps in 2021](https://blog.bitsrc.io/top-5-icon-packs-for-web-apps-in-2021-f0321653980e)
> * 原文作者：[Chameera Dulanga](https://medium.com/@chameeradulanga)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/top-5-icon-packs-for-web-apps-in-2021.md](https://github.com/xitu/gold-miner/blob/master/article/2021/top-5-icon-packs-for-web-apps-in-2021.md)
> * 译者：[zenblo](https://github.com/zenblo)
> * 校对者：[PassionPenguin](https://github.com/PassionPenguin)

# 2021 年 Web 应用开发常用的五个图标库

![](https://cdn-images-1.medium.com/max/5760/1*uPK9UAnb1ni6GDB690LYig.jpeg)

在过去的十年里，网络和移动应用已经成为我们日常生活的一部分。如今，我们可以找到很多解决同一问题的应用程序。因此，应用程序的功能显然不再是唯一的区别。

此外，为用户提供良好的整体体验对这些应用程序的成功起着重要作用。为了实现这一点，我们还需要更好的用户界面（UI）。

作为开发人员，我们必须确保应用程序的外观和视感符合更高的标准，以便吸引新用户并保留现有用户。我希望这些事实能让你相信 UI 设计的重要性。

> 谈到 UI 设计，我们使用的图标体现了它的个性。

## 图标库

图标或许很小，但即便是没有一个单词文本的图标，也能给用户提供强有力的信息。说到图标，我们可以使用现成的图标库，或者独立构建图标。然而，鉴于以下原因，我建议使用图标库。

* 图标库能使得整个应用程序保持独特的外观。
* 图标库能节省应用开发时间，因为你不需要从头开始构建图标。
* 最重要的是，可以通过选择大多数用户已经熟悉的图标子集使得应用程序个性化。
* 如果你有一整套应用程序，你可以在应用程序中统一使用这些图标库。

在本文中，我将讨论现有的五个常用图标库的用法以及优缺点。

## 1. ICONS8

![Source: [https://icons8.com/icons](https://icons8.com/icons)](https://cdn-images-1.medium.com/max/3146/1*cTiGQ9fSlPjnivRZdcKUDg.png)

[Icons8](https://icons8.com/icons) 是最受设计师和开发者欢迎的图标库之一。它提供超过 140000 个图标，涵盖 35 个不同类别供你使用。

为开发项目找到最合适的图标组合是你最忙碌耗时的任务之一。有了 Icons8，你可以选择一种风格，并立即得到一个庞大图标组合。你还可以通过添加轮廓、不同颜色、文本效果来自定义它们，而不会浪费宝贵的时间。

此外，Icons8 通过为你的项目提供像素完美的图标来消除模糊效果，同时允许你下载任意标准格式的图标，包括 PNG、SVG、嵌入式 HTML 和 PDF。

![Screenshot by Auther: Customizing icons in Icons8](https://cdn-images-1.medium.com/max/3068/1*Mv5Z09kKyMafb0PlZLONLw.png)

#### Icons8 的主要特点

* 并不是所有的图标都需要注明出处。
* 在下载之前完成自定义图标设置。
* 你可以找到任意颜色、大小和格式的图标。
* 有不同的图标样式可供选择。(填充图标、线条图标、实心图标等。)
* 免费增值服务。从 13 美元起，有不同的图标、照片、插图供你选择。
* 免费套餐包括可达 100 像素的 PNG 图标，你需要更改为付费套餐才能下载其他格式。

**缺点**

* 需要注册才能下载图标。
* 在下载图标并在项目中使用它们之前，你必须仔细检查，因为有些图标需要注明出处。

## 2. Flaticon

![Source: [https://www.flaticon.com/packs](https://www.flaticon.com/packs)](https://cdn-images-1.medium.com/max/3776/1*BGohqk4R6c5r42XK45mLvA.png)

[Flaticon](https://www.flaticon.com/home) 是另一个有名的图标库，我们可以将其用于 UI 设计，它以免费和高级软件包的形式提供了超过 200 万个不同的图标。像 Icons8 一样，你可以在下载之前编辑 Flaticon 图标。但是，Flaticon 不提供像 Icons8 那样丰富的编辑选项。

另一方面，你可以下载分辨率可达 512 像素的 PNG 版本图标。如前所述，Flaticon 还分为免费和付费版本，用户可以在付费版本中使用大量更高级的图标。

如果你是 Flaticon 的游客用户，你只能创建一个收藏，并且每天只能下载 10 个图标。你可以通过在 Flaticon 注册，每天最多扩展到 3 个收藏和下载 100 个图标，而不会产生任何费用。最重要的是，他们的高级版本允许你创建无限的图标集合，每天下载 2000 个图标。

![Screenshot by Auther: Customizing icons in Flaticon](https://cdn-images-1.medium.com/max/3092/1*rtcwQJSb3TlvMDMAQQOg7A.png)

#### Flaticon 的主要特点

* 提供 SVG、EPS、PSD、BASE 64 和 PNG 格式。
* 为 Adobe 的创意云套件（CC）提供了扩展。（校对者注：目前并没有搜索到相关扩展，官网链接已失效，可能是该扩展已下架）
* 能在下载之前进行自定义图标设计。
* 高级套餐的价格为每月 9.99 欧元。
* 高级套装提供无限数量的图标，包括三百万多个高级图标的集合。
* [可以在 GSuite 应用程序中直接使用 Flaticon 图标。](https://www.flaticon.com/for-google)
* [可以使用 Flaticon 为演示文稿、故事、博客和网站创建背景图像。](https://www.flaticon.com/pattern-generator)

**缺点**

* 使用免费版本时需要提供注明出处。

## 3. Font Awesome

![Source: [https://fontawesome.com/icons?d=gallery](https://fontawesome.com/icons?d=gallery)](https://cdn-images-1.medium.com/max/3746/1*EIJXAiWtSbQW-JuFOpczSQ.png)

[Font Awesome](https://fontawesome.com/) 是开发者常用的另一个流行图标库，主要是因为它直接支持 Bootstrap 和 CSS。然而，Font Awesome 图标比 Icons8 和 Flaticon 少。因为 Font Awesome 是 Bootstrap CSS 框架中使用的默认图标集，它成为了任何使用 Bootstrap 开发项目的默认选择。

如果深入探究会发现，Font Awesome 中有两个库，分别为免费版和专业版。免费版仅包含 1,598 个图标，而专业版包含额外的 6,250 个图标和其他功能。

顾名思义，Font Awesome 使用字体而不是图像，因此在免费版和专业版中，它都提供了像素完美的图标，简单的 CSS 样式，托管的工具包，强大的转换以及轻松的升级。 Font Awesome 没有提供 Icon8 或 Flaticoin 之类的编辑选项，但为你提供了 CSS 类，可以直接在 HTML 中定义使用。

使用免费版，你只能下载所选择图标的完整版本，如果你希望使用 Regular、Light 或 Duotone 等字体，则需要切换到专业版。

![Screenshot by Auther: Customizing icons in Font Awesome](https://cdn-images-1.medium.com/max/3614/1*_GvBDBIHrbXi82AmPWXYxg.png)

#### Font Awesome 的主要特点

* 从 Font Awesome 3.0 版本开始，不再需要注明出处。
* 支持 CSS 和 Bootstrap。
* 提供 CSS 类，Unicode 和 SVG 格式的图标。
* 可以使用纯 CSS 直接更改图标的基本属性（颜色、阴影、背景等）。
* 可以轻松升级到最新版本。
* Font Awesome 全局 CDN 和缓存可用于更快地加载图标。
* 专业版价格为每年 99 美元，包括自定义设置，人工技术支持，专业版下载，标准专业证书和其他功能。

## 4. Fontisto

![Source: [https://fontisto.com/icons](https://fontisto.com/icons)](https://cdn-images-1.medium.com/max/2784/1*cCFElZNhCB0BUvdKR1-WMQ.png)

与我们讨论的前三个图标包不同，[Fontisto](https://fontisto.com/) 是一个完全免费的矢量图标库，你可以将其用于项目开发和设计目的。你只需从它网站点击几下就可以定制图标。添加旋转效果、动画、边框等简单的修改，你可以用字体来完成。你也可以下载图标的 CSS 类。由于 Fontisto 支持 CSS，所以可以直接对图标的 CSS 属性进行修改，包括图标大小、颜色、背景等。

除此之外，Fontsto 提供了几种方法来开始项目，比如使用 CDN，通过将整个 Fontsto 目录复制到项目中来直接使用 CSS。你可以使用包管理器，如 npm、yarn 或者 bower 等。使用以下命令：

使用 Fontisto CDN：

```html
<link rel=“stylesheet” href=“https://cdn.jsdelivr.net/npm/fontisto@v3.0.4/css/fontisto/fontisto.min.css”></i>
```

使用 CSS：

```html
<!DOCTYPE html> 
 <html lang="en">     
  <head>         
   <meta name="viewport" content="width=device-width, initial-scale=1">         
   <!-- fontisto css -->         
   <link href="fontisto/css/fontisto.min.css" rel="stylesheet">       
  </head>     
  <body>         
   <i class="fi fi-facebook"><i>         
   <i class="fi fi-twitter"><i>         
   <i class="fi fi-instagram"><i>     
  </body> 
 </html>
```

使用包管理：

```bash
npm install fontisto                    // npm
yarn add fontisto                       // yarn
bower install fontisto                  // bower
composer require kenangundogan/fontisto // composer
```

#### Fontisto 的主要特点

* 完全免费用于商业用途。
* 不需要使用 Javascript。
* 支持使用 CSS。
* 完美适配高分辨率显示器。
* 图标是可伸缩的。

你可以在[项目文档](https://fontisto.com/get-started)中找到更多关于 Fontisto 的使用信息。

## 5. Streamline Icons

![Source: [https://streamlineicons.com/](https://streamlineicons.com/)](https://cdn-images-1.medium.com/max/3654/1*6XPQ3ubWvNZ6Mlhyw1uFfA.png)

[Streamline Icons](https://streamlineicons.com/) 是另一个优秀的图标库，你可以在项目开发中使用。Streamline 大约有 30000 个漂亮的可适应性图标，包括 50 多个类别。Streamline 图标库以其对优化草图的支持而出名，这使得操作图标宽度和颜色变得容易。你可以在 Streamline 中创建一个免费账户并开始使用图标，也可以直接将整个图标集下载到你的设备上。像 Icon8、Font Awesom 和 FlatiCoin 一样，Streamline 支持在下载所需图标之前进行编辑。你可以轻松更改像素大小、格式，并在类似设计之间切换。但是，除非升级软件包，否则无法更改图标的颜色。

![Screenshot by Auther: Customizing icons in Streamline Icons](https://cdn-images-1.medium.com/max/3092/1*ZMkeZRebdIvYGxGYR5J9TQ.png)

#### Streamline Icons 的主要特点

* 提供 Sketch、AI、EPS、PDF、PNG 和 SVG 格式。
* 用于搜索和编辑图标的 Web 应用程序。
* 三个套餐版本，包括免费版、基础版和旗舰版。
* 免费版中有 30000 个图标可供使用。
* 基础版包含 12000 多个图标，有 .iconjar .sketch .fig .xd .svg .ai .pdf .png 等类型，售价 194 美元，而旗舰版包含 31500 多个图标。

**缺点**

* 除非你购买了付费高级套餐，否则必须注明出处。

## 总结

以上图标库只是互联网上许多可用库的子集，由于它们的实用性和丰富的功能集而流行。然而，一个优秀的图标库只是开发者选择图标库的一个方面。最好要考虑图标升级的适用性、易用性，以及使用所选图标库在开发项目的启动速度。

此外，决定是购买图标还是坚持使用免费图标也很重要，因为你可能需要考虑其中一些图标需要注明出处。可定制性和可用格式也是选择这些图标的考虑因素，大多数时候，每个图标库都包含其独特的设计类别，如材质、矢量、CSS、SVG 等。

因此，在为开发项目选择图标库之前，请考虑一下从本文中学到的知识。我相信这会让你的工作流程更顺畅。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
