> * 原文地址：[The Future Of The Web](https://www.hazem.cool/blog/the-future-of-the-web)
> * 原文作者：[Hazem Osama](https://www.hazem.cool/)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/the-future-of-the-web.md](https://github.com/xitu/gold-miner/blob/master/article/2021/the-future-of-the-web.md)
> * 译者：[Gesj-yean](https://github.com/Gesj-yean)
> * 校对者：[KimYangOfCat](https://github.com/KimYangOfCat)、[jaredliw](https://github.com/jaredliw)

# Web 的未来

![](https://www.hazem.cool/static/7858b1b89c0b19aeb9c7671418a6e1a7/1aca4/the%20web%203.0.webp)

## Web 的远古时代

曾经有一段时间，Web 不像今天这样是我们生活的重要组成部分，它主要用于查看天气、邮件、新闻、雅虎知识堂、下载 MP3 或玩 Flash 游戏。

Web 是静态的，单机的，就好像是印刷时代的一部分被带到了 Web 上。然而我不得不说这既有点[古怪又十分有趣](https://www.spacejam.com/1996/)。

## Web 的商业时代

随着 Web 应用程序、社交媒体、视频流和移动设备的兴​​起，Web 从一种实用工具转变为一种生活方式。

黄金之泉已经喷发，科技公司开始投入数十亿美元的资金。当有这么多钱在流动时，增强乐趣以及终端用户隐私和兴趣就不会真正成为他们优先考虑的事项。

因此搭建网站使人上瘾。所有公司都开始创建自己的网站。最终每家公司甚至他们的狗都有一个登陆页面，如果你仔细观察，他们似乎都在使用相同的模板，甚至标题都相同，都是“自动化组织协作工作场所远程通信交付的多合一解决方案”，“减少 100 倍的时间提高 10 倍的生产力！！！”，或“厕所......重新发明！”等等。它们之间除了一些文本、样式和图像之外，很难发现差异。这就像有人占领了整个互联网，同时消灭了所有的创造力和乐趣。

Web 变得太商业化、太平庸、太...乏味了。

## 事情正在悄然改变

> 光明的未来一直存在，如果你向着正确的方向瞭望，你就会看到它在远处闪闪发光。
>
> —— 《Safari Honeymoon》杰西·雅各布斯

Web 正在发生变化，它正在变得更加动态、更加身临其境、更加多元，事实上，如果你仔细观察，你会发现它已经做到了。

### 桌面应用销声匿迹

如果你查看日常使用的应用程序，例如 Twitter、Facebook、Gmail、Zoom、YouTube、Slack、Discord、Microsoft Teams、Google Drive、Google 表格、Office 365 或 Notion 等应用程序。

你能猜出哪些不是 Web 应用程序吗？好吧，唯一可以不基于 Web 技术的桌面客户端的是 Zoom，但它也可以在你的浏览器上运行。

即使是 Microsoft Office 应用程序，“事实上的”桌面应用程序，它们的界面也是[基于 Web 技术 react 重写的 ](https://react-etc.net/entry/microsoft-office-rewrite-to-react-js-nears-completion)。

#### 专业级的大型应用

你可能会说 Photoshop、After Effects、Final Cut Pro、Blender 和 Visual Studio 之类的应用程序是桌面应用程序，它们太过笨重和复杂以至于无法在 Web 上使用。

但不知你是否已经注意到，这些类型的应用程序已经转移到 Web 上了。

- Photoshop，Illustrator 和 Adobe XD → [Figma](https://www.figma.com/)，[Framer](https://login.framer.com/?origin=framer-web&redirect=https%3A%2F%2Fframer.com%2Fprojects%2F)（有我见过最好的 SaaS 产品[广告](https://www.youtube.com/watch?v=hAPxeoP8wn8)），[Photobea](https://www.photopea.com/) 和 [Avocode](https://avocode.com/)
- After Effect → [Rive](https://rive.app/)
- Blender → [Spline](https://spline.design/)
- Microsoft Office → [Office 365](https://www.office.com/)，[Google 文档](https://www.google.com/docs/about/)，[Google 幻灯片](https://www.google.com/slides/about/)，[Google 表格](https://www.google.com/sheets/about/) 和 [Notion](https://www.notion.so/)
- Skype → [Slack](https://slack.com/)，[Teams](https://www.microsoft.com/en-ww/microsoft-teams/group-chat-software)，[Zoom](https://zoom.us/) 和 [Discord](https://discord.com/)
- Visual Studio 和其他 IDE → [CodeSandBox](https://codesandbox.io/)，[Github CodeSpaces](https://github.com/features/codespaces)，[Glitch](https://glitch.com/)，[Git Pod](https://www.gitpod.io/) 和 [Next.js Live](https://nextjs.org/blog/next-11#nextjs-live-preview-release)
- Unreal Engine 和 Unity → [Three.js](https://threejs.org/)，[Babylon](https://www.babylonjs.com/)，[Play Canvas](https://playcanvas.com/#!) 和 [RogueEngine](https://rogueengine.io/)
- AutoCad 和 Sketchup → [AutoCad Web](https://web.autocad.com/) 和 [Sketchup Web](https://app.sketchup.com/app)
- Audacity → [Soundation](https://soundation.com/)
- VLC 媒体播放器 → [VLC.js](https://code.videolan.org/jbk/vlc.js)

哎呀，你甚至可以在 [Web 上运行浏览器](https://www.mightyapp.com/)（还有另一个很棒的 [SaaS 产品广告](https://youtu.be/cxUN1dZ0Edk)？）。

还有克隆版的 [Windows Paint](https://jspaint.app/)、[Windows 98](https://copy.sh/v86/?profile=windows98) 和 [Windows XP](https://winxp.vercel.app/) 都可以在你的浏览器上运行。

亲爱的读者，如果你还没有注意到，传统的桌面应用程序已经在走向数字墓地的路上了。

### 移动应用程序即将消失

移动应用具有“本机”的感觉，它们可以在你的主屏幕上显示、发送通知、访问相机、电话簿、文件系统等。它具有流畅的动画和手势，这些是你在普通的、敲敲点点的网站上看不到的东西。

当一家公司想要支持移动设备时，他们不会创建适合移动设备的 Web 应用程序，而是创建本机移动应用程序。为什么？因为 Web 无法访问与本机应用程序相同的 API 和功能，并且其通常被认为性能不好，同时你也很难实现能跨浏览器工作且不干扰设备默认手势的手势和动画，显然你也不能向应用商店提交一个网站（或者你可以试试👀 ？）

类似 [React Native](https://reactnative.dev/) 的一些 Web 技术框架能够让你编写跨平台应用程序。尽管它们的性能较低，但它们能允许你访问与原生应用程序相同的 API 和功能。

有一些公司已经采用了 React Native，例如 Facebook、Instagram、Discord、Tesla、Skype、Pinterest 和 Uber Eats 等等。

但我相信会有更好的东西即将出现，有一种 Web 应用程序可以像一个原生应用程序一样运行，它们被称为“渐进式 Web 应用程序”。它们是可安装的，可以访问[诸如存储、相机、通知等 API](https://whatwebcando.today/)，并且可以立即更新（与需要在应用商店中构建的原生应用不同），不必提交到应用商店，易于访问（URL 的强大功能），并且使用 [use-gestures](https://use-gesture.netlify.app/)、[react-spring](https://react-spring.io/) 和 [framer motion](https://www.framer.com/motion/) 等库，你可以轻松实现流畅的动画和手势（试用 [Bottom Sheet](https://zuwji.csb.app/)、[Multi-Gestures](https://rkgzi.csb.app/)、[Slide Show](https://v364z.csb.app/) 和 [App Store Like Cards](https://ecgc2.csb.app/) 手机上的演示）。

最著名的例子可能是 Twitter PWA。

Google Play 商店和 Microsoft 商店已经允许将 PWA 提交到他们的应用商店。

让我们期待 Apple 能够尽快添加更多的支持并解除它对 iOS 上 PWA 的一些限制🤞。

随着时间的推移，我预测更多的公司将转向 PWA，等到 PWA 成为标准的那一天，我们将看到它们与原生应用程序并存（希望😁），然后我们就会怀疑为什么我们要为了每个平台多次构建相同的应用程序😲！

## 沉浸式 Web

### Web 正越来越强大

你可能会问：“Web 不是很慢的吗？Chrome 占用了我所有的 CPU 和 RAM。”的确，Web 并不适用于大型的应用程序，但有了 [WebAssembly](https://webassembly.org/)，情况有所不同了。

WebAssembly 允许你以接近机器代码的速度在 Web 上运行来自 [多种语言](https://github.com/appcypher/awesome-wasm-langs)（如 C++、Rust、Go、Java 等）的编译代码。这将为 Web 上的新型应用程序打开大门，例如：

- [Figma 的渲染引擎](https://www.figma.com/blog/webassembly-cut-figmas-load-time-by-3x/)
- [Google 将 C++ 代码从其桌面应用程序移植到 Web](https://web.dev/earth-webassembly/)
- [发声音频计算](https://soundation.com/station/soundation-is-the-first-online-music-production-software-to-implement-webassembly-threads-gains-over-70-performance-improvement/)
- [图像压缩 —— 由谷歌开发的 Squoosh](https://squoosh.app/) （即使是 Web 本身不支持的格式）
- [3D 建模 —— 由谷歌开发的 Sketchup](https://madewithwebassembly.com/showcase/sketchup/)
- [VLC 媒体播放器被移植到 Web](https://madewithwebassembly.com/showcase/vlc/)
- [Lichess 国际象棋引擎分析](https://madewithwebassembly.com/showcase/lichess/)
- [PSPDFKit](https://pspdfkit.com/blog/2017/webassembly-a-new-hope/) 和 [PDFTron](https://www.pdftron.com/blog/wasm/wasm-vs-pnacl/) PDF 渲染引擎
- [TensorFlow 现在支持 WebAssembly 了](https://blog.tensorflow.org/2020/03/introducing-webassembly-backend-for-tensorflow-js.html)

### 三维化

传统上，Web 是二维的，那是因为它主要用于共享文档而不是作为“应用程序”。

但是 3D 已经在 Web 中存在了一段时间​​了，这不仅仅是出于美学原因。

以下是 Web 上 3D 体验的一些示例：

- [Google 地球](https://earth.google.com/web/) (Obviously 👀)
- [NASA 火星 2020 模拟](https://eyes.nasa.gov/apps/mars2020/#/home)
- [NASA 喷气推进实验室开源漫游车](https://opensourcerover.jpl.nasa.gov/#!/home)
- [SpaceX 空间站对接模拟器](https://iss-sim.spacex.com/)
- [Chrome 的 10,000 Stars 实验](https://stars.chromeexperiments.com/)
- [维基世界](http://wikiverse.io/)
- [Zenly 登陆页面](https://zen.ly/)
- [Bruno Simon 的个人主页](https://bruno-simon.com/)
- [Lusion 站点](https://lusion.co/)
- [Paper Planes](https://paperplanes.world/)
- [Google 艺术与文化 —— Blob Opera](https://artsandculture.google.com/experiment/blob-opera/AAHWrq360NcGbw)
- [Google 云基础设施](https://cloud.withgoogle.com/infrastructure/)

### XR 体验

VR 和 AR 尚未成为主流，但它们将在 Web 上占有一席之地。

[WebXR](https://developer.mozilla.org/en-US/docs/Web/API/WebXR_Device_API) 是一种允许在 Web 上创建混合现实（VR 和 AR）体验的 API，因此现在我们将能够创建可以跨不同头显的体验，而不仅仅是一个头显。

以下是一些 WebXR 体验示例：

- [Shopify 3D 产品模型](https://www.shopify.com/3d)
- [A-Painter：3D 绘画](https://aframe.io/a-painter/)
- [蜘蛛侠 VR 体验](https://spiderman.webvr.link/)
- [谷歌 WebXR 实验](https://experiments.withgoogle.com/collection/webxr)
- [KonterBall：乒乓球](https://konterball.com/)
- [谷歌的 Tonite Dance](https://tonite.dance/)
- [Moon Rider（击败克隆人）](https://moonrider.xyz/)
- [Hubs：Mozilla 的虚拟房间](https://hubs.mozilla.com/)
- [Plockle：益智游戏](https://plockle.com/)

### Web 游戏时代的开始

电子游戏一直存在于游戏机和 PC 上。Web 只剩下小型 Flash 游戏。那时 Web 还没有真正为视频游戏行业做好准备。

但是有了 WebAssembly，事情开始发生变化。现在，你可以将用其他语言（如 C++）编写的游戏直接移植到 Web 上。

Unity 宣布它将借助 [Three.js](https://threejs.org/)、[Babylon](https://www.babylonjs.com/)、[Play Canvas](https://playcanvas.com/#!) 和 [RogueEngine](https://rogueengine.io/) 等工具[支持 WebAssembly](https://blog.unity.com/technology/webassembly-is-here)。在 Web 上运行游戏看起来有了一丝曙光。

以下是一些在 Web 上运行的游戏示例：

- [Unity：Angry Bots](https://beta.unity3d.com/jonas/AngryBots/)
- [Doom 3（通过 WebAssembly 移植）](https://wasm.continuation-labs.com/d3demo/)
- [Heraclos](https://heraclosgame.com/)
- [Ouigo —— 弹球](http://letsplay.ouigo.com/)
- [pmndrs —— 赛车游戏](https://racing.pmnd.rs/#)
- [我的世界经典版](https://classic.minecraft.net/)
- [After The Flood](https://playcanv.as/p/44MRmJRU/)
- [Trolli](https://trollideliciouslydarkescape.com/)
- [HexGL —— 赛车游戏](http://hexgl.bkcore.com/play/)
- [Robostorm](https://robostorm.io/)
- [桌上足球世界杯](https://www.foosballworldcup18.com/)

#### 为什么 Web 是游戏开发的好地方

Web 是唯一向后兼容的平台，想象一下，你可以创建一个可以运行到互联网末日的游戏！

你可以向大众发布你的游戏，而无需让发行商或游戏商店从你辛苦赚来的收入中扣除 30%。

从技术层面来讲，你可以在任何设备上运行你的游戏，而无需将你的游戏移植到不同的控制台和架构，PC 游戏不再是 Windows 独有的。

Web 易于访问，任何人都可以通过 URL 访问你的游戏，无需下载千兆字节的数据来测试游戏。

你可以立即更新你的游戏，无需让你的用户等待下载更新。

你可以通过代码拆分和延迟加载资源来使用 Web 流功能，（理论上）用户可以立即畅玩并测试你的游戏。

想象一下，当你想和朋友一起玩游戏时，你看不到哪个朋友和你有相同的游戏机/PC（因为大多数游戏都不是跨平台的），或者等待你们俩下载整个游戏或下载最新的 10GB 更新！你需要做的就是分享你的游戏 session 的 URL 并且游戏障碍将非常低，基本上不存在。

## 去中心化 🕸 —— 互联网巨头的杀手

互联网的大半片天都被 4 至 5 家公司垄断，即 Facebook、亚马逊、苹果、Netflix 和谷歌）。这五大互联网巨擘被合称为 FAANG。

他们将数以万亿计的数据输送到他们的数据中心，他们可以控制哪些内容可以放在他们的平台上，哪些内容不能放在他们的平台上，他们可以通过管理你看到的内容和你不看到的内容来影响你的决定，当你搜索他们的竞争对手时，他们可以在顶部展示他们的产品，他们可以通过将你的产品投放到他们的市场中使你的收入中大幅减少，他们可以通过将你的数据作为威胁不让你轻松导出来并将你限制在他们的泡沫中到其他应用程序。

因此，一家公司可以控制像互联网这样重要的东西是非常令人担忧的😅。

那么我们该怎么办？我们注定要遵循 FAANG 的想法吗？

对此我说想象一下你的数据真正属于你的 Web，你可以将它从一个应用程序转移到另一个应用程序。注册时，你不需要向应用程序提供你的电子邮件、密码、电话号码、地址、社交身份或你的照片。虚拟密钥足矣。想象一下互联网不是由数据饥渴的巨头运营，而是由我们所有人运营。想象一下真正的匿名性，你可以选择哪些内容公开，哪些内容保密，不再有中间人。

这就是去中心化应用程序希望做的事情。你可能从比特币中了解到它们，但它比那要大得多，我们只是看到它可能是什么的早期趋势。如果有一件事可以使互联网免于 FAANG 的束缚，那么最终会杀死科技巨头的就是去中心化应用程序。

## 为什么 Web 能生存

Web 永远不会消亡（除非我们都被核弹炸了💣），那是因为 Web 是我们的延伸。

与封闭系统不同，Web 是开放的，可从所有设备访问，不是由一家大公司运营，始终向后兼容，在你和你想要联系的人之间没有中间人，并且它在不断发展。

在开发人员的生态系统中一直有一个“编写一次，到处运行”的梦想，但他们没有意识到它一直就在他们的眼皮子底下，Web 一直是跨平台的。

## 要么落后

我有一个理论，即所有封闭系统最终都会消亡。它们唯一能做的就是延长他们的存在，为什么呢？虽然它们可以继续给围墙内的花园浇水，但总有一天它们生长的天气会不一样。树叶落下，苹果腐烂，花园变成了博物馆或历史遗迹，提醒人们这是什么。

为了生存，他们必须打开花园并拥抱季节，即将到来的季节都是 Web。

## 最终的操作系统

Web 将是最终的操作系统，所有设备都连接到一起，永远发展。

总有一天，有人指着他们的电脑设备，但他们不会指着他们的笔记本电脑、手机、眼镜或甚至微波炉，他们会指着天空说“它在某个地方......到处都是！”

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
