> * 原文地址：[Node.js vs. Python: Which One to Choose for Your Project?](https://javascript.plainenglish.io/node-js-vs-python-which-one-to-choose-for-your-project-331c33c958a)
> * 原文作者：[Saul Gallegos](https://medium.com/@saulgallegos)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/node-js-vs-python-which-one-to-choose-for-your-project.md](https://github.com/xitu/gold-miner/blob/master/article/2021/node-js-vs-python-which-one-to-choose-for-your-project.md)
> * 译者：[kamly](https://github.com/kamly)
> * 校对者：[Kimhooo](https://github.com/Kimhooo), [PassionPenguin](https://github.com/PassionPenguin), [Miigon](https://github.com/Miigon)

# Node.js 与 Python：为你的项目选择哪一个？ 

![图源 [Alex Kotliarskyi](https://unsplash.com/@frantic?utm_source=medium&utm_medium=referral)，出自 [Unsplash](https://unsplash.com?utm_source=medium&utm_medium=referral)](https://cdn-images-1.medium.com/max/10944/0*COxufZ6uSEyF1y1-)

Node.js 和 Python 是网络上最常被拿来做比较的两门后端技术。由于两者在 Web 应用程序开发中都非常流行，在作出二选一之前，有必要对两者进行透彻的对比。在本文中，我们将探讨这两门技术中哪一个更能适合您的开发需求，以及在哪些情景下适用。

## 什么是 Node.js?

Node.js 属于事件驱动型，它的可拓展性为项目带来出色的开发效率。它的异步式设计使其可处理并发请求而不阻塞 I/O 操作。多数开发团队为了使用 JavaScript 同时开发客户端和服务端，会偏向选择 Node.js。

## 什么是 Python?

另一方面，Python 是一门成熟的高级面向对象语言。它接近 30 年的历史也意味着它有大量的库、API 和辅助工具可用。Python 对多种编程范式友好，被广泛应用于商业应用程序。

---

它的社区、库和支持平台十分广泛。因此，对于大多数需要为不同且通常不相关的场景开发应用程序的企业来说，它是一种理想的编程语言。

## Node.js 和 Python 的流行度

一种后端技术的受欢迎程度对它是否会被用于你的项目起着关键作用。

首先从公司的角度来看，开发团队必须确定哪种语言在市场上有相当程度的人才储备。从程序员的角度来看，他们必须思考是否愿意学习那些许多公司大量使用的语言。

按网站热度来看，[SimilarWeb](https://www.similartech.com/compare/nodejs-vs-python) 报告称，Node.js 享有「热度前 10,000、前 100,000 、前 1,000,000 的网站以及『所有网站』类目中使用最多的工具」之名。

根据 [Stack Overflow](https://insights.stackoverflow.com/survey/2019) 2019 年的调查，Python 语言是最受「喜爱」的编程语言，而 Node.js 则是专业程序员最偏向使用的工具。

---

根据行业采用情况来看，Node.js 在计算机电子与技术、生活、艺术与娱乐以及其他 16 个类别中均处于领先地位。而 Python 则是科学与教育、工程和其他一些行业的热门选择。

## Node.js 和 Python 性能比较

当你的应用程序规模扩大时，每一点执行效率提升都有助于减少运营成本。因此，在评估一种编程语言或环境时，性能和速度是很重要的。

#### Node.js

我们已经探讨了 Node.js 的非阻塞架构。有了这个优势，它的执行过程更加简单和快速。在此基础上，还有一个优势使得 Node.js 成为一个坚实之选，那就是它可以在网络浏览器之外执行代码。

这样，在浏览器上运行的应用程序处理速度更快，并因此在效率指标上表现得更好。该特性还允许应用程序使用原本在浏览器中无法使用的功能，如 TCP 套接字。

#### Python

Python 的架构天生不支持多线程，因此在这方面也是一个问题。因为任务处理不是并行运行的，处理速度受到了降低。虽然 Python 的语法易于学习和运行，但对于需要频繁从 Web 服务器调用数据的应用程序来说，它的速度还是不够快。

---

Python 的语法很易于学习，但它没有针对速度和性能进行优化。在这方面，Node.js 也是明显的赢家。

## Node.js 和 Python 的社区

社区是投身技术的用户和开发者群体。由于他们的活跃性，他们会不断更新流行的库，进行调试练习，甚至增加新的功能。一般来说，最有效的社区是由是由单一、专门的组织来管理对应的语言或编程环境的社区。

#### Node 的社区

你可能会认为由于 Node.js 是一种相对较新的技术形式，从而误以为其社区规模很小。然而实际上，Node.js 社区规模之大可能会令你震惊，在全球范围内活跃着众多经验丰富的 [Node.js 开发者](https://www.simform.com/hire/node-js-developers/)。在 Node.js 圈子里要发现人才超级容易。

#### Python 的社区

Python 作为这两种语言中的老大哥，自然拥有更大的社区。从初级到高级的贡献者，Python 并不缺乏人才。如此壮大的社区的最大优势之一就是容易找到开发者。正是因为这些开发人员的积极参与，为 Python 带来了快速的解决方案和语言总体的改进。

![nodejs.org](https://cdn-images-1.medium.com/max/2000/0*hJFJeIr9c3-naAvA.jpg)

## 什么时候应该使用 Node.js

Node.js 是一款适合运行需要在服务端和浏览器端之间保持可靠连接的应用程序的运行时环境。

考虑应用程序中是否需要 Node.js 的一种简单方法是对应用程序的实时特性进行评估。如果实时数据传输对应用程序的可用性至关重要，那么 Node.js 正是您所需要的。

同样值得注意的是，Node.js 在服务端和客户端都可使用。这将减少部署时间，并使团队在协作中维护代码变得可行。

由于其高效的处理能力，Node.js 是云服务器和客户端应用之间频繁交互的公司使用的首选平台。Netflix、LinkedIn、**Medium**、Trello 和 Paypal 是其中几个使用 Node.js 作为平台的知名技术公司。

![docs.python.org](https://cdn-images-1.medium.com/max/2000/0*Zc2tp-LTZZqoptD9.jpg)

## 什么时候该使用 Python

Python 拥有充足的人才供应，部分原因是由于其不复杂的语法。因此，谷歌和 Facebook 这两个最大的技术人才消费者大量使用 Python 来构建技术也就不足为奇了。

此外，一些最受欢迎的数据科学培训课程使用 Python 作为教给学生的默认语言。因此，Python 人才的供给仍在不断上升。

进一步讲，Python 的流行使学习和使用它具有了重要的战略意义。它丰富的库允许你非常高效地建立和部署一个 MVP 设计模式。这也确保了开发人员的资源得到最佳利用。

---

还有呢! 负责执行代码的 Python 解释器是超级有效的。它不需要编译，这使得 Python 成为快速部署和迭代的理想语言。

## 总结

在 Node.js 和 Python 之间进行选择有时很棘手，特别是当你想开发一个完整的产品，而不仅仅是一个附带项目时。双方的功能和优势都可能是压倒性的，可能会模糊你的判断。

摆这种困境的最佳方法，是关注产品的最终用途。列出你产品的所有特性，以及你计划如何设计它们。最终对你的设计更有帮助的语言或运行时环境就是你的不二之选。

如果你发现自己仍然感到困惑，或者不知道自己是否做出了正确的决定，请随时在文章下方评论区将你的问题贴上来，我们还有广大掘金社区开发者们都很乐于帮助你的呀～

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
