> * 原文地址：[Common Social Engineering Attack Strategies](https://blog.bitsrc.io/common-social-engineering-attack-strategies-23357db3d2d5)
> * 原文作者：[Alicia Jones](https://medium.com/@alicia1990jones)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/common-social-engineering-attack-strategies.md](https://github.com/xitu/gold-miner/blob/master/article/2021/common-social-engineering-attack-strategies.md)
> * 译者：[jaredliw](https://github.com/jardliw)
> * 校对者：[KimYangOfCat](https://github.com/KimYangOfCat)，[PingHGao](https://github.com/PingHGao)

# 常见的社会工程攻击策略

![Photo by [Sigmund](https://unsplash.com/@sigmund?utm_source=medium&utm_medium=referral) on [Unsplash](https://unsplash.com?utm_source=medium&utm_medium=referral)](https://cdn-images-1.medium.com/max/10368/0*DLH5MYlvMGvzK8jC)

随着技术的飞速发展，我们在日常生活中面临的网络威胁数量也将随之增加。我们当前的时代有时也被称为“数据时代”。网络上充斥着如此多的数据，有些专家甚至将数据视为另一种形式的财富。当事情涉及财富时，坏人也会随之出现。

这些网络犯罪分子试图以某种方式访问这些数据并利用它们为自己谋取利益。这些形式千变万化，从勒索到使用数据制造混乱。

网络犯罪分子利用多种方法来给公司和个人制造问题，其中一种方法被称为社会工程。让我们来看看这是什么。

## 什么是社会工程？

尽管“社会工程”一词听起来像是工程师的某种社团，但它指的另有其物。社会工程学是操纵人类心理以完成恶意任务的技术。社会工程在此过程中不涉及任何技术类型的黑客攻击。

在典型的黑客攻击场景中，黑客试图通过识别和利用网络中的漏洞来访问公司网络。但是在社会工程攻击中，攻击者会试图操纵员工以泄露敏感信息，攻击者可以利用这些信息来执行各种操作。

如今，社会工程攻击变得越来越普遍，攻击者更专注于寻找欺骗员工的新方法。社会工程攻击不是件简单的事情。首先，攻击者会选择他们的目标，监视他们的活动，来寻找任何形式的心理弱点。然后攻击者试图通过利用它来获得员工的信任。一旦员工掉入陷阱，攻击者就会采取下一步的行动。

![Social Engineering Attack Lifecycle — Source: [McAfee](https://twitter.com/netsafenz/status/575451458763497473)](https://cdn-images-1.medium.com/max/2000/0*1gqdskcDdajeQwSY)

> 图中文字注解：
>
> 社会工程攻击可分为四个阶段：
>
> 1. 调研（可选）
>
>    了解目标以便布下成功的圈套。
>
>    - 收集有关个人和/或组织的背景信息。
>    - 选定最容易接近目标的人。
>    - 计划如何与目标交流，确认他/她能带来的杠杆效应。
>
> 2. 部局/下饵
>
>    为一场成功的攻击做好准备。
>
>    - 与目标互动。
>    - 编造谎言。
>    - 创造亲密关系。
>    - 控制交流。
>
> 3. 行动
>
>    获取信息，并让计划一直持续下去，直到完成。
>
>    - 维持伪装。
>    - 加强关系控制。
>    - 提取信息。
>
> 4. 全身而出
>
>    结束交流，不引起对方怀疑。
>
>    - 将“游戏”自然地结束。
>    - 提供一个合理的理由，让目标“保持安静”。
>    - 掩盖痕迹。

你可以在你的组织中设置最好的安全协议，但熟练的社会工程师依然可以找到方法，绕过你设下的高端的安全措施，并且设法发起攻击。即使是最大的科技公司，也发生过了无数次的社会工程攻击。我们将在下面看到其中的一些例子。

## 主要针对哪些人？

社会工程攻击主要针对组织中价值高的员工。攻击者不会浪费时间来攻击小型企业，而是会尝试针对大型公司，有时甚至是政府，以造成最大的破坏。

多项调查显示，新员工最容易受到社会工程攻击，因为他们还没有为此类攻击做好心理准备。这些攻击手段非常复杂，以至于在造成损害之前你永远不会意识到自己正在被操纵。

让我们来看看常用的攻击技术。

## 常用的攻击技术

### 网络钓鱼

网络钓鱼是最常用的社会工程攻击技术之一。这是一种冒充合法人，并通过电子邮件或短信方式提取敏感信息的欺诈方式。

网络钓鱼攻击主要针对大量人群，并且没有单一的特定目标。就好比钓鱼，你不会试图钓到一条特定的鱼，而是尝试钓到任何鱼。因此，这些网络钓鱼活动是批量进行的，以覆盖大量毫无戒心的人。

网络钓鱼攻击的一个例子是通过发送给用户的电子邮件，强调他们的 PayPal 帐户因可疑行为而被阻止。这会让收件人产生一种恐慌感，使他们匆忙地点击电子邮件中的链接而忽略了其中的可疑之处。点击这些链接后，他们将被重定向到一个**诈骗网站**，该网站看起来与 PayPal 高度相似，就连网址也几乎相同。一旦提交了帐户凭据，攻击者也将获取相应的凭据。另一种可能的情况是，一旦点击链接就会下载恶意软件，并在你的本地系统上自行执行。

由于网络钓鱼攻击是针对许多用户且是批量进行的，邮件服务商很容易在这些攻击给用户带来麻烦之前就检测并阻止它们。

![Photo by [Sticker Mule](https://unsplash.com/@stickermule?utm_source=medium&utm_medium=referral) on [Unsplash](https://unsplash.com?utm_source=medium&utm_medium=referral)](https://cdn-images-1.medium.com/max/11520/0*HF9_pUgDR-gjl9Qj)

### 鱼叉式网络钓鱼

鱼叉式网络钓鱼是一种更有针对性的网络钓鱼版本，攻击者将目标锁定在选定的员工或公司。这种形式的攻击需要攻击者付出巨大的努力，甚至可能需要几个月的计划和准备时间。攻击者需要收集主题相关的个人信息，例如工作、个性、特征甚至是联系方式。一旦收集到这些信息，攻击者就会通过电子邮件或短信发送一条消息，情况类似于网络钓鱼，但这些消息是针对每个目标量身定制的，使攻击看起来不那么明显。

如果没有出现任何的差错，这类型的攻击往往是最成功的。由于邮件只是被少量地发送，邮件服务器很难检测和阻断这类型的攻击。

### 下饵

下饵是一种攻击技术，利用虚假承诺来触发受害者的贪婪或好奇心，将其变成攻击者的优势。它的主要特征是黑客用来欺骗受害者的善意承诺。攻击者要么窃取敏感信息，要么将恶意软件强加到毫无戒心的受害者设备上。

下饵攻击以物理和线上攻击的形式进行。在物理攻击中，受恶意软件感染的设备将被放置在公共可访问区域，一些已知潜在受害者常出没的地方。这些设备看起来非常真实，并且包含标签，标注着一些让人感兴趣的东西。

一个示例场景是攻击者将受恶意软件感染的 U 盘留在受害者可访问的公共区域。这个 U 盘会被标记上一些令人不可抗拒的东西，比如公司的高绩效客户，或者一些色情材料。 一旦受害者将此设备插入他们的计算机，恶意软件就会感染主机并能让攻击者远程采取行动。

如果是线上攻击，受害者将被“好得令人难以置信”的广告引诱，引诱他们访问恶意网站或鼓励用户下载已被恶意软件感染的应用程序。

### 交换条件（Quid Pro Quo）

交换条件可以说是下饵的一种变体。Quid Pro Quo 是一个拉丁语短语，在汉语中表示“服务的交换”。这种形式的攻击将承诺提供某种服务，而不是商品。

最常见的交换条件攻击之一包括冒充美国社会保障局（SSA）。这些冒名顶替者联系毫无戒心的人，并以技术原因要求他们确认他们的社会保障号码。完成此操作后，攻击者可以轻松进行身份盗用。

在联邦贸易委员会（FTC）发现的其他案例中，欺诈者建立了虚假的 SSA 网站，声称他们可以帮助人们注册新的社会保障卡，但实际上窃取了他们详细的个人信息。

### 假托

假托是一种社会工程攻击技术，主要通过建立信任来操纵单个受害者。攻击者通常将自己表现为拥有知情权的人，例如同事、警察、银行或税务官员，然后攻击者以确认受害者身份为借口提出问题，然后将敏感信息用于自己的用途。

虽然这些攻击者大多只收集个人数据，但也曾有过攻击者通过这种方法来获得与工业工厂相关的安全信息的事件。

这种攻击形式的成功在很大程度上取决于攻击者能够与受害者建立的信任程度。许多复杂类型的假托攻击试图诱使受害者采取行动，使得攻击者能够找到并利用企业内的漏洞。

### 恐吓

恐吓是一种攻击类型，受害者会被带有虚假警报和虚构威胁的弹出窗口和电邮的轰炸。这些很常见，但效果最差。你可能会在多个网站上看到带有“您的计算机可能感染了有害间谍软件程序”的弹出窗口。单击这些链接后，你将被引导安装“能删除恶意软件”应用程序，该应用程序本身包含恶意软件，或者将你引导至能感染你的计算机的恶意站点。

另一种类型的恐吓软件在你的垃圾邮箱中很常见。你的垃圾邮件箱中充满着“好得令人难以置信”优惠或是虚假的威胁。你的邮件服务器可能会很好地识别和隔离这些电子邮件，因此这种形式的攻击是最无效的。

---

社会工程攻击者使用多种策略来成功实施他们的攻击。最常见的策略之一是**提供不可抗拒的东西**。该策略利用人类的贪婪来实现攻击者想达到的结果。另一个常见的策略是**伪装**。这种策略主打感情牌，将自己伪装成受害者，并最终让员工相信你的故事。**展示权限**也是攻击者在冒充某人时使用的另一种策略。由于人们倾向于尊重具有**权威**的人，或**表现出权威**的人，因此这个技巧在大多数情况下都奏效。

## 历史上最著名的社会工程攻击

### Facebook 和 Google

在 2 年多的时间内，[Facebook 和 Google 被诈骗了](http://fortune.com/2017/04/27/facebook-google-rimasauskas/)超过 1 亿美元。一个立陶宛的黑客冒充这两家公司的亚洲供应商向他们发送虚假发票。这被认为代价最高的网络钓鱼攻击之一。

### 芭芭拉·科克伦（Barbara Corcoran）——《创智赢家》

《创智赢家》的裁判 —— Barbara 差点陷入社会工程攻击，[这将使她损失 400,000 美元](https://www.cnbc.com/2020/05/06/how-barbara-corcoran-almost-lost-400000-dollars-to-an-email-scam.html)。一名攻击者冒充她的助手，联系她的簿记员，要求支付她的房地产投资的续期费用。攻击者使用的电子邮件地址与合法助理的电邮地址非常相似。当簿记员就电汇事宜联系助理时，这才发现了这个诈骗案。

尽管这笔钱已经离开了 Barbara 的账户，但他们还是成功地在这笔交易到达攻击者在中国的账户之前冻结它。

### 丰田（Toyota）

丰田纺织（Toyota Boshoku Corporation）是一家日本汽车零件制造商。它是丰田集团公司的成员。他们在[2019 年社会工程攻击](https://www.forbes.com/sites/leemathews/2019/09/06/toyota-parts-supplier-hit-by-37-million-email-scam/）中损失了大约 3700 万美元。目前尚不清楚丰田是否能够追回损失的资金。攻击者说服具有财务权限的人员更改了电子资金转账的帐户信息。

### 以太坊经典版（Ethereum Classic）

[以太坊经典版的网站在 2017 年被黑客入侵](https://www.trendmicro.com/vinfo/us/security/news/cybercrime-and-digital-threats/ethereum-classic-wallet-a-victim-of-social-engineering），使用户损失价值数千美元的加密货币。社会工程攻击者冒充网站的所有者并访问其域名的注册表。当他们收到访问权限后，将域名重定向到自己的服务器。攻击者后来能够查看受害者的私人交易，并从他们那里提取加密货币。

### 索尼影视娱乐（Sony Pictures）

这个社会工程攻击是当时最大的话题之一。索尼影业[在 2014 年受到攻击](https://www.washingtonpost.com/news/the-switch/wp/2014/12/18/the-sony-pictures-hack-explained/)并因此失去了几个重要文件，包括业务协议、财务文件和员工信息。后来，这次的攻击被确定为是鱼叉式钓鱼攻击，目标员工是通过 Apple 产品的电邮而被引诱的。

## 作为个人，我该如何保持安全？

* 不要打开可疑来源的电子邮件和附件。请务必检查发件人的电子邮件地址，即使是来自受信任发件人的电子邮件地址也可能存在诈骗。
* 使用多因素身份验证（MFA）。攻击者对你的登录凭据非常感兴趣。但是，如果你使用多因素身份验证，攻击者将无法单独使用你的凭据执行任何操作。
* 小心那些“好得令人难以置信”的优惠。如果优惠听起来好得令人难以置信，请在谷歌上搜索有关信息，以了解它是否合法。
* 确保你的防毒软件保持最新的状态。
* 不使用设备时，请始终将它锁定。
* 与人交谈时始终保持谨慎。说话前请三思，你可能会无意中说出一些可能属于机密的内容。

## 作为一个公司/组织，我该如何保持安全？

根据 Dan Lohrmann（Security Mentor 的首席安全官）的说法，

* 专注于培训你的员工，尤其是新员工。确保你有一个全面的安全意识培训计划，并定期更新它们，以解决一般网络钓鱼威胁和新的且有针对性的网络威胁。请记住，攻击不仅仅发生于点击链接。
* 定期举行“路演”简报会，解释最新的攻击趋势。 确保所有级别的员工都参加这些简报会，包括高级管理人员和对金融交易有权力的人。
* 聘请外部独立安全团队来审核你公司的安全。这些审计应定期进行。

---

我们必须保持适当的安全措施，以避免自己和公司陷入困境。正如我们在上面看到的，这些攻击的代价可能非常高。我们有责任保护自己不被潜伏在周围的邪恶眼睛所盯上。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
