> * 原文地址：[A Layman’s Intro to Quantum Computers](https://betterprogramming.pub/a-laymans-intro-to-quantum-computers-67b7a7126695)
> * 原文作者：[David Mooter](https://medium.com/@davidmooter)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/a-laymans-intro-to-quantum-computers.md](https://github.com/xitu/gold-miner/blob/master/article/2021/a-laymans-intro-to-quantum-computers.md)
> * 译者：[PingHGao](https://github.com/PingHGao)
> * 校对者：[samyu2000](https://github.com/samyu2000)，[nia3y](https://github.com/nia3y)

# 外行说量子计算机

![照片由 [Zoltan Tasi](https://unsplash.com/@zoltantasi?utm_source=medium&utm_medium=referral) 发布于 [Unsplash](https://unsplash.com?utm_source=medium&utm_medium=referral)](https://cdn-images-1.medium.com/max/9792/0*FPUtmaqNJ12IcZx8)

量子计算机具有彻底改变信息技术的潜力。许多分析师认为当前的量子计算机与 1940 年代房间大小的计算机一样，还处于初级阶段。在接下来的几十年里，它们可能会以与经典计算机相同的指数速度发展。不幸的是，关于量子计算的文献通常是**由**内行人（拥有物理学学位的人）**写给**内行人看的。在这里，我将用通俗的语言解释量子计算：包括它的工作方式、它与经典计算机的差别，以及为什么它能引领技术变革。

## 经典比特 vs 量子比特

经典计算机的内存系统是由经典比特组成的。其中每个比特都有两种状态，表示 “0” 或 “1” 。随着你使用的比特数越来越多，你可以存储更多的信息。

例如，两个比特可能有四种状态：“00 01 10 11”。三个比特可能有八种状态：“000 001 010 011 100 101 110 111”。

从物理角度理解，这些经典比特就是电路元件，其中 “0” 和 “1” 代表流过它们的电流大小。

量子计算机维持着一系列的量子比特，每个量子比特也有两种状态，可以用 “0” 或 “1” 表示。然而， 这些量子比特不是电路元件。相反，它们是固定在一个地方的亚原子粒子 —— 固定不动。它们通过各种方式来表示 “0” 或 “1”，具体取决于量子计算机的类型。但是，不需要知道其中的细节，就可以理解它们的用途。

与经典比特不同，当你测量量子比特时，并不总是能得到相同的结果。相反，量子比特的状态可以被认为是在一个球体的表面上。北极和南极分别代表最终状态 “0” 和 “1”。当量子比特的状态更接近北极点时，它表示在测量时进入 “0” 状态的几率更高，等等。例如，位于赤道上的量子比特有相同的机会走向任一方向。在测量下图中的量子比特时，由于离北极更近，它最终状态为 “0”（北）的几率明显高于 “1”（南）。

![将量子比特的状态表示为球体表面上的一个点。图片来源：作者。](https://cdn-images-1.medium.com/max/2000/1*6ek0KRvlg8Q22Bs0vij9YA.png)

## 第一个区别：确定的状态 vs 随机的状态

这是它与经典计算机的第一个区别。经典比特对应明确的 “0” 或 “1”。相比之下，一个量子比特对应成为 “0” 或 “1” 的**概率**。例如，如果一个量子比特有 60% 的概率成为 “1”，那么你可以将其视为存储着 “60%” 这个值。通过重复多次量子计算并观察结果，你可以在一定程度上确定该概率是多少。因此，它可以存储从 0 到 1 的无限数量的值，但代价是这一结果始终具有某种程度的统计不确定性。量子算法通常是概率性的，它们在某个已知概率范围内提供正确结果。相比之下，经典计算机的本质是确定性的，可以完全确定的输出一个答案。任何计算机科学家都知道，让经典计算机真正随机化是相当困难的，因为它们非常倾向于给出确定性的答案。

## 经典逻辑门 vs 量子逻辑门

计算机通过各种逻辑门来进行运算。这些逻辑门一般需要一个或两个输入参数，并对输入参数进行某种运算，得到输出结果。例如，对于“与”们来说，如果两个输入是 “1”，其输出也是 “1”；否则它输出 “0”。下面展示了两个逻辑门：

![两个经典的逻辑门。图片来源：作者。](https://cdn-images-1.medium.com/max/2000/1*nnCAiy_9xEhyqQwmToybyw.png)

量子计算机使用量子门对其量子比特进行运算。这些计算让量子比特围绕球体表面移动，这意味着输入和输出是同一个量子比特的不同状态。例如，一个量子门可能会将量子比特翻转到球体的相反部分或围绕着其一个轴旋转。有些门接受一个输入。有些门需要两个或更多，此时每个输入的状态影响所有输出状态。在下图中，我们看到，量子门令之前的量子比特围绕垂直轴线旋转。

![量子门使量子比特在球面上移动。图像来源：作者。](https://cdn-images-1.medium.com/max/2000/1*UsZeojy60miuuh5Wmd1tOg.png)

## 第二个区别：十分不同的逻辑门

经典计算机的逻辑门在输出一个新比特的同时不会改变其输入比特。而量子计算机的逻辑门直接改变其输入比特的状态，并不产生新的输出比特。此外，所有量子门都是可逆的，但并非所有经典门都是可逆的（见上图的两个门 —— 不是总能从输出推断输入）。最后，数学家已经证明，所有经典门都可以使用量子门的组合来创建，但有些量子门不能由经典门创建。换句话说，量子门能实现经典计算机无法实现的操作。这意味着发明新算法的可能。

## 量子纠缠

两个或多个量子比特可能会纠缠在一起。这意味着测量一个量子比特会立即影响其他量子比特，即使它们深处宇宙的对侧。一个简单的例子是，如果你有两个量子比特，观察一个会导致另一个在被观察时总是产生相反的结果。另一种可能是观察一个量子比特的结果会影响另一个量子比特变为 “0” 或 “1” 的概率。这提供了基于整个数据系统的算法，而非每次操作一位。

## 第三个区别：比特之间的依赖性

一种理解方式是，两个纠缠的量子比特的状态不再相互独立。

下方的左图显示了两个未纠缠的量子比特 —— 蓝色的 A 和红色的 B。两者都有一半的机会变成 “0” 或 “1”。每种组合的几率是相同的：“00” 的几率为 25%，“01” 的几率为 25%，等等。已知 A 或 B 的值并不能推导出另一个比特的任何信息。

在下方右图中，显示了两个纠缠的量子比特。在这种情况下，已知其中一个比特的值就可以得到另一个比特的一些信息。如果已知量子比特 B 为 “0”，那么量子比特 A 为 “1” 的概率是 “0” 的两倍。但是如果量子比特 B 是 “1”，那么量子比特 A 一定是 “0” —— 它们不再是独立的。

![图片来源：作者。](https://cdn-images-1.medium.com/max/2000/1*aAorGuHgmX7o-HkKhEJkJg.png)

## 量子叠加

回想一下，当观察到一个量子比特时，会产生一个随机结果。你会凭直觉认为量子比特在这两种状态之间摇摆不定，就像硬币在空中翻转、正反交替， 直到它落地才能得到最终结果。然而，实际上，在同一时间，一个量子比特既是 “0” 又是 “1”。这是因为存储量子比特信息的粒子可以同时具有不同的能量水平或位于不同的位置。当量子粒子与其他事物（例如测量其能量或位置的工具）相互作用时，它会随机“坍缩”到某个状态。

### 放下你的怀疑

我需要打断对量子叠加的描述，并消除大多数人的主要障碍：难以置信并且感到很困惑。你现在可能认为，“一个东西怎么会同时出现在两个地方？这不可能！”

我向三位量子物理学博士提出了这个问题。其中一位回答说，你只需要停止怀疑，相信已有的数学和实验已经证明它是正确的。另外两人的回答更有说服力。我们生活的宏观世界与微观世界是完全不同的，所以我们无法将宏观上观察到的情况应用于宇宙最微观层面。

为了便于接受这些理论，请思考一些宏观层面的问题。爱因斯坦证明光速无法超越。从我们人类思维角度来看，这在直觉上似乎也是不对的：当我接近光速时，为什么我不能继续踩油门？然而，这一理论已被普遍接受。

因此，当我说一个量子比特可以同时位于两个不同的位置或同时具有两个看似矛盾的能量级时，请接受它，不要试图更深入地思考原因。

现在再回到介绍量子叠加态的地方 ...

## 第四个区别：指数增长

经典比特只能处于 “0” 或 “1” 两种确定的状态，而量子比特可能同时处于两种状态的叠加。一个长度为 32 的经典比特序列可以有大约 40 亿种组合。一台经典计算机一次只能处理其中一个。32位量子比特序列可以同时包含 40 亿种组合。因此量子计算能力呈指数增长，而经典计算机只能呈线性增长。

例如，如果我想搜索某个 8 位的键值组合，一个 16 位的计算机可以一次执行两次并行搜索，搜索速度是 8 位计算机的两倍。 32 位计算机将允许一次进行四次并行搜索，搜索速度是 8 位计算机的四倍。这意味着当其位数加倍时，经典计算机的能力加倍。

将其与量子计算机进行对比。如果量子计算机有一个量子位，那么它同时存储两个状态（“0 1”），因此可以同时搜索这两个状态。如果它有两个量子比特，那么它会同时存储四个状态（“00 01 10 11”），并且可以同时搜索所有四个状态，使其速度是单个量子比特计算机的两倍。如果它有三个量子比特，那么它会同时存储八个状态 (“000 001 010 011 100 101 110 111”)，并且可以同时搜索所有八个状态，因此它比单个量子比特计算机快 4 倍。因此，每增加一个量子比特，量子计算机的能力就会加倍。

不过，你可能还记得，量子比特有一个问题：当我们进行测量时，只能随机得到这些组合中的一种。如果我们想利用其同时处于多种状态的能力，这不是很有用。如何解决这个问题？答案是波干涉。

## 波干涉

如果你忘记了高中科学课的内容，让我们回顾一下波的原理。您可以在水池中看到，当两个波浪相遇时，它们会相互影响。当两个波的波峰和波峰相遇时，它们会相互增强，有更强的波峰和波谷。但是当波峰和波谷相遇时，它们会相互抵消，导致没有波浪。

![图像来源： [Veritasium](https://www.youtube.com/watch?v=Iuv6hY6zsd0) with edits by author](https://cdn-images-1.medium.com/max/2000/1*jR6AB_iN8UKjh-H55KQ3hw.jpeg)

从本质上来说，量子比特的特性来自于能量波，它与池塘中的水波具有相同的特性。有一些复杂的算法（其数学原理超出了本文的范围）通过波的干涉效应来抑制错误的能量状态，同时放大正确的能量状态。通过在测量量子比特之前多次重复该算法，可以降低错误状态被测量出来的概率，提高期望状态被测量出来的概率。即使量子比特同时处于所有状态，你也可以通过在放大你想要的状态的同时抑制不想要的状态，从而在一定的置信度内找到问题的正确答案。

## 应用

量子计算机有望在某些领域超越经典计算机。下面是一些例子。

* **人工智能与数据科学** 大部分人工智能都建立在复杂的统计数据和在复杂数据中进行模式搜索的基础上。量子算法具有同时搜索所有状态的能力，所以它很适合在复杂数据中查找模式。这不仅可以用于人工智能，还可以用于数据科学的其他领域。
* **密码学** [Shor 算法](https://en.wikipedia.org/wiki/Shor%27s_algorithm) 是一种理论量子算法，可以破解大多数非对称密码。另一方面，量子纠缠为新加密模式提供了可能性。两个纠缠的量子比特即使分别移动到宇宙的对侧，也相互关联。使用纠缠的量子比特加密在数学上是不可破解的，因为没有共享密钥。例如，如果我有一对纠缠的量子比特，它们的观察值总是相同的。我可以将一个量子比特给我的消息接收者，然后将另一个量子比特改变为我期望的值。当我的接收者读取他的量子比特的值时，他得到的值与我设置的值相同，而且信息不需要传递就能被接收。
* **金融与天气模型** 量子比特的随机性使它们更适合模拟复杂的随机系统，如金融市场和天气。投资者往往希望在随机产生的大量场景下评估各种结果的概率。决定天气的变量非常多，所以传统计算机进行天气预测所需的时间比天气演变所需的时间还要多。此外，麻省理工学院的相关研究表明，控制天气的方程具有隐波性质，可以通过量子计算机进行求解。
* **分子建模** 分子模型非常复杂，因此经典计算机只能对最简单的分子进行建模。在化工领域，量子计算机可以对复杂分子建模，以便开发新型化合物，应用潜力巨大。

## 你的 IT 组织应该如何抉择

量子计算的应用还存在两个关键的瓶颈。最大的限制是量子计算机还处于起步阶段，目前很少有商业上可行的选择。第二是量子计算机永远不会在所有领域击败经典计算机。相反，它们仅在某些特定类型的计算任务上有优势。在大多数计算任务中，经典计算机仍将优于量子计算机。这意味着经典计算机将继续存在。

尽管如此，你的企业现在可以采取一些措施来为量子竞争做准备。以目前量子计算机的发展程度，数据科学家已经能识别适合量子计算机的算法，并识别出现有量子计算机能够胜任的用例。应当开始让你的数据科学团队培养量子算法技能。让他们确定哪些计算任务更适合量子计算。更具体地说，确定某些更适用于量子计算的模式并记录，以便其他数据科学家可以依据这些模式识别出包含这些特征的数据集。这将允许数据团队列出哪些当前的商业案例（以及未来出现的商业案例）适合量子计算，包括量子计算机需要达到什么样的成熟度才是商业上可行的。最后，根据你的数据科学家识别的适合量子计算的业务问题，制定利用量子计算的战略计划。

下面的一些资源能够帮助你发展自己的量子技能：

* [Quantum Computing Playground](http://www.quantumplayground.net/) 是一个可以在网络浏览器中运行的量子模拟器。它不能如真正的量子计算机那样强大，但提供学习量子计算机概念的机会。
* 微软发布了一种[称为 Q# 的量子语言](https://www.microsoft.com/en-us/quantum/development-kit)，它也可以在量子计算机模拟器中运行。
* 最后，[IBM 量子计算机体验中心](https://quantum-computing.ibm.com/)有一台真正的连接到互联网的量子计算机。使用 IBMid 帐户，你可以在他们的量子计算机上运行自己编写的代码并访问他们的量子社区论坛。

量子计算正在快速发展。通过在你的数据科学组织中播下量子技能的种子并立即制定相关的战略计划，最终，你的组织将能够得心应手的利用量子计算的优势，而此时竞争对手才开始了解量子计算。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
