> * 原文地址：[5 Misconceptions About UI Design Systems](https://blog.bitsrc.io/5-misconceptions-about-design-systems-82453ff10acf)
> * 原文作者：[Nethmi Wijesinghe](https://medium.com/@wnethmi96)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/5-misconceptions-about-design-systems.md](https://github.com/xitu/gold-miner/blob/master/article/2021/5-misconceptions-about-design-systems.md)
> * 译者：[CarlosChenN](https://github.com/CarlosChenN)
> * 校对者：[Z招锦](https://github.com/zenblofe)，[zaviertang](https://github.com/zaviertang)

![](https://cdn-images-1.medium.com/max/5760/1*Sc7Rrut8tE9_WnWIlLlY4g.jpeg)

# 5个关于 UI 设计系统的误区

> 你之前是否听过这些设计系统的误区？下面是他们背后的事实。

在现代 web 开发中，开发一个产品时，维持统一的设计语言是至关重要的。它可以加快开发进程、提高用户体验以及帮助处理设计矛盾。

然而，有许多关于设计系统的误区，可能会误导开发者。本文将介绍五个你应该注意的误区。

## 1. 设计系统是不是为了设计师而设计的？

其中一个有关设计系统常见的误解是设计师开发设计系统，而开发者只是使用它。这主要是因为对于设计系统边界的误解。

虽然设计系统从产品设计或用户体验团队开始，但它并未就此结束。

鉴于现代 web 应用是用 UI 组件集合开发的，设计系统的范围跨越简单的 UI 元素，比如按钮或者段落，一直到整个应用。

因此，开发一个设计系统需要开发者和设计师的参与和洞悉。

## 2. 设计系统会限制灵活性

另一个有关设计系统常见的误解是在尝试升级或者改进一个设计的时候，设计系统限制了灵活性。

一方面，为了保持一致性，设计系统应该是精确和不变的。另一方面，它也应该为主题、段落、颜色、边框等提供灵活性。换句话说，一个设计系统应该提供自定义外观和风格的能力。

除此之外，你不应该害怕重用设计系统，允许你的组件继承自他们的设计特征。无论如何，如果它不起作用，你可以自己创建一个。

## 3: 设计系统只是一个风格引导

这是关于设计系统误解中，最常见的一个。一个组件库或者一个设计只能可以很大程度上影响一个设计系统内容。

然而，一个合适的设计系统包含更多内容，例如：

* 设计令牌
* 品牌规范
* 规则、约束和准则
* UI 工具
* 代码组件

在一个设计系统中，这些特征是建立整个应用的标准所必需的。

## 4: 设计系统是固定的

确实，一个设计系统的风格不需要每隔一天就改变。但应该能够在同一个构建模块中，不断的改进和改变设计系统，去适应当前的趋势和用户行为 — 规则、约束和准则

有一个设计系统的一个显著优势是，改进可以只用少量的工作就快速完成，因为设计系统是在可重用组件的基础上构建的。

## 5: 每个产品的设计系统应该是独一无二的

每一个产品都是独一无二的，并且有时候适用于一个产品的功能，并不适用于另一个。但那不代表一个设计系统不能在产品之间重用。

在某些例子中，为每个独一无二的产品设计不同的设计系统是合理的。但如果一个公司有一个相互关联的产品组合，重用一个单一的设计系统，通常是确保遵循品牌规范的最佳方案。

最大的好处是，公司不必每次开发新产品时都要从头开始。

并且，他们可以使用设计系统引用和重用以前创建的组件，根据需求开发新的特性。

## 本文总结

构建一个设计系统一开始可能是漫长的，但长期收获来看，这是值得的。好的设计系统弥合了设计师和开发人员之间的差距，让他们更有效率。

设计系统有助于部门间的协调，从而在产品的每个接触点上产生一致的 UI 和 UX。

因此，开发人员和设计人员之间的协作对于构建更好的设计系统至关重要。所以，不管你是设计师还是开发者，不要让这里列出的误解阻碍你创建和维护设计系统。

感谢您的阅读！

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
