> * 原文地址：[100 Tips on Software Developer Productivity](https://dev.to/apkoponen/100-tips-on-software-developer-productivity-36if)
> * 原文作者：[Ari Koponen](https://dev.to/apkoponen)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2021/100-tips-on-software-developer-productivity.md](https://github.com/xitu/gold-miner/blob/master/article/2021/100-tips-on-software-developer-productivity.md)
> * 译者：[jaredliw](https://github.com/jaredliw)
> * 校对者：[acev](https://github.com/acev-online)、[finalwhy](https://github.com/finalwhy)

# 100 个能提升软件开发效率的小技巧

过去十年，我一直专职从事软件开发行业，并从中总结出 100 条关于**软件开发效率**的经验：

1. 在你的职业生涯初期，学习如何“快速地写代码”会显著地你的工作效率。但当你积累了足够的工作经验后，它带给你的影响将大大减少。你需要留意何时会发生这种转变。

2. 乐于尝试“打破思维”。很多高大上的小技巧确实是行之有效的。

3. 写下待办事项。

4. 定一个确切的目标能让你行动得更快。

5. 做事拖延是很平常的事情。不过请记住，千里之行始于足下。

6. 适合别人的东西不一定适合你。

7. 试试番茄工作法，它可能对你有用。

8. 发掘能提高效率的事物。

9. 设定一些能让你提高效率的界限或规则。

10. 强烈的内在动机和好奇心胜过一切提高效率的小技巧。

11. 发掘能激发内在动机的方法。

12. 尝试结对编程并观察别人是如何写代码的。你可能会从中学到一些提升效率的技巧。

13. 努力培养良好的直觉。你的直觉比你想象中更能影响你的效率。

14. 改掉坏习惯是需要付出努力的。花时间在培养好习惯中。

15. 一味地接受工作会拉低你的效率。你需要设置自己的 [WIP 限制](https://segmentfault.com/a/1190000018186305)。

16. 对于工作的痴迷会让你短时间内更有效率，但若持续太久就会使你精疲力竭。      

17. 体育运动、均衡饮食和充足的睡眠不仅不会影响、反而有利于你的工作效率。

18. 定期休息（例如，每工作 50 分钟休息 10 分钟）。

19. 长时间的工作会将你的思绪带到沙雕梗图和微博热搜上。

20. 确保你有时间专注于深度工作并进入“心流”状态。

21. 尽可能地屏蔽所有通知。

22. 在“心流”状态下会让你感到非常有效率，但这并不总是意味着你在向预定目标前进。

23. 你在“打磨”抽象类和方法中花费的数小时可能不会对客户和商业带来任何价值。（译者注：即要避免过度设计）

24. 有效率并不代表能产生影响。只为重要的事而努力。

25. 比起提升个人的效率，有经验的人更注重于提升团队或组织的整体协作水平。

26. 当解决需要协作的技术问题时，提供可行方案的能力比写代码的能力更重要。

27. 在构建应用产品中，很多问题都需要沟通。你的沟通能力会成为效率的瓶颈。

28. 在某些团队或公司中你会更有效率。

29. 渐渐地，你效率的瓶颈将会是你周围的团队和组织。

30. 开发者的效率和报酬很多时候不一定是同步推进的。

31. 对于同一个工作，一些公司开出的薪资可能更高。

32. 好的“十倍工程师”（指那些能以一扛十的工程师）是那些有着十倍的团队和人力的人。

33. 要懂得分派任务并协助执行人。学会为他人的成功庆祝。

34. 学习使用自动化。比起提升写代码的速度，排除 bug 和减少认知负荷（cognitive load）对于效率的影响更大。

35. 开发体验和人体工学不容忽视。

36. 使用代码美化工具（如 Prettier 或 Black）来自动地格式化代码。

37. 使用 linter。学习如何为团队的代码风格编写自定义规则。

38. 编写自动化测试。别将生命浪费在修改琐碎的 bug 中。

39. 设置一个持续集成（Continuous Integration，CI）流程比你想象的要容易。学习如何使用它能减少你在以后的每个项目中花费的时间。

40. 缩短反馈循环。

41. 使项目部署自动化。

42. 减少构建的次数。

43. 确保每个开发者都能在他们的电脑上运行测试。

44. 当文件被修改时自动执行相关测试。

45. 使用特性切换（feature flag）可以更快地将工作交付到生产中。

46. 你可能不需要过渡环境（stagging environment）。

47. 你可能会从过渡环境中获益。

48. 事无定数，随机应变。

49. 使用 Vim 的开发者似乎比其他开发者更有效率。

50. 不要只选择哪些让你感觉很有效率的工作。这样会使你的学习停滞，让你感觉自己在原地踏步。

51. 注重代码审查。它能帮助你保持团队的效率。

52. 每个注重代码审查的开发者都是明日之星。

53. 敏捷开发带来的实际效益很小。

54. 计算速率（velocity）和故事点（story point）很少能帮助团队提高开发效率。

55. 基于数据的实际小改变胜过于“敏捷转型（agile transformation）”。

56. 计划的目标是将庞大的项目分割成几个小块。

57. 对于时间跨度很长的大型项目，开发者更喜欢自己写自己的代码。

58. 长时间单独处理大项目的开发者很少能快速交付小增量。

59. 在短期内，共同完成一个项目的效率通常较低。

60. 共同完成一个项目能促进学习，从长期来看效率更高。

61. 对于大型代码库，开发者的效率在很大程度上取决于他们对系统的了解。

62. 将代码库分成好几个模块能帮助新来的开发者更快地提升效率。

63. 模块化结构只在 API 文档清晰且模块之间完全解耦合的情况下才有用。

64. 有时候，一个开发者比起其他人员更有效率是因为他有更多的知识和能力。

65. 在团队中，比例失调的知识和能力会导致开发者表现不佳。

66. 由于团队中知识和能力不匀称而产生的“十倍工程师”是一种反面模式，这会导致有能力的开发者离开公司；应该不惜一切代价避免此类状况的发生。

67. 只基于开发者的活动量（如，提交或 PR 的次数）来衡量效率是行不通的。

68. 尝试将开发者的效率浓缩为一个指标也是行不通的，这会让开发者失去对于公司管理层的信任。

69. 衡量每个个体开发者的效率是很困难的。如果你尝试这样做，那你很有可能会得不偿失。

70. 当你尝试衡量开发者的效率时，数据质量非常重要。基于错误的数据而做出的错误决定是要付出很大的代价的。

71. 关于软件开发效率的研究比大多数开发者想象中的要可靠得多。

72. 将注意力放在团队和组织的效率上能产生最好的结果。

73. 阅读《Accelerate》并理解 SPACE 框架是你了解开发团队效率的一个好开端。

74. 在衡量开发人员效率时，你应该有多个相互弥补、相互对立的指标。

75. 开发者的主观体验是宝贵的数据。

76. 单单依靠开发者的主观经验是不足够的，尤其是当你想要尝试提升跨组织的开发效率时。

77. 提升软件团队的效率主要是努力改善工作流程，同时保持高质量和可持续性的工作步调。

78. 衡量你的团队的周期时间和部署频率能帮助你提升工作流程。

79. 知悉你的团队在修复 bug 和开发功能中分别花费了多少时间。这能帮助你确定编写测试的优先顺序、偿还技术负债并保持代码高质量。

80. 开发软件不是短跑，而是一场马拉松。依据情况来优化。

81. 每个团队应该专注于提升自身的效率并使用必要的指标和工具。

82. 了解影响团队整体的效率能让开发者受益。

83. 很多的团队都想要在一个时间内完成太多的事情。你需要一个 WIP 上限。

84. WIP 上限能促进团队协作并帮助你部署重要的事物。

85. 对于难度较高的项目，WIP 上限能减少拖延。

86. WIP 上限和好的优先级处理能鼓励学习，并帮助开发者着手处理他们不熟悉的事情。

87. 从长远的角度来说，鼓励学习能让软件开发者更有效率。

88. 持续的良好输出比起过往的那一两件“英雄事迹”还来的可贵。

89. 从长远来看，将英雄主义置于持续的良好输出之上的组织表现得更差。

90. 开发者喜欢衡量除了自身效率以外的各种事物。

91. 对于大多数开发者来说，过早地衡量效率会毁了整件事。

92. 从行业创伤中恢复过来是很困难的。

93. 如果你想提升你的公司的软件开发速度，不要将注意力放在衡量每个个体的开发者的效率。

94. 学习关于精益生产（lean production，认为产品的价值需由最终的用户来确定）和排队论（queuing theory，通过对服务对象到来及服务时间的统计研究）的知识对于提升软件团队的效率是有益的。

95. 对其余的人来说，顾问很好地破坏了精益生产原则。

96. 衡量软件团队的效率能让工程团队感到开心。

97. 当软件团队参与其中时，衡量团队效率能让他们感到高兴且更有效率。

98. 如果开发者们没有参与，你设立的衡量标准就会被钻空子。

99. 不让开发者有适当的自主权并过度地控制他们的工作会让他们感到不满。不要进行微观管理。

100. 快乐的开发者更有效率。


> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。