> * 原文地址：[What Makes a Good Github Profile?](https://codeburst.io/what-makes-a-good-github-profile-ced754284e3d)
> * 原文作者：[Yasmine Hejazi](https://medium.com/@yazihejazi)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2020/what-makes-a-good-github-profile.md](https://github.com/xitu/gold-miner/blob/master/article/2020/what-makes-a-good-github-profile.md)
> * 译者：[caiyundong](http://github.com/caiyundong)
> * 校对者：[zenblo](https://github.com/zenblo)，[Chorer](https://github.com/Chorer)，[Hoarfroster](https://github.com/PassionPenguin)，[lsvih](https://github.com/lsvih)

# 如何打造一个好的 GitHub 用户档案？

![Photo by [AltumCode](https://unsplash.com/@altumcode?utm_source=medium&utm_medium=referral) on [Unsplash](https://unsplash.com?utm_source=medium&utm_medium=referral)](https://cdn-images-1.medium.com/max/10000/0*iwSXtYiyA_BR6bmg)

当我在大学申请实习的时候，我绝对低估了 GitHub 的作用。我在大学期间编写了很多项目，而且为每个项目写了详细的描述文档，这些文档很容易翻译为项目 README 文件。但我没有花时间在 GitHub 上面上传和维护这些项目，很快我就意识到错失了良机。

事实上，维护 GitHub 的用户档案需要花费大量的时间和精力。在你的课程进行到下一个项目时还能编写文档并保持之前代码更新是很繁杂的工作。然而，只要再努力一点点，课程项目或其他项目就能变成一个有意义的作品集，而一个作品集是让你脱颖而出的绝佳方式。

#### 哪些求职者从 GitHub 项目开发中受益最多？

初级的求职者（大学生、应届毕业生和训练营学员）从中获益匪浅，因为他们缺乏专业技术经验，参与过的项目是他们最能展示自己能力的地方。[经验丰富但寻求转型的开发人员](https://techbeacon.com/app-dev-testing/what-do-job-seeking-developers-need-their-github)也可以从 GitHub 项目中获得巨大收益。一个程序员如果不愿意接受挑战或被迫使用不受欢迎的语言编程，将很难在没有经验的情况下找到一个拥有最新技术栈的雇主。

在这篇文章中，我将从本人大学期间和导师那里积累到的所有心得整合在一起，告诉你如何创建一个 GitHub 档案来助力你的工作申请。我绝对不是 GitHub 的超级用户，但请继续阅读这些我希望大家遵循的有用的指导方针。

## 在每个项目仓库里面添加一个详尽的说明文档

为自己的代码编写文档有着长远的意义 —— 不仅仅是为了任何打算使用这些工具的用户，也是为了那些查看你个人资料的招聘人员和招聘经理。在仓库里面添加格式良好的文档，这表明了：

1. 你有很好的沟通技巧。
2. 你知道如何对一个项目进行长期投资。

在文档中，你应该指明项目的**目的和用例**，当然还包括**安装说明**，这样用户可以轻松地运行或使用你创建的任何工具或产品。最后但是同样重要的是，你应该添加一个**演示**（截图或 gif 文件是一个加分项！）或一个演示链接，以便用户可以轻松地体验你的作品。

## 编写整洁且有条理的代码

当你与一个团队合作时，能够产生干净的代码是非常必须的。对于招聘经理或团队成员来说，一个最让他们失望的事情就是当他们看到代码的时候，他们很难处理。就像使用说明文档一样，在代码中显示良好的组织结构是给人留下深刻印象而不让人失望的好方法。为重复的代码创建函数并规范你的代码是非常好的做法。

在代码中根据需要或编程语言的最佳实践尽可能加入注释。例如，在 Python 中，可以在你的函数里面添加 [Docstrings](https://www.datacamp.com/community/tutorials/docstrings-python?utm_source=adwords_ppc&utm_campaignid=1565261270&utm_adgroupid=67750485268&utm_device=c&utm_keyword=&utm_matchtype=b&utm_network=g&utm_adpostion=&utm_creative=332661264374&utm_targetid=aud-299261629574:dsa-429603003980&utm_loc_interest_ms=&utm_loc_physical_ms=9033348&gclid=CjwKCAjwq_D7BRADEiwAVMDdHtPFljxXsIaMpcyiPjdYBJrUmC2oCkQw7G7bVGfHzUHwE_k-FwogHhoCqtEQAvD_BwE)。考虑[让你的注释保持精炼]( https://medium.com/better-programming/comments-in-your-code-730cfd1dde02)以免让人心烦。为了减少冗余注释，请确保选择有意义的变量名，并尽可能简化代码（尽量避免编写 hack 代码）。你的注释应该更多地体现代码的**意图**。

![Photo by [Beatriz Pérez Moya](https://unsplash.com/@beatriz_perez?utm_source=medium&utm_medium=referral) on [Unsplash](https://unsplash.com?utm_source=medium&utm_medium=referral)](https://cdn-images-1.medium.com/max/9856/0*1eUO9v7-DxCaSx01)

一般来说，你应该有一个好的项目和文件结构。例如，如果有很多辅助函数，那么将它们保存在一个单独的文件中。同时，如果可以的话为代码编写测试案例。

## 保持活跃度

![Photo by Author](https://cdn-images-1.medium.com/max/2876/1*lm1C-Qngubphko9-OqvvFg.jpeg)

**目标**：你肯定想要得到那些绿色方块！更多的绿色信息表明你在平台上很活跃，并且正在不断地贡献代码，这在招聘经理看来是很好的表现。

一般经验法则：**经常更新并提交你的代码**。在做学校的课程项目吗？在你有进展的时候更新你的 GitHub。项目如果比较小型是没有问题的，但要尽量让它们多样化，以展示你不同的技能。

**让你的项目保持在最新的状态**。在你学习过程中，你可能会对以前的项目进行更改或更新。

除了向仓库提交更改，你还可以通过其他贡献来保持活跃度，例如:

* 发布一个问题
* 提出一个项目合并请求
* 提交一个项目合并请求审查

你的工作场所使用 GitHub 吗？你可以在用户档案下的工作活动中[打开“enable private contributions”开关](https://docs.github.com/en/free-pro-team@latest/github/setting-up-and-managing-your-github-profile/showing-an-overview-of-your-activity-on-your-profile)来展示你在私有库中的贡献，以便在你的用户档案下展示你的工作活动。

![Photo by docs.github.com](https://cdn-images-1.medium.com/max/2000/1*HbJR9Zk1nLob1X_hylb4XQ.png)

## 使用 GitHub Pages

[GitHub Pages](https://pages.github.com/) 是一个很棒的工具，它可以直接托管你仓库中的网页。其强大之处在于用户可以即时看到你的项目成果。例如，如果你的项目是一个网站，那么只需要简单的几个点击即可用 GitHub Pages 来托管 **index.html** 。此外，你推送的任何更改都将直接反映在托管页面上，无需经过部署。为你的项目制作一个演示或托管页是展示你技能的关键。如果你不确定如何托管一个演示页面，那么 GitHub Pages  会是一个不错的选择。

## 管理你的位置和用户档案信息

为了把你和档案联系起来，你应该在档案中添加自己的职业信息和联系方式。招聘人员使用搜索工具时会根据位置信息查找个人资料，因此个人资料中包括位置信息会让他们更容易找到你。如果你有 GitHub 的追随者，这些链接也可以让他们更容易在其他平台上找到你。

![Photo by [delfi de la Rua](https://unsplash.com/@delfidelarua7?utm_source=medium&utm_medium=referral) on [Unsplash](https://unsplash.com?utm_source=medium&utm_medium=referral)](https://cdn-images-1.medium.com/max/6912/0*N7XsHBKoAstQRGGR)

你还可以给某些仓库置顶，从而定制你的 GitHub 页面。选择那些你希望用户能第一时间看到的最佳项目。

需要牢记 [GitHub 不是你的简历](https://blog.jcoglan.com/2013/11/15/why-github-is-not-your-cv/)。对于招聘人员和招聘经理来说，高质量的 GitHub 简介和项目只是你的面试申请和面试内容的补充材料。不要把它当作一切的中心 —— 保持你的描述简洁，甚至可以表现出一点个性。

## 其他小贴士

* 利用可以为仓库添加描述和标签的优势，保持信息准确和内容丰富。
* 在你提交的更新信息中保持内容的专业和丰富。包括一些比“修复错误”或“为什么这行不通？？”更有意义的内容。
* 如果你想让别人为你的项目做贡献，就要有明确的贡献准则。t
* 移除一些没用的信息，比如你没有再使用过的仓库分支。
* 参与社区活动-为开源项目做贡献！

## 结论

在这些指导原则下，我把我的 GitHub 档案修改了一番，让它成为了我申请工作的一个有用工具。我甚至在与面试官谈话中提到我做过的项目。无论是在求职中，还是营造一个优秀、专业的网络形象，我都强烈推荐你把 GitHub 当成一个重要工具。祝你好运！

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
