> * 原文地址：[UX Case Study: KoinStreet Homepage Redesign](https://medium.com/ux-in-plain-english/ux-case-study-koinstreet-homepage-redesign-9da7686acd5b)
> * 原文作者：[Mellownie Ho](https://medium.com/@mellownie.ho)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2020/ux-case-study-koinstreet-homepage-redesign.md](https://github.com/xitu/gold-miner/blob/master/article/2020/ux-case-study-koinstreet-homepage-redesign.md)
> * 译者：[Zhengjian-L](https://github.com/Zhengjian-L)
> * 校对者：[rachelcdev](https://github.com/rachelcdev)

# 用户体验案例学习：重新设计 KoinStreet 主页

![](https://cdn-images-1.medium.com/max/11634/1*_4OaRdRVy_x_luuum4_plg.png)

## 项目介绍

**客户**：KoinStreet 是一个加密电子货币交易平台，可在经验丰富的交易商和消极投资者之间建立跟随交易系统（Copy trading system）。这个平台也为对电子加密货币感兴趣并想要了解更多的人构建了一个社区，精选并分享新资讯和学习资源。  
**任务**：重新设计 [登录页](https://www.koinstreet.com/)  
**时限**：4 天  
**工具**：Adobe XD

## 方法和时间安排

**第 1 天**：对 KoinStreet 进行启发式分析（Heuristics analysis）和实地调查，并对现存的加密电子货币交易平台进行竞争力分析（Competitive feature）和特征分析（Feature analysis）  
**第 2 天**：对关键功能进行头脑风暴，并将设计概要写在白板  
**第 3 天**：在纸上打草稿，在 AdobeXD 中制作线框，根据 KoinStreet 的社会媒体形象绘制心情看板  
**第 4 天**：在 AdobeXD 中重新设计 KoinStreet 的高精度模型

#### 设计理念

在这次设计中，我的理念是采用原本的内容，着眼于最好的特点，然后将它们重新组合为新颖的、现代化的网页。

#### 目标

创建一个视觉上令人惊艳的登录页，**富有未来感，前卫感和信赖感**，同时让用户**明确** KoinStreet 的功能。

## KoinStreet 的原始登录页

![](https://cdn-images-1.medium.com/max/2552/1*yffV6lxmyG-Dyab1T2Q_iA.png)

![](https://cdn-images-1.medium.com/max/2534/1*2AgPz1LHQO7V01xCLlWt6Q.png)

![](https://cdn-images-1.medium.com/max/2522/1*19rvK3Fin_uCEGQg5eoqoQ.png)

![](https://cdn-images-1.medium.com/max/2528/1*bjMZUvzgrXUjQiSZmYbwLQ.png)

![](https://cdn-images-1.medium.com/max/2450/1*3NWciJ5AwkDCcGuNU4il5A.png)

#### 启发式评估

在浏览了 KoinStreet 的原始登录页后，我写下了几个需要改进的地方，并将它们按重要程度高低进行排序：

1. 对于如何使用网站，**没有给出明晰的步骤和指导**。
2. 登陆页没有任何一处提及**安全**。
3. 有能够展示公司特点和长处的出色视频。**但是，视频提到的几个重要功能并没有在登录页强调，尤其是跟随交易的功能。**
4. 颜色协调，但有些过时。
5. 合作伙伴和社区媒体图标过大，容易让人分散注意力。另外，合作伙伴的图标没有居中。

#### 竞争力分析

在研究了 KoinStreet 的登录页后，我也浏览并学习了 [Coinbase](https://www.coinbase.com/)、[Luno](https://www.luno.com/en/)、[Binance](https://www.binance.com/en?ref=16626703) 和 [Paxful](https://paxful.com/#) 的登录页。

通过对这些竞争对手的观察和研究，我写下几个在浏览 KoinStreet 的网页时遗漏的几个关键功能（尤其是明确网站作用和提高安全感和信任感的功能），用于头脑风暴和设计概要环节。

## 开始设计

在深入了解 KoinStreet、加密电子货币和同一领域的竞争对手后，我开始了头脑风暴和草稿环节。

#### 头脑风暴和设计概要

首先，我记录下 KoinStreet 新登录页需要的功能，这些功能是为了让用户对 KoinStreet 有更多的理解和信任。

然后，我为新登录页的设计列出了几种可能。

![Feature analysis, MoSCoW Prioritization Chart, Outlining on the whiteboard](https://cdn-images-1.medium.com/max/3212/1*muHy5sumJbcFngUhUcWcRg.png)

之后，我对新登录页进行更细致地描绘。右侧的草图最接近最终的外观。

![Sketches for the KoinStreet redesign landing page](https://cdn-images-1.medium.com/max/3212/1*4YqjWk-5NN0cW_45H2qsqg.png)

#### 心情看板

在草稿环节，我使用了 koinStreet 在 Twitter、Facebook、Medium 和 Instagram 的图片制作了心情看板。

![Moodboard made up of KoinStreet’s existing social media platforms](https://cdn-images-1.medium.com/max/3188/1*Q0GIuxIfhsBzaLk-LSskrQ.png)

我这样做有几个原因：

* 了解目前 KoinStreet 是如何在视觉上向观众展示其形象的
* 确保 KoinStreet 登录页的新版本和它在社交平台上的形象保持协调一致
* 看看我们在不改变基础的情况下可以将设计推向怎样的高度

#### 线框

下一步，我为登录页制作了一个非常简单的线框，帮助告知内容的顺序和空间。

![Simple wireframe of KoinStreet’s new landing page](https://cdn-images-1.medium.com/max/3014/1*_w5xZAH7h_DnM6B929N_9g.png)

## 最终成品

这是 koinStreet 的最终登录页。

我使用来自 Medium.com 的 KoinStreet 横幅来创建新的配色方案，并着眼于确保能明确 KoinStreet 的功能和优点。

![](https://cdn-images-1.medium.com/max/3840/1*yA0SHGEn46Kg82eIlpNjYA.png)

## 后续

* 通过用户测试和用户研究，了解更多熟悉加密货币的人想从这次重新设计看到的内容。
* 获得客户的反馈意见，以了解他们想要加入的内容
* 创建关于页和博客页

如果您对模型有任何反馈或建议，请随时发表评论！

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> 掘金翻译计划 是一个翻译优质互联网技术文章的社区，文章来源为 掘金 上的英文分享文章。内容覆盖 Android、iOS、前端、后端、区块链、产品、设计、人工智能等领域，想要查看更多优质译文请持续关注 掘金翻译计划、官方微博、知乎专栏。
