> * 原文地址：[React Native vs. Flutter vs. Ionic](https://medium.com/better-programming/react-native-vs-flutter-vs-ionic-46d3350f96ee)
> * 原文作者：[Sophia Martin](https://medium.com/@sophiamartin121)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2020/react-native-vs-flutter-vs-ionic.md](https://github.com/xitu/gold-miner/blob/master/article/2020/react-native-vs-flutter-vs-ionic.md)
> * 译者：[黄梵高](https://github.com/mangotsing)
> * 校对者：[HurryOwen](https://github.com/HurryOwen)

# 哪个跨平台框架才是最好的选择？React Native、Flutter 还是 Ionic。

![](https://tva1.sinaimg.cn/large/007S8ZIlly1gj7mdcoaldj30m80eut9w.jpg)

无论你是计划为你的初创公司投资一个移动应用，还是打算将线下实体店改成网店，你最关心的一定是为你的业务找到最佳的解决方案。

你注意到了吗？在 Google Play 里面的大约 280 万个应用，以及在 Apple App Store 里面的 220 万个应用里，仅仅只有很少的一些应用成为行业龙头。

在这些行业的不同领域内，有一些龙头品牌占领了市场最大的份额，例如：

* **电商应用程序：** 亚马逊，Flipkart，eBay，阿里巴巴等。预计将在 [2020 年产生超过 24116 亿的收入](https://www.statista.com/outlook/243/100/ecommerce/worldwide#market-revenue)。
* **游戏应用程序：** Google Play 游戏，Pokemon Go，Candy Crush Saga，和 Lucky Money 是最受欢迎的 iOS 应用分类，[占活跃应用的 25%](https://www.statista.com/statistics/580150/most-popular-us-gaming-apps-ranked-by-audience/) 并且在美国的用户一个月超过 1874 万。
* **在线送餐应用程序：** 在叫外卖时，Grubhub，Doordash，UberEats，Postmates，Instacart 等是其中一些龙头应用的名字。
* **社交媒体应用程序：** Instagram，Facebook，Messenger，Whatsapp 等。
* **娱乐应用程序：** 每月[有 570 亿以上的用户](https://www.statista.com/statistics/579479/most-popular-us-music-video-apps-ranked-by-audience/)访问YouTube，Netflix，Apple Music，Spotify，Pandora Radio，Amazon Prime Video，Google Play 音乐，Hulu 等。

关键问题是究竟什么使他们成功，并帮助他们在市场上独树一帜？可能许多人迫切想跟风模仿他们的应用，但在此之前，你需要先找到他们成功的秘诀。

有太多的因素会影响成功，包括功能，复杂性，UX/UI 设计，后端，前端，开发人员的技术等等。但真正的成功在于他们选择开发应用使用的技术。

不管你的应用有多么出色的创意，以及有什么独特的东西融入你的应用，如果你选择了老旧、乏力、过时的编程语言，那可能会让你的全部投入置于风险之中。

而且如果我们考虑到移动应用程序的趋势，和业务增长带来的需求，那么可以肯定的说，现在的企业家对跨平台移动应用更感兴趣。由于混合应用有助于通过多个平台大规模地锁定用户，因此企业家都渴望雇佣一支拥有开发跨平台应用经验都开发者团队。

还有一个关键问题：你应该选择哪种编程语言来开发应用程序？

在使用顶级的跨平台移动端应用框架开发混合应用时，[React Native](https://reactnative.dev/)、[Flutter](https://flutter.dev/) 以及 [Ionic](https://ionicframework.com/) 都是开发者社区中的龙头。

![图片资源：[Statista](https://www.statista.com/statistics/869224/worldwide-software-developer-working-hours/)](https://tva1.sinaimg.cn/large/007S8ZIlly1gj7r4c0kimj30lv0dtq3r.jpg)

现在，当你需要在这三个优秀的移动应用开发框架中进行选择时，真正当挑战接踵而至。不用担心，我们只需要比较每个框架的要点，以帮助你轻松的找到最适合你业务需求的框架。

让我们开始给每个框架都做一个简短的介绍吧。

## 开源跨平台移动应用开发框架的标准线

#### 总览

Flutter 和 React Native 都是高级软件开发工具包，但是 Flutter 是由 Google 开发和支持，而 React Native 是由 Facebook 开发。Ionic 是最古老的编程语言之一，由 Driffy Co 开发。

#### React Native

React Native 是一款开源框架，并在 2015 年开始由多种语言编写，包括 JavaScript、Swift、Objective-C、C++ 和 Python。它基本上提供了在 iOS、Android 和 Windows 平台，开发一款优秀跨平台应用程序需要的所有工具和服务，而且由它开发的应用拥有近似原生应用的性能。

主要使用者：在很短的时间内，这个框架就被用于开发各种应用，包括 Instagram，Facebook，Airbnb，Walmart，UberEats 等等。

#### Flutter

Flutter 由 Google 提供支持，并且为了帮助开发者能够开发出漂亮，并且风格近似与本机原生系统的应用，它在开发过程中增加了一个强大的渲染层。它提供了自己的渲染引擎，开箱即用的窗口小组件，命令行工具，API 等等，这些都可以使整个开发过程更加轻松。但是，和 React Native 进行比较，它在 2018 年才刚刚开始流行。

主要使用者：虽然 Flutter 是近期才推出的新框架，但是 Google Ads、Alibaba、Reflectly、Birch Finance 等公司已经开始使用了。

#### Ionic

Ionic 在 2013 年作为开源的跨平台移动开发 SDK 推出。由于它使用了包括 HTML5、CSS 和 SaaS 在内的各种技术，因此使用 Ionic 可以更轻松的构建一个跨平台的移动应用程序。

主要使用者：Ionic 在行业内已经有很长的时间了，它被用作诸如 Sworkit、JustWatch、MarketWatch 等应用程序的构建。

现在让我们着眼于关键点，通过下面简单的比较可以帮助你了解每个框架的优劣之处。

## 比较 React Native、Flutter 和 Ionic 的主要属性

由于每家企业都有不同的产品需求，并且招聘的移动应用开发团队技术水平也略有不同。因此，适合一家初创企业的框架在另一家初创企业中未必适用。所以我们这里将会讨论开发人员在选择框架时，最关心的那些特点。

#### 1. 编程语言

**总览：** React Native 是基于 JavaScript，Flutter 使用 Google 的内部编程语言 Dart，而 Ionic 使用多种语言。

**React Native：** 在选择是哪种编程语言的框架时，React Native 可能是开发人员的首选，因为它基于 JavaScript，而 JavaScript 是目前开发混合应用程序最流行且具有动态性的语言之一。此外，这款框架结合了 JavaScript 和 React 的所有优点，并得到了 Facebook 的支持。React Native 使它与其他编程语言区分开来的地方在于，它可以在需要的时提供用 Swift、Objective-C 或 Java 编写一些组件的能力。

**Flutter：** 由于 Flutter 是 Google 的一个新生儿，因此它使用了一个内部编程语言，[Dart](https://dart.dev/)，可以帮助你开发 Android、iOS 和 web 应用程序。相比于 JavaScript，Dart 仍然是一种不常见的编程语言。但是尽管这是一个新语言，但在未来几年中依然具有极大的潜力席卷整个行业。

**Ionic：** 它使用多种技术（包括 HTML5、CSS 以及 JavaScript）来开发和运行应用程序，并且可以通过 [Cordova wrapper](https://cordova.apache.org/) 来使用原生平台的一些控制器。为了提高代码的质量，你还可以使用 Ionic 的同时使用 TypeScript。

#### 2. 代码的运行和复用

**总览：** 在为跨平台应用程序招聘跨平台应用开发者时，代码的可复用性是公司最关心的一点。这三个框架都使用不同的代码执行策略。React Native 遵循 「 learn once and write anywhere 」，Ionic 使用 「 one code base, any platform 」，而 Flutter 为你提供了一组高级功能可以提升你的编程速度。

**React Native：** 使用 React Native 编写代码的主要原因已经十分清晰：单个代码库可以用作开发多种多样不同平台的应用程序，包括 Android、iOS 和 Windows 等。这可以让开发人员构建更快更好应用程序的时间大幅度缩减。

**Flutter：** Flutter 越来越受欢迎的真实原因是，它提供了一个全面的工具包，可以帮助开发者使用现成的小组件，API 以及独特的渲染引擎来创建现代应用程序。通过使用 Flutter 丰富的功能，开发者可以得到一个很美好的开发体验。

**Ionic：** 它的简单标语 「 one code base, any platform 」 也说明了对于各种应用程序都可以复用代码库的优点。通过使用相同的代码，开发者可以在短时间内构建高度交互的应用程序。

#### 3. 流行度和社区文化

**总览：** 如果你假设最老的框架有着最高的知名度和社区支持度，那么你可能对这一点存在误解。根据 [Statista](https://www.statista.com/statistics/869224/worldwide-software-developer-working-hours/)，React Native 被 42% 的开发者使用，而 Flutter 尽管是一个新框架也被 39% 的开发者使用，而 Ionic 被 18% 的开发者使用。如果我们比较这三个框架，那么 React Native 可能处于最高的位置。然而，它的开发人员比例与 2019 年相同，并且 Ionic 已从 28% 降低到 18%，而 Flutter 的比例已从 30% 上升到 39%。

**React Native：** 在评估社区对框架对支持程度时，毫无疑问 React Native 将会轻松夺走冠军。由于它基于最基本的 web 开发语言 JavaScript，并且使用了流行的 React 库，因此与 Flutter 和 Ionic 相比，开发者成员正在迅速壮大。同时根据 [Github](https://github.com/facebook/react-native) 的数据，React Native 拥有 89.7K stars，3.7K 关注以及 19.9K forks。

**Flutter：** Flutter 是社区近期发布的一个框架，因此和 React Native 与 Ionic 相比，Flutter 的社区很小。但是由于 Google 的大力宣传以及迅速普及，使它很快就成为移动开发框架中的佼佼者。此外，在短时间内 [Flutter](https://github.com/flutter/flutter) 已经收获 99.2K stars，13.7K forks 以及超过 3K 的开发者正在关注它，超过了 React Native 和 Ionic。

**Ionic：** 作为最古老的框架之一，Ionic 经常改进自己的代码。它拥有第二高的社区支持和广阔的市场。从[流行程度](https://github.com/ionic-team/ionic-framework)而言，它拥有 41.6K stars，13.3K forks 以及超过 1.8K 的开发者正在关注。

#### 4. 性能

**总览：** 对于任何企业来说，应用程序的性能都是最重要的关键因素之一。应用程序的性能取决于各种因素，比如使用框架的编程效率。但在这里我们将通过简单分析应用程序的运行时间来评估性能。

**React Native：** 由于这款框架使用原生 API 和组件，它能帮你构建一款拥有原生外观的应用程序。

**Ionic：** 与其他框架不同，Ionic 使用了高级的 web 技术，例如 HTML、CSS、JavaScript。借助它们来创建高性能的混合应用程序。但它需要插件和第三方包才能将应用程序包装成为原生系统支持的应用程序。

**Flutter：** 毫无疑问，React Native 和 Ionic 都提供了出色的性能，但 Flutter 更领先一步的是，为了帮助构建漂亮、高性能的跨平台应用程序，它提供了开箱即用的插件，广泛的小组件，以及它专属的渲染引擎。

#### 5. 用户界面

**总览：** 应用程序的设计和用户界面才能用户决定继续使用这款应用还是将它卸载。React Native 使用 React 这个库来组织 UI，而 Ionic 使用 HTML 和 CSS，不同的是 Flutter 和其他框架相比，确保了自适应系统的最佳用户界面。

**React Native：** 为了能提供近似原生应用的体验，React Native 利用 React 库来提供让人惊艳的 UI。

**Ionic：** Ionic 完全依赖 HTML 和 CSS 等 web 技术，支持原生类型的应用程序体验。同时它也使用 Cordova 获得原生应用程序的外观。

**Flutter：** 毫无疑问，Flutter 通过跃过和原生组件的交互连接桥，提供了[最佳的用户界面](https://flutter.dev/docs/development/ui)。这也是为什么有数量十分庞大的移动应用开发者会选择 Flutter 作为跨平台应用的开发框架的原因。Ionic 确实可以支持跨平台的应用程序，但由于它使用 Cordova 来运行 JavaScript，因此比不过 Flutter 和 React Native 的效率和性能。

#### 6. 使用现状

**总览：** 当然可以对所有的技术都留一个深刻的印象，但现实生活中怎么使用或思考框架才是真正重要的。

**React Native：** 无论是移动还是 web 应用开发，JavaScript 都是编程语言中的王者。它不仅保持了在编程语言前五名的位置，而且在应用程序开发行业中保持着重要的地位。React Native 就是基于 JavaScript 的，并且这就是为什么包括 Facebook 和 Airbnb 在内的几家领先的公司采用此框架开发的原因。

然而另一方面，你很难忽略关于 [Airbnb](https://medium.com/airbnb-engineering/react-native-at-airbnb-f95aa460be1c) 改用另一种技术的事情。由于这次活动，React Native 团队正在努力摆脱已经记录在案的限制和问题。

**Flutter：** 尽管相比之下比较新，但 Flutter 只是简单的通过向开发者提供一份完整的软件开发工具包就在行业内树立了标杆。使用 Flutter，不仅可以轻松构建精美的应用程序，而且还可以通过热重载功能快速地编辑代码。

Flutter 具有十分多的高级功能，已经让大约 39% 的开发者印象深刻，并已经用于一些重要应用程序的构建，包括 Google 的 AdWords。Flutter 越来越受欢迎，并且越来越多的人使用它，可以肯定的说 Flutter 将开发出更多出色的应用。你需要做的就是招聘能对这个框架有足够掌控力的开发者。

**Ionic：** 相比之下，Ionic 是最老的框架，但它仍然没有开发过任何突破性、出色的应用程序。尽管如此，仍然有 [86,400 开发团队](https://ionicframework.com/customers)利用 Ionic 来开发 Android 和 iOS 应用程序。

#### 7. 应用开发成本

**总览：** 无论你是初创企业还是企业家，应用开发成本都是每个人主要担忧的问题之一。应用程序开发的成本与开发应用需要多长时间、开发人员的成本以及所使用的库直接相关。

**React Native:** React Native 是一款开源框架，允许开发人员免费接入各种各样的库。如果想将好处发挥到极致，你需要做的就是雇佣一支拥有熟练技术的软件开发团队。

**Flutter：** Flutter 也是一个允许开发者免费接入小组件、库、API 的开源平台。此外，你也可以轻松地在全球各地找到 18 至 35 美元的 Flutter 开发者。

**Ionic：** 它是一个免费的，开源的跨平台移动应用框架，然而对于专业的开发环境，你需要购买付费版本。但是，Ionic 可以轻松加快开发进度，并且可以让开发者更轻松地实时创建应用程序。

## 你最终将为跨平台应用程序开发选择哪种框架？

在完成所有的指标比较之后，你需要先确定是否仍然想使用 Swift、Object-C、C++ 和 Java 等原生语言，并继续麻烦的学习和掌握两种不同语言，用来开发两种不同系统的应用程序。或者你想选择一种可以在多个平台上正常工作的框架？

假设你已经准备好使用跨平台框架来开发应用程序。在阅读了整篇文章，你如何决定最适合你的技术框架呢？

让我稍微简化一下。

如果你正在寻找给应用程序包装的解决方案，那么 Ionic 是你的理想选择。但是由于 Ionic 使用第三方组件且由 Cordova 为应用程序提供了模拟原生的感觉，因此它从效率和性能上来说，无法打败 Flutter 和 React Native。另一方面，Ionic 可以确保你获得一个超级快速的开发体验，并使你能够在更少的时间内，用一个栈同时构建两个应用程序。

其次，如果性能和使用数量众多的原生设备功能是当务之急，那么 Flutter 和 React Native 可能是你的最终选择。

放轻松，上面已经详细解释了关于它们的所有内容。

## 最后的想法

总结一下这篇文章，不得不提的是，我们的目的不是宣传跨平台应用开发框架哪个获胜。相反，本文简单的目的是帮助你理解这三个跨平台框架的优点和局限性，以便你能够为应用程序开发框架做出一个完美的选择。

在评估了各种调查报告后和统计数据之后，本文对信息进行了分析，并对这三个框架中的巨头进行了详细的比较。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
