> * 原文地址：[UX Case Study: Mood Talk — A mental health app](https://medium.com/ux-in-plain-english/mood-talk-tell-how-you-feel-to-others-who-face-the-same-challenges-5e885ae7bd3)
> * 原文作者：[Balint Nagy](https://medium.com/@pinaban81)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2020/mood-talk-tell-how-you-feel-to-others-who-face-the-same-challenges.md](https://github.com/xitu/gold-miner/blob/master/article/2020/mood-talk-tell-how-you-feel-to-others-who-face-the-same-challenges.md)
> * 译者：[niayyy](https://github.com/niayyy-S)
> * 校对者：[Roc](https://github.com/QinRoc)、[Jessica](https://github.com/cyz980908)

# 用户体验案例学习：Mood Talk ——  一个心理健康应用

> Mood Talk —— 将你的感受告诉和你面临同样挑战的人

在这个世界上，很多人都面临着某种心理问题，例如：**孤独，失眠，抑郁，压力大，焦虑或者人格障碍**。不幸的是，这些可能性还没有列举完。

![](https://cdn-images-1.medium.com/max/4000/1*ChYK0nSlbyqz3x2p1cBABw.jpeg)

如果你能够**和那些面临着或者已经经历过同样问题的人**交流，这些人了解你的感受，并就如何克服这些可怕的情况给出切实有效的建议，那不是很好吗？我认为这会非常棒。事实上，我认为它是如此优秀，所以我设计了一款应用程序来解决这个问题。

## 背景

![](https://cdn-images-1.medium.com/max/2000/1*V7xKbTLAqakMAtciwZBz2g.jpeg)

作为我在设计学校的作业的一部分，我被要求设计一个**健康主题**的应用程序。我相信**人脉是解决我们大多数问题的关键**。甚至拥有宝贵人脉也是我们人生的最大财富之一，我们看待**人际关系**和**交际网**的方式也能帮助自己在事业上取得更好的职位，在人生中取得优势。

当我决定要做一个项目的时候，我的主要想法是**让那些面对精神障碍的人更快乐一点**。或者，最好**把他们从困境中“劝出来”**。

## 研究和发现

#### 调查

最后我设法收集了 **42 个调查答案**。在我的研究过程中，这些是我想要找到答案的最重要的问题：

* 有多少人面临心理问题？
* 哪个年龄组受影响最大？
* 解决这些问题的最好方法是什么？

![](https://cdn-images-1.medium.com/max/7732/1*gqBIsxJG1LIwVsYZ5rstPA.png)

#### 采访

![](https://cdn-images-1.medium.com/max/7364/1*NRsq36KAGGzwcGDStpb-Nw.jpeg)

我已经进行了 **5 次访谈**来进一步拓展这个话题，以更强调与真实的人有关。虽然我从调查中得到了一些答案，但这里我想把重点放在“**它是如何开始的**”。

事实证明，在大多数情况下，一个**悲剧性的人生事件**在这些案件中扮演着最重要的角色。但有时即使是正常的事情也会产生问题，例如，由于工作或学习而**找不到时间与朋友和家人见面**。**搬到另一个城市或国家。**此外，仅仅是**有压力，不堪重负**的生活也会导致严重的问题。

#### 分析给定的数据

关于这一主题，来自不同大学的领域专家和教授已经做了大量的研究。只要在谷歌上搜索，就可以免费获取信息。

---

我找到了很多信息，**证实了我之前的发现**。我也读了很多关于**预防的方法**和**更多克服这些情况的方法**。

## 我的用户

卡尔·威廉姆斯刚搬到荷兰，因为他得到了一份不错的工作。不幸的是，他不会说当地的语言，即使在工作场所，每个人都会说英语，但当涉及到更私人的对话时，他的同事们会切换回他们的母语，这让卡尔很难融入他们的社交圈。

![](https://cdn-images-1.medium.com/max/5612/1*zDPYQpVvs3YgkBG25e3A5Q.png)

一段时间后，由于他努力建立新的关系，他变得孤独。他很有可能很快就会得抑郁症了。

> 卡尔最近搬到了荷兰，他需要找到新的朋友和一个倾听的社区，因为他感到孤独

## 解决方案

因为沟通和人脉是解决问题的关键元素，所以我需要找到在这些行为中帮助用户的特性。我为项目的特性进行了头脑风暴，获得了以下想法。

* 每日情绪追踪
* 真实生活团体活动
* 私人群组聊天
* 情绪分享功能

当我在寻找可能的解决方案时，我一直牢记这些功能必须建立联系，但同时我必须意识到，有些人可能根本不会参加现实生活中的活动。

## 结构

我的想法很简单，一个主屏幕，你可以看到你的朋友最新的帖子。用户也有机会写一篇新文章。在导航栏中，还有真实生活事件和私人群组聊天选项。

![](https://cdn-images-1.medium.com/max/5616/1*2GPEQ8AjlS00wjFduJXXzw.png)

经过大量的反馈和可用性测试之后，最终的版本发生了很大的变化。

## 视觉效果

第一步，我分析了我的主要竞争对手的应用程序，看看他们使用什么样的颜色，图像和图标，使他们的网站更有吸引力和功能性。

![](https://cdn-images-1.medium.com/max/5698/1*HofxPYER9IFxJdw73leaRw.png)

我想要找到在相同领域运营的应用程序，它将人们联系起来以创造更好的情绪。通过视觉分析，我可以得出一些结论。应用程序往往使用友好、轻松的颜色。他们专注于社区以及如何将他们联系起来，这给了我很多制作视觉效果的灵感。

## 情绪板

最终我创建了我的情绪板，在那里我专注于一个有趣的、友好的方法。有点孩子气。我使用 Baloo Da 2 作为我的主要字体，因为它确实符合我对视觉效果的想法。

![](https://cdn-images-1.medium.com/max/5200/0*j0jcJZTm0SY3ymbn.png)

## 建立设计体系

毋庸置疑，在现实生活的设计项目中，建立一个现实生活的设计系统需要更长的时间，但在这里我们只关注应用程序的本质。

![](https://cdn-images-1.medium.com/max/3628/0*rUqmFLPT3Lchm_Wn.png)

## 最终界面

最后这是最终版本的应用程序设计的一些页面的最终外观

![](https://cdn-images-1.medium.com/max/5200/0*h47wVSrSZ5wZgl_V.png)

## 微动画

因为下一个大的步骤是添加微动画到我们的项目，我想展示它是如何以一种简短的视频格式呈现出来的。为了创建内部动作，我使用了 InVision studio。

![](https://cdn-images-1.medium.com/max/2000/0*_AY_yjb7XGKJUwy2.gif)

## 项目总结

这是我第一个从 UX 到 UI 的完整项目。如果可以重新来过，我一定会选择一个不那么宽泛的话题。回过头来看，在没有任何领域知识的情况下解决精神障碍的想法本身就很大胆。作为第一个项目，我对结果很满意，但以我目前的知识，我确信我能做得更好。

因为这是我第一个需要实现微动画的项目，这是一个额外的挑战，但我学到了很多关于恰当的层命名和适当的分组的重要性，现在我看到了它们在一个更大的项目中是多么的重要。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
