> * 原文地址：[Microservices: The Right Solution for You?](https://blog.bitsrc.io/microservices-the-right-solution-for-you-869e916ded09)
> * 原文作者：[Ashan Fernando](https://medium.com/@ashan.fernando)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/article/2020/microservices-the-right-solution-for-you.md](https://github.com/xitu/gold-miner/blob/master/article/2020/microservices-the-right-solution-for-you.md)
> * 译者：[wangqinggang](https://github.com/wangqinggang)
> * 校对者：[loststar](https://github.com/loststar)

# 微服务是你的最佳解决方案么？

我写关于微服务的文章已经有好几年了，十分了解它的优缺点。我经常提醒新手们，在没有正确理解所面临的复杂性的情况下，不要随波逐流地采用微服务。

谈到微服务，成功的故事和概念确实令人着迷。每个微服务处理各自业务领域中的业务，这些微服务集合到一起，构建出精益架构的完美形象。但是，我们不应该忘记，这些服务需要协同工作才能向最终用户提供业务价值。

![](https://cdn-images-1.medium.com/max/2560/1*H5vA_7yhd8zq7F8ZfmAkFg.jpeg)

## 全面了解业务领域

在现实世界中，我们以网络应用、移动 APP、物联网、API 集成的形式为终端用户提供服务。因此，如果我们遵循微服务体系结构，我们要讨论是微服务之间如何以特定的方式进行通信。

因此，如果你不熟悉微服务，在采用它之前，你需要首先回答以下问题。

#### 问题 1 :  你是否对自己的业务领域了如指掌，并能合理地预测短期内会发生什么变化？

业务领域的全面了解和领域驱动设计服务的经验对于确定每个服务的有界上下文是至关重要的。我们为每个微服务分配团队，并使他们在干扰最小的情况下工作，但这会使每个团队误解边界上下文，增加通信开销和团队间的依赖性，从而影响整体开发速度。因此，对于一个从零开始的项目来说，选择微服务是一个有风险的举动。

## 进入分布式系统的世界

> “分布式系统很难”ーー匿名者

但是分布式系统和微服务之间有什么联系呢。他们之间的关系很清晰，当您构建微服务时，您可以直接深入到微服务的高级模式，分布式系统领域。微服务可以解决特定问题，但也会引入其他问题。

> 事实上，在您的软件产品生命周期中，单体应用的问题不值得使用微服务解决。

#### 问题2: 你尝试采用微服务架构来实现什么？

微服务不是精湛的架构风格，不是适合所有人的灵丹妙药。采用微服务我们需要处理分布式系统，这对许多人来说可能是极大的困难。因此，必须评估微服务是否可以解决您在单体应用中遇到的问题。

#### 问题3: 您和您的团队是否有足够的经验来使用微服务所需的分布式系统？

使用分布式系统需要专业技能的设计使用经验，如分布式遥测和监控、网络和通信、容错设计、分布式事务、事件驱动架构、容器和中间件等。虽然在互联网上有这些技术的参考架构和指南，但如何正确使用这些技术是主要的挑战。

## 关注名企

我看过网飞、亚马逊使用微服务的著名案例研究 。你可能也会觉得，为什么不站出来，跟随他们的成功之路，走向下一个伟大的事业。你甚至可能从你的商业伙伴那里获得技术订单。有趣的是，非技术人员也会问你为什么不考虑微服务，从而激起你的使用欲望。

> 说到底，谁不想成为亚马逊或者网飞公司，追随他们的道路？

这些影响可能会给你留下微服务非常积极的印象。您可能通过案例研究或观看技术视频得出微服务的优势要点，并说服自己，然后让自己相信单体应用是落伍的，而微服务是通向未来的道路。

#### 问题4: 你有足够的时间、精力和金钱投资微服务吗？

你可能会忽略这一点：他们花了多少时间和精力才把他们的整体业务迁移到微服务。这些项目可能很快达到好几年的运行时间。即使你使用微服务启动了一个新项目，由于复杂性和生产力降低带来的挑战，也不能保证你会节省时间和金钱。

## 前期的大设计？

我与一些关注微服务全功能的人交谈过，他们经历了比平时更多的延误，仍然相信微服务将来会解决这个问题。

> 微服务会拖慢你的速度，相信我。如果推向市场的时间非常重要，最好使用单体架构。

处理分布式系统、微服务通信、在数据一致性上的额外努力、在开发运维流程上的额外努力，都是软件开发的间接开销。

#### 问题5: 您是否了解架构和技术开销，并有足够的解决经验？

除非你建造了一个单体应用并使用了来自微服务的最佳实践，否则你可能会掉进这个陷阱。

## 让架构进化

如果你仔细阅读了这篇文章，你会觉得我只是在引起你使用微服务的恐惧。我的最终目的就是让你们意识到直接采用微服务的风险，这是我亲身经历的坑。好处是采坑过程中我学会了如何更好地使用微服务。

我提出了五个问题，将它作为采用微服务之前的检查表和试金石。如果所有问题的答案都通过，那么你就有希望在你的微服务之旅中做出理性的决定。如果不通过，最好远离微服务，因为学习它会让企业付出高昂代价，而且有可能使整个项目面临风险。

#### 遵循正确的架构流程

因此，我的第一个技巧是通过识别影响项目质量的属性，使用正确的策略来确定架构风格。了解取舍以便正确地选择应用程序的架构风格、工具和技术。

遵循这种方法将使您远离架构选择的纠结，也使得微服务在大多数应用场景下成为一个遥不可及的现实。

#### 从单体应用到微服务的演变

如果你已经有了一个成熟的业务，并且在发展过程中遇到了架构和技术上的困难，那么现在正是考虑微服务的时候。

如果你从亚马逊和网飞的成功故事中得到启示，请记住，他们最初成功地将单体应用作为业务，从该业务获取足够的资金和人员来进行转型。这些迁移可能需要几个月或几年的时间。但是，这些企业有财务能力来支持数字化转型，因为它们知道自己的规模带来的总体利益。

## 使用正确的工具

如果你进入微服务和微前端，使用正确的工具，遵从正确的实践是必不可少的。

如果您使用的是公共云提供商，那么使用云中可用的中间件将是一个救命稻草。在使用网关、异步通信、数据存储和微服务监控时，这些云服务有助于降低总体成本。

此外，正确地组织项目结构对于提高开发人员的生产力也很重要。您可以选择分布式仓库或集中化仓库，并围绕项目结构建立开发运维流程以便快速发布。

## 总结

最后，在结束本文之前，我想说，如果您决定从项目开始就采用微服务，那么请务必谨慎。这个过程似乎比你想象的更具挑战性，除非你有一个坚实的理由来使用微服务（例如，在你已经知道有限的上下文的情况下遵从规范或给定的标准构建一个应用程序，从而降低整体风险）。或者，你可以选择从一个单体应用开始构建。

我希望我已经把要点讲清楚了。如果你有任何问题或不同意的事实，请留下评论。我很乐意尽快回复。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
