> * 原文地址：[Wireframes are becoming less relevant — and that’s a good thing](https://medium.com/@seandexter1/wireframes-are-becoming-less-relevant-and-thats-a-good-thing-e66b30724a27)
> * 原文作者：[Sean Dexter](https://medium.com/@seandexter1)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/wireframes-are-becoming-less-relevant-and-thats-a-good-thing.md](https://github.com/xitu/gold-miner/blob/master/TODO1/wireframes-are-becoming-less-relevant-and-thats-a-good-thing.md)
> * 译者：[hanxiansen](https://github.com/hanxiansen)
> * 校对者：[Fengziyin1234](https://github.com/Fengziyin1234), [xiantang](https://github.com/xiantang)

# 线框图变得不那么重要了 — 好事啊！

![](https://cdn-images-1.medium.com/max/3160/1*-uTCxjdcMtjgKnKfUJqixA.png)

随着时间的推移，我发现线框图越来越没用，而且这么想的还不止我一个。因为“线框图”一词并没有很精准的定义，所以这里或许还得说清楚本文讲的是什么。虽然有许多种原型可以检测不同[维度](https://medium.com/in-the-hudl/prototype-fidelity-its-more-than-high-and-low-4dedb4cb1a0)的逼真度，但我想重点介绍的，是人们在听到“线框”一词时最先想到的那一种。这里说的线框图，既不是草图，也不是一个全面呈现细节的原型，而是一个典型的“中间”状态（一种以数字形态存在、故意不加样式的人造物，其用途是以黑白色调呈现整个页面的“骨架”）。原型线框图试图准确地展现布局和信息框架，同时**故意**不追求大量重现外观层面的每个细节，有时候连内容上的细节也不会大量保留。

![唉哟，这只野生的线框图长着细细的线条，还煞白煞白的，都把我眼睛看花了](https://cdn-images-1.medium.com/max/3360/0*0FGSCBVTYpA2Dt4z.png)

在我参与的线下或线上讨论中，我惊讶地发现，人们还是将线框图定位为设计环节中的**基本**步骤，虽然这种态度似乎处于下降趋势，但我仍然能听到每个人 — 从初出茅庐的职业设计师到业界领先的机构，都在坚持“线框阶段”的必要性，这些论点通常包含以下几个方面：

> - 线框图关注于实用性而不是美观程度，可以避免利益相关者因拘泥于无关紧要的细节（如：按钮颜色）而把会议方向带偏，还允许使用者在测试时集中于交互而不是视觉呈现。
>
> - 画线框图耗时较短，它能把问题控制在概念层面，还可以防止我们在某一方向上紧抓不放，或者花费过多精力。
>
> - 还有一种（更贴近企业视角的）观点，它和前两种有点不同，是说线框图这种工具可以用来对交互进行详细记录，同时又不需要我们在外观设计方面下额外工夫。

并不是说所有人都真的有画线框图，但是要承认没画线框图的时候，人们通常就会压低声线，目光游离。他们不是不想画；他们只不过是因为受制于所处的组织、利益相关者或项目本身，所以不能每次都画。但是，这种认为线框图不画不行的心态，以及各种关于画线框有哪些好处的想法，或许是被误导了。虽然我不否认，总有些时候线框图是有用的，但现在这些场合已经不多了，而且还日益减少。推动这种变化的，是行业思维和实践的多项转变，这些转变值得我们考究一番。

## 不断变换的产品开发方法正改变着人们从事设计的方式

**敏捷**产品的开发鼓励我们使用线性程度较低的过程。这种开发方式不是先从全面覆盖整个产品的基础元素着手，然后在其基础上搭建层，而是将重点转移到更小，更频繁地交付完全实现的“纵向”切片。

![](https://cdn-images-1.medium.com/max/2000/1*ZP-WJyxl2cwFlE_SifUCkA.png)

这也包括完全实现的设计，这使得同时考虑可视化、信息架构和交互性变得非常重要。在敏捷开发团队中，每次迭代的发生时间都以天或星期为单位计算，而不是几个月或几年；在这种开发场景里，比较难有空间容纳那种在早期进行、常常让人画出一堆线框图的大规模mapping phase。

[**精益UX（Lean UX）**](https://www.smashingmagazine.com/2011/03/lean-ux-getting-out-of-the-deliverables-business/)是一种随之诞生的改进流程（似乎在不断被关注），在 Lean 设计中，繁重类的设计工作被忽略或完全省略，这有利于在产品本身上进行协作，Lean 设计还反驳了将线框图作为文档工具的想法，它建议实际产品的屏幕布局可以作为它们的文档，你自己创建的设计组件将成为临时项 —— 只要它们包含的信息在实际产品中以可访问的方式存在，就可以把他们放到一边去。其它相关情况仍可记录在案，但仅在设计时或之后。

### 可用性和信息框架并不是孤立存在的

虽然这道理大家都懂，我还是要在这说一遍：界面中元素的视觉表现形式会影响用户对它们的感知。如果下拉菜单长得像表单区域，就可能会让人误解其功能；如果菜单标题的外观很难让人把它和菜单条目区别开，用户就可能看漏眼。颜色和对比度在引导视觉注意方面起着巨大的作用。如果你在一个线框上做可用性测试，等到最终大幅修改外观时，做好的测试就派不上什么用场了。而且到了那个时候，你可能还要为了更好地适应视觉效果，而对布局进行更多修改。用户可能只会专注于视觉元素，他们这样做无可厚非，而且将所有内容设置为灰色并不一定会降低这种风险。问理解方面的问题，以及用完成任务的方式做测试，比口头评论更能暴露可用性或者信息框架方面的问题。只要你能很好的设定预期并注意反馈的征求，就可以用任何保真度来实现概念的输入。

### 让利益相关者看线框图的做法很少奏效

开会的时候，要是有个利益相关者对某个按钮或副本的颜色揪住不放，就会让人很心塞；这我懂。但是，难道存心不用高逼真度的图像，然后处处用 lorem ipsum（译者注: 排版时的专用测试文字）填充，你就真的能解决问题吗？还是说，你只是把解决问题的时间推迟？你喜欢低保真度，是因为它能让人理解起来更容易，然后发表意见吗？还是说，实际情况是：它让别人**更难**理解了，而我们**喜欢**这样，因为这样一来我们就够将自己的专业知识凌驾于他人之上，免受批评？如果利益相关者不热衷于评价信息架构，而是更在意与他们专业知识相关的其它事情，那你为什么还要摆出一副对抗态度呢？你才是信息架构方面的专家，他们不是；任何需要对布局进行的更改都应通过对用户的测试而变得清晰。

### 它变得更快捷，也更容易接近高保真的视觉呈现

几年前，Photoshop是 UI 设计之王，每个人都在争先恐后地看，比拼谁能在给定的页面上添加最详细、最逼真的纹理。在那个时候说线框具有节省时间的优势，是站得住脚的。但今天，我们的设计工具专为 UI 设计（想想 Sketch，Adobe XD，或 Figma）而打造，它们大大加快且简化了在全局层面对设计进行管理和更新的操作。在设置好视觉风格之后再更改布局，没理由比在之前更改难。对于那些成熟的设计组织来说，设计系统和支持这些系统的组件库的结合几乎消除了任何借口。而即使你所在的组织还不成熟，你大概也还是能取得与身边的开发人员所使用的 UI 框架相匹配的 UI 工具包。这也有助于：今天，即使是最复杂的视觉美学，仍然是相对简单的。如果你的按钮只是个带有圆角的蓝色长方形，那么就算你故意把它变成灰色，又真能省掉多少时间？

### 线框图还有意义吗？

它在合适的情况下是有意义的。比方说，你画线框图可能是出于以下原因：

- 你确实拥有一个视觉上很复杂的产品（如移动游戏），它的艺术创作过程必定耗时颇长，而你要在不牵涉艺术创作的情况下订出产品的交互方式。即使如此，你仍然可以尽力实现风格的相似度。

- 你将它们用作练习，以帮助人们独立的了解信息框架（希望是产品开发的一次性而非反复性的部分）。

- 你想绘制或测试信息框架，但又依赖于他人的视觉设计（这并不理想！），或者，你在某些方面受制于你可用工具的视觉功能抑或者是被你个人的技能水平拉了后腿。

- 你处于过时的瀑布流或代理环境中，并且你对流程没有太多的自主权，这不是很好，你没有办法。

我确信还有很多其它的可能场景和例外情况，但我认为对于今天的大多数设计师来说可能并不常见，如果你认为传统的线框设计只是在真正适合问题的情况下才使用的方案，那么你会发现它们经常可以避免 — and that’s OK.

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
