> * 原文地址：[Why is Front-End Development So Unstable?](http://www.breck-mckye.com/blog/2018/05/why-is-front-end-development-so-unstable/)
> * 原文作者：[Jimmy Breck-McKye](http://www.breck-mckye.com)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/why-is-front-end-development-so-unstable.md](https://github.com/xitu/gold-miner/blob/master/TODO1/why-is-front-end-development-so-unstable.md)
> * 译者：[Colafornia](https://github.com/Colafornia)
> * 校对者：[geniusq1981](https://github.com/geniusq1981) [sunhaokk](https://github.com/sunhaokk)

# 为何前端开发如此不稳定

我们都知道这样一个笑话：在你学会一项前端技术的时候，另外三项新技术已经发布了。不仅如此，你刚学会的那个也已经被弃用了。

我们却不常看到有解释为什么会这样。

典型的解释（来源于 reddit 的 `r/programming` 频道）这似乎与前端开发者天生不耐烦，追逐流行与能力有限相关，这种解释构成了一个更普遍的谬论：假设你所不理解的行为是由整个群体的愚蠢，糟糕或贪婪造成的 (而你自己的不明智行为完全是由你无法控制的因素造成的)。

无论它是不是谬论，我们确实有这个问题，对吗？

### 量化问题

在跑偏之前，我们有必要确定这个问题是否真的有现实依据。前端技术真的变化很快吗？

从主流受关注（也可能不是）的技术来看，细想一下这个 [Github](https://github.com/collections/front-end-javascript-frameworks) 上“高星” JavaScript 前端技术排行：

```
+------------------------------------------------------------+
| 库               | Star 数  | 发布时间        | 年龄      |
|------------------------------------------------------------+
| React            | 96986   | 2015 年 3 月    | 3 年      |
| Vue              | 95727   | 2015 年 10 月   | 2.5 年    |
| Angular (1)      | 58531   | 2010 年 10 月   | 7.5 年    |
| jQuery           | 49061   | 2006 年 8 月    | 11 年     |
| Angular (2+)     | 36665   | 2015 年 12 月   | 2.5 年    |
| Backbone         | 27194   | 2010 年 10 月   | 7.5 年    |
| Polymer          | 19668   | 2015 年 5 月    | 3 年      |
| Ember            | 19003   | 2011 年 12 月   | 6.5 年    |
| Aurelia          | 10506   | 2016 年 6 月    | 2 年      |
| Knockout         | 8894    | 2010 年 7 月    | 8 年      |
+------------------------------------------------------------+
```

最年轻的项目已经两岁半了，虽然并不是**那么**老，例如，它都不到你的桌面操作系统维护周期的一半长，但是也不是像那个笑话说的那样。所以是什么导致人们对前端有了这种更迭快速、甚至不可持续变化的感觉呢？

### React 与它的朋友们

可能是 React 造成的。作为一个强力工具，它需要一系列的辅助模块和支持库来支撑，这就是问题所在。React 生态中我称之为“微型库（microlib）架构”的内容非常庞大，其应用是由无数离散的，单一用途的 JavaScript 库组成，以对 [Unix 哲学](https://homepage.cs.uri.edu/~thenry/resources/unix_art/ch01s06.html) 致敬。

这一架构的优点是，当新的实践出现，你可以快速适应，这在像几年前那种快速革新阶段非常有用。缺点在于它使你需要经常进行大型迭代，同时也要求你在众多（往往太多）所谓的微型库（microlib）中审查挑选。

这也是我论点的主旨：问题不在于 JavaScript 语言本身 [1]，Web 或是任何特定的技术，而是糟糕的“做选择式架构”使得开发者不得不追逐流行趋势。

### NPM 问题

NPM 是现代 JavaScript 的最大资产，也是最大负债。它提供了丰富的模块，几乎可以满足任意特定需求，但很难对于这些模块进行过滤和管理。哪些模块是真正得到支持的？哪些模块真的有正确的功能？哪些模块不只是恶意软件的载体？JavaScript 开发者真正使用的选择方法是受欢迎程度——下载次数与 Github 上的 Star 数量，这无疑加剧了追逐流行的风气。

当然还有其它方法去甄别一个库：你可以浏览这个库的 Github issue 列表，在 StackOverflow 上搜索问题。你也可以做一些测试甚至自己检查源代码（在大多数情况下）。但这些方法都耗费时间，在选择类似日期解析模块这种小玩意儿时，没有必要做这些耗费时间的事。

我承认这是 JavaScript 开发者的一个文化缺陷。作为面试官，我经常问面试者是如何进行技术选型的，答案令人沮丧，受欢迎程度总是他们唯一知道的指标。软件工程至少在一定程度上是一项研究工作，我们需要培训初级工程师这些研究技能，但是即使我们做了培训，工程师们也未必能做出正确的选择。

### 想象自己是一名初级工程师

站在初级、中级 JavaScript 开发人员的角度，第一次编写新的应用程序。

起初你很天真。你的项目非常干净并希望让事情一直简单，你是一个虔诚的 Agilist（敏捷开发倡导者）而且 YAGNI（You aren't gonna need it，意为 “你不需要它”）是你的口号。因此你从一个“简单的框架”入手。这感觉挺好，对吧？（即使感觉并不好，这也经常是你唯一的选择）。

作为一个基本框架它能做的事很少，因此担子落在你的肩上，需要选择一些辅助库。如果你负责前端工作，可能是 Redux 的用于表单和 API 请求的辅助库。如果是后端，则可能是 Express 中间件[2]。

如果你用 Google 搜索一下，会发现一个强烈推荐 **X.js** 的 Medium 文章。后来发现这篇文章就是 **X.js** 的作者写的，尽管她从未声明过利益冲突（但是她提供了一个 GitTip 的 jar 包）。并不是说所有的 Medium 文章看起来都一样，因此你不能依赖某个“品牌”来识别有信誉的资料。

你错过了一些指出 **X.js** 致命缺陷的评论，因为 Medium 有意压下了这些评论，然后你去继续寻找一个 **Y**。

这次你在 Twitter 上找到了一个有一百多个红心的链接！你猜这是个好信号，因为 Twitter 是一个比你懂得更多的社区“策划”的。你在感激之情中也点了红心（像之前那一百多个人一样）然后按照链接到了 Github。

事情进展的没那么快。那个链接过时了——这个库已经被废弃了。你会发现这一点是因为页面上到处都是 `DEPRECATED` 这个单词，就像史努比主题公园里的 `CONDEMNED` 标志（译者注：史努比系列电影中的一个主题）。

你发现 **Y.js** 是“面向对象”的。你模糊记起计算机专业大一时学到的面向对象程序设计语言和通信的内容，觉得这是一个好东西。但显然这很糟糕。

Medium 上的另一篇文章试图解释为什么，然而他的论证不仅含糊不清，还有一堆密密麻麻你不认识的术语。后来你发现这些术语就是文章作者自己发明的，正如他所引用的看似中立的外部博客文章一样，他引用了自己的论点。

情况变得更糟了。文章声称在 JavaScript 面试中提到 OOP（面向对象）也会导致你拿不到 offer！你现在已经完全懵逼了。谢天谢地，手头就有解决方案——文章作者的售价 50 刀的 JavaScript 开发课程。你记下了课程链接，感觉三生有幸才能找到这个课程，为了表示感激又给了一个 clap（此文章的第一万九千零一个 clap）（译者注：clap 是 Medium 上类似于点赞的一个东西）。

于是你继续找到了 Github 上的高星项目 **Z.js**，虽然它的文档看起来没什么用。文档只是列出了一堆方法，实际该怎么使用 **Z.js** 呢？至少看到 **Z.js** 使用了叫 “Standard JS” 的东西，你觉得这与 ECMA 标准委员会有关，精神一振。然而它们之间并没有什么关系。

作为一名初级工程师，怎么才能做得更好呢？谁可以引导你？高级工程师也同样在边学边做。我们也困在其中，只能疲于跟上潮流，维持工作。

所以你放弃抵抗：选择了 Gihub 上 Star 数最多，投票最多的项目。**这就是为什么 JavaScript 是由潮流和炒作驱动的**。

### 应该做些什么？

和那些天生爱抱怨的人一样，我更擅长抱怨问题，而不是**解决**问题。但我有一些想法：

### 谨慎对待 Medium

Medium 鼓励了一些标题党，使得我们很难辨别权威内容。传统博客允许优秀作者创建独特的博客主题，有助于读者识别之前有过帮助的内容源。

### 谨慎对待 “自我提升”

过去几年里看到了 JavaScript 领域中更积极的自我推销，这可能与在线付费内容的增加与作为 Github “网红” 进行就业/咨询的优势有关。对于那些为优秀内容付费并感到满意的人来说这没有任何问题，但是越来越多的人遇到了虚假策略：自我引证，发明专有术语（所以搜索引擎会将你带回作者的文章）以及名称冒用（如 “Standard.js”）。

### 考虑无微型库（non-microlib）架构

尝试用提供丰富功能特性并且无需其它插件来提升效率的框架来启动项目，这将立即减少模块变动和意想不到的变更。这也是我对 [Vue.js](https://vuejs.org/) 感兴趣的原因之一。你也可以像 [Next](https://github.com/zeit/next.js/) 一样使用 React 作为初学者工具箱或更大型框架的一部分。

### 不要过分焦虑就业问题

唯一需要在报到当天就全盘了解公司内外技术栈的是外包人员，他们可以在公司外完成项目，获得可观的薪酬。除此之外，大多数老板并不在意你不了解最新 React 辅助库的来龙去脉。因此，不必理会那些需要学习一切内容的呼吁，其中大多数都是噪音。

### 注释

[1] 这一想法有很多很多错误。

[2] 你敢信 Express 需要一个中间件才能解析 JSON 格式的 POST 请求？抱歉，Express 就是这么为所欲为。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
