> * 原文地址：[What is accessibility and why is it crucial for your user’s experience?](https://medium.com/ux-in-plain-english/what-is-accessibility-and-why-is-it-crucial-for-your-users-experience-2079e9829076)
> * 原文作者：[Ania Puchala](https://medium.com/@itsaniahere)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/what-is-accessibility-and-why-is-it-crucial-for-your-users-experience.md](https://github.com/xitu/gold-miner/blob/master/TODO1/what-is-accessibility-and-why-is-it-crucial-for-your-users-experience.md)
> * 译者：[Roc](https://github.com/QinRoc)
> * 校对者：[samyu2000](https://github.com/samyu2000)，[z0gSh1u](https://github.com/z0gSh1u)

# 什么是无障碍？为什它对于用户体验很重要？

![Illustration made using Humaaans by Pablo Stanley](https://cdn-images-1.medium.com/max/3000/1*qYEhqdw3LaYgol-wrjrjDg.png)

我们每个人都是独一无二的，在性别、年龄、文化背景和健康状况等方面会各有差异。但是我们可能使用许多共同的产品。是什么能让这些产品适用于各种各样的人呢？答案就是无障碍。

让我们来看看无障碍代表着什么。

根据 Wikipedia 的说法，“无障碍是指针对残障人士的产品、设备、服务或者环境的设计。”

当你读到“残障”这个单词的时候，你的脑海中浮现出了怎样的画面？是一个坐在轮椅上的男人？或者是一个失聪的女人？还是一个失明的儿童？

这些可能是对于残障的最常见的理解。但是它们是否反映了问题的全部呢？

事实上，残障人士的字面意思是指那些由于某种原因，不能依靠自身的感官、肢体、或者意识来完成某些事情的人。造成这种现象的原因是多方面的。

世界卫生组织把“残障”定义为对环境的依赖。这句话的意思是“残障不只是一个健康问题。它是一个复杂的现象。这个现象反映了一个人的身体功能和他或她所处的社会环境的相互作用。”换句话说，你所处的环境决定了你实现目标的能力。当一个人断了一只手的时候，她就无法用两只手来使用智能手机。但是当一个人在一辆拥挤的公共汽车上，握住一个把手的时候，也一样会无法使用手机。有的人在嘈杂的餐馆中会无法听到视频的声音，这时他可能就需要隐藏式字幕。

在包容性设计工具箱（Inclusive Design Toolkit）中，Microsoft 称不同用户的情况为“用户画像谱”。它反映了用户在不同环境中残障的范围。有了这个工具箱，那些有永久的、暂时的或者环境相关的残障的用户就可以使用这个产品。这些知识可以帮助设计人员分析残障特征不明显的人使用产品的体验。如果你的产品满足了一个失聪者的需求，那么那些患有耳部疾病的人，或者是待在嘈杂餐馆中的人也会从中受益。

当你为一个群体解决了无障碍问题的时候，你实际上扩大了它的价值，让其他很多人也受益。这些人在某些暂时的或者受到环境影响的状态下也可以使用你的产品。多亏了这个，你的产品才能以相似的质量和价格，为尽可能多的消费者提供相似的服务。

![](https://cdn-images-1.medium.com/max/2000/1*c54uroDrwHzhtVj6CE-3cg.png)

如果你需要综合评估你的产品的无障碍性，请去熟悉 WCAG 标准。这个指南由 W3C 组织制定，它为设计网页端和移动端产品提供了多方面的建议，以便让尽可能多的人可以在任何环境中使用它。记住，当你为永久残障的人群解决了无障碍问题的时候，更多的人也会从中受益。

---

了解更多：

- [https://www.microsoft.com/design/inclusive/](https://www.microsoft.com/design/inclusive/)
- [https://www.w3.org/WAI/standards-guidelines/wcag/](https://www.w3.org/WAI/standards-guidelines/wcag/)

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
