> * 原文地址：[User experience mapping for dummies](https://uxdesign.cc/user-experience-mapping-alice-emma-walker-868259547ba8)
> * 原文作者：[Alice Emma Walker](https://uxdesign.cc/@aliceemmwalker?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/user-experience-mapping-alice-emma-walker.md](https://github.com/xitu/gold-miner/blob/master/TODO1/user-experience-mapping-alice-emma-walker.md)
> * 译者：
> * 校对者：

# User experience mapping for dummies

## Understand the user’s journey before you start building.

![](https://cdn-images-1.medium.com/max/800/1*r7PCzmLI-otAmK_ib401qQ.jpeg)

The touchpoints of baking by [ux-lady.com](http://ux-lady.com)

### What is User Experience Mapping?

User experience map is a mirror to the user interactions within your products/services.

Last month, I wrote [a guide to Google Analytics for UX designers](https://uxdesign.cc/google-analytics-ux-alice-emma-walker-958d6f0f0af3). It’s a useful article if you have a website or product that already has traffic, but what if you’re starting from scratch? How do we build something that people want to use?

A user experience map helps you sketch out the UX and forecast any friction before creating the actual website or prototype. It’s important to look at the whole picture before you start building or even designing. If you already have a product, it can be a great exercise to understand any friction points your customers may be facing.

* * *

### Personas

![](https://cdn-images-1.medium.com/max/800/1*dLorS3Y_tjuTCI0lsy8Yrw.png)

A great example of a persona by [Keep It Usable](http://www.keepitusable.com/blog/tag/persona/)

If you don’t have any users, how can we map their journey? First we need to create personas for a few kinds of users. Creating personas is an entirely different beast so [check out this article from Hubspot](https://knowledge.hubspot.com/contacts-user-guide-v2/how-to-create-personas) if it’s your first time.

A user experience map shows the users’ needs, expectations, wants, and potential route to reach a particular goal. It’s like a behavioral blueprint that defines how your customer may interact with your product or service.

Businesses generally have enough data about their customers, but sometimes the data fails to provide an answer to the friction or hesitation customers have in fulfilling a business goal. Using storytelling and visuals, a user experience map can let you understand the customer’s relationship with your brand over a period of time. Constructing a narrative of what your users might do is much more compelling than making up a few guesses and jumping right to design.

* * *

### Why you need User Experience Mapping

![](https://cdn-images-1.medium.com/max/800/1*4BWJLglJqJ0dn4A7scEP8A.jpeg)

An incredible customer experience map of Emirates Airlines by [Robert Dersley](https://www.illustrious.co.za/)

You and your team did your best to come up with the best functioning and looking product, but you need understand your customer’s first-hand journey.

You need to understand the way they approach your product, the touch points, their frustrations, and the pain points. Listening to your customer’s experiences gives you a scope to fine-tune your product’s experience.

Having a good understanding of your customer’s journey helps you gain benefits like:

_01 Having a big picture of your customer’s journey_

_02 Making collaboration between design, tech, and business groups easy and effective_

_03 Optimise the user experience by identifying and addressing the negative user experience_

_04 Optimised conversion funnel as you worked on friction points_

_05 Identify the customer leak points, address them, and get the opportunity to bring them onboard again_

_06 Better customer experience journey designing_

* * *

### Creating a User Experience Map

The aim of creating user experience map is to identify and address the pain points of your customers.

![](https://cdn-images-1.medium.com/max/800/1*7GIADubMjmm9t2cEOjN6gQ.png)

Via [Visual Paradigm](https://www.visual-paradigm.com/guide/user-experience-mapping/what-is-user-experience-mapping/)

#### 01 Create a persona

Creating user personas help you understand who your actual customers are, what they need, and the way they interact with your business.

The majority of the information that you need to create user experience map will come from the user personas.

You can create user persona for different user types like your actual customer, potential customer, or an entire customer segment. Ideally, you should create a user persona representing a common set of customers/ behaviors. Use these user personas in user experience map to showcase each user persona’s experience at various touch points.

Example:

> You operate a learning platform. It’s a freemium business model. Your targeted user personas are the young school students and adults aged around 35–60. You will need to create at least two user personas. One for young students and another for the adults 40+ age group.
>
> The basic coursework is free but for advanced coursework or a degree, students needs to pay. The young users are typically your customers.
>
> You motivate the 40+ age group users to donate some of their time to help you convert the free coursework into different local languages.

Both personas will have a different goal in mind while using your website. They have different levels of technology understanding and interaction patterns. You need to create an experience that matches both personas needs.

#### 02 Customer stages

Customer stages consist of goal-oriented user actions. You can visualize it as a multi-step sales funnel.

You need to define the customer stages. A customer stage should illustrate your customer’s motives or goals behind the journey. What brings them to the page/step? What is their motive is and what is their journey be like in next pages/steps.

Each stage should represent your customer’s goal-oriented journey, not your business process steps. A user’s goal could be defined as ‘find a gift for my wife’ and the activities to get there would be:

> product search> compare> cart> checkout

How would you define the stages? Very simple, you define a distinct step right from the start of their journey to buying your product/service.

In our learning platform example, you define customer stages for buyer persona (students) as:

> 1. Visit the website
>
> 2. Search the most suitable course
>
> 3. Decide whether to go for a free course or a paid degree course
>
> 4. Pick the right one and getting the course details
>
> 5. Choosing the desired course
>
> 6. Pay the final fees if it’s a paid degree course

#### **03 Define customer interactions**

Every time you have a point of customer contact with your business it’s called a ‘touchpoint’. For a customer to achieve a goal, they must go through numerous touchpoints. Touchpoints include but are not limited to signing up for a newsletter, creating an account, subscribing to your service, or buying a product.

![](https://cdn-images-1.medium.com/max/800/1*PzKvLKnsenqG3aXaxlgc5g.jpeg)

A friction touchpoint in the Emirates customer experience map by [Robert Dersley](https://www.illustrious.co.za/)

You will need to define a detailed list of touchpoints. It will probably be a long list, but it will help you optimise each step of journey for your customers.

#### 04 User Testing

This might cost you a bit of money but you will get the very accurate end-user insights for your website. The test results will help you understand:

_01\. The user’s goal on your website after landing on it._

_02. The feel of the site with your process in place._

_03. How they find the touchpoints on your site._

_04. How they interacted with the touchpoints and reached the goal._

_05. Their emotions and expectations while interacting with the touchpoints._

_06. What made them think before taking the desired action?_

_07. What friction did they come across while passing through different customer phases?_

_08. How long it took to reach the desired goal._

#### 05 Identify friction

The user experience map helps you get the big picture of your customer journey with your product/service. You may look at the customer persona and their journey differently than other team members.

It’s best to design the user experience map, define the customer persona, highlight the customer stages, and discuss with your team. This is the easiest way to locate the friction on customer touchpoints.

You and your team know your customers the best. But here are a few generic questions that may help you identify the friction:

_01. What are the possible points of friction that our customers may find while interacting with touchpoints?_

_02. Are they reading all the content before leaving the page?_

_03. Are they abandoning the ultimate goal because of too much or too little content ?_

_04. Are we keeping users in the communication loop to make them onboard in future?_

_05. Do we have enough content detail on the page that our users may want to see?_

_06. Is slow loading speed causing the high bounce rate?_

#### 06 Address friction

Like we discussed in the previous section, you need to view your process through your targeted customers’ lens to find the friction.

The purpose of user experience map is not only write down and visualize the user journey, it’s also to view the journey from customer’s perspective, note down the friction, and find out the ways to address the friction.

User experience mapping will help you decide a set of actions that will help you improve the experience. Ideally, you should follow your user persona’s thought process and try finding ways to address the friction. If you are in a team, each member should think about the solution using the user persona and log the results.

Discuss all the possible ways to address the friction with your team. You will have a definite way addressing the friction. Implement that on your user experience map.

Now, make your user persona try to reach their goal from the beginning and see how that new solution you put in place works. Do you all agree with the solution? If yes, you addressed it.

Feel free to repeat the process for all the bugs you or your team come across. Address all the major friction points. This will help you optimise and fine-tune your user experience and drive the ROI.

You can download the print ready .[jpeg mapping chart file](http://lesliedesigns.com/wp/wp-content/uploads/2014/03/customerjourneymap.jpg). You can use it to map your users experience stories. Feel free to download and print it.

* * *

### Conclusion

User experience mapping can help you significantly improve the customer journey even before you start prototyping it. It helps you think from your user’s perspective and visualise the friction you have in experience. Addressing these issues helps you create a super awesome product that your real customers want to use.

**About me: I’m Alice Emma Walker, a User Experience Designer in Canada / Hong Kong / Australia. When I’m not UXing, I’m playing rugby or traveling. Check out [my other articles](https://medium.com/@aliceemmwalker) or connect with me on [LinkedIn](https://www.linkedin.com/in/aliceemmawalker/).**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
