> * 原文地址：[Fun places to learn CSS Layout –  Part 2: Grid Layout](https://stephaniewalter.design/blog/fun-places-to-learn-css-layout-part-2-grid-layout/)
> * 原文作者：[Stéphanie](https://stephaniewalter.design)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/un-places-to-learn-css-layout-part-2-grid-layout.md](https://github.com/xitu/gold-miner/blob/master/TODO1/un-places-to-learn-css-layout-part-2-grid-layout.md)
> * 译者：[EmilyQiRabbit](https://github.com/EmilyQiRabbit)
> * 校对者：[Alfxjx](https://github.com/Alfxjx)，[sleepingxixi](https://github.com/sleepingxixi)

# 趣味学习 CSS 布局 —— 第二部分：网格布局

![](https://stephaniewalter.design/wp-content/uploads/2019/07/places-learn-css-grid.jpg)

两年前（天呐原来已经过去两年了！）我曾经写过一份关于[趣味学习 CSS 布局 —— 第一部分：弹性盒](https://stephaniewalter.design/blog/fun-places-learn-css-layout-part-1-flexbox/)的短篇文章。实话说，我很早之前就想写一写关于网格布局的第二部分，但是一直没有时间落实这个想法。我第一次谈论到网格布局是在六年前（又一次想感叹，天呐！）即 2013 年的一篇文章中：[响应式网页设计现状](https://www.smashingmagazine.com/2013/05/the-state-of-responsive-web-design/)。该设计准则从那时候开始就吸引了我的注意，但是它当时还并不完善。

从那以后，前端发生了很多变化，现在[大部分主流浏览器都支持网格布局了](https://caniuse.com/#feat=css-grid)。说到网格布局标准，归功于 [Rachel Andrew](https://rachelandrew.co.uk/) 和 [Jen Simmons](https://jensimmons.com/) 真是实至名归！网格布局是一个相当优秀的 CSS 属性集合，它让你可以使用行、列来确定一个网站网格布局系统，并依照此系统放置元素。很酷吧？

如果你习惯使用老方法：float，那么这种语法对于你可能会有些复杂，所以有很多有趣的网站、教程以及沙箱网站来帮助你学习并掌握网格布局的一切内容。请享受这个过程吧！

> 法语版文章地址：**[Apprendre le positionnement en s’amusant – Partie 2 : Grid Layout](https://www.creativejuiz.fr/blog/css-css3/apprendre-le-positionnement-en-samusant-partie-2-grid-layout)**

## 用来学习 CSS 网格布局的游戏

### [Grid Garden](http://cssgridgarden.com/)

在这个有意思的游戏中，你要使用一些 CSS 网格布局属性来浇灌并照顾你的花园。游戏的每个关卡都会对不同的属性作出解释，你可以使用它们来提升等级。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/grid-garden.jpg)

### [Grid Critters](http://www.gridcritters.com/)

这是一个价值 $139 的游戏课程，它的设计完美，并能够教你如何可以成为一名 CSS 网格专家。我其实很希望能有一个“免费”的游戏入门，这样我就能试玩一下了。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/gridcritters.jpg)

### [奖励关 —— CSS Diner](https://flukeout.github.io/)

在这里你可以学习 CSS 网格，弹性盒以及其他任何你想学的布局，而如果你不能在页面中选中你需要的，那可就不那么有趣了。CSS 选择器游戏有 32 个级别，能让你学习很多 CSS 选择器。饿了吗？游戏由 [@flukeout](http://www.twitter.com/flukeout) 制作。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/cssdinner.jpg)

## CSS 网格布局可视化游戏场和生成器

有时候学习的最好方法是在浏览器里直接玩一玩代码和属性。这些可视化的游戏场工具能让你使用网格搭建内容或者随意玩一玩，以此帮你掌握它。

### [常见网格布局实例](https://gridbyexample.com/examples/)

还有什么学习方法能比实际查看代码原理更好呢？这个网站（网站策划是 [Rachel Andrew](https://rachelandrew.co.uk/)）是一个非常棒的实例库，解释了如何使用 CSS 网格布局构建不同的布局。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/grid-by-example.jpg)

### [网格可视化游戏场](https://alialaa.github.io/css-grid-cheat-sheet/)

在这个多彩的游戏场里，你可以试玩一个已经构建好的网格，并测试不同的属性。作者是 [@alialaa](https://twitter.com/alialaa)。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/css-visual-ground.jpg)

### [CSS Grid Generator](https://cssgrid-generator.netlify.com/)

它是由 [Sarah Edo](https://twitter.com/sarah_edo) 创建的工具，帮你构建属于自己的网格系统

![](https://stephaniewalter.design/wp-content/uploads/2019/07/css-grid-generator.jpg)

### [CSS 网格布局生成器](https://jhpratt.github.io/grid/)

另一个可以在浏览器里帮助你创建网格模版的工具。但这个也支持 regions！由 [Jacob Pratt](https://github.com/jhpratt) 创建。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/css-grid-generator-2.jpg)

## CSS 网格布局备忘录

### [CSS 技巧：网格布局指南大全](https://css-tricks.com/snippets/css/complete-guide-grid/#grid-table-of-contents)

这是一份很详细的介绍，同时也是一份很实用的备忘录，[CSS Tricks](https://css-tricks.com) 页面包括了所有网格属性。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/csstricks-grid.jpg)

### [GRID：一份简单的关于 CSS 网格布局的可视化备忘录](http://grid.malven.co/)

这是一份超棒的可视化备忘录，可以让你在点击的时候复制/粘贴属性。由 [Malven Co.](https://malven.co/) 创建

![](https://stephaniewalter.design/wp-content/uploads/2019/07/css-cheatsheet-1.jpg)

## 几个有趣的演示

### [CSS Grid Floor Plan](https://codepen.io/oliviale/pen/moLrBq)

为什么不能用 CSS 来布置你的房间呢？这是由 [Olivia Ng](https://twitter.com/meowlivia_) 制作的一个很酷的演示

![](https://stephaniewalter.design/wp-content/uploads/2019/07/css-grid-floor.jpg)

## 一起看几个视频吧！

### [视频 —— 1 分钟学习如何使用 CSS 网格布局！](https://www.youtube.com/watch?v=FwiSbmyNQ18)

在这个有趣的视频里，[Jenn Lukas](http://jennlukas.com/) 将会在一分钟内为你演示如何使用 CSS 网格布局模块来定义行和列。

[![](https://stephaniewalter.design/wp-content/uploads/2019/07/css-grid-jen-lukas.jpg)](https://www.youtube.com/watch?v=FwiSbmyNQ18)

### [Layout Land 频道 —— CSS 网格布局视频教程](https://www.youtube.com/playlist?list=PLbSquHt1VCf1x_-1ytlVMT0AMwADlWtc1)

这是一个来自 youtube Layout Land 频道的播放单，[Jen Simmons](https://jensimmons.com/) 将会在视频中为你讲解网格布局基础

![](https://stephaniewalter.design/wp-content/uploads/2019/07/grid-basics-video.jpg)

### [cssgrid.io](https://cssgrid.io/)

这里包括由 [Wes Bos](https://twitter.com/wesbos) 创建的 25 个视频，这些视频由 Firefox 支持，能帮助你学习 CSS 网格布局。

![](https://stephaniewalter.design/wp-content/uploads/2019/07/CSSGrid-io.jpg)

## 扩展阅读

如果你需要更多经典资源，可以查看：

* [Rachel Andrew’s book “Get Ready for CSS Grid Layout”](https://abookapart.com/products/get-ready-for-css-grid-layout)
* Rachel Andrew 的文章“[The New CSS Layout](https://abookapart.com/products/the-new-css-layout)”
* 网站 [Learn CSS Grid](https://learncssgrid.com/)，它包含所有网格相关的属性，能帮助里理解它们是如何运作的
* [CSS Grid for Designers](https://open.nytimes.com/css-grid-for-designers-f74a883b98f5) —— 介绍了新技术是如何改变网页布局的
* [Mozilla has a really cool step by step tutorial on CSS Grid Layout](https://mozilladevelopers.github.io/playground/css-grid)

您是否正在为网页或移动端应用招聘 UX 或者 UI 设计师？您的会议是否需要一个演讲者，或者只是想了解我的更多信息？您可以看看[我的作品集](https://stephaniewalter.design/#work)并[联系我](https://stephaniewalter.design#contact)。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
