> * 原文地址：[The State of Web Browsers: Late 2018 edition](https://ferdychristant.com/the-state-of-web-browsers-f5a83a41c1cb)
> * 原文作者：[Ferdy Christant](https://ferdychristant.com/@ferdychristant?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-state-of-web-browsers.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-state-of-web-browsers.md)
> * 译者：[HumesFork](https://github.com/HumesFork)
> * 校对者：[connie610](https://github.com/connie610), [Wangalan30](https://github.com/Wangalan30)

# 2019 开年浏览器之争的最新进展报告

![](https://cdn-images-1.medium.com/max/800/1*ysSQaD2xD85QT2Zz2kFxZw.png)

**截至2018年12月6日**：微软宣布放弃自家引擎，证实此前的流言为真。浏览器大战中只剩下最后一个巨人 —— Firefox（原因见下文）如果你想支持火狐，[安装 Firefox](https://www.mozilla.org/en-US/firefox/)。该安装包同时支持移动端。这里是指导 [如何从 Chrome 转移到 Firefox](https://www。mozilla。org/en-US/firefox/switch/)。

**截至2018年12月8日**：下文可能会让人感到沮丧。但同时我也发布了一系列后续文章，包含 2019 年振奋人心的新技术[点击这里](https://ferdychristant.com/the-state-of-web-browsers-88224d55b4e6)。

### 序言

**警告：这篇文章包含了几个预测。**

昨天，[Windows Central](https://www.windowscentral.com/microsoft-building-chromium-powered-web-browser-windows-10)发布了一则流言：Microsoft 打算放弃自家 Edge 浏览器，或更确切的说，准备利用 Chromium 引擎开发一款新的浏览器。这则消息很快被主流媒体传开，据我所知微软并未否认,因此我认为这是真的。借此机会，我想分享一下我对该问题的想法。

如果你从未看过我的博客也没关系，我会从 1996 年开始介绍历史背景。我属于 Zeldman 派，坚定地相信并支持互联网的开放化、标准化及共享化。

同时我也要提醒你，我相当直接，有点古怪，喜欢黑色幽默，并且还有些玩世不恭。牢记这一点，让我们出发吧。

#### Microsoft Edge：注定失败

让我们首先来看一下 Edge 推出三年后在市场占有率上的失利。数据资料显示，Edge 的市场占有率大概在 4-5%。微软公司曾经在桌面系统拥有 80%-90% 市场，基本处于垄断地位。时至今日也依然占据半壁江山，鉴于此,它可以用直接或间接的方式将 Edge 推广给我们。

但随着移动端的发展，市场份额下跌到 2%。就像Opera、Vivaldi 或 Samsung 浏览器一样。Edge 正变得无人问津。诚然，每个浏览器都有自己的忠实追随者，在他们的眼中这些浏览器足够棒。然而他们不是主流用户，开发者也不会关心。

事实上，Edge 的处境比 Opera 这样的小众浏览器更加糟糕。至少它们与 web 标准是兼容的。由于内置引擎是 Chromium，网站可以很顺畅的运行其中。Edge 享受不到这种便利，因为它需要维护自己的引擎，玩一场努力跟上现代 web 标准的追赶游戏。

移动端无人问津，桌面端也节节败退，Edge 彻底失败。以下有一些 Edge 如何自救的方法。但仅仅只是个人看法，而且都是一些后见之明：

* 争取市场的最佳时机从开始就已经错失了。无论你多么讨厌 IE，也必须承认，依然有数千万用户就像肌肉记忆一样认为 IE 就是“互联网”的入口。其中一些是不得不使用 IE，还有一些没找到更好的选择，IE 足以满足他们。然而当 Edge 问世时这一大部分用户并未被挽留住。从 IE 切换到 Edge 没有任何指引。对那些年尝试使用新浏览器但却失败的 IE 用户来说，Edge 和那些新浏览器没任何区别，仿佛一个外星人。见鬼，微软至少可以保留相同的图标，然后偷偷换掉渲染引擎来保留用户。但是他们没有，所以老用户都不愿使用 Edge。这一切都发生在巨变的 Windows 8 时代。这是胡搞，也是一次彻头彻尾的失败。

*  对那些熟悉各种浏览器的 IE 用户，Edge 相比其他浏览器例如 Chrome 没有任何优势。Edge 反而在某些方面有明显劣势。Edge 的触碰式，扁平化设计破坏了与桌面端用户的联结。对那些最有希望使用 Edge 的 IE 用户来说，深根于脑海里的桌面端操作概念模型被彻底破坏。

*  对于开发者来说，Edge 只能算是另一个 IE。它比 IE 好一些，但依然落后于现代 web 标准和特性，与其他浏览器的工作原理和渲染机制也不同，完全是个新麻烦。这并不是 Edge 研发团队造成的。通过我和他们的交谈，我发现他们都是伟大的工程师，同时也是开放 web 的拥护者。但他们只是一个极小的团队，并没有很多的资源支持。同时，当 Edge的 竞争对手每 6 周就更新一次时，微软依然坚持系统更新时顺带更新浏览器这个失败策略。所以最好的结果也就是发布比竞争对手略差的浏览器，开发者何必为此费心呢。

* 缺乏营销。微软有时会被过去的经验困住：他们认为只要发布产品,用户就会使用。就像他们在数十年的垄断期做的那样。然而辉煌已经过去，微软需要持续不断地竞争和营销以此来赢得人心。Edge 显然没有做到。自发布以来，Edge 的品牌知名度一直不高。

但以上原因都不是根本原因。即使以上问题全部解决，也只能提高 4%-6% 的市场份额。这些方法不能让 Edge 广泛传播，也很难帮它重回主导地位。

简而言之，根本原因在于移动端的出现。一个网站 50%-60% 的流量来自移动端，数亿的用户只用手机上网，如果你未在移动端投入任何精力，那么可以宣布你在这场游戏中出局了。

桌面端依然是一个相当大且有趣的市场，在这里微软需要和谷歌竞争。谷歌拥有全球最大的 web 服务并且可以轻松的将 Chrome 推给数亿使用者。微软没有做到，所以失去了这批使用者。谷歌可以只允许他们的服务在 Chrome 上运行，或者拒绝向使用其他浏览器的用户提供服务（据称）。他们强迫 Android 制造商默认给用户安装 Chrome 和无数的 Google 应用。

不得不提一下曾经在该领域发生过的角逐游戏。微软曾使用不道德和反竞争的方式获取了浏览器领域的绝对垄断地位 (IE)。如今，它的对手正在做着同样的事情，而这一次，它失败了。

所以我认为，Edge 注定失败。毋庸置疑，它的全新版本还是会失败。原因很简单，微软对浏览器的安装方式没有任何发言权：在移动端谷歌是默认浏览器，在桌面端谷歌可以通过 web 服务来控制用户。所以微软切换到 Chromium 引擎对于市场份额不会有任何改变，现在唯一的竞争方式是通过浏览器 UI，而不是引擎。但这没有触及到根本，因为 UI 只是一种消费品（此处指容易模仿）。

#### 运行在 Chromium 上的微软 Edge

假设传言是真的，Edge 使用 Chromium 作为渲染引擎意味着什么？

上文已经提到，市场占有率不会有根本改变。由于 Edge 和 Chromium 主导的 web 服务更兼容，可以吸引一小批用户，所以市场会有小额提升。但我并不认为这会带来显著改善，因为不是一项特有优势。

对于开发者来说，少了一个浏览器需要兼容，如果这是他们首要操心的事情（不太可能）。更少的测试工作，更少的浏览器 bug，都可以轻微提高生产力。

对于开放 web 来说，事情就变得复杂。如果我是一个务实的开发者，我很难从浏览器引擎竞争中看到巨大收益。实际上，如果我输入代码并运行，无论浏览器引擎是什么，我希望获得同样的输出。如果得到不同输出甚至是 Bug 只会让人觉得痛苦。不同的引擎拥有各自的特性，这意味着实现同样的功能需要几份代码。从生产的实用性角度看，你可以取一个漂亮名字例如“渐进增强”，但这不会改变糟糕的事实。

所以为什么我们需要不同引擎？速度可能是一个原因，但这没有说服力。时至今日，几乎所有的引擎速度都相同。

保留不同引擎唯一的好处就是它可以激励创新。尽管实践中不同引擎引发了大量麻烦，但他们确实能为开放 web 带来好处。无数的浏览器制造商研发出新特性，并且最终被纳入 web 标准。针对这种情况，我们应该：这些特性能被集成进开源引擎。就像 Chromium。只要这个浏览器是真正意义上的开源。

我的看法是，浏览器引擎不应该是维护开放式网络的驱动力。如果这样，那么在 Chromium 占主导地位的情况下，开放式网络已经不存在了。相反，在 web 标准决策过程中应该保持多样性，既有竞争也有合作。只要在标准化决策过程中保持多样性，不被一个组织垄断，减少引擎数量也是可以接受的。

更直白地说：在 W3C 的会议或标准讨论中，房间内不应该有 60-70% 的谷歌员工。同样，谷歌也不应该拥有 Chromium 这样“开源”项目的否决权。微软，火狐， Adobe 等都应该在那里获得一席之地，这样即使引擎数量很少，我们也能拥自我决策权。

另一个浏览器创新方式与引擎无关，它是 UI 层面的。我会很快聊完这个话题：因为我对此完全没有兴趣。在我看来他们都一样。

让我们从微软的角度推测一下为何投奔 Chromium。我认为他们已经意识到 Edge 在市场中毫无竞争力，因此，继续在 Edge 中投入也只是绝望的空耗金钱。开发一个没有任何商业利润的引擎代价非常高昂，所以他们不得不承认自己的失败，并加入“标准化”大家庭。由于他们已经失去了移动市场并且逐渐转型为服务公司，他们必须使产品与 Chromium 百分百兼容，所以为什么要自己研发一个不兼容的引擎呢？即使在微软内部，Chromium 才是一等公民，而不是 Edge。

有人疑惑，既然新的浏览器份额也不会超过 Edge，为何还需要一个新的呢？我猜测实际原因可能是，他们想集成一些桌面端特有的功能进去，例如在 web 页面上绘画。但是当你发布操作系统却没有自带的浏览器会相当尴尬。用户也不会自行下载 Chrome。

#### 火狐：逐步走向衰落

如果你认为 Edge 的处境已经很惨，事情还可以更糟。让我说些真实想法：我希望火狐能够成功。从他们打破微软 IE 的垄断那刻起，我就成为他们的粉丝，今后也会一直支持他们。我支持火狐的原因略显感性：尽管不是最好的浏览器，但他是唯一的独立浏览器，开放共享式网络的守护者。比起其他浏览器，他更具人文价值。

然而他们把事情弄砸了。他们已逐步走向衰落。他们自己的系统没有成功也没有抢占到移动端市场，占比仅为 1%，比 Edge 还少。

我再重申一遍，失去移动端市场就意味着失败。大部分的网络流量来自手机，就这么简单。

不过，桌面端依然有意义。但火狐早就在这里失败了：

![](https://cdn-images-1.medium.com/max/1000/1*a0-r-zbZqI0PnCcYSjUCuA.png)

从上图可以看到，桌面端浏览器只分为两款：Chrome 和其他。其中其他浏览器又可以分为两类：火狐和其他一堆没有任何存在感的浏览器。

火狐虽然占据市场份额不多，但依然是有价值的主流浏览器。它在阻止谷歌垄断市场的过程中扮演了重要角色。不是主角，但依然重要。

根据资料，火狐在桌面端的市场份额已经低于 10%，在其余设备上占比更低，并且呈下降趋势。上图没提到的是，他们去年一年就丢失了 3% 的市场。如果不重视市场营销而仅仅关注技术，显然是行不通的。

跨设备的市场份额更加令人震惊：

![](https://cdn-images-1.medium.com/max/1000/0*UKH_lV5-RXgDUAFm.png)

来源: [https://en.wikipedia.org/wiki/Usage_share_of_web_browsers](https://en.wikipedia.org/wiki/Usage_share_of_web_browsers)

火狐仅仅 8 年就从 30% 的市场份额跌到无人问津。可以明显看到随着移动端的发展，Chrome 和 Safari 崛起了。就像我们在桌面端图表看到的那样火狐越来越不重要。

火狐在移动市场中无足轻重，在桌面端也逐步衰落。警报已经拉响。在过去的十年，如果你开发一个在火狐里不能运行的程序，你会被同伴嘲笑。它是开发者心中的标杆。

现在越来越多的网站或者代码测试已经不在火狐中运行。人们慢慢意识到火狐不再重要。它已经衰落了，但会衰落到何种地步呢？

火狐有两种方式阻止颓势，但我要遗憾宣布，这两种方法都难以奏效。并不是我危言耸听或想让他们失败，而是他们难以解决根本问题。

第一个武器是技术。从工程角度看，火狐在重写浏览器方面做的非常出色。无论是 Rust 写的 Servo 内核浏览器，还是纯 java 写的 WebRenderer 内核浏览器都极具创造性，我相信他们最终能够开发出更好的浏览器。从技术角度看，他们发布世界上最优秀的浏览器指日可待。

火狐的忠实用户（比如我）会非常爱它，当然了，还会有 3 个新用户觉得它很棒。但仅此而已。浏览器市场份额的巨大变化不是由浏览器功能或性能引发的。随着移动浪潮到来，这些移动系统的主导方可以向数十亿用户推广内置浏览器。非技术用户不会根据功能或速度有意识地选择浏览器，实际上现代浏览器都很快。老实说，即使在很普通的硬件上运行，也难以感觉到区别。火狐的衰落和竞争对手的迅速崛起并非出于技术原因，所以技术不是解决之道。我们都必须使用谷歌的服务。火狐即使赢得一场战役也无法赢得全局战争。

第二个武器是传道。火狐作为隐私守护者，扮演的是一名正义角色。我很在意这点，但诚实地说，大多数人并不在意。当便利和原则出现冲突时，人们总是选择便利。当讨论到这个问题时，他们要么不愿意倾听你的想法，要么根本不觉得这是一个问题。诚然，有许多人关心这个问题，但恐怕他们的数量并不足以挽救火狐。一个类似的例子是当 Facebook 收购 WhatsApp 时，引发了一场用户是否会因为隐私问题而放弃使用 WhatsApp 的讨论。实际情况是，那一年的用户增加了许多。

火狐未来的景象似乎非常惨淡。最后的结局会怎样？最好的结果是维持当前水平。即便如此，他们的市场份额仍然会随着移动市场的增长而下降，因为火狐在移动端几乎没有存在感。而桌面端市场应该会比较稳定，不会有爆发式的增长。

最坏情况是，在桌面端他们跌到 5% 以下。此时，它就彻底边缘化了，并最终沦落到和 Edge 一样。

请注意，当我说边缘化时，我并不是说彻底消失或等死。作为一个拥有 5% 市场份额的浏览器，依然可以为一亿用户提供价值。这是一批庞大的用户。我们中的大部分不会在如此高的产品层面工作。当我提到边缘化时，指的是世界范围内的浏览器战争。

糟糕的不仅仅是这些。微软，在放弃 Edge 和自家渲染引擎过程中做出了错误决策。他们本可以和 Mozilla 联手，结成强大的同盟共同对抗谷歌 Chromium 的垄断。至少在客户端，此举意义非凡。

但是他们没有，他们选择了一条简单却短视的路。在这一轮战争中，好人输给了蠢人，火狐虽然失败了但至少做了正确的事。

#### Chrome，也称“网络”

关于 Chrome 的讨论已经很多，我对它的感觉很复杂，你可以认为我的态度是“有层次的”。

首先，就个人用途而言，我认为 Chrome 是目前最好的浏览器。它速度快，有漂亮的 UI，扩展支持良好，开发者工具更是无与伦比。但并不是说其他浏览器都是垃圾。它们也不错，但 Chrome 要更好一些。

从开发者角度看，Chrome 有非常吸引人的开发者工具。除此之外，Chrome 通常第一时间发布新功能。作为一名开发者，我几乎从未遇到某些功能在 Chrome 中无法运行但在其他浏览器可以运行的情况。反过来的状况倒是很常见。

所以无论作为使用者还是开发者，Chrome 都让我很舒心。它是一款优秀的浏览器。更加令人称赞的是：谷歌为改善网络平台质量做出的努力比历史上任何一个组织都多。

他们有能力这样做。微软也有，但他们有巨大区别。从历史角度看，微软总在积极地破坏网络。谷歌也许为了自己的利益才改善网络，但假若没有谷歌的这些努力，我们也许还处在黑暗时期。

你可以稍微感受一下黑暗时期：浏览器从不发布新功能，即使最简单的功能被广泛使用也需要 5 年，然后该功能也许还不能正常使用。谷歌作为改善网络的最大驱动力，在近几年以一己之力扛起了可持续应用平台的大旗，使网络成为了一等公民。

但谷歌也有缺点。Chrome 作为一款优秀的浏览器，使市场充满生机。它的高质量吸引了一批用户，顺利抢占到部分市场。

但你要是认为数十亿用户仅仅因为好用就一起选择谷歌浏览器，那你实在天真。口碑传播速度不可能如此快，人们也不会仅仅因为理性或者技术原因选择浏览器。

显然，谷歌在其他市场的主导地位造成了这部分市场的急剧上升：

*  如果您想在 Android 设备上加入 Playstore，则必须将 Google 的应用套件放在设备上，其中包括 Chrome。如果您不想要 Playstore，你可能根本启动不了设备，因此你没有选择。这里有个简单的等式：如果你不是苹果用户然后启动移动设备，你 **将会** 转移到 Chrome。你也许会提到现在有些安卓设备不需要  Playstore，但这不会撼动根本。

* 谷歌不仅可以让数亿用户转投到 Chrome，还拥有世界上最广泛的网络服务。谷歌搜索，谷歌地图，Gmail，Youtube 都在 Chrome 运行更好，并且这些服务还会为 Chrome 做广告。再次印证了在一个领域的垄断可以给另一个领域带来优势。这种方式不同于安卓系统的捆绑式安装，它更加温和，但依然是一种强有力的营销手段。

*  用户经常无意识地就安装了 Chrome。和其他软件捆绑在一起是一个很好的例子。

我认为通过在市场 A 的垄断去侵占市场 B 是一种反竞争行为。“垄断”是这里的关键词。从商业角度看，一家公司小范围这样做是正常的也是被广泛许可的。福特可能会发布一辆带有汽车收音机的新车（据我所知），但没有人会担心。这样做完全合法，也没有扰乱二级市场。

但当规模扩大后，事情就变了。这与微软反垄断案异曲同工（该案子最后无疾而终）。

你可以反对我并且赞同新自由主义者的主张，公司有权在他们自己的系统或网络服务中做任何事。你可以有自己的想法。但无论持哪种想法，事实不会改变。由于在移动端和网络服务的垄断地位，谷歌是目前世界上唯一有能力让如此多的用户安装（默认）浏览器的公司。

Chrome，数十亿用户使用的选择，确实是一款优秀的浏览器。谷歌公司一直在优化，所以它会一直成为用户首选。Chrome 结合其特有的功能，俘获了数十亿用户，占领了 60%-70% 的市场。开发人员和代码实验项目将其作为首选（例如 Electron 和各种 Chromium 复制版）进一步加强了其主导地位。

由于上文提到的原因，火狐和微软都很难重新赢回市场。他们在移动端毫无存在感，也没有广泛使用的网络服务。微软本可以通过 Windows 推送浏览器，但他搞砸了。现在，无论他们把浏览器做得多好都没用，因为他们无法大范围推广。

我们现在生活在 Chromium/Chrome 的世界。这似乎回归了微软用 IE 统治世界的日子，但现在谷歌才是垄断者。

微软曾经用糟糕的浏览器统治世界（IE6）。相反，谷歌一直做的很好，Chrome 十分优秀。IE 一直不遵循标准，Chrome 则是基于标准开发的（即使 Google 在这些标准决策中有很大的发言权）。微软并未在改善网络质量方面进行过投资，也不重视 IE，任其自生自灭。谷歌正好相反，他们积极改善网络服务。

这是一种温和的垄断，像一个友好的独裁者，但没有改变独裁本质。短期来说有利于开发者，优秀的浏览器，高效的引擎，大众的拥护都使开发者无需担心兼容问题。在这种单一文化中，开发人员只需关注软件发布。

从长期看，它将会打破开放式网络的平衡。仅仅发布一款新的浏览器或引擎无法打破垄断，正如我之前所说：在制定 web 标准的决策过程中必须要有多方代表，保证他们都同样重要。我们可以有更少的引擎，甚至只有一个，然而这个引擎的构建过程必须是共享，开放的。这是另一种形式的开放网络。

虽然这不是最理想的状态，但至少比较现实。开放式网络比一家独大好。我们已经无法回到百花齐放的时期。

#### Safari

重点都已经说完，但我还想继续谈谈一些小众浏览器。我会对每一个科技巨头都一视同仁，以确保不用收到他们其中任何一个的邀请信，而且我也不喜欢虎头蛇尾。

由于苹果手机的成功，Safari 获得了不小的市场份额，用户必须用 Safari（或更准确地说，他们可以使用这种浏览器引擎）。虽然不像谷歌那样占主导地位，但也不容忽视。

在移动设备阵地的沦陷，微软和火狐不可能做这样的推广。这再次证明浏览器的特性或功能并不是用户首要关注的，如果是，Safari 不可能成功。

Safari 拥有 15% 的市场占有率，但显然不是因为它好用（如果只算移动端比例更高）。它很普通，与 Chrome、Edge 和火狐比，它在 web 标准和功能支持方面远远落后。甚至没有任何市场的 Chromium 克隆浏览器，都比 Safari 优秀。

Safari 是故意不遵循 web 标准的。Safari 的发布说明一定会让你印象深刻：当一个 web 新功能发布时，它通常漏洞百出且可用性极差。如果你希望在 web app 上获得和原生 app 同样的体验，那么你将成为 Safari 的头号敌人。

苹果公司，作为一个拥有数万亿美元资产的科技公司，完全有能力和谷歌在技术上一较高下。至少可以试着这么做。他们本可以将他们的品牌价值加诸到 Safari，但是他们没有。他们完全沉迷于自娱自乐。投资的钱让 Safari 不至于无人问津，但又不足以多到使其成为一款优秀的 app 平台。因为任何不属于 Apple 本身的强大平台都是一种威胁。

最后强调一下，背后的技术团队没有错。他们都是很优秀的工程师，支持开放式网络。但是他们的雇主需要平衡商业利益。这在大公司很常见，因为我曾经为其中一家服务过。

#### IE

关于 IE 还有什么可说的吗？我想除了它是历史上消亡最慢的浏览器外，没什么了。即使微软自己宣布放弃都没有彻底杀死它。但是现在，众多开发者终于可以忽略旧IE，也许他们早就这么做了。

依然有不少人喜欢 IE。我曾经为一家医疗保健公司工作，客户似乎就很喜欢 IE。大概有 10% 的用户依然选择它。令人沮丧的是，时至今日，这个市场占有率依然没下降太多。但是在老 IE 里开发一款现代 web 应用就好比在特斯拉汽车上装上正方形车轮，令人痛苦。

还有一批只兼容老式 IE 的企业。他们虽然厌烦却不得不维护这些程序。我经常困惑这些系统的拥有者到底想做什么。他们想一直运行系统，但不想投入一分钱。看起来什么都不做就刚好。但等待不能解决问题，只会让这些系统在绝望中走向死亡。

#### 其他

还有一些其他小众浏览器。主要是基于 Chromium 内核的浏览器。关于这些浏览器我并没有太多想法。它们通过独特的 UI 吸引一些特定用户，但注定难以有大的发展。他们可以赢得或失去 1-2 个百分比的市场份额，但永远不会超过 10% 的市场份额。

### 总结

我没有料到文章会变得又长又涩。即使事实如此丑陋，我仍然希望能够还原真相。可怕的真相是：

web 现在运行在一个单一引擎上。除了 Safari 之外，没有一个浏览器在移动设备上使用非 Chromium 引擎。它使用 webkit 引擎，与 Chromium 引擎类似，是一种基于 webkit 的引擎。

在桌面端，Edge 放弃自家引擎意味着只剩最后一个巨人抗衡 Chromium 的垄断：火狐。它是曾经的王者，但现在已经逐渐式微，进入小众浏览器阵营。由于他们在移动端的缺失，他们很难推广自己的浏览器，没法真正和谷歌抗衡。

所以这是 Chromium 主宰世界。我没法给你带来你希望的消息或快乐结局。就像 IE 之前统治世界一样，浏览器不仅仅依靠质量取胜，真实世界要复杂得多。新一轮垄断是通过市场营销，利用各种方式向数十亿用户推广来完成的。在这轮竞赛中，一款足够好的浏览器（Chrome）胜出，不像之前的 IE（IE6）。

赢家不言而喻，除非市场以激烈方式变革，否则平衡很难被打破。但在那天到来之前，享受 Chromium 吧。

**更新**：为了弥补上述故事令人沮丧的结局，我写了一篇后续文章，旨在让人们更加关心网络。看看[这里](https://ferdychristant.com/the-state-of-web-browsers-88224d55b4e6)。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
