> * 原文地址：[The State of Web Browsers 2019 edition](https://ferdychristant.com/the-state-of-web-browsers-88224d55b4e6)
> * 原文作者：[Ferdy Christant](https://ferdychristant.com/@ferdychristant)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-state-of-web-browsers-2019-edition.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-state-of-web-browsers-2019-edition.md)
> * 译者：[xionglong58](https://github.com/xionglong58)
> * 校对者：[letica](https://github.com/letica)、[HearFishle](https://github.com/HearFishle)

# 2019版 web 浏览器现状

![](https://cdn-images-1.medium.com/max/800/1*mkxbYIvO9oe1xsjjezUELA.png)

两天前，有感于微软放弃 Edgehtml 引擎，使用 Chromiun 取而代之的事件，我发表了一篇关于[浏览器兴衰](https://ferdychristant.com/the-state-of-web-browsers-f5a83a41c1cb)的文章。微软的此番作为被视为将 Chromium 与 Safari 的 webkit 结合建立搜索引擎的最后一步。而此时，唯一能对微软的垄断行为产生威胁的对手 —— Mozilla，发现自己已经没有盟友和动力来应对微软的这一举措了。

这篇文章获得了大量读者的反馈，大家普遍肯定了文章的真实性，但也对文章揭露的事实感到沮丧。

一些批判性的评论则认为文章的一些观点是真实可信的，但过于宽泛，缺乏细节。我肯定有些观点可以更加精辟，但这会使文章的篇幅增加一倍，并且增加的内容对我所要阐述的核心观点没有太大用处。比如说，该篇文章获得了数万读者的浏览，实际上仅仅有 25% 左右的读者真正通读了，可能是因为文章的长度，有些读者感到厌烦，在阅读中途就放弃了，既节省了时间又免得内心沮丧。

只有少数人批评我近似残酷的诚实，更多读者则偏向欣赏我的做法。这等同于领土问题。我所能说的是，尽管那天我的情绪很平和，但我并不会降低语气。我也不会用我的诚实获取价值和关注，我坚信在一个由科技主导的世界里不需要毫无意义的批评，更不需要高谈阔论的建议。另外，我是一个荷兰人，我们惯有的语调就是如此。

回到主题上，为什么要发布第二篇文章？我想要谈谈原文中令人沮丧的那部分内容。如果你有足够的时间读到最后，你会在末尾发现这将是一个缺少快乐的结局。你可能会认为 web 是一个失败的东西，开放的 web 处于极大的危险中，我们已经回到了中世纪的 IE 时代。如果你关心 web 的话，即使是最乐观的人也会在不破坏自己一天的情况下读完这篇文章。

我不能改变的事实是： Chromium/Webkit 的统治之路是混乱的，甚至是滥用的。这是一段不可抹去的、值得怀疑的历史。我们将把这个留给律师，但足够肯定的是，这些浏览器仍不会被卸载。咱们走着瞧。

在本文中，我们将接受 Chrome 主导 web 的新态势，并展望未来。看看 Chromium 的优势对用户、开发者和开放 web 意味着什么。剧透一下，我们将有很多理由对这个态势感到高兴、乐观，甚至兴奋，即使这个新态势是以一种不公平的方式出现的。

## Chromium 之于用户：Web

根据对全球市场份额的粗略估计，Chromium/Chrome 浏览器将占有至少 70% 的用户。还有 15% 的 Webkit，主要是移动端的 Safari 。

任何明智的开发人员都不会忽视移动端的 Safari，而 Webkit 在许多方面与 Chromium 相似(尽管有所不同)，因此，一个基本的出发点是 85% 的用户将完全按照预期体验浏览一个网站。这至少算是 Chromium 的一个优势。 

其次，大多数网站不会使用前沿功能或只适用 Chromium 的功能，因此 Chromium 的优势并不意味着相同的网站不能像 Firefox 那样工作。Firefox 在 web 标准方面与 Chromium 接近。即使略微落后，这并不意味着网站将在 Firefox 中大规模崩溃。如果有任何问题，Mozilla 肯定会尽快实现兼容性。

因此，我的粗略评估是，对于90%的用户来说，几乎所有的 web 都将按照创建者的意图正常工作。唯一的例外是 web 的前沿性或实验性部分。

很奇怪的是，假设在一个浏览器竞争环境中，3个搜索引擎占据相同的份额，上面所说就不成立了。这种假设下将会出现很多兼容性问题，具体应用时，web 在 chrome 的世界中运行得非常好，移动端的 Safari 和 Firefox 结合起来也足够大到可以占据主导地位。

另外 10% 的浏览器是像旧版 IE 一样的东西，虽然它的消亡速度很慢，但它最终会缩小，进一步提高我们的90%。

对于用户的好消息是，除了移动端的 Safari，其余浏览器都会经常自动更新。这促使几乎所有的 web 用户都将使用最新的浏览器来体验不断改进的 web。

## Chromium 之于开发者：生活可以变得更简单

“web 运行在 Chromium 这一个搜索引擎上”这句话的负面含义可能是:

* 开发人员构建的是基于 Chromium 的网站，而不是基于标准的网站，并且大部分开发者都将是如此。
* Chromium 充满了非标准的特性，并且破坏了开放式 web ，或者说是破坏了 web 标准

上述两个观点都过于夸张，我认为均不正确。

首先，当移动端如火如荼发展的时候，web 端的确经历了一段低谷期，在那期间，web 开发者们不得不一边等待 web 标准的发布，一边大量使用与厂商相关的前缀或 Chrome/Webkit-only 等特征去最大化他们能在移动设备这种全新 web 载体上实现的功能。到目前为止这种做法已经失控，浏览器必须实现其竞争对手的供应商前缀功能才能留在这个游戏中。

那段低谷期已经距离我们很久了。所有的浏览器厂商也都认为使用厂商前缀是一个坏的解决方法。新的特性隐藏在一个标志后面，这意味着开发人员无法在它们成熟之前部署给用户。那些我们无法直接撤销的现有的前缀问题，现在已经内置到每个浏览器中，以确保兼容性。

所以，这些开发人员使用非标准的 Chromium 特性对我来说似乎不是一个大问题。

那么那些仅仅基于 Chromium 的标准特征呢？在这里，会出现这样一种情况：Chromium 发布了一种新的基于标准的功能，但在其他搜索引擎中却不可用。

一个目光短浅的开发人员可以得出这样的结论：他们可以仅仅使用 Chromium 而不需要其它的备用引擎，因为世界上无论如何都有 Chromium 的存在。呵呵！这也是不正确的。落在后面的移动端 Safari 来拯救我们了。很有可能的是，移动端 Safari 不会有 Chromium 发布的新功能，而且在未来几年也不会有。

在移动端 Safari 中，你不能提供中断的 web 体验。移动端 Safari 在不同设备上拥有 15% 的市场份额。在移动设备上，这个比例是 25%。而一些主要市场，在手机用户的这一比例甚至可能高达 40%。

几乎在任何情况下，**备用技术都是必须的**，通过发展其它备用技术，你才很可能还会使用到其他浏览器:比如 Firefox。

至于 Chromium 及其与 web 标准的关系，我将在另一章中讨论。现在让我们首先考虑浏览器的新状态对开发人员意味着什么。

似乎也没有什么。第一个明显且正面的工作流改进是你不需要再测试 EdgeHTML 的兼容性。

可你将不得不继续测试 Firefox ，但是在这里我也希望能得到改进。Mozilla 现在处于寻求生存模式，我希望他们会优先考虑与 Chromium 的兼容性，而不会进一步降低其自身的兼容性。

Safari 缺乏更大的工作流改进，这使得它落后于其他浏览器，迫使我们使用向下兼容、polyfills、transpilations等技术。

与其继续抨击移动端 Safari，我还不如换一个视角。让我们粗略估计一下，Safari 在支持主流新 web 标准上总体落后了大约1-2年。

现在，问你自己一个严肃的问题: 考虑到你的受众和产品，你是否可以使用1-2年前普遍可用的 web 标准开发出你希望用户享受的 web 体验吗?

如果这个问题的答案是肯定的，其实我相信通常情况下会得到肯定的答案，那么你可以大大简化你的工作流程。也许，你可以跟 polyfills, transpilation 和自动补齐前缀说再见。因为1-2年前的 web 真的不是开玩笑。

你确实需要最新的和最好的标准，例如 web 组件。在这里，你仍可以问自己一个问题，用户是否真的需要 Web 组件。老实说，需要 Web 组件的是开发者你自己，而不是你的用户。我不做评判，因为我也喜欢 web 技术。

我希望有一个更简单的开发工作流，我认为当前的工作流相当糟糕。异常复杂、缓慢、反复中断，当你让它工作的时候，它已经过时了。我希望回到只输入代码并运行它，而不是需要 10 万个节点模块处理我的输入。也许 web 开发可以再次为那些不是铁杆工程师的人提供方便和乐趣。因为 web 属于我们所有人，那些人和我们其他人一样有权利为之工作。即使作为一名经验丰富的开发人员，你学会了如何应对它，你也必须承认当前的状态是相当复杂和混乱的。

## Chromium 以及 web 标准

可以确定的是，我们正处在 Chromium 的垄断环境中，Chromium 的垄断引发了对 web 标准、Chromium 自身标准建立过程、两者对 web 未来发展方向的关注。在这一部分，我们将从实践层面讨论 Chromium 的垄断所带来的坏的一面，以及其有利的一面。 

我们假设 Google 不仅担任着标准实现的角色，还是标准的践行者。虽然这种假设不是百分百的可能，但很大程度上是可能发生的。接着让我们看看在背地里 Google 可以如何滥用这种优势，并分析这种滥用是否会发生。

### 动机

首先，我们应该消除一个主要担忧，甚至是最大的担忧。与微软和苹果不同的是，Google 是没有商业动机去以任何方式伤害或阻碍 web 或 web 技术发展的。因为 Google 是一家诞生在 web 上的公司，其致力于 web 和 web 技术的蓬勃发展。两者的停滞不前或故意引入不兼容性，逻辑上不成立，经济上也没有意义。在多数甚至是大多数情况下，Google 的 web 发展方向对用户、开发人员和他们自己都有好处。三者的利益是一致的。这种互利状态虽然不是很完美，也不是每时每刻都存在，但大多数时候都是这样。

因此，从一个非常基本的层面来讲，web 或 web 技术注定不会失败。两者的命运掌握在像我们一样致力于维护和改进它们的人手里。

细节决定成败，下面让我们来详细探讨几个存在的风险:

### Google 用 Chromium 仅仅是为了提高 web 质量

由于 Chromium 的主导地位，Google 在理论上完全可以绕过标准的建立，并在推行符合自己规划的新特征时肆无忌惮。毕竟，如果新的特征在 Chromium 中实现了，那它基本上已经成为了一个标准，对不对?

他们偶尔可以这样做，但是从长远来看是行不通的。非常糟糕的特征永远不会在 webkit 和 Firefox 身上出现，这是因为 Google 鉴于其 web 属性非常广泛，他们也不希望 web 对数以亿计的用户不兼容。

此外，如果推行的特征真的很过分，公然违背了大众的利益，那么其他利益相关者就会予以抵制，从而导致糟糕的公关。

最后，如前所述，“符合他们的规划”通常与用户和开发人员的规划一致。总之，我不太担心这个。

### Google 决定实现的优先顺序

在该场景下，Google 会以一种将他们的利益放在首位的方式影响 web 标准实施的逻辑顺序。

比如，想象一下，我们正在等待 subgrids 的应用，这是对大家都有益处的一个特征。与此同时，Google 则优先实现机器学习云工具下的语音合成器，该语音合成器是其代号为 “Hola” 的新型聊天客户端 #735 中的一个必要 API, Hola 客户端在 2019 I/O 大会上发布，仅仅 6 周后就废止，因为其仅仅获得了 3 亿用户。

诚然，这种情况有可能发生，我认为确实发生了。密切关注 Chrome 的版本说明很长一段时间(我意识到了 Chromium 的变化，但这种变化却不是很大),我自己偶尔也会惊讶于一些我从未听说过或无法想象会有广泛需求的 api 更新出来,同时一些具有广泛用例的补充特征还没有发布。

其实也没有那么糟糕，这并不意味着一些更重要的特征没有得到发布，况且现在 web 发展得如此之快。此外，不发布那些重要特征并不是一件坏事情。特征可以变得更复杂，或者会有更多的依赖项。由于许多人同时完成发布工作，所以不能保证首先交付的就是最重要的特性。

因此，虽然 Google 可能会偶尔优先考虑利己的特征，但在实践过程中，我并没有看到 Google 顶风作案。请再次记住，全世界都在关注 Google。

### Google 说：“不”

优先考虑利己特性的反面是降低其他厂商特征的优先级或完全阻止其想法实施。我们认定有些想法或提议是真正有益的，并且得到了很多其他利益相关者的一致肯定。但不知道是什么原因 Google 就是不接受它们，并且阻碍其实现。

这是一个棘手的问题，我们所能做的就是关注 Google 的历史记录和动机。 我承认我不会密切关注 Chromium ，因为我还有我的生活。 可能有大量这样的例子在发生，如果有的话请大家分享出来让我知道。

我一个印象深刻的例子是发生在 CSS 领域。Adobe 提交的一个很重要的规范和大量代码被 Google 拒绝了。尽管关于此事件有很多讨论，我仍无法回答是出于什么原因 Adobe 的提交就这样被否定。与其深究，还不如享受生活、坐山观虎斗。

最近的一个例子是 Google 放弃使用 HTML Imports，其它浏览器厂商虽然照做，但表现得极不情愿，所以我也不肯定 Google 的这一举措是不是错误。 封锁 HTML Imports 实际上是技术的原因，而不是 Google 的原因。

我认为 Google 不太可能拒绝那些帮助 web 向前发展的方法，因为他们也有兴趣帮助 web 向前发展。只要这些想法不会威胁到他们的业务。

web 标准具有威胁性的一点是：几乎所有 web 事务均与隐私有关。 如果全世界都同意在 web 标准技术层面上无法进行第三方跟踪，那么可以确定有些公司会从个人数据中谋利。 然而，全世界也在时刻关注着这一问题，如果 Google 过于在暗地里保护他们的业务，就会为竞争对手留下难得的机会。Firefox 的卷土重来，Apple Safari 的隐私保护力量足以瓜分 Chromium。 隐私对于 Google 确是值得权衡的。

所以底线是: Google 通常没有对好主意说不的动机或历史记录，而且在他们说不的情况下，对自身的损害既不是灾难性的，也不会太过火。

### Chromium之外的 Google

在上面的章节中，我已经说明了我如何相信 Google 在全球 web 发展道路上并不像听起来的那样对 web 有害。很多人这样认为仅仅因为他们有能力那样做，但这也不意味着 Google 会滥用他们的主导地位。我不认为它会经常被滥用或当作主要竞争手段，当然要除去一些偶然的案例。没有历史记录，也没有动机证明 Google 的滥用行为。我们可以进一步加强这一结论，因为我们知道，尽管处于主导地位，但仍然存在着制衡。例如，微软和其他有前途的公司也在向搜索引擎贡献力量。

实际上，在实践层面上，我对 web 、web 技术和 web 标准的未来没有直接的关注。如果我是在一个极其乐观的人，鉴于 Google 在改善 web 方面的历史记录，我甚至可以为 web 感到兴奋。web 将继续快速改进，这些改进将立即部署到绝大多数 web 用户身上。很难将 Google 视为对 web产生负面影响的公司。更重要的是，如果你和我一样老，我们所经历的 web 时代一直一帆风顺。

这就像你看的电影一样，主角们似乎高兴了大约10分钟。但你知道将会有不好的事情会发生。

我不能忽略这样一个想法:如果对 web 及其用户产生的威胁不是在 Chromium 中，而是在 Chromium 以外的其它部分。Google 最可疑的举动就发生在 Chromium 之外，下面我将讨论几个例子:

到目前为止，我能想到的最突出的例子是 AMP。我认为这是对开放 web 原则的暴力攻击。如果你想知道原因，我另有有一篇[文章](https://ferdychristant.com/amp-the-missing-controversy-3b424031047)有分析。尽管有来自 web 社区的批评，Google
并没有改变它的路线，相反，他们正在加倍部署 AMP。

另一个最近的争议是 Chrome，它包装在 Chromium 之外 。Google 让你无论何时登录到 Google 服务，都会秘密地将你登录到浏览器本身。它积极地隐瞒这个变化(不像普通的发布说明)，这是非常可疑的，这证明他们知道这是一个糟糕的做法。一旦暴露出来，就会突然出现“reasons”和“listening to feedback”。

第三个例子是 Google 缺乏同理心的强势弃用政策。我在这方面有自己的亲身体验。出于我的爱好 (野生动物摄影)，我花了很多时间在与描述动物物种有关的网站上:。这些网站通常是由程序小白、业余爱好者、非专业 web 开发人员创建的。此外，其中一些网站多年来 (在代码方面) 都没有被修改。让我们把这些网站称为“old web”。

世界上有多少 old web 呢?我也不知道，但是我敢打赌世界上大部分的网页都没有进行有效的维护。问题是，很多这样的网站其部分或是整体正处于崩溃状态。他们正在一点点地分崩离析。由于 Google 的弃用政策，比如应用 HTTPS 而弃用 HTTP，其中通过打破第三方服务的 API 更改（例如Maps）更是如此。 或者，由于 old web 不符合新的期望，因此它们被大规模降级，消失殆尽。

然而，这些网站仍然有价值。科技公司应该感谢这些网站的所有者，因为他们的网站曾经运作良好，并坚持运行多年。这是 web 承诺的一部分:向后兼容。这些网站的所有者应该承认他们的不幸，也应该认识到世道的残酷和无情。一个错误的认知是，在每个网站的背后，都有一些开发团队在网站的整个生命周期中提供维护。

即使你认为这是他们的问题，想想这个类比。假设你有一位不懂电脑的母亲(我母亲就是)。她很难掌握基本的计算技术，需要不断的帮助。你现在可以沾沾自喜地告诉她，要“与时俱进”，重新学习一下她的计算技能。从技术上讲，你可能是对的，但我确实希望她给你一脚。即使是对的，问题也不会得到解决，因此同理心就是答案。这就是我对“old web”的看法:必须以同理心来对待它的存在。Google 在这方面的做的很差。

我在这里已经有点跑题了，违背了要让这篇文章变得乐观的承诺。我可以举出更多的例子来，在这里我主要观点是，Goodle 在对 web 及用户的大多数可疑举动都不是在 Chromium 中发生的，而是在 Chromium 之外发生的。

我没有解决方案，也只是提出了一个观点。

## 权力的弊端

转向更积极的方面。对我们来说算是积极的，而不是 Google，当然也不包括 Google 的员工。但我保证这不是针对个人的。不过这可能会把你吓个半死。我想谈谈权力的弊端，其中有很多。

每当我看到一家大公司的 CEO 时，我的直接感觉是怜悯，而不是钦佩。他们处在食物链的顶端，所有的目光都集中在身上。他们也没有人可以依靠。对他们的期望一如既往的高。任何人犯错造成的灾难性后果都将与他们联系在一起。权力带来的好处不完美，名气也有缺点。如果你没有时间享受，金钱也将一文不值。甚至存在个人安全风险和法律风险。你甚至不知道你身边的朋友是敌是友。

我不想和一个 CEO、世界领袖、任何其他处于食物链顶端的人进行交易。我宁愿做一个默默无闻的人。

几年前我在一部自然纪录片中看到了一个很好的例子。它在记录的是一群猴子。猴群是由支配着大约20只雌性配偶的一只雄性猴王管理的。纪录片追踪记录猴王的日常生活多年，追踪的活动甚至包括让母猴高兴以及与挑战者战斗。

直到有一天，猴王老得不能维持其统治，一只年轻的公猴结束了他的统治。猴王瞬间从拥有绝对的权力到一无所有。你知道接下来发生了什么吗?老猴王非但没有因为失败而沮丧，反而在庆祝，显然是因为松了一口气。因为统治是需要承受压力、令人疲倦、残酷无情，所以统治根本不像你想象的那么美好。我相信我甚至看到了老猴王在嘲笑年轻的统治者:哦，孩子，总有一天你会后悔的。哈哈，那只是我瞎编的。

我举上面的一个例子的重点是什么？Google 就像是红屁股猴子。在这个巨大的食物链的顶端就要承担我们刚才讨论的所有缺点。那不是一个舒适的位置，而是一个压力、危险、高风险和波动性共存的位置。滥用权力会导致被竞争取代、用户的大规模抗议、数十亿的损失、法律的巨额索赔等等。一项技术创新就能毁掉你所有的业务。没有一种力量是永远存在的，新旧交替是不可避免的。

实际上是 Google 自己应该产生担忧，而不该是我们去担忧 Google 的统治地位。因为一旦你到达最高点，你就不能再继续往上了，但是几乎所有人都希望你走下坡。旁人只是在等待，而你却要面对成为赢家的所有缺点。

如果我更聪明，更有资格成为一名浏览器工程师，我绝对不会去开发 chrome，因为它是“赢家”。如果我在 Firefox 工作，我会完全放松、乐观、大笑，因为 Firefox 是一个“失败者”。这就是在全世界注视下失去一切，和在没有人关注的情况下一无所有却赢得一切的区别。这也是设法让一艘满载集装箱的船只稳定航行，和驾驶新型、酷炫快艇自由驰骋的区别。

这对我们有什么好处? Google 给人的印象是一家理性而明智的公司，我希望他们能意识到自己的地位有多么脆弱。如果那样的话，将会强有力地防止出现对 web 过于敌对的行为。他们根本也经不起失败。前一家尝试过的公司 —— 微软(Microsoft) 已遭到重创。太傲慢会犯错，做错事会被追责，只是时间早晚的问题。没有永远的权力，这是对我们来说也是一件好事。

所以，我们不要为这种统治而惊慌失措，坐下来，放松一下，吃点爆米花。压力不在我们身上。从长远来看 web 不可能被杀死或卸载，它也不属于任何人，充其量只是暂时的幻觉而已。

## 竞争对手虽倒下，但还活着

这一轮浏览器战争的最大受害者是 Firefox。正如前一篇文章所讨论的，他们陷入了深深的麻烦之中。手机市场占有率几乎为零，台式机市场份额不断下降，如果不采取干预措施，将处于危险的境地。

从这场灾难中可以提炼出什么有希望的信息？我可以想到一些：

* Firefox 桌面浏览器份额的损失一部分是由于 Chrome 被大力推荐（加上 Chrome 本身还是一款很棒的浏览器），另一部分损失可能是由于 Mozilla 在Firefox OS 时代忽视了桌面浏览器。另一个原因可能是 Firefox 对 UI 和 web 扩展进行了一系列让人厌烦的更改。这里的重点是有大量的观用户可以重新争取过来，并且不会永远失去。我在这儿说的几个百分点不仅意味着数以千万计的用户，还意味着对 Google 统治地位的撼动。
* 也许 WebRenderer 浏览器真的像我梦想的那样独特和出色。也许一些玩家会开发一款游戏或其他杀手级的应用程序，让它大放异彩，而 Chromium 却永远无法运行它。如果不是浏览器中只有人们喜欢或正确的应用程序存在的话，那么也许一个技术上更先进的浏览器确实很重要。
* 我们生活在一个注重隐私的时代。无限制采集数据的时代基本结束或已经过去了。虽然公众似乎还不太在意浏览器所使用的技术，但这并不意味着这种漠不关心的状态会永远持续下去。暴风雨一触即发，比如蝴蝶引发飓风。受益者将是 Firefox 和移动端的 Safari。
* 也许一些主要 Android 制造商已经厌倦了 Google 的粗鲁行为，并说:我要把 Firefox 放到主屏幕上。这种情况可能发生随时发生，因为 Google 和 Android 制造商之间的关系是双重的:既有盟友，也有竞争对手。移动端 Firefox 的占有率不会跌太多，但却可以涨很多。

我所假设的这些场景，极可能发生的事情极不可能发生，但对于**任何**不可能发生的事件，却都极有可能发生。不太可能的事情总是发生的，我们不确定是什么时候发生的，但确定他们一定会发生。

年轻的猴子们严阵以待，他们很有耐心。他们的时机将会到来。

## 总结

我在想，我毕竟不擅长写积极向上的文章，但我会试着总结一下为什么我认为 Chromium 作为驱动 web 的主导引擎并不像我之前的文章所分析的那样糟糕或令人沮丧:

* 对用户来说，web 仍旧照常运行。几乎所有用户都会以他们想要的方式来浏览网页。通过不断更新搜索引擎来体验快速改进的 web，而不是使用被绑定到某些操作系统(iOS用户除外，他们的速度较慢)的搜索引擎。
* 对于开发人员来说，少一个引擎意味着更简捷的工作流。主导引擎 Chromium 即使不是最好的引擎，也算得上是一个非常棒的引擎。因为 Chromium 是几乎所有 web 用户都在使用的一个很棒的搜索引擎，通过巧妙地定位 web 特性，你甚至可以极大地简化你的工作流。
* 至于 web 标准，Chromium 的不兼容性或供应商前缀在很大程度上已经成为过去，人们强烈反对引入新的不兼容性(原因在于移动段端 Safari)。此外，Google 没有破坏 web 标准发展的记录和动机，反之亦然。开放 web 和 web 标准并没有消亡，它们甚至可以蓬勃发展。Chromium 的发展速度很快，而且它是部署到几乎所有用户的首选引擎，两者作为一个整体，这也意味着 web 的快速发展。
* Google 可能会偶尔把自己的利益置于总体利益之上，但 Google 不太可能在 Chromium 上做手脚。如前所述，那更可能发生在 Chromium 以外他们所控制的地方。
* 权力是暂时的，在科技行业更是如此。竞争已然平息，但从未停止，这不仅为我们的霸主提供了一个强有力的激励，还为那些关心 web、以强有力的方式发声的人们提供了强大的动力。

在2019年，没有理由对 web 的现状感到沮丧，即使它不是一个理想的状态。

web 技术比以往任何时候都更有能力，并且将继续快速发展，没有任何放缓的迹象。web 技术将比以前更兼容，用户将体验到一个兼容的 web，无论他们使用哪种浏览器。

不断改进的 web 将不可避免地带来一个可持续的 web 应用程序平台，这个平台一旦足够强大，web app 就会抢占 native app 的领土。这是一条不可避免的前进之路，可以放慢脚步，但不能停下来。web 在计算领域的作用非但不会减少，反而会以专有解决方案为代价再次增长。

web 将会继续依照公开发布的 web 标准发展。最新的、基于标准的 Web 技术及时部署到每个用户，最终不仅可能使 web 开发变得更加简单，还会引入新的创建者。

这就完美了吗？不！还有很多值得兴奋的东西。与多个功能差异较大的不兼容引擎相比，单引擎文化可能让我们在 web 中具有更大的优势。

基于此，我祝你节日快乐。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
