> * 原文地址：[The role of mobile technology in improving financial health](https://medium.com/googleplaydev/the-role-of-mobile-technology-in-improving-financial-health-f42b509f0433)
> * 原文作者：[Ash Hassan](https://medium.com/@ashrafh?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-role-of-mobile-technology-in-improving-financial-health.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-role-of-mobile-technology-in-improving-financial-health.md)
> * 译者：[DateBro](https://github.com/DateBro)
> * 校对者：[LeviDing](https://github.com/leviding)

# 移动技术在改善财务健康方面的作用

## 下面是对财务健康以及金融科技企业家改变市场机会的介绍

![](https://cdn-images-1.medium.com/max/800/1*-WmNCV2QgyjVBW42yD1l8Q.png)

管理财务可能非常具有挑战性。[57% 的美国人](https://cfsinnovation.org/research/consumer-financial-health-study/) 正在努力管理他们作为整体财务健康关键因素的日常财务和/或准备应对金融冲击。仔细看一下这个，一个惊人的数字，[75% 的学生](https://s3.amazonaws.com/cfsi-innovation-files/wp-content/uploads/2017/12/18203926/CommCollegeJourney-FINAL.pdf) 面临各种财务健康挑战，这些挑战会影响他们在规划教育，学生生活和学生生活方面取得成功的能力。

作为今年 [#财务健康关键日](https://cfsinnovation.org/news/finhealth-matters-day-2/) 的一部分，Google Play 在 Google Play 商店（美国可用）推出了一系列称为 **‘**[**改善你的财务健康**](https://play.google.com/store/apps/collection/promotion_3003206_financial_health_apps_us?e=-EnableAppDetailsPageRedesign)**’** 的金融科技应用。这些金融科技应用可以帮助那些正在努力改善财务状况的人，包括学生——2018 年财务健康关键日的焦点。

那么为什么改善财务健康很重要呢？高水平的财务健康意味着，社会中的所有人，不论其收入、种族、性别或国籍，都能够参与到金融系统，并以一种改善其福祉的方式参与进来。调查结果表明在金融机会与经济增长和就业之间存在 [正相关](http://www.cgap.org/sites/default/files/FocusNote-Financial-Inclusion-and-Development-April-2014.pdf)  的关系。一个为货币和财富管理(包括访问银行、信贷和金融工具)提供多种有效手段的市场，可以为整个社会带来更广泛的利益。

### **移动技术的作用**

多亏了行业的进步，移动技术可以帮助缩小那些受到的经济服务不足的人与能够获得高质量金融解决方案的人之间的差距。根据 [最近的尼尔森调查](http://www.nielsen.com/us/en/insights/news/2016/millennials-are-top-smartphone-users.html)，Android操作系统是用户最多的操作系统，51％的美国智能手机运行在该系统上。因此，Android正处于一个有利的位置，可以帮助缩小这个差距，并为历史上获得服务不足的人群提供优质的财务解决方案。

改善获得服务欠缺者的财务状况的挑战已经引起了金融科技企业家的共鸣。Jimmy Chen，[Propel](https://www.joinpropel.com/)的创始人和CEO，创建了 [Fresh EBT](https://play.google.com/store/apps/details?id=com.propel.ebenefits&hl=en_GB&e=-EnableAppDetailsPageRedesign)，一个金融科技移动服务应用程序，旨在帮助数百万食品券收件人管理他们的收益，省钱，找工作，并评论道：

_“ Android 被用于社会经济范围的每个部分，使其成为达到目标人群的理想平台，Google Play 工具帮助我们优化了信息并为用户创造了高质量的体验。通过 Android 和 Play，我们能够覆盖并帮助财务状况不足的社区重新站起来。”_

作为一名企业家，你不仅有能力创建一个成功的商业应用，还可以对你生活的世界产生积极的影响。

### **使开发人员有兴趣开发和开发一个财务健康应用的 6 个原则**

在四月 25 号，[#财务健康关键](https://cfsinnovation.org/news/finhealth-matters-day-2/) 日，我们希望通过关注学生的财务健康来提高对 `美国人` 财务状况的认识。学生是我们国家的未来，而且，[根据CFSI最近的一项研究](https://s3.amazonaws.com/cfsi-innovation-files/wp-content/uploads/2017/12/18203926/CommCollegeJourney-FINAL.pdf)，63% 的社区大学学生靠工资生活，75% 的学生甚至没有 1000 美元的应急基金。去年早些时候，我们与消费者财务健康权威、创始人CFSI合作，制定了6条原则，帮助您构建最佳的类别金融解决方案。[财务管理方案实验室](http://finlab.cfsinnovation.com/) 创始人CFSI合作, 制定了6条原则，帮助您构建最佳的不同类别金融解决方案。如果您是有兴趣处理财务健康的开发人员或企业家，并希望有所作为，请查看以下6条原则：

#### **1) 理解你的受众**

了解你的受众是谁，以及你的产品可以给他们的日常生活中带来什么不同。他们的经济需求是什么？你的产品又是如何改善他们的财务健康状况的？你的产品如何适应他们的财务生活？首先回顾一下 [美国金融日记](http://www.usfinancialdiaries.org/) 和 [消费者财务健康研究](https://cfsinnovation.org/research/consumer-financial-health-research/) 来了解这些消费者正在经历的事情。

#### **2) Focus on access**

记住，那些获得的服务不到位的消费者往往从事多份工作，可能没有多少时间来管理日常财务。思考一下如何将产品的用途无缝地融入到他们的日常生活中。认识到这些消费者可能会不成比例地使用低端手机，因此可能会面临设备性能和存储能力有限的问题。他们也可能只有有限的流量，因此请注意整体流量消耗。最后，请记住，许多获得的服务不足的人可能不是母语为英语的人; 因此，app 和 Play 商店列表内容应翻译为战略性二级语言。Google Play为Android开发人员整合了大量资源，以应对这些挑战，这也是 “[为全球人建设计划](https://developer.android.com/topic/billions/index.html)” 的一部分。

#### **3) 建立并维护信托**

信托在金融领域非常重要。你围绕产品/服务和公司建立的信任和社区越多，其发展的速度就越快。从财务角度来看，请确保您正在开发具有明确和一致价值的互利解决方案。对于如何赚钱，对合作组织参与以及消费者可以提出问题的方面保持透明。从技术角度来看，请确保你的应用程序能利用 Android 平台提供的安全创新来保护用户的财务信息。要考虑的工具包括用于生物认证的 [Fingerprint API](https://developer.android.com/about/versions/marshmallow/android-6.0.html)，用于检查设备完整性的 [SafetyNet API](https://developer.android.com/training/safetynet/index.html)，和用于检查用户身份的 [ID Tokens](https://developers.google.com/identity/smartlock-passwords/android/idtoken-auth) 。如果在需要你的应用中请求敏感权限，请务必解释对这些权限的需求并仅在需要时请求它们 (具体信息请参阅 [ Android 权限最佳实践](https://developer.android.com/training/permissions/usage-notes.html) ). 维护用户信任与建立用户信任同样重要。许多用户将应用商店视为建立和维护与开发人员对话的论坛，通过评级和评论来表达反馈和问题。务必 [关注用户反馈并回应](https://support.google.com/googleplay/android-developer/answer/138230?hl=en) 以维持对话并与您的用户建立社区。

#### **4) 测试和迭代**

在向公众发布任何产品之前，请确保已全面测试过。从财务角度来看，请务必衡量产品对用户的实际影响。从技术角度来看，一定要利用 [Google Play alpha and beta channels](https://developer.android.com/distribute/best-practices/launch/beta-tests.html) 在公开发布之前分发应用。通过这些渠道，你可以放心地进行测试，并使用户能够在不影响应用公开评级或评论的情况下提供反馈。Google Play 开发者控制台还提供 [listing experiments](https://support.google.com/googleplay/android-developer/answer/6227309?hl=en&ref_topic=7046704) 以便在 Play 商品列表的多个组件上运行变体测试，而且有利于在你的应用发布后优化安装转换。这两种工具都可以让您快速迭代，确保优化的产品性能和意识。

#### **​5) 推动积极的用户行为**

通过智能设计和沟通推动积极的消费者行为。提供（并鼓励）向上流动的选择。Android 平台提供了许多工具来引导用户采取积极行动。`有意义的动作` 是 Android [Material Design](https://material.io/guidelines/#introduction-principles) 语言的核心原则之一，它使开发人员能够将注意力集中在您希望他们采取行动的功能和决策上。同样，Android 提供了丰富的 [notifications](https://developer.android.com/guide/topics/ui/notifiers/notifications.html) ，可以利用这些来鼓励用户在适当的时间重新参与或采取财务行动。

#### **6) 认识到共赢的价值**

请记住，最好的商业模式是双赢的：如果用户的财务状况有所改善，你的公司也会受益。在财务方面，[CFSI 的研究](https://cfsinnovation.org/research/eight-ways-to-measure-financial-health/) 已经发现了八个潜在的财务健康指标，以帮助把重点转移到改善消费者的生活方面。在技术方面，Google 开发了 [Firebase Analytics](https://firebase.google.com/docs/analytics/)，这是一款免费且无限制的应用分析解决方案，可以帮助你清楚地了解应用的使用情况和用户参与度。

* * *

### **你怎么看？**

这些基本原则可以帮助你提高金融科技应用业务的成功，并吸引消费者使用你的应用作为改善其财务状况的工具。你也可以浏览这些金融科技公司为财务健康创新的 [故事](http://finlab.cfsinnovation.com/wp-content/uploads/2016/10/FinLab-Brief-Profiles-in-Innovation_Final.pdf) 并 [看看什么容易](https://www.youtube.com/watch?v=1_PYAYgymGo) 被金融系统服务不周。如果你是金融科技应用程序的开发人员，或者有兴趣推出可以改善财务状况的，我们很乐意听取您的意见——[**兴趣注册**](https://docs.google.com/forms/d/1Vx8IVmahp4O_ndRrCHco-foZbufqk6-t-EXCnJcrhRc/edit?ts=5addc2c7)。

如果您对金融科技和/或财务状况有所了解，请在下面的评论中告诉我们，或者使用 **#AskPlayDev** 发送推文，我们会从 [@GooglePlayDev](http://twitter.com/googleplaydev) 回复，我们会定期分享关于如何在 Google Play 上取得成功的新闻和提示。您还可以通过分享您的财务状况，最佳实践或解决方案加入 #FinHealthMatters Day，[了解有关如何入门的更多信息](https://cfsinnovation.org/news/finhealth-matters-day-2/?utm_campaign=Public&utm_medium=email&_hsenc=p2ANqtz-_JYDMJaNFo7c56_ykZ0S9XoPU1jI_xfCYA-urQAr02xf90gMmJA0HxbPV1d1a53GXUIOUXhsnSZE621Nyjv_qO1DDP6Q&_hsmi=61995743&utm_content=61995743&utm_source=hs_email&hsCtaTracking=2d24a17e-073c-4de2-af74-2e55887f880f%7C53ddabcc-a46f-4f45-a410-61f272b3f5c2)。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。

