> * 原文地址：[The Open Source Conundrum: How Do We Keep the Lights On?](https://codefund.io/blog/the-open-source-conundrum-how-do-we-keep-the-lights-on)
> * 原文作者：[Eric Berry](https://codefund.io/author/eric-berry)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-open-source-conundrum-how-do-we-keep-the-lights-on.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-open-source-conundrum-how-do-we-keep-the-lights-on.md)
> * 译者：[lihanxiang](https://github.com/lihanxiang)
> * 校对者：[yangxy81118](https://github.com/yangxy81118)、[swants](https://github.com/swants)

# 开源难题：如何保持长久？

## 若要保持开源行为在未来发展的可持续性，获得开源资金的想法需要发生转变。

开源软件 (OSS) 在当今复杂的发展生态中有着不计其数的标准。在此文中，它的定义是：源代码发布，以及所有与之相关的修改都必须按照与原始软件所持有的开源许可证一致，并且支持免版税发布的程序。在此基础之上，我们来探讨一下 OSS 所面临的挑战。

自从互联网出现以来，OSS 已为科技界贡献了巨大的价值。通过在广泛的社区中共享源代码，应用程序可以在[软件开发周期]中(https://stackify.com/what-is-sdlc/)更快、更低成本地迭代。分享出来的源代码还可作为无数其他项目的启动平台，从而节省了从头开始的时间和费用。

但，OSS 的盈利是呈指数级[低于专有软件开发](https://www.forbes.com/sites/forbestechcouncil/2018/02/22/why-pay-for-something-when-its-free/#6335810a3169)的。鉴于 [96% 的应用程序都具有开源组件](https://www.synopsys.com/content/dam/synopsys/sig-assets/reports/2018-ossra.pdf)，这就具有些许讽刺意味了。此外，这些应用程序的代码库中平均含有 57% 的开源代码。这些数字表明，在这个生态中存在严重的脱节。虽然最终用户获得了巨大的价值，但那些贡献者们却没有得到对应的报酬。

**但是，OSS 到底具有哪些价值**？基于 6 年前 Black Duck 的计算值，当今全球开源软件的综合价值可能超过 387 亿美元。

![undefined](https://cdn.buttercms.com/ZnftGc3OS4qxkF9Aa9My)

来源：[2018 年开源安全与风险分析](https://www.synopsys.com/content/dam/synopsys/sig-assets/reports/2018-ossra.pdf)

#### 开源软件背后的动机

你可能会纳闷：为什么有开发者在专有软件开发更有利可图的时候，选择参与 OSS 的工作。那么，**究竟是什么促使着开发者一直在为开源项目工作**？与由对后果的恐惧以及对奖励的渴望所驱动的外在动机不同的是，[OSS 的向前推动是由开发者的内在因素促成的](https://www.zdnet.com/article/its-an-open-source-world-78-percent-of-companies-run-open-source-software/)。

开源工作者将推进项目作为一项自我投资的爱好，他们乐在其中并且享受从中学到的知识，抑或是他们想为世界作出自己的贡献。这种利他主义推动者人们将利益抛诸脑后，与以盈利为主的专有化应用开发形成鲜明对比。

#### 开源生态中的角色

对于那些在开源中不断贡献的利他主义开发者，通常会被定义为是参与者。

##### 贡献者

作为程序或应用开发的贡献者，他们的主要贡献可能包括漏洞修复，功能开发，文档撰写以及语法纠正。

##### 维护者

这一类别的人员主是推进项目版本，以及管理程序组件的参与者。他们的主要任务是进行漏洞分类，检查 pull requests (PR) 以及指导整个项目。这是一份通常是不被大型社区所认可的，但又需要持续投入的工作。

大多数人都没有意识到的是，在所有的 OSS 仓库中，有 65% 的[卡车因子为 2](https://medium.com/@aserg.ufmg/what-is-the-truck-factor-of-github-projects-bb0d5f019a6f)。卡车因子反映了在一个项目中变为不可持续的时候（被卡车撞上或赢了彩票等等），其开发者所离开的数量。这描绘出了开源生态以及其未来可行性的不稳定图景。Semantic UI 就是一个不再可持续的项目，他的唯一开发者如是说：

> **“我在花费了三年的业余时间，投入于 OSS 的工作。在不影响软件功能的前提下，我找不出任何的方法来完成。不幸的是，这就意味着我必须要推迟开发进度直到我得到合适的融资来完成它。”**

#### 用奖金鼓励开源

OSS 对于大型社区来说或许代表着免费，但是对于开发者和维护者来说，他们将以最少的资源来应对用户需求的冲击。去年，为了引起人们对这种趋势的重视，有 100 人聚集在旧金山，致力于改变我们对于开源软件可持续发展的看法。

在他们的最终报告中，这个群体重申了一小部分人员是如何在没有资金支持以及合同义务的情况下，支撑起了 OSS 的关键部分。其结果是，少数人的善意再也无法满足 OSS 生态日益发展的需求。**所以，该如何解决这一困境呢**？看上去容易，但是需要引入一个新的概念。 

**用奖金鼓励开源**

恰如 [Gitcoin](https://gitcoin.co/) 和 [CodeFund](https://codesponsor.io/) 正在做的一样。虽然策略不同，但最终目标是一致的 —— 探索如何更好地进行开源。

#### 鼓励开源软件

当涉及到 OSS 开发时，有几种机制还待探讨。虽然有些已尝试过，但其它的或许是更优解。每种方式都有其优缺点，但是最终目的都是为了更好地促进开源。

![oss-conundrum-2.png](https://cdn.buttercms.com/E89ikPXhRTu5MktD3FHx)

#### 捐赠

捐赠是一种较为直接的方式，开发者能够向他人寻求资金帮助以用于项目开发。捐赠的方式包含了补助、赞助、捐赠按钮以及建立基金会。虽然捐赠的方式提供了一个较低的门槛，并且能够使得开发者专注于代码，但这种方式有着巨大的缺陷。

例如，如果没有持续的积极筹款，捐赠的数额就将会减少。另外，如果项目的受众不够广泛，开发者就无法吸引足够的注意力来获得资金赞助。 

![oss-conundrum-3.png](https://cdn.buttercms.com/tOHkRk9QnmUIwUpKNHNw)

支持 Support

开发者能够通过这种方式，来出售服务时间、教程和商品等。当选用这种方式自助项目时，开发者能够提供为最终用户提供相关书籍、付费培训、商品，甚至是咨询服务。这种方式可作为一种实际的营销工具，同时能够让开发者清楚的了解到最终用户在整个项目中的需求。       

但是，小型的 OSS 项目可能很难从这种资助方式中获益，因为它们没有足够大的用户基数。同时，付费培训的需求相对较少，这种以用户为中心的方法可能会占用编写代码的宝贵时间。

![oss-conundrum-4.png](https://cdn.buttercms.com/6Vwd374mQJGUzxRO1uGB)

许可证和使用权

项目所有方可以这种模式出售相关许可证、特性以及付费托管。在这种方式下，开发者可能寻求风险投资、著佐权、open core、SaaS 以及受限的许可机会。如果成功，这种模式有望具有可伸缩性以及提供全职收入。

虽然这是一个有希望的选择，但是小型的 OSS 项目碍于受限的用户群体和曝光程度，或许不会从中受益。 这种方式也可能十分耗时，并且需要很强的创业精神，这对一些开发者来说，是一个具有挑战性的选择。

![oss-conundrum-5.png](https://cdn.buttercms.com/9mMl8dvcRgGh8kapTWtg)

#### 开源资金的重叠

在同一个体系模式下，开源基金存在着明显的共性。这些是 CodeFund 和 Gitcoin 已经着手开发的领域。

![oss-conundrum-6.png](https://cdn.buttercms.com/UnAIRsBATRKuaMTwhmpZ)

众筹（Crowdfunding）

众筹包含一次性或持续的捐款。在使用这种融资模式时，附加的条件较少。通过几个专门为此目的而设计的平台，比如 Patreon、Liberapay、Open Collective 和 Flattr，管理起来也较为容易。

虽然很吸引人，但是持续的众筹是很难实现的，因为大多数人不想持续投入。众筹所获得的资金，也少于其他方式，通常不适用于用户群体和曝光度受限的小型 OSS 项目。

![oss-conundrum-7.png](https://cdn.buttercms.com/d9bDglWoTm67NXQhTHEB)

奖金（Bounties）

奖金能够为那些愿意为开源做出贡献的开发者提供了经济鼓励。奖金计划具有高度包容性，以此利用全球的人才库。同时，特定的项目指标直接与奖金挂钩。这种透明化的过程，能够为参与其中的开发者带来全职工作。Gitcoin 就是一个提供这些好处的奖赏平台之一。

虽然奖金数额较大，但也有一些需要注意的。奖金计划一般只提供给开发人员最低级别的奖励，并且通常是一次性的。Bug 奖金通常还要求获得者具有专门的安全技能来应对工作。

![oss-conundrum-8.png](https://cdn.buttercms.com/Bfrcc7j7SROcksfKis12)

广告（Advertising）

在所有的融资方式中，广告是最稳定、最持久的收入来源，但是在采用这种方式时，还有几个因素需要考虑。

最重要的是，要确保广告的合理性，以及广泛的受众群体。使用广告进行推广项目的开发者还需要考虑潜在的信任缺失以及参与营销的道德问题。如果所展示的广告和项目有所牵连，也有可能产生利益纠纷。

为了应对这些挑战，CodeFund 正致力于消除与开发者广告相关的道德困扰。CodeFund 旨在帮助开发者在一个值得信赖且声誉良好的环境中获得被动收入，建立一个道德广告平台。

![oss-conundrum-8.png](https://cdn.buttercms.com/Bfrcc7j7SROcksfKis12)

#### 改变开源的方式

开源软件在长期以来一直被视为是无数高端应用程序的发源地。然而，在专有软件持续收入达到数十亿美元之后，OSS 却因为资金不足而萎靡不振。如果要开源在未来保持良好的可持续性，这种情况需要发生改观 —— 这是重中之重。

接下来，这个由 OSS 维护者和贡献者所组成的小型社区需要变得健壮，并且获得足够的资金支持。如果我们不承认，那些支撑着开源社区的人肩负的重大责任，那我们都将承担后果。有前途的项目将会被取消，优秀的开发者将涌向专有软件开发，曾经产生巨大创新的生态将不复存在。

但我们现在还没有丢失一切，我们能做的就是尽一份力让这份善意持续。虽然开发者必须要为他们的项目拉取赞助，但我们需要改变对 OSS 的看法。尽管开源看上去是免费的，但这是精疲力竭的开发者耗费无数小时所得的产物。

[了解一下](https://codefund.io/publishers) CodeFund 是否能为你的博客、应用或网站提供资金帮助！

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
