> * 原文地址：[It’s Time for Digital Products to Start Empowering Us](https://medium.com/s/user-friendly/the-future-of-digital-product-design-is-about-human-empowerment-6a025bc330a)
> * 原文作者：[Jesse Weaver](https://medium.com/@hairyelefante)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-future-of-digital-product-design-is-about-human-empowerment.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-future-of-digital-product-design-is-about-human-empowerment.md)
> * 译者：[Mirosalva](https://github.com/Mirosalva)
> * 校对者：[xionglong58](https://github.com/xionglong58)，[hanxiansen](https://github.com/hanxiansen)  

# 数字产品为人们授权的时代已来

我们已习惯拿失去权力来换取功能实用，这实则是不公平的交易。

![](https://cdn-images-1.medium.com/max/1400/1*9Xk_5PDKic3BihIoliZm8g.jpeg)
Credit: grivina/iStock/Getty Images Plus

* * *

我们设计的数字世界，正在消耗我们的生命。我们正在使用的产品和服务就像粘人的朋友：饥渴又贪婪。然而我们又不能却步，我们处于相互依赖的关系当中。我们使用的产品似乎永远都欲求不满，并且我们一直都愿意给予更多的关注。它们需要我们的数据、文件、照片、邮件、朋友、汽车和房子，它们需要我们每时每刻的关注。

我们心甘情愿地把这些东西给予数字产品中，因为它们非常有用。产品设计者们非常善于提供功能实用。他们已经完美地设计出可以提高人们完成任务效率的流程。不幸的是，单单具备功能性是不够的这件事已经变得越来越明显。

很多时候，我们与这些所谓有用的产品的互动，实际上让我们感到非常沮丧。

我们希望能够被科技赋予权力，但是我们忘记了实用不等于授权。

赋权意味着变得更加自信，尤其是掌控我们自己的生活以及行使我们的权力。这不是目前的技术能够做到的。相反的，数字产品对我要求了太多，并且减少了我们如此多的日常存在感，以至于它们其实是在破坏我们的自信和掌控力。我们的数据和活动以没有补偿或透明公开的方式被挖掘和使用。我们的选择权被决定我们所看范围的算法减少了。我们甚至无法关闭自己的设备，因为我们已经失去了抵制它们的能力。

> 在互联网时代的早期，人与网络还存在一定程度的隔离。我们对电脑还没有那么依赖，接着智能手机随之而来。

我们忽略这些的原因是我们弄混淆了实用性和被赋权的感受。我们确信自己在掌控生活：当我们经常登录某个地方，收到朋友的最新消息，发现一篇很棒的文章，或者收到我们快递物件。这些仅仅是一些纯粹实用的微小瞬间，我们经常习惯于把它们与掌控自己的生活混为一谈。

我们已经待在这种状态上一段时期了。几十年来，很多公司在持续增长地获取渗入我们生活的权力。在接近度和数据可用性的共同驱动下，这种趋势在过去十年中已经达到高潮。

我们在网络上做得所有事情都是可追踪的。在互联网时代之前，这种数据粒度级别是不可思议的。在网络发展的早期，公司就开始利用对用户的洞察来定位广告并推动他们的业务。在较短的时间内，我们还有一定程度的隔离，因为当时我们并未太沉浸于桌面电脑，但是紧接着智能手机时代紧随其后而来。

智能手机创造了客户与公司之间曾经难以想象的接近程度。这种永远存在的联系极大地推动了我们花费更多在线时间。突然间，公司可以在任何时间任何地点触达我们，再加上持续增长的巨量数据，我们的生活和那些试图影响它们的公司之间那些隔离消失了。

这不是一种可持续的关系。它看起来好像未来的形式，但事实并非如此。

大多数公司当前的价值模式都是设计实用功效，认为用户会原谅他们以其名义可能会犯的任何错误。这种模式正在失效，因为它没有更大的图景：人们从他们所用技术中期望所得的东西。

仅靠实用工具不会让我们感到宽慰。我们需要被赋权，我们希望成为更好的人。我们希望技术可以增强我们的能力以及增加我们的代理意识，而不是控制我们生活的节奏。

* * *

这是下一代数据产品的使命，并且它需要我们考虑设计时切换到一种完全不同的方式。首先，我们需要愿意打破现有『实用』思维模式。和以往一样，当一家公司制定了一种制胜战略时，其他人都会效仿。现在我们已经建立了一套基于提取和利用的最佳实践，我们已经在各个行业以非常精细的方式应用它们。公司鼓励以用户为中心的设计，但他们创造的产品往往聚焦于从用户那里获取的价值，而非为用户提供价值服务。

作为数字产品设计者，这些是我们需要重新思考的内容：

1.  **在产品生命周期中用户角色是如何被看待的。** 如果产品价值取决于其用户的活动或资源，那么这些用户不是客户，而是业务合作伙伴。
2.  **数据的收集、处理和透明度** 我们需要将用户（而不是业务）作为数据的核心拥有者。
3.  **持续参与的动力** 故意操作人们的心理以吸引人们是一种掠夺性商业行为，对于我们应该如何操纵用户的行为，我们需要有道德标准。
4.  **收入模型** 依赖于用户参与水平的商业模式是无法持久的。
5.  **内容创作者如何得到补偿。** 平台本身不应该从它的用户所创造的作品中获利。
6.  **算法和人工智能** 对于我们控制用户看到什么内容需要一些道德标准。
7.  **我们的产品在用户生活中的作用。** 我们的产品不是人们生活的核心，它仅仅是生活的一小部分。

在这些领域中发展我们的思想将向前迈出一大步，但仅仅做到这一点并不是完整的解决办法。我们还需要打破对基于屏幕的解决方案的依赖。虽然屏幕不太可能完全消失，但它们已成为拐杖 - 阻力最小的路径。如果存在问题有待解决，产品设计师认为他们所要做的就是创建一个应用程序。我们对屏幕设计的痴迷推动了整个行业的 UX 新手训练营成为 app 的设计师。我们欺骗自己相信所有的问题都是『钉子』，而屏幕就是用来解决问题的『锤子』。我们已经在这一点上如此刻板，以至于大多数应用看起来都一样。

屏幕问题很简单。

它们引发了数字产品设计的上述许多问题。它们需要被专心地处理，这意味着我们的大脑必须充分参与和这些问题互动。从本质上讲，它们需要我们的注意力 - 这是鼓励收集大量数据的因素 - 并且适用于商业度量指标，如应用查看的分钟数，停留时间，页面浏览量和阅读时间。屏幕使我们确信，用户的持续参与是产品成功的定义。

> 我们从来不想被技术束缚，这不是我们为自己承诺的未来。

只要我们继续设计需要我们全部注意力的解决方案，就几乎不可能打破“无权产品”范式。很多时候，痴迷于屏幕使我们甚至无法已意识到：使用网络功能可以带来的许多其他创造性和强大的方式。

有人指出增强现实作为下一阶段产品。虽然AR可能看起来变革和疯狂，但它实际上只是处在不同位置的同一个屏幕。竞争的下一阶段是，看我们的通知究竟能够多么接近我们的眼球。它没有为我们赋权。

授权类产品可以增强我们的能力和代理意识，同时不会破坏我们的生活节奏。车就是一个很好的例子，它显著提升了我们的旅行能力，当我们认为合适的情况下，我们让代理使用它（在一些基本安全规则之外），它适用于我们，它听取了我们的意见，它不会扰乱我们的生活。当我们需要它时，汽车就在那里，而当我们不需要时，它就是隐形的。

这一定是我们新设计的口头禅：『当你需要时，它在；当你不需要时，它会消失』。它会比我们今天所认为的要好得多：『当你需要时，它在；当你不需要时，不断乞求你回来。』

* * *

身兼产品设计师和麻省理工学院媒体实验室主办人身份的大卫罗斯，在他的着作『Enchanted Objects』中提出了『glanceable technology』的概念：无需持续关注也会提供价值的产品。罗斯举得最基本的例子是一个支持网络的伞，当下雨时它的手柄会发出蓝光，以便你记得带上它。这是一种依靠简单网络智能变得神奇的常见的设备，它简单又有力。

思考一些[其他例子](https://www.media.mit.edu/projects/proverbial-wallets/overview/)：一个钱包在越接近预算限制时变得越难打开。与锁定屏幕上涌现地大量『高消费』通知以及像 Mint 这类服务提供的电子邮件等形成鲜明对比。一个根据当天预测温度而改变颜色的闹钟怎么样，这样你就知道如何打扮而无需打开应用程序？或者是一个监控交通模式并且通过振动提醒你的手表，让你知道何时需要出发以便准时赴约。一个带有把手的行李箱，如果您的航班延误，把手通过发光来通知你。

这些产品中的每一种都可以增强我们制定决策和管理生活的能力，而不会干扰或控制我们的行为。他们将利用网络的力量提供效用，同时在我们认为合适的情况下为我们提供代理服务。

屏幕之外还有很多可以挖掘的内容。上面描述的一些解决方案可能需要与应用程序相结合，但即便如此，它们也会让我们远离这种情况：屏幕作为我们使用技术的主要入口。这些方式会在我们和那个需要我们更多时间的粘人朋友之间放置一个缓冲空间。

这就是我们应该建设的未来。它不仅仅是关于『智能』的对象。如果我们继续目前的道路，我们最终会将 A.I. 应用到我们可以发现的各种随机方向上。智力本身正如效用一样，不能相当于授权，授权来自动态执行过程。如果我可以在商店里给我的冰箱发信息，在购买之前询问冰箱里是否还有牛奶，我就有更多次代理来协助管理我的生活。但是，如果那个『聪明』的冰箱也跟踪我的饮食习惯，并将它们汇集到亚马逊上，那么亚马逊可以向我的手机发送类似『双层奥利奥有特别新款上架』的垃圾邮件，那么我们就会回到前面所述我们开始的地方。

我们从未想过被技术束缚，这不是我们为自己承诺的未来。我们过去的故事没有描绘出这种未来：我们都将头埋在屏幕中，除非过去这些故事属于反乌托邦的类型。

我们一直希望技术看起来像魔法一样奇妙，而非像负担。

我们可以创造想要的未来。技术不是偶然发生在我们身上的事情；它是我们选择创造的东西。当我们设计下一波产品时，让我们选择授权。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
