> * 原文地址：[The economics of package management](https://github.com/ceejbot/economics-of-package-management/blob/master/essay.md)
> * 原文作者：[ceejbot](https://github.com/ceejbot)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-economics-of-package-management-2.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-economics-of-package-management-2.md)
> * 译者：[Baddyo](https://juejin.im/user/5b0f6d4b6fb9a009e405dda1)
> * 校对者：[LanceZhu](https://github.com/LanceZhu), [MarchYuanx](https://github.com/MarchYuanx)

# npm 的经济风云 —— 下半部分

> 如果你还没读过本系列的上半部分，请先阅读：
> 
> * [npm 的经济风云 —— 上半部分](https://github.com/xitu/gold-miner/blob/master/TODO1/the-economics-of-package-management-1.md)

而从 JavaScript 的层面来说，这门语言的规范就是属于我们开发者的公共资源的一部分。它由一个专门成立的组织所拥有，这个组织让所有的 JavaScript 利益相关者齐心协力来设计和构建这门语言。TC39 委员会在这方面功不可没。

所有的开源代码也都是我们的 JavaScript 公共资源的一部分。Babel 的源代码、webpack 的源代码、TypeScript 的源代码，以及 React、Angular —— 成千上万的开源包构成了属于我们的 JavaScript 公共资源。**维护着这些开源包的注册中心**同样也是 JavaScript 公共资源。有了注册中心，我们才能与彼此分享，才能便捷地找到需要的源码。JavaScript 公共资源还包括命名规范、更新方式等一系列开发约定。

但现在，**所有这些**，完完全全被一家由风投资金赞助的私人公司所掌握。

在去年的这个大会上，Node.js 的发明者 Ryan Dahl 再次登台演讲。他谈到了 Node.js 的[设计误区](https://tinyclouds.org/jsconf2018.pdf)。我在此引用他的一句话。

> 模块仓库的中心化（甚至由私人所控制）是一种不幸。—— Ryan Dahl

当我第一次听到这话，我很想就中心化的概念和 Dahl 辩论一番，但关于他说的私人控制的部分，我不得不信服。

那我们就说说私人控制。我们赖以共享 JavaScript 代码的平台被私人掌控。其含义是什么？

npm 的经营策略由一个公司来掌舵，JavaScript 社区对此没有话语权。那删除代码包是出于何种原因？代码包的命名纠纷又该如何解决？这是一个有争议的话题！你们是否还记得 left-pad 事件？

该事件是这样的：left-pad 是另一个依赖包用到的依赖包，当它突然被从 npm 中删除，每一个依赖于安装 Babel 的持续集成构建软件（CI build）都崩溃了。那为何 left-pad 会突然被删除呢？请我吃饭我就告诉你！但这种不公开的经营策略此前并不存在，它让我们的生活越来越好，也越来越糟。

想要包签名功能？那可有得盼了！这个功能又不能给公司创收，因此你们不太可能看到它上线。也许只有对安全事故的畏惧，或者公众强烈抗议才能促成这件事。

请注意，我在这里仅仅是在说**代码包注册中心**。注册中心是闭源的，其经营策略不受我们控制。npm 脚手架工具（cli）倒是开源的，但这不是重点。npm 的 API 暂时还是开源的，编写自己的脚手架所需的重要构建模块也都是开源的，不受 npm 公司的控制。不论如何，你们中有三分之一的人使用的是另外的客户端与 npm 交互。我们可以认为脚手架工具不牵涉其中，因为在这方面，npm 公司需要社区来出力。

API 之所以开源，是因为该公司允许其开源。我们根本无法控制其一分一毫。我们无法对 API 产生影响，更无法做对 JavaScript 生态有益处的改变。

我们碰不到对自己的资源的管理权。这种隔离状态会一直持续，直到该公司出于经济动机去改变它。你不知道他们会用你的代码包数据做什么 —— 你无从知晓。你只能选择信任这种不透明的管理机制。

但没有问责制就没有信任，而我们做为 Javascript 社区成员，是没有途径去向 npm 公司问责的。

当我还在 npm 团队中时，我可以告诉自己说，我信任我自己，信任我的团队，我知道我们的动机是为了社区好。而现在，这不是一个令人信服的答案，我一度对此的信赖是错误的。你们没有办法让我负责，也没有办法证明我是值得信赖的。

溜了溜了。

总之，npm 公司是一家私有性质的实体，是它控制着我们的公共资源，而不是我们开发者。这就一定代表它是十恶不赦的吗？不，也不尽然。但也同样不尽然使其积德行善。问它是否仁慈可算是问错对象了。

npm 公司可不是慈善机构。可能性**为零**。即使有那么一点可能性，也早就在接受风投资金而没有把它交给一个基金会或其他形式的社区所有权的那一刻消亡殆尽。那一决策把 npm 变成了**金融工具**。

我说这话，完完全全就是字面意思。

所谓金融工具，就是资本方之间的货币合同。它们是可以用来创造和交易的小工具。npm 公司 —— 掌控着 JavaScript 生态和你们每天都在使用的 npm 的角色 —— 在其所有者眼里不过是一堆能换钱的猪肚罢了。他们签一份份合同，做一笔笔生意。

npm 公司就是其拥有者用来钱生钱的手段。

当你使用 npm 时，当你和 npm 方面的人打交道时，你最好记住 npm 公司的性质。我的意思是**着眼于动机**。在这个故事里，多数人的动机归根结底都是金钱。

一切向钱看。

商业公司并不爱你，即使是那些做出了让你爱不释手的产品的公司。

“Build amazing things”，这只是一句广告词，用来让你误认为金融工具是你的朋友。多年来，这句广告词一直非常见效，不是吗？给你一个抱抱熊吉祥物，给你一些好看的贴纸，再加上一颗红心表情符号，你就上钩了，对吧？

npm 公司并不爱你。它不可能爱你。npm 公司只是特拉华州的一家公司，只是少数人的摇钱树罢了。

当我开始决定与其躲在角落和朋友窃窃私语，不如在大庭广众之下振臂高呼时，我就知道我要打一场艰苦的战役。npm 这家风投资金赞助的公司大受欢迎，我的犬马之劳也是原因之一。我参与了它的整个崛起过程 —— 我也贡献了力量。我也曾站在舞台上，面对你们大家，鹦鹉学舌地说出那句广告词。我也曾说“我，C J Silverio，爱你们所有人。”那是我的肺腑之言。

而现在，我不认为有人在你们面前大言不惭地说出 “npm 爱你们”还能够不被骂。过去几个月，npm 已经耗尽了所有的美誉。其实本不该如此 —— 都是公司运作者的决策导致的。他们做出了决策，而且押下双倍赌注，于是乎，我们走到了这般田地。

这一切是怎么发生的？为什么抱抱熊开始黑化？让我们接着讲故事吧，好吗？

我们从，呃，2018 年这个时间点拾起。你们大家一直从免费的 JavaScript 开源包中受益。但你们从没想过，或者在乎过这些开源包是从哪里来的，是谁在为这些服务买单。你们只需敲出 `install` 命令，你们要的代码包就自动上门了。

但带宽是要花钱的，总得有人来出这笔钱。

就这样，npm 花着风投资本家给的钱来购买服务器和带宽。最终报应不爽，把风投资金纳入囊中时种下的恶果就像堵在门口的债主一样开始敲门，清清嗓子准备连本带利地索要回去。“咳咳，还认识我们吗？把我们的钱还给我们。” 我们终于看清，靠风投资金赞助公司只是赚钱工具罢了。资本家们终会无所不用其极以获取 10 倍收益。他们每做一笔投资都要确保金主是最后的赢家。这种生意并不总是只赚不亏，但如果你不能保证保本，那你得有说服力足够的故事让金主相信你能确保赚钱的机器能一直运转下去。

从本质上说，我认为接受风险投资并没有错。很多拉投资的企业的目标都和投资方的目标相匹配，并且并非所有的投资方都是一样的。有些投资方喜欢放长线钓大鱼。像 Futureshape 这样的投资方是很明确想让世界变得更美好。但更多的投资方只看重收益。这就是他们的出发点：赚钱，把羊养肥卖给新主顾，赚个十倍利润。你拿了风投资金，就要迅速增长。要么做大，要么作古。

记住，npm 公司里是金主说了算，而不是那些为开源宝库添砖加瓦的开发者。

所以 npm 公司必须要盈利，否则就得忽悠更多的投资来拆东墙补西墙。

那位觉得把 ypm 开源出来是个好点子的前 Yahoo 员工，他的想法没错，但他没有深思熟虑过开源之后的发展，事实证明，运营公司可不单单有个好点子就行了，还需要很多血汗。因此在 2018 年，他新雇了一位 CEO 为他运营公司，于是乎，这下可有得折腾了。新 CEO 上任的第一把火就是改变了 npm 的文化 —— 你懂的，就是那套一直做为广告语输出的文化。这位新领导就位后，率先踢开的就是宽容、仁慈的 npm 文化。

结果搞得 npm 的公关问题路人皆知。我们真是一个爱看热闹的社区。如果管事的是一位圣人，那可能我也不会站在这里。但可能我还是会，因为即使一位正派的领导者处在这种位置，也有很大的问题急需解决。

这就是问题所在。

公开的注册中心 —— 所有开源包被索引和存储的地方 —— 是大家所关心的部分。这个注册中心极大地消耗着 npm 的预算，**同时**，这也是投资方觉得有利可图的地方。它控制着所有 JavaScript 开发项目，因为所有 JavaScript 开发项目都自愿以其为代理。数据 —— 用户的使用数据 —— 也是有利可图的地方。每一个 package-lock 文件都存放在亚马逊云存储中的某处，满载着关于用户偏好的有趣数据块。这也是影响 API 设计的强有力因素。npm 公司没理由降低客户端在安装代码包时向服务器发出请求的次数，因为这些请求都能产生有价值的数据。

注册中心是 npm 的负担。想要跟上持续的、近乎指数级的增长，就要付出同等的工作量。我在 npm 任职时，这种繁重的工作占用了小小的开发团队几乎全部的时间。为何开发团队这么小呢？那时我们没有资金，无法扩大规模。或许因为那时的 npm 团队不擅长向投资方讲动听的故事，或许那些潜在的投资者也知道我们拿不出金光闪闪的赚钱方案。我不太确定到底是哪个原因。但总之，团队的资金只够维持免费的 JavaScript 服务，但无力做出像样的产品来卖钱。终于，创业资金即将给到期。终于，到了一个不成功便成仁的关口。

一切向钱看。

因此，我们的处境变成了现在这样，npm 公司还没有完全认清自己作为某些人的赚钱工具的命运，而这些人并不是 JavaScript 开发者。也许它会成功，也许它会破产。也许它会用我们都讨厌的方式赚钱，从你们每个用户的大量宝贵数据中榨取利润。

现在，我们都清楚 npm 并不爱我们，也不爱它的员工。我们对其怒目而视，却同时仍在用它安装代码包。我，个人来说，对这种现状不能安之若素。我怀疑这种现状不会长久。

其实剧情不必是这种走向。在近几个月及之前的过程中，各位主演本可以选择不同的道路。但现在却变成了这样。掌握着我们的公共资源的角色，是不值得我们信任的角色，因为其初衷并不与我们这些 JavaScript 社区成员的诉求相合。

那我们如何应对这种局面呢？

有一种答案是按兵不动，因为我们反正也无计可施。我们的社区在 2013 年时就已经做出了抉择，并且一条道走到黑。我们只能寄希望于 npm 公司的倒闭，等它真倒闭了，我们再用难熬的几个月时间来找到替代品。

我不太喜欢这个答案。

设想一下 npm 被某个海盗公司（专门收购不景气的公司并强制改革）掌管的情形。这种接管者可能没兴趣让公共注册中心维持运转，可能还会想要滥用用户数据。我们，npm 的用户，受制于董事会的决策，而鉴于董事会迄今为止表现不佳，上述设想变为现实的可能性很大。

还有一种更乐观的结局。一个体量更大的救世主公司从天而降，拯救我们心爱的 npm 于水火之中，让我们的公共资源焕发生机。但即使掌管 npm 的公司很靠谱，我认为这还是治标不治本。Microsoft 如今扮演着仁慈的角色，但他们肯定不会一直如此。Google 也曾扮演过仁慈的角色，但如今活活一副上个世纪九十年代 Microsoft 那种垄断者的嘴脸。

我希望我们能够避免重蹈过去十年的覆辙。

我觉得我还是赞同 Ryan Dahl 的观点。npm 不应该私有化。我认为中心化是个负担，会不可避免地导致私有控制，因为服务器总是一笔开销。如果我们大家共同分担，我们就能扛住这个负担。

这可能让你们都觉得不可能。你们都觉得 npm 根深蒂固。几个月前我也这么想，但后来 npm 公司出于所有人都不知道的原因，一把火将其良心烧得干干净净，包括我在内的所有信任者都曾愿意为其良心鞠躬尽瘁。就那么“噗”的一声，付之一炬。他们对 JavaScript 社区、对价值观、对我们开发者如此恶劣，他们是蓄意为之！（此处配合愤怒的手势）

而且，坐以待毙不是我的风格。无计可施在我的字典里根本不存在。

另外我要说的是，尽管发生了这一切，但我仍然信仰 Potlatch 文化。我认为互相分享对我们有益，而即使有人利用这一点赚钱，我也能心平气和地面对。

因此我要在这里宣布。我今天要和你们大家分享一些东西。而且分享者不仅仅是我一个人。我和同事 Chris Dickinson 一直在合力做这件事。

今天我要向你们介绍 Entropic，一个 JavaScript 联合包管理工具。

Entropic 基于 Apache 2 协议，仅需引入就可以运行你自己的注册中心。

Entropic 带有自己的脚手架工具，叫做 `ds`，即 entropy delta。

Entropic 提供全新的发布和安装 API，极大地降低了网络请求量。安装单元就是一个文件，而不是一个大包东西。

Entropic 是联合性质的。你可以使用来自其他 Entropic 实例的依赖包，并且你的本地实例会把你所有的依赖包进行镜像备份，这样就可以自给自足了。

Entropic 还会备份你从遗留的包管理工具安装的所有依赖包。

安装要求非常简单，我们已经将其容器化了。

你可以用 GitHub 账号登录，且支持其他任何 OAuth 认证提供方。

（在此处播放一小段 demo 视频）

这个项目才刚刚满月。我们还没准备好将它推到大众视线内，但对于喜欢尝鲜的开发者来说，它足以让你把玩。

Entropic 还有很多功能，并且我们列了长长的待开发功能清单。比如，Entropic 目前还缺个官方网站。如果感兴趣，你可以去 GitHub 仓库看看长长的一列 issue。

Entropic 的目标是什么？

首先，我想向大家证明，除了无计可施，我们还有其他选择。我们不必坐在原地等着 npm 倒闭再采取行动。乐观一些，积极一些，咱们有这个能力。

其二，Chris 和我以及其他几个人深切理解一个开源包注册中心需要解决的问题，特别是规模问题。我们的社区此刻迫切需要这种专门的经验，而我们几个也迫切需要分享这类经验。我们选择把有价值的东西分享出来。遵从 Potlatch 文化：把我们的经验做为礼物赠与诸君。

第三，我认为中心化终会式微，我愿意在这个过程中出一把力。过去的十年，是整合统一服务的十年，但接下来的十年，将是属于联合化的十年。联合化将分担开销。联合化将分化集权。联合化将分解一言堂。联合化将我们的语言生态掌控权交到我们自己手中。

我的愿景，是通过 Entropic，帮助我们大家把公共资源夺回来。夺回来，我们才不再是风投资本家案板上的鱼肉。夺回来，我们才能走一条与 2013 年年末决定走上的不一样的路。夺回来！作为数以百万计的开发者的共同体，我们有这个能力夺回来。此刻，Entropic 就是我们夺回 JavaScript 公共资源的冲锋号。

关于 Entropic，还有很多想说，还有很多想做，但是时候把它分享给大家了。

如果我们明白了 npm 不爱我们 —— 确实不爱，如果我们明白了一个私有公司不该掌控公共资源 —— 确实不该，那么，是时候迈开脚步了。我坚信这个由优良开发者组成的优良社区，他们拥有惊艳世界的才华和意志。在这个紧要关头，Web 的未来已经危如累卵，我们的规则不应该让某个公司来定义，我们的命运不应该让某个公司来掌控！我们把控制权夺回来，而为了夺回来，我们需要共同完善 Entropic。

我们要把对这份对社区的热爱，传递给大家，由己及人。请大家务必善待这份爱。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
