> * 原文地址：[The economics of package management](https://github.com/ceejbot/economics-of-package-management/blob/master/essay.md)
> * 原文作者：[ceejbot](https://github.com/ceejbot)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-economics-of-package-management-1.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-economics-of-package-management-1.md)
> * 译者：[Baddyo](https://juejin.im/user/5b0f6d4b6fb9a009e405dda1)
> * 校对者：[mymmon](https://github.com/mymmon)，[TiaossuP](https://github.com/TiaossuP)

# npm 的经济风云 —— 上半部分

我想给你们讲一个故事，讲讲谁是 JavaScript 语言的公共资源的拥有者，讲讲我们是如何陷入了公共资源受制于人的局面，讲讲为何我们需要改变这个局面。这是一个关于金钱、所有权和控制权的故事，同样也是一个关于 JavaScript 的故事。

我要讲的这个故事，是我所知道的版本。我是一个知识和观点都不完善的人，因此我的故事可能会稍有主观色彩。但我讲述的内容是这个故事的精华，因为我曾亲历其中。我曾处于故事的核心，因为直到去年我还是 npm 公司的首席技术官，该公司运营着 JavaScript 代码包注册中心。这个身份让我知道了一些世人鲜知的内幕，也使我怀有一种观点，我希望你们在听这个故事的时候记住这个观点。

这个关于 npm 的故事，**你们**也是其中的角色。我敢说你们并没有意识到这点。等我讲完，你们就会知道为什么你们也是故事的一部分，以及为什么你们的存在意义重大。

这个故事涉及到金钱、资本家，以及那些利用开源软件赚钱却不曾贡献过代码的人。在这个故事里，你们无心插柳，我有意栽花，这是一个关于所有权、操纵与最终结果的故事。

这也是一个关于权力的故事 —— 谁掌控着权力、你们的权力有多大，以及我们可以用这种权力做什么。

耳朵洗干净了吗？故事要开始了。

故事开始于 2000 年代的中期，也就是 Yahoo 最后的光辉岁月。Yahoo 是那时候众多 JavaScript 活动的核心。它招纳了许多 JavaScript 领域的意见领袖（例如 Douglas Crockford），推动着 JavaScript 艺术的繁荣发展。或许当时的 Yahoo 还没有一套完善的商业计划，但其技术栈已足够优良。

而 Yahoo 的技术栈中的一项就是 ypm，一种软件包管理工具，这个东西着实是慧心巧思。

得益于愈发流行的 jQuery 和遵循标准开发的浏览器，JavaScript 开始成为一种引人关注的编程语言。服务端 JavaScript 在当时是炙手可热的话题，很多项目都在努力实现它。

JSConf EU 盛会见证了服务端 JavaScript 的成功。就是在 2009 年的 JSConf EU 上，Ryan Dahl 宣布了 Node.js 的诞生。

Node.js 正是人们渴求的服务端 JavaScript 平台。早期的 Node 社区吸引了一群有趣的人，他们喜欢尝试前沿技术，喜欢开垦无人涉足的处女地。这群人中有几位参与了 Node 的早期研发，他们一开始就发现软件包管理在 Node 领域将会非常有用武之地，于是他们就开始各自开发包管理工具。没错，不止一人，那是群雄逐鹿的时代。

群雄之中有一位是个痴迷于 Node.js 的 Yahoo 员工。他辞掉工作，便于专心开发包管理工具，他受到 ypm 的启发，但与 ypm 不同的是，他的包管理工具是开源且专用于 Node.js 的。这位特殊的程序员有得天独厚的优势：他深度参与了 Node 项目的开发，而这又让他可以在 Node 中实现 CommonJS 模块标准。为了打败其他包管理工具，他做了很多努力，例如给很多开源项目提 PR，吸引开发者来使用他的包管理工具。

这款包管理工具足够优秀，得到了 Node 官方的大力支持，它赢了。这款 Node 包管理工具，或者说 `npm`，开始和 Node 安装包捆绑打包，它可不是一个单独的第三方插件，不需要你装完 Node 再去下载包管理工具。这块 Node 官方认证的金字招牌一直挂到今天。

大概就是这个时候，Joyent 用很少一笔钱从 Ryan Dahl 手中买走了 Node。

你会注意到，我们的故事已经发展到了有趣的经济领域了。数百万人每天用 Node.js 做为 JavaScript 开发的工具，而发明 Node.js 的人只用它赚了几万美元。如今，不论是谁在靠 Node.js 赚钱，那个人绝不是 Node.js 的发明者 Ryan Dahl。但至少 Ryan Dahl 还可以借 Node.js 维生，因为 Joyent 将 Ryan Dahl 招致麾下了。（提示：我听某些知情者说，Ryan Dahl 卖出的价格不止几万美元，所以短期内他还高枕无忧。但比起 Node.js 产生的价值，这个卖价还是九牛一毛。）

npm 的作者也被 Joyent 聘来开发 Node.js，但（划重点）他保留了 npmjs.org 域名、npm 源码以及源码中的任何专利的所有权，这些都是他自己的知识产权。他并没有像 Ryan Dahl 卖 Node.js 源码那样，把这些一股脑地卖给 Joyent。这个决定会对后世产生深远影响，所以你们要记在小本本上。

在 2012 年，Ryan Dahl 离开了 Node 项目组，而 npm 的拥有者接替他登上了项目组的领导岗位，到了这个时候，npm 是笑到最后的那个包管理工具。

就在此刻，你们各位（或者说，至少你们中的一部分人吧）就络绎登场了。你们是 JavaScript 开发者，你们喜欢 JavaScript 语言。如果能用 JavaScript 实现某个工具，你们绝对不会看其他语言一眼！因此你们开始用 Javascript 开发 Node 程序，并且乐在其中。与此同时，人们（比如我）发现用 Node.js 开发多路 I/O 服务非常得心应手，因为 Node 内置的 Reactor 模式简直棒极了。耶！妈妈再也不用担心我的多线程！从 2013 年开始，更多的人加入了我们的行列，共同在 JavaScript 的快乐旅程上前行，Node 风靡一时。而 npm 自然也随之流行。

一派太平盛世，是不是？嗯。

npm 的闪光点在于，它不只是一个脚手架工具而已，它的功能不限于找到代码包然后“咣当”一声下载到本地的 node_modules 文件夹里。事实上，尽管大家如此频繁地使用 npm 的脚手架功能，但那可能是 npm 这套“机甲”最无足轻重的功能。npm 更主要是一个中心化的代码包**注册中心**和**仓库**。这个注册中心从一开始就存在，运行在一个 CouchDB 数据库中，绑定的就是如今用的这个域名。“注册中心”就是一个列有大量 JavaScript 代码包及其名称、作者以及版本号的清单。注册中心使得 Node 代码包**易于查找**，安装起来**快速可靠**。

npm 中有数量浩繁的代码包，值得我们花时间去探索。

现在来看看**中心化**的优点。npm 注册中心就是**中心化**的。中心化有一些显而易见的可用性优势 —— 它可以一站式地为你提供所需代码包。这个中心站点会用特定规则来管理其中的代码包 —— 它们形式统一、提供同样种类的信息，并且不会因作者一时之念而凭空消失。

对用户来说，中心化有诸多好处。当这个源头总是能提供你想找的东西，你就可以免于踏破铁鞋之苦，大大缩短工作时间。我最近经常要做 Go 语言开发工作，而到处搜索 Go 语言代码包让我感觉非常别扭，因为它们散落的满世界都是，别无他法，要么靠 Google 面向搜索引擎编程，要么去翻手动维护的文字清单 —— 你懂的，就是 Yahoo 原来那种传统的方式。而且你得从 GitHub 仓库里下载安装，要知道你可能下次就找不到这个仓库了，我简直要被逼疯了。8 年来 npm 带给我的舒适体验拉高了我的心理预期。Go 语言生态里没有注册中心可用，才让我意识到 npm 有多体贴。

近来，中心化概念在互联网上卷起狂潮。例如，博客已经将阵地转移到中心化的托管平台上了，像 Tumblr、Medium 这样的平台早已屹立起来了。社交媒体本身就是中心化的。开源领域中，GitHub 是中心化的代表，即便 Git 存在的使命是去中心化。

总之，npm 是一个托管所有的 Node 代码包的注册中心，这很棒，可是到了 2013 年，Node.js 开始崛起时，这一切就开始变味了。中心化的劣势就是，**开销**也是中心化的。npm 注册中心的短板就是，它需要运行在一台带有数据库的服务器上。

而服务器是要花钱买的。

那这笔钱从何而来？

这些年来，npm 一直靠着捐助的主机维持。Node 的开发者一部分来自 CouchDB 的团队，因此 npm 选用了 CouchDB 作为数据库。很长一段时间里，npm 都被 IrisCouch 团队用作 CouchDB 等自家服务产品的活广告。后来 NodeJitsu 收购了 IrisCouch，npm 仍旧没有摆脱被人用作廉价广告的命运。

但到了 2013 年，到了你们大家开始使用 Node.js 的时候，npm 真正得到了用武之地，不再是那个廉价广告了。随着使用量激增，npm 中大量的代码包带来了沉重负担。在 2013 年的 10 月，npm 的服务器频频宕机，看来是时候采取措施了。

npm 需要更好的服务器。npm 需要一个全职的维护者。归根结底，npm 需要钱。

这是个任何一个编程语言生态都会面临的平常问题。就好像 RubyGems 也需要资金来运营一样。Perl 很久以前就通过 CPAN 网络镜像解决了这个问题。

npm 的拥有者决定要做一些其他语言的包管理工具没做过的尝试：接受风险投资，把 npm 包装成一家公司。他亲眼目睹过 Joyent 给 Ryan Dahl 出的价格是多么低廉，也知道 Node.js 的价值到底应该值多少钱（即使 Joyent 也没靠 Node.js 赚多少钱）。他保留着 npm 的所有权，所以即使他运营着 Node.js 这样的开源项目，他仍决定让 npm 走商业路线。

因此，他向 Joyent 递交了辞呈，成立了一家公司 —— npm 公司，从一家风投公司获得了创业基金。

Node 项目组决定支持这一举措，并保留 npm 作为 Node 官方御用包管理工具的特权。关于这一点，我不知道 Node 项目组内部是否意见一致，因为我没有参与这件事。Node 项目在 2013 年年底进入了濒死期，所以这可能也是不得已而为之。总之，Node 项目组允许一家私企将其产品捆绑在自家的 Node.js 上。他们对此安之若素。

你们（JavaScript 开发者）也是支持此举的一方。你们各位，连同整个 JavaScript 生态，你们的决定至关重要。你们连脑子都没过就同意了，只顾着享受 npm 带来的便利，对于 npm 的质变睁一只眼闭一只眼。

“Ceej，我懂你的意思，但那时候我们还没有用过 npm 呢！我们并不知情！”没错！你们大多数确实不知情！但你们顺理成章地接受了这个决定。你们可能都没有意识到这**是一种支持**。npm 公司就在那，而你们从来没有质疑过。或许你们没意识到它是私企性质的机构，或许你们根本就不在乎。

但在当时，那是一项有争议的决定。一直免费托管 npm 的 Nodejitsu 公司对此很是不满。Nodejitsu 一直在自己筹划的 `#scalenpm` 活动，在 npm 的拥有者筹集风投资金的同时，他们也筹到了一笔钱。这涉及到一些法律上的漏洞，对于这些，我知之甚少。我只知道 npm 迅速而潦草地和 Nodejitsu 一拍两散，因为两家公司已经处在纠纷之中，产生了法务层面的较量。随后，npm 迅速脱离了 Joyent 的公司，因为二者同样起了纠纷。

当利益之争摆上台面，昔日的情谊也就烟消云散。曾经因开源而建立的友情，在金钱竞争的压力下土崩瓦解。

在这种关头，我也做出了抉择：对于风投公司占有 JavaScript 的公共资源，我决定接受。但我的真实想法并非如此。我告诉我自己，这么做是为了把 Node 发展壮大。我真的很喜欢 Node 编程，而 npm 是我首次参与开源开发的地方。一想到要把 Node 社区建设好，我就热血沸腾。我深信 npm 的 所有者所言，我们会让 npm 公司自力更生，我们的服务器会快乐地嗡鸣着把代码包分发给广大开发者。

就这样，时间的脚步来到了 2014 年，npm 公司成立了，手握风投资金，开始招兵买马。一号员工是 Raquel Vélez，你们或许在 JSConf 上听过他的演讲。而二号员工就是我。

我最终成了 npm 开发团队的领导，然后，怎么说呢，后来的事你们都知道了。我们确实“误打误撞”地把 npm 做大做强了。我们的运营工作如此成功，让 Node.js 的普及率爆炸性增长。所有 JavaScript 开发者都开始用 Node.js 做开发，而 npm 则成为每个 JavaScript 开发者日常工作中不可或缺的一部分。大家都把 npm 问世之前不能实现的 Web 项目拿出来重新启动。形势一片大好！那是一段杰出职业生涯中的高光时刻，我颇引以为豪。

故事发展到了 npm 辉煌历程的顶峰，而我们要在这里暂停一下，

我们要说说“金钱”这个词。

为什么 Ryan Dahl 没能在一座热带小岛上惬意地生活？

为什么 James Halliday 没能在他的热带小岛上圆满地退休？

为什么 Dominic Tarr 没能拥有一艘游艇，只有一艘帆船？

为什么 Jan Lehnardt 还要辛辛苦苦做一份全职工作？

这些人名你们听过吗？他们就是你们笔记本电脑里的 Node.js 的开发者，而 Node.js 就是你们每天使用的成千上万个开源程序的灵魂所在。不单单是你们，每个世界五百强企业都在用他们开发的软件，还有另外几十人是 Node 和 npm 的早期贡献者。尽管他们开发的软件创造了巨大的价值，他们却并未因此而富有。

从中获利的资本家本该给这些默默无闻的开发者予以报酬，然而遍身罗绮者，不是养蚕人。

我相信，绝大多数为 JavaScript 公共资源做贡献的开发者都是不求回报的。他们或许也希望拥有热带小岛，但他们从未指望用开源贡献来实现金钱梦想。在 Node.js 发展史的初期，npm 的使用者很少，都是圈里人，他们在开发那些模块、创造 Node.js 生态时，本意根本不在于赚钱。

他们做的还不止这些。他们互相交换礼物，这种氛围与金钱没有任何关系。

在美国和加拿大的太平洋西北沿岸，当地的美洲土著居民有一种**赠送**礼物（而非收受礼物）的习俗。他们将这种习俗称为 [Potlatch](~~https://en.wikipedia.org/wiki/Potlatch~~)。Potlatch 这种社会习俗被西方殖民者暴力废除了，但这个词语流传了下来，因为这种对分享的渴望是人类的天性。Potlatch 正是让我们聚集在一起的动机，因为它激励着参加大会和登台演讲的每一个人。Node 早期的社区文化正是这种 Potlatch 文化，那时候，人们以自己的个人意愿为出发点，彼此共享软件库，以使每个人的 Node 程序愈发强大。

每一个由开发者自发发起、与商业无关的开源项目，都或多或少传承着 Potlatch 精神。而这种对 Potlatch 文化的现代诠释没有遭到暴力镇压。资本家爱它还来不及呢！为什么？因为他们发现可以借此来武装自己，对付我们。而对付我们的武器，就是 Eric Raymond 式的开源。

你们可能都知道**免费软件**（Richard Stallman 式开源）和**开源软件**（Eric Raymond 式开源）的区别。Stallman 的 GNU 协议旨在让用户把使用共享源代码构建的软件也免费地共享出来。或者至少把源代码免费共享出来。暂且不论 GNU 协议是否实现了其目标，而人们确实对此争论不休。我不打算在此老生常谈。我只想说说 ESR 风格的开源，这种开源形式是你分享的源代码带有许可协议，这种形式目前占据上风。就好像你们大家平时做的那样 —— 你们可能在自己的软件中使用“许可性质的” MIT 和 BSD 协议，而对 GPL 协议弃若敝屣。

资本家喜欢 ESR 式开源，因为这样企业就能免费获得许多好处。资本家甚至得寸进尺，告诉你说要想找到工作，就**必须**支持 ESR 式开源。他们告诉你“GitHub 就是你的简历”，他们摊开手掌向你索要免费的源代码，再包装成自己的产品去卖个好价钱。

Dominic Tarr 开源了推流（pull-stream）技术，每个世界五百强企业都在无偿使用他的劳动成果，而获利却与 Dominic Tarr 无关。这就式赤裸裸的现实。

在我们的故事中，恰恰是**未曾**开源其知识产权的人最能赚得脑满肠肥。当然了，这个人赚到的钱不会像为这一切买单的风投资金那么多 —— 真正富得流油的人是那些手握原始资本的人。而这些掌控着 JavaScript 公共资源的人，却和 JavaScript 没有半毛钱关系。

现在让我们来聊聊我反复说到的这个词 —— JavaScript 公共资源。这个词是什么意思？

公共资源啊！这是一个单数名词，意思是所有社会成员都能享受的资源的集合。它可以是自然资源，比如我们所有人都在呼吸的空气。它也可以是我们共同放牧的草场。

> 欢迎继续阅读本系列文章的下半部分：
> 
> * [The economics of package management - 下半部分](https://github.com/xitu/gold-miner/blob/master/TODO1/the-economics-of-package-management-2.md)

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
