> * 原文地址：[The 7 Programming Languages & Frameworks to Learn in 2020](https://medium.com/swlh/the-7-programming-languages-frameworks-to-learn-in-2020-6f9ac923ec5d)
> * 原文作者：[Kent Sia](https://medium.com/@kentscg)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-7-programming-languages-frameworks-to-learn-in-2020.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-7-programming-languages-frameworks-to-learn-in-2020.md)
> * 译者：[司徒公子](http://github.com/stuchilde)
> * 校对者：[GJXAIOU](https://github.com/GJXAIOU)、[niayyy](https://github.com/niayyy-S)

# 2020 年要学习的 7 种编程语言和框架

> 推荐给充满激情的程序员

![](https://blog-private.oss-cn-shanghai.aliyuncs.com/20200301104804.jpeg)

为你的应用程序选择合适的编程语言或框架不仅会影响开发速度和开发周期，而且还会影响你未来职业发展的广度。

在这里，我将分享 2020 年你最应该学习了解的 —— 7 种编程语言，并且在未来几年与你息息相关。如果你还在为前端或后端选择哪一门编程语言而苦苦挣扎或热情于此，那么这篇文章非常适合你。

## 1. Java/Kotlin —— Spring 框架

![](https://blog-private.oss-cn-shanghai.aliyuncs.com/20200301104831.png)

很多人可能会问为什么是 **Java**？Java 依然存在？还在流行？答案是**肯定的**。选择学习任何一门编程语言都不仅仅是基于流行程度或者它诞生的时间。无论你喜不喜欢，Java 仍然是一门企业标准的编程语言，并且得到了广泛的运用。工作机会也是我们选择学习编程语言时要考虑的因素之一。

**Kotlin** 是一门具有类型推断的跨平台、静态类型和通用的编程语言。Kotlin 旨在与 Java 完全互操作，并且它标准库的 JVM 版本依赖于 Java 类库，但是类型推断允许它的语法更简洁。Kotlin 由推出 IntelliJ IDEA 的 JetBrains 公司在 2010 年创立，并从 2012 年开始开放源码。

**Spring** 框架是最流行的 Java 开源框架之一。它面向开发人员，并且提供了一个全面、灵活的框架。Spring 5.0 之后的版本为 Kotlin 提供了专门的支持，人们总是将 Kotlin 与 Java 进行比较。对于 Spring 框架来说，既然两种语言都有它的优点和缺点，为什么不把两者结合起来呢？

借助 Internet 上的扩展、资源和文档。使得开发人员可以更轻松的找到并添加与之不同类型的第三方应用程序集成所需的依赖项。

Spring 框架最受欢迎的产品：

* **Spring Boot** 旨在以最少的前期配置实现尽快的运行
* **Spring Cloud** 旨在简化分布式和微服务风格的架构
* **Spring Cloud Data Flow** 是用于创建可组合数据微服务的统一服务

你应该考虑使用，当：

* 构建企业级应用程序
* 使用流行的云服务提供商实现微服务架构
* 使用代码控件构建大型项目
* 寻找易于扩展且具有弹性的框架

## 2. Golang

![](https://blog-private.oss-cn-shanghai.aliyuncs.com/20200301104840.png)

**Go**，也称为 **Golang**，是 Google 创建的一种开源的编程语言，它可以轻松构建简单、可靠和高效的软件。语法干净，新手易于理解。

Go 的美妙之处在于它对并发性的一流支持。Go 不仅支持**多线程**，它本身也是多线程的。

如果你在寻找轻量级、快速执行和快速开发的产品，Go 是最佳选择之一。与 Spring jar 文件相比，Go 的二进制文件要小的多（10 倍）。

你应该考虑使用，当：

* 构建小型轻量级的应用程序
* 构建基于微服务的容器平台
* 快速开发，易于构建，学习曲线更平缓
* 构建异步和多线程服务

## 3. Python —— Django 框架

**Django** 框架被认为是构建 web 应用程序的最佳 Python 框架之一，并且它是免费和开源的。Django 提供稳定性、包、和最好的文档，并且有良好的社区支持。

Django 广泛用于构建 CRM、CMS、预定引擎和各种 web 应用程序，它支持以**最少的编码**快速开发后端 API。

除其他事项外，Django 非常适合用于数据分析解决方案、复杂的计算和机器学习。它是目前开发人员首选的框架之一。

你应该考虑使用，当：

* 构建大规模 web 应用程序
* API 驱动的应用程序
* 不在意整体架构
* 数据分析解决方案和机器学习

## 4. Node.js —— Express

JavaScript 可能是过去几年最强大和增长最快的编程语言之一。那时候，JavaScript 只用于构建 web 应用程序，但是，现在如果你精通 JavaScript，就可以开发构建 web 应用程序、后端数据库集成、桌面应用程序，甚至是移动应用程序。

如今，JavaScript 几乎无处不在。由于 JavaScript 的占比很高，并且没有竞争，因此，我们无法预见它不久的将来会走向何方。

**Express** 以快速、无约束、极简的 Node.js web框架而闻名。它基于 JavaScript 构建，学习曲线相对较平缓。如今，大多数开发人员都选择 Express 是因为它的灵活性、简单性和可扩展性。更不用说，Express 是 MEAN（软件捆绑包）技术栈的一部分，该技术栈是基于 JavaScript 技术开发 web 应用程序的完整全栈技术的集合。

你应该考虑使用，当：

* 构建小型 web 应用程序，例如门户网站、看板等
* 构建桌面应用程序
* 最小可行产品构建（MVP）
* 学习曲线更平缓
* 你只有一个小团队和较短的开发周期
* 尽量减少雇用后端开发团队的成本
* 你不想打扰或等待现有的后端团队 😆

## 5. Angular —— Web 框架

![](https://blog-private.oss-cn-shanghai.aliyuncs.com/20200301104848.png)

多年来，我一直关注 Angular，那时 AngularJS 曾经是最好的框架之一。**Angular** 是一个基于 TypeScript 的开源 web 应用框架，由谷歌构建。Angular 是谷歌的同一个 Angular 团队对 AngularJS 的完全重写。它功能强大，并且有很好的社区支持。

Angular 支持 web、手机和桌面的各种平台。学习 Angular 最主要的原因之一是因为其庞大的生态系统且蓬勃发展。Angular 团队已经向社区交付了大量的工具和库。我参加了 2019 年的 Angular 大会，非常高兴能与世界各地的所有伟大开发者会面，分享使用 Angular 的经验。

新版本的 Angular（9.0）将会成为关于 JavaScript 框架接的下一个大事件。它有更小的包大小、更快速的构建和更好用的调试工具等。

你应该考虑使用，当：

* 构建大规模的 web 应用程序
* 为社区中所有的工具和库寻找一个大型的生态系统
* 不介意陡峭的学习曲线
* 你喜欢写 Typescript 而不是 JavaScript 🙄
* 有**谷歌**的支持

## 6. Vue.js —— 渐进式 JavaScript 框架

![](https://blog-private.oss-cn-shanghai.aliyuncs.com/20200301104856.png)

**Vue** 是一个非常受欢迎的 JavaScript 框架，在过去几年里发展迅猛，Vue 是尤雨溪创建的，当时他在谷歌的 AngularJS 团队工作。

为什么 Vue 会这么受欢迎？Vue 是一个构建接口的渐进式 JavaScript 框架，它从一开始就被设计成为可以逐步采用的。Vue 最主要的优势之一是，它从竞争对手（Angular 和 React）那里吸取了许多优质成分，并向其中加入了自己的特色。

我个人非常喜欢 Vue，因为它简单、灵活，最重要的是它是纯 JavaScript 编写的。然而，Vue 仍然很新，社区仍然很小，而且大多数开发人员都不会说英语。

你应该考虑使用，当：

* 构建中型规模的 web 应用程序
* 寻找快速开发和较短交付周期（纯 JavaScript）
* 学习曲线平稳
* 你可以看懂中文 😉
* 你非常喜欢 JavaScript（这就是我！）

## 7. lonic 框架

![](https://blog-private.oss-cn-shanghai.aliyuncs.com/20200301104902.png)

2014年，我开始使用 AngularJS 和 Apache Cordova 对 Ionic 进行开发。它是一个用于混合移动应用程序的开源 SDK。开发人员可以使用 JavaScript 框架构建移动应用程序。Ionic 包括移动组件、排版、移动主题和交互范例来构建移动应用程序。

在最新版本的 Ionic 中，它允许用户选择任何用户界面框架，例如 Angular，React 或 Vue.js。Ionic 正在推广一个全平台（IOS/Android/Electron/PWA）的代码库。Ionic 也提供了实时更新的工具，并且使用 Appflow 来实现 DevOps 生命周期的持续集成、持续交付。

你应该考虑使用，当：

* 你想构建小型/中型移动应用
* 快速开发和平稳的学习曲线
* 你不想学习原生编程
* 节省构建 Android 和 IOS 移动应用程序的时间和成本
* 你喜欢使用 JavaScript 框架来构建移动应用程序

## 结论

总之，学习任何编程语言都没有对错之分。还有其他好的一些编程语言可以学习，比如 iOS 的 Swift，谷歌的 Dart、数据科学的 R，Python 的 Flask 等等。从长远来看，为正确的应用场景选择最佳的编程语言非常重要。

以上的排名列表都是基于受欢迎程度、学习曲线、特性以及我的拙见选出来的。我相信，在 2020 年，只学习一门编程语言并成为这方面的专家已经不可能了。如今，每个人都在讨论全栈编程。

> 真正的程序员是活到老，学到老。

我希望你们喜欢这篇文章，如果你觉得这篇文章对你有用，请把它分享给你的朋友，并与我分享你的评论。感谢！

开心写代码！ 😊

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
