> * 原文地址：[The 10 Statistical Techniques Data Scientists Need to Master](https://medium.com/cracking-the-data-science-interview/the-10-statistical-techniques-data-scientists-need-to-master-1ef6dbd531f7)
> * 原文作者：[James Le](https://medium.com/@james_aka_yale)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/the-10-statistical-techniques-data-scientists-need-to-master.md](https://github.com/xitu/gold-miner/blob/master/TODO1/the-10-statistical-techniques-data-scientists-need-to-master.md)
> * 译者：[HearFishle](https://github.com/hearfishle)
> * 校对者：[mymmon](https://github.com/mymmon), [hu7may](https://github.com/hu7may)

# 数据科学家需要掌握的十种统计技术

![](https://cdn-images-1.medium.com/max/3840/1*itOusDBOUogAV1QbNaj4cQ.png)

无论你在数据科学是否“性感“的问题上站定何种立场，都无法忽略一个事实：数据，和我们分析数据、组织数据、确定数据上下文关系的能力正在越来越重要。凭借庞大的就业数据和员工反馈，Glassdoor（一家美国的求职社区，译者注）将数据科学家排在全美最佳的 [25 个职位](https://www.glassdoor.com/Best-Jobs-in-America-LST_KQ0,20.htm)中的第一名。因此，虽然这个角色会依然存在，但毫无疑问，数据科学家们所做的具体任务将会不断进化。随着像机器学习这样的技术的普及，还有像深度学习这样的新兴领域，获得了来自研究人员和工程师们及他们所在的公司的巨大关注，数据科学家们将继续在创新和科技进步的浪潮中乘风破浪。

尽管拥有强悍的编程能力是重要的，但数据科学并不完全是软件工程（事实上，熟悉Python的话会更容易展开工作）。数据科学家需要的是编程，分析和关键性思考的三重能力。正如 Josh Wills [所言](https://www.quora.com/What-is-the-difference-between-a-data-scientist-and-a-statistician)，“**数据科学家具备比任何编程人员都更丰富的统计学知识，和比任何统计学家都强的编程能力**。”据我个人了解，太多的软件工程师想转行成为数据科学家。他们在没有完全理解数据科学理论的情况下就盲目利用机器学习框架如 TensorFlow 或者 Apache Spark 去处理数据。他们对待[统计学习](https://en.wikipedia.org/wiki/Statistical_learning_theory)这个基于统计学和泛函分析的机器学习理论框架，也是如此。

**为什么要学习统计学习理论？** 理解多种技术背后的思想是很重要的，这样便于知道如何以及何时使用它们。为了掌握更复杂的方法，人们必须先理解更简单的方法。准确评估方法的性能是非常重要的，这让我们确定工作是否正常进行。并且，这是个令人兴奋的研究领域，在科技，工业和金融行业都有这非常重要的应用。归根结底，统计学习是现代数据科学家培训的基本要素。统计学习问题的例子包括有：

* 确定引起前列腺癌的危险因素。
* 根据对数周期图对录制的音素进行分类。
* 根据人口统计学、饮食和临床测量预测某人是否会心脏病发作。
* 自定义电子邮件垃圾邮件检测系统。
* 识别手写的邮政编码。
* 将组织样本分类到几种癌症中的一种。
* 在人口调查数据中建立薪水和人口统计变量之间的关系。

在大学的最后一个学期，我自学了数据挖掘。这门课的材料涵盖了这三本书的内容：[Intro to Statistical Learning](http://www-bcf.usc.edu/~gareth/ISL/) (Hastie, Tibshirani, Witten, James)，[Doing Bayesian Data Analysis](https://sites.google.com/site/doingbayesiandataanalysis/)（Kruschke）和 [Time Series Analysis and Applications](http://www.stat.pitt.edu/stoffer/tsa4/)（Shumway，Stoffer）。我做了大量和贝叶斯分析，马尔可夫链，分层建模，监督和无监督学习相关的练习。这个经历加深了我对数据挖掘学术领域的兴趣，并使我确信要向更深处探索。最近，我在 Stanford Lagunita 自学了 [Statistical Learning online course](https://lagunita.stanford.edu/courses/HumanitiesSciences/StatLearning/Winter2016/about)，它涵盖了 [**Intro to Statistical Learning book**](https://www.amazon.com/Introduction-Statistical-Learning-Applications-Statistics/dp/1461471370) 的全部材料。两次接触这些内容，我想分享这本书中的 10 种统计技术，我想任何数据科学家都应该学会这些技术，以便更有效地处理大数据集。

在开始介绍这十种技术之前，我想先区分一下统计学习和机器学习。之前我写了[机器学习中最流行的方法之一](https://gab41.lab41.org/the-10-algorithms-machine-learning-engineers-need-to-know-f4bb63f5b2fa)因此我非常自信我有能力去判断它们的差异：

* 机器学习是人工智能的一个分支。
* 统计学习是统计学的一个分支。
* 机器学习非常强调大数据和预测精确度。
* 统计学习强调模型以及它的可解释性，精确性和不确定性。
* 但是两者的界限在变得模糊，并且还有大量的“学科交叉”。
* 机器学习更有市场！

## 1 — 线性回归：

在统计学中，线性回归是一种通过拟合自变量和因变量之间的**最优线性函数**去预测目标变量的方法。当拟合每个点得到的值和实际观测值的距离之和最小时，我们就可以认定**最佳拟合**了。在选择形状时，在没有其他的位置会产生更少的误差的情况下，说明这个形状的拟合是”最好“的。两种主要的线性回归是**简单线性回归**和 **多元线性回归**。**简单线性回归** 通过拟合一个最优线性关系，使用单自变量去预测一个因变量。**多元线性回归**则是通过拟合一个最优线性函数，使用不止一个自变量去预测因变量。

![](https://cdn-images-1.medium.com/max/4328/1*KwdVLH5e_P9h8hEzeIPnTg.png)

可以选择你生活中的任意两个有关系的事物。比如，我有过去三年我每个月收入和支出以及出行的数据。现在我要回答如下问题：

* 我下一年的月支出将是多少？
* 哪个因素（月收入或者月出行次数）在决定我的月支出中更加重要？
* 月收入和月度出行次和月支出有怎样的相关关系？？

## 2 — 分类：

分类是一种数据挖掘技术，它为数据集合分好类，以帮助进行更准确的预测和分析。分类有时候也被称为决策树方法，是有效分析大型数据集的几种方法之一。两种脱颖而出的主要的分类技术是**逻辑回归**和**判别分析**。

当因变量是对立的（二元）时，**逻辑回归**是适当的回归分析方法。和所有的回归分析类似，逻辑回归是一种预测分析。逻辑回归用于描述数据，并解释一个因变量与一个或多个定类、定序、定距或定比自变量之间的关系。逻辑回归可以校验的问题有：

* 每天每增加一磅体重和每多抽一包烟，患肺癌的几率（是与否）会有怎么样的变化？
* 体重、卡路里摄入量、脂肪摄入量和参与者年龄对心脏病发作有影响吗（是与否）？

![](https://cdn-images-1.medium.com/max/2000/1*_jCbRluq1_g89LhNgIujLg.png)

在**判别分析**中，两个或者更多的组或群或总体是已知先验的，而根据分析的特征，1个或者更多的观测值被划分进入已知的某一类簇中。判别分析模拟了预测因子 X 在每个响应类别中的分布，然后使用贝叶斯定理将其转换为给定 X 值的响应类别的概率估计值。这些模型可以是**线性的**，也可以是**二次的** 。

* **线性判别分析**通过计算每个观测值的“判别分数”来对观测值进行响应变量类的归类。这些分数是通过寻找自变量的线性组合得到的。它假设每个类中的观测值都是来自一个多元高斯分布，并且预测变量的协方差在响应变量 Y 的 k 个级别上都是相同的。
* **二次判别分析**提供了另一种方法。和 LDA 一样，QDA 假设每一类 Y 的观测值都来自高斯分布。而不同于 LDA 的是，QDA 假设每一类都有它自己的协方差矩阵。换句话说，预测变量的协方差并不假设为在响应变量 Y 的 k 个级别上都是相同的。

## 3 — 重采样方法：

重采样是指从原始数据样本中提取重复样本的方法。它是一种统计推断的非参数方法。换言之，重采样方法不涉及使用通用分布表来计算近似的 p 的概率值。

重采样基于实际数据生成一个唯一的抽样分布。它使用实验方法而非分析方法来生成这个唯一的抽样分布。它基于研究员所研究的所有可能结果的无偏样本来产生无偏估计。为了理解重采样的概念，你应该了解**自举法（也翻译成拔靴法，译者注）**和**交叉验证**：

![](https://cdn-images-1.medium.com/max/2000/1*SebBhTd29KMJ25JfPn2QgA.png)

* **自举法** 应用于多种场景，如验证预测性模型的表现，集成方法，偏差估计和模型方差。它的工作原理是在原始数据中执行有放回的数据抽样，使用 “**未选中**” 的数据点作为测试样例。我们可以多次执行并且计算均值来评估我们模型的性能。
* 另一方面，交叉验证用于验证模型性能，并通过将训练数据分成 k 部分来执行。我们将前 k-1 部分作为训练集，“**留出**” 的部分作为测试集。用不同的方法重复这个步骤 k 次，最后将 k 次分值的均值用作性能评估。

通常，对于线性模型来说，普通最小二乘法是拟合数据时考虑的主要标准。下面三个方法可以替代它并且能够提供更好的预测准确率和拟合线性模型的可解释性。

## 4 — 子集选择：

此方法确定被我们认为与响应相关的 **p** 个预测因子的一个子集。然后我们利用子集特征的最小二乘来拟合模型。

![](https://cdn-images-1.medium.com/max/2000/1*R1tdVlwJX-N1qnFLzGp0pQ.png)

* **最优子集选择:** 这里，我们为 **p** 个预测因子的每个可能的组合分别拟合一个 OLS 回归，然后观察每个模型的拟合效果。该算法有两个阶段：（1）拟合包含 k 个预测因子的所有模型，其中 k 为模型的最大长度。（2）使用交叉验证预测损失来选择单个模型。重要的是使用 **验证** 或 **测试误差,** 而且不能简单地使用训练误差评估模型的拟合情况，因为 RSS 和 R² 随变量的增加而单调递增。最好的方法就是选择测试集中最高的 R² 和最低的 RSS 来选择模型并进行交叉验证。
* **前向逐步选择**研究的是一个小得多的 p 个预测因子的子集。它从不含预测因子的模型开始，逐步添加预测因子到模型中，直到所有预测因子都包含在模型中。添加预测因子的顺序是根据不同变量对模型拟合性能提升的程度确定的，会一直添加变量，直到再没有预测因子能在交叉验证误差中提升模型。
* **后向逐步选择**一开始就在模型内加入所有的 p 个预测因子，然后每次迭代都移除一个最无用的因子。
* **混合法**遵循前向逐步方法。但是在添加每个新的变量之后，该方法也可能会移除那些对模型拟合无用的变量。

## 5 — 特征缩减：

这种方法适合包含所有 p 个预测因子的模型。然而，估计系数将根据最小二乘的估值向零收敛。这种收缩也称之为正则化。它旨在减少方差以防止模型的过拟合。由于我们使用不同的收敛方法，有些系数将被估计为零。因此这种方法也能执行变量的选择，将变量收敛为零最想见的技术就是**岭回归**和 **lasso** 回归。

![](https://cdn-images-1.medium.com/max/2000/1*nlg3Mo5du17JV8VmLQ8H4g.jpeg)

* **岭回归**非常类似于最小二乘法，只不过它通过最小化一个稍微不同的数值来估计系数。岭回归和 OLS 一样寻求减少 RSS 的系数估计。但是当系数值接近零时，它们会对这种收缩进行惩罚。这个惩罚项具有将系数估计值缩小到趋近于零的效果。不需要数学运算，就能知道岭回归通过最小的列空间方差来收敛系数是很有用的，比如主成分分析中，岭回归将数据投射 **d** 方向空间中，并且相较于高方差成分，更多的收缩低方差的成分，这两者等同于最大主成分和最小主成分。
* 岭回归至少有一个缺点，它需要在最终模型中包含所有的 **p** 个预测因子，这主要是因为罚项将会令很多预测因子的系数逼近零，但又一定不会等于零。这对于预测准确度来说通常并不是什么问题，但却令模型的结果更难以解释。**Lasso** 则克服了这一缺点，并且能够在 **s** 足够小的情况下使一些预测因子的系数归零。由于 **s** = 1 将导致正规的 OLS 回归，当 **s** 逼近 0 时，系数将收敛到零。因此 Lasso 回归同样是执行变量选择的一个好方法。

## 6 — 降维：

 降维算法将 **p + 1** 个系数的问题简化为 **M + 1** 个系数的问题，其中 **M < p**。算法执行包括计算变量的 **M** 个不同**线性组合**或**投影**（projection）。然后将这 **M** 个投影作为预测因子，并通过最小二乘法来拟合一个线性回归模型。两个处理方法是**主成分回归（principal component regression）** 和 **偏最小二乘法（partial least squares）**。

![](https://cdn-images-1.medium.com/max/2000/1*WVFe7w1rzZWsmghdvaoXag.png)

* 主成分回归（PCR）可以看成一种从大型变量集合中导出低维特征集合的方法。数据中的第一主成分（first principal component）是指观测值沿着这个变量方向的变化最大。换言之，第一主成分是最接近拟合数据的线，总共可以用 p 个不同的主成分拟合。第二主成分是和第一主成分不相关的变量的线性组合，且在该约束下有最大的方差。其主要思想是主成分能在各个互相垂直的方向使用数据的线性组合捕捉到最大的方差。使用这种方法，我们还能结合相关变量的效应从数据中获取更多的信息，毕竟在常规的最小二乘法中需要舍弃其中一个相关变量。
* 上面描述的 PCR 方法需要提取 X 的线性组合，以获得预测因子的最优表征。由于 **X** 的输出 **Y** 不能用于帮助决定主成分方向，这些组合（**方向**）使用无监督方法提取。即，**Y** 不能**监督**主成分的提取，从而无法保证这些方向是预测器的最优表征，也无法保证能获得最优预测输出（虽然通常假定如此）。**偏最小二乘法**（PLS）是一种**监督**方法，作为 PCR 的代替方法。和 PCR 类似，PLS 也是一种降维方法，它首先提取一个新的较小的特征集合（原始特征的线性组合），然后通过最小二乘法将原来的模型拟合为一个新的具有 M 个特征的线性模型。

## 7 — 非线性回归：

在统计学中，非线性回归属于一种观测数据使用模型参数的非线性组合的函数（依赖于一个或多个独立变量）建模的回归分析形式。其使用逐次逼近法拟合数据。下方是几种处理非线性模型的重要技术：

* **阶梯函数（step function）**，变量为实数，可以写成区间的指示函数的有限线性组合的形式。非正式的解释是，阶梯函数是一种分段常数函数，只有有限的部分。
* **分段函数**（piecewise function）通过多个子函数定义，每一个子函数被定义在主函数定义域的确定的区间上。分段实际上是一种表示函数的方式，而不是函数自身的特征，但通过额外的限定条件，它可以用于描述函数的本质。例如，一个**分段多项式函数**是一个在每一个子定义上为多项式的函数，其中每一个多项式都可能是不同的。

![](https://cdn-images-1.medium.com/max/2000/1*_vb4tu4Vvi8b2Rg7hzf5NQ.png)

* **样条曲线（spline）** 是一种用多项式分段定义的特殊函数。在计算机图形学中，样条曲线是一种分段多项式参数化曲线。由于结构的简单性、评估的简易和高精度、通过曲线拟合和交互曲线设计以逼近复杂曲线的能力，样条曲线很常用。
* **广义加性模型（generalized additive model）** 是一种广义线性模型，其中线性预测器线性依赖于某些预测器变量的未知平滑函数，其主要作用就是推测这些平滑函数。

## 8 — 基于树的方法：

基于树的方法可以用于回归和分类问题，包括将预测因子的空间分层或分割成几个简单区域。由于用于预测器空间的分离规则集合可以总结为一个树，这类方法被称为**决策树**方法。以下的方法是几种不同的树，它们可以组合起来输出单个一致的预测。

* **Bagging** 能减少预测的方差，即通过从原始数据中生成额外的数据（通过组合和重复生成和原始数据大小相同的多段数据）用于训练。通过增大训练集无法提高模型的预测能力，只能减小方差，仔细地调整预测以得到期望的输出。
* **Boosting** 是一种使用多个不同的模型计算输出，然后使用加权平均方法对结果进行平均的方法。将这些方法的优点和缺点结合起来，通过改变加权公式，您可以使用不同的更细致的调优模型，对更广泛的输入数据产生良好的预测力。

![](https://cdn-images-1.medium.com/max/2000/1*W70TAcPDXVexTL6JNED6OA.png)

* **随机森林算法（random forest algorithm）** 实际上和 bagging 算法很相似，都是对训练集提取随机 bootstrap 样本。不过，除了 bootstrap 样本以外，还可以提取特征的随机子集来训练单个树；而在 bagging 中，需要给每个树提供整个特征集。由于特征选择是随机的，相比常规的 bagging 算法，每个树之间更加独立，从而通常能获得更好的预测性能（得益于更好的方差—偏差权衡）。由于每个树只需要学习特征的一个子集，所以计算速度也更快。

## 9 — 支持向量机：

![](https://cdn-images-1.medium.com/max/2000/1*MStS2dBWSZo8iJPiL2_uXg.png)

支持向量机（SVM）是一种常用的监督学习分类技术。通俗地说，它用于寻找对两类点集做出最佳分离的超平面（hyperplane，在 2D 空间中是线，在 3D 空间中是面，在高维空间中是超平面。更正式的说法是，一个超平面是一个 n 维空间的 n-1 维子空间）。而支持向量机是保留最大的间隔的分离超平面，因此本质上，它是一个约束最优化问题，其中支持向量机的间隔在约束下被最大化，从而完美地对数据进行分类（硬间隔分类器）。

"支持"超平面的数据点被称为"支持向量"。在上图中，填充蓝色圆和两个填充方块就是支持向量。在两类数据不是线性可分的例子中，数据点将被投射到一个更高维空间中，使得数据变得线性可分。包含多个类别的数据点的问题可以分解成多个"一对一"（one-versus-one）或"一对剩余"（one-versus-rest）的二分类问题。

## 10 — 无监督学习：

目前为止，我们都只讨论过监督学习技术，其中数据分类都是已知的，且提供给算法的经验都是实体和其分类的关系。当数据的分类是未知的时候，就需要使用另一种技术了。它们被称为无监督的，因为它们需要自己去发现数据中的模式。聚类（clustring）是无监督学习的一种，其中数据将根据相关性被分为多个集群。下方是几种最常用的无监督学习算法：

![](https://cdn-images-1.medium.com/max/2000/1*DwqQu4oiGTsa5L--DD0v6Q.jpeg)

* **主成分分析** 通过识别具备最大方差和互不相关的特征之间的线性连接，帮助生成数据集的低维表示。该线性降维技术有助于理解无监督学习中的隐变量交互。
* **k-Means 聚类**：根据数据到集群中心的距离将其分成 k 个不同的集群。
* **层次聚类**：通过创建集群树来构建集群的多级层次结构。

这是一些基本统计技术的基本运用，它们可以帮助数据科学项目经理和/或执行人员更好地了解他们的数据科学团队的内部运行情况。事实上，一些数据科学团队纯粹是通过 python 和 R 语言库运行算法。他们中的大多数甚至不需要考虑基础的数学。但是，能够理解统计分析的基础知识可以为您的团队提供更好的方法。洞察最小的部分可以使操作和抽象更容易。希望本基础数据科学统计指南能给您一个很好的理解！

**你可以从[我的 Github 源代码]获得所有讲座的幻灯片和 RStudio 课程（https://github.com/khanhnamle1994/statistical-learning）感谢你的热情回复。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
