> * 原视频地址：[Andrew Godwin - Taking Django Async - PyCon 2018](https://www.youtube.com/watch?v=-7taKQnndfo)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/talking-django-async-pycon-2018.md](https://github.com/xitu/gold-miner/blob/master/TODO1/talking-django-async-pycon-2018.md)
> * 译者：[geniusq1981](https://github.com/geniusq1981/)
> * 校对者：[mingxing47](https://github.com/mingxing47)

# Andrew Godwin — Django 异步 — PyCon 2018

> 本文为 PyCon 2018 视频之 Andrew Godwin - Taking Django Async 的中文字幕，您可以搭配原视频食用。

00:00:00,560 --> 00:00:15,660

大家好，让我们热烈欢迎 Andrew Godwin！

00:00:15,660 --> 00:00:19,109

大家下午好，今天我在这里和大家

00:00:19,109 --> 00:00:22,619

一起分享如何更好地使用 Django 异步特性。

00:00:22,619 --> 00:00:25,289

好吧，我们现在开始。

00:00:25,289 --> 00:00:28,410

先给还不认识我的人做一个简单的自我介绍。

00:00:28,410 --> 00:00:31,769

我是...

00:00:31,769 --> 00:00:33,210

点击器有些不太好用。很有趣，是不是？

00:00:33,210 --> 00:00:45,210

我是 Andrew Godwin，

00:00:45,210 --> 00:00:47,489

近段时间比较出名的 Django 核心团队队的一员。

00:00:47,489 --> 00:00:50,010

我过去主要在做

00:00:50,010 --> 00:00:53,010

Django migrations 的工作,，而最近

00:00:53,010 --> 00:00:54,840

我的工作重心集中在 channels。

00:00:54,840 --> 00:00:57,600

这也是这次演讲的主要内容。

00:00:57,600 --> 00:00:59,609

我是一名在 Eventbrite 工作的高级软件工程师。

00:00:59,609 --> 00:01:01,859

可能你不太了解，

00:01:01,859 --> 00:01:03,899

我们是一家运营演出，比赛以及

00:01:03,899 --> 00:01:05,760

类似的活动的票务公司。

00:01:05,760 --> 00:01:08,729

另外出于兴趣我还做了一个网络编程方面的

00:01:08,729 --> 00:01:11,460

有趣的个人项目，

00:01:11,460 --> 00:01:13,680

正如你看到的，大概只有失去理智的人

00:01:13,680 --> 00:01:18,840

才愿意这么做吧，让我们开始吧。

00:01:18,840 --> 00:01:21,479

先来讲一点历史。

00:01:21,479 --> 00:01:24,030

我于 2015 年开始了 channels（库）后端的工作，

00:01:24,030 --> 00:01:27,110

它有点像是一类新兴项目。

00:01:27,110 --> 00:01:29,220

当时 migrations 已经基本上完成了，

00:01:29,220 --> 00:01:31,140

已经被合并到 Django 中，

00:01:31,140 --> 00:01:32,939

Django 团队的其他成员接管了维护的工作，

00:01:32,939 --> 00:01:35,280

这里要感谢马科斯。

00:01:35,280 --> 00:01:37,290

所以那时我开始希望解决新的问题

00:01:37,290 --> 00:01:39,920

我脑海中的新问题是

00:01:39,920 --> 00:01:42,420

WebSockets 或者其他新的网络协议。

00:01:42,420 --> 00:01:44,750

所以特别之处就是

00:01:44,750 --> 00:01:49,290

channels 从 0.1 到 1.0

00:01:49,290 --> 00:01:51,930

都有一些基本的总体目标。

00:01:51,930 --> 00:01:53,850

核心是要增加一个支持 Django 的

00:01:53,850 --> 00:01:56,040

异步通信协议，

00:01:56,040 --> 00:01:57,869

而不仅仅是像 HTTP 那样只有 request 和 response 的协议，

00:01:57,869 --> 00:02:00,390

而是需要一个持续的 socket。

00:02:00,390 --> 00:02:02,880

当你打开一个 socket，

00:02:02,880 --> 00:02:04,829

然后发送一些信息，接受一些信息，

00:02:04,829 --> 00:02:06,960

它会持续更长的时间。

00:02:06,960 --> 00:02:08,819

相比 HTTP 协议的

00:02:08,819 --> 00:02:10,739

单个的请求、响应来说，

00:02:10,739 --> 00:02:13,569

socket 可以让你连接更多的会话。

00:02:13,569 --> 00:02:15,939

所以很明显，主要协议是 Websockets。

00:02:15,939 --> 00:02:18,790

它能同时支持很多（连接），

00:02:18,790 --> 00:02:20,590

现在也相当受欢迎，

00:02:20,590 --> 00:02:22,090

并且已经被用于很多

00:02:22,090 --> 00:02:24,549

网络上非常有趣的应用，

00:02:24,549 --> 00:02:26,499

比如一些实时应用以及游戏相关应用。

00:02:26,499 --> 00:02:28,659

但是除了 WebSockets，

00:02:28,659 --> 00:02:30,040

我还希望能包含更多的协议。

00:02:30,040 --> 00:02:31,840

我开始对其他我所听过的协议进行准备。

00:02:31,840 --> 00:02:35,200

所有以上这些的结果就是，

00:02:35,200 --> 00:02:36,310

在 2017 推出了 channels 1.0。

00:02:36,310 --> 00:02:39,579

它是经过两年辛苦努力的一个工作成果，

00:02:39,579 --> 00:02:43,150

至少我觉得它已经稳定，

00:02:43,150 --> 00:02:44,680

已经可以在生产环境下使用，

00:02:44,680 --> 00:02:46,780

总体来说它非常棒。

00:02:46,780 --> 00:02:48,819

之前我提到的很多目标也已经实现，

00:02:48,819 --> 00:02:50,560

但是还是存在一些问题。

00:02:50,560 --> 00:02:54,069

在设计之初我做出过一些抉择，

00:02:54,069 --> 00:02:56,530

我记得是 2015 年刚开始的时候，

00:02:56,530 --> 00:02:59,919

现在都已经三年过去了，

00:02:59,919 --> 00:03:01,959

那时我认为需要兼容 Python 2，

00:03:01,959 --> 00:03:04,510

那时的 Django 还是 Django LTS，

00:03:04,510 --> 00:03:06,879

没有考虑到 Django 2 的兼容，

00:03:06,879 --> 00:03:10,180

所以我选择了 Python 2.7

00:03:10,180 --> 00:03:12,459

作为基础支持的语言，

00:03:12,459 --> 00:03:15,099

而且这贯穿在所有的异步输入输出的支持中。

00:03:15,099 --> 00:03:17,620

然后，我又选择了 Twisted Web 服务器，

00:03:17,620 --> 00:03:19,629

因为它的可靠性非常高，

00:03:19,629 --> 00:03:20,919

可以通过插件的方式实现很多功能，

00:03:20,919 --> 00:03:25,329

比如 Autobahn 和 WebSockets。

00:03:25,329 --> 00:03:27,669

我没有改动 Django 的同步代码，

00:03:27,669 --> 00:03:29,229

我想保持这些熟悉的代码。

00:03:29,229 --> 00:03:31,359

在这个过程中，我没有重写太多的 Django 代码

00:03:31,359 --> 00:03:33,639

所以到最后，

00:03:33,639 --> 00:03:36,370

您可能会有这样的想法，

00:03:36,370 --> 00:03:38,799

您感觉看到一个看起来有点怪怪的设计。

00:03:38,799 --> 00:03:41,290

您有一个 twisted web 服务器，

00:03:41,290 --> 00:03:43,030

它能够支持高并发请求，

00:03:43,030 --> 00:03:44,680

一次能很容易地处理数百个 sockets，

00:03:44,680 --> 00:03:47,109

但同时你有一个同步的 Django 进程，

00:03:47,109 --> 00:03:49,569

它在一个大的 for 循环中处理各种事务，

00:03:49,569 --> 00:03:51,069

一次只能处理一个事务，

00:03:51,069 --> 00:03:54,579

而这些在 Python 2 中当然不能共存。

00:03:54,579 --> 00:03:57,430

你无法这样做，

00:03:57,430 --> 00:03:59,799

所以我又增加了一个 channel 层，

00:03:59,799 --> 00:04:02,409

这是一个允许你脱离 Python 而使用的异步调度机制，

00:04:02,409 --> 00:04:04,479

在这里，你可以像运行一段独立代码段一样

00:04:04,479 --> 00:04:07,269

地运行它。

00:04:07,269 --> 00:04:09,939

在这种情况下，我使用了 Redis 来驱动

00:04:09,939 --> 00:04:11,909

这里面的异步行为。

00:04:11,909 --> 00:04:14,949

当然，这样做有点复杂，

00:04:14,949 --> 00:04:17,769

但同时也能带来更多好处。

00:04:17,769 --> 00:04:19,810

当你考虑需要多台服务器和需要多个 Django 进程，

00:04:19,810 --> 00:04:21,430

它会表现得更好。

00:04:21,430 --> 00:04:23,560

因为大多数网站不会只使用一个服务器，

00:04:23,560 --> 00:04:25,870

所以你要做的是，

00:04:25,870 --> 00:04:26,790

如之前讲过的一样，

00:04:26,790 --> 00:04:29,550

你使用一组 twisted

00:04:29,550 --> 00:04:30,840

服务器组，

00:04:30,840 --> 00:04:32,520

它们都通过一个中间层，

00:04:32,520 --> 00:04:34,350

进入一个大的

00:04:34,350 --> 00:04:36,900

进程服务器池。

00:04:36,900 --> 00:04:39,150

一旦收到一个 WebSocket 的事件，

00:04:39,150 --> 00:04:41,850

就会通过这个网络找到

00:04:41,850 --> 00:04:43,710

一个 Django 进程，运行其中的代码，

00:04:43,710 --> 00:04:45,390

等待完成后把结果返回给 twisted 服务器。

00:04:45,390 --> 00:04:49,530

所以，在 Python 2.7 中，

00:04:49,530 --> 00:04:52,020

这些就是所有你能做到的。

00:04:52,020 --> 00:04:54,210

我被自己最开始的选择给限制了！

00:04:54,210 --> 00:04:56,160

你可以想象一下，

00:04:56,160 --> 00:04:58,260

它有太多的移动片段，

00:04:58,260 --> 00:05:00,360

这个导致我们不能在应用栈中间

00:05:00,360 --> 00:05:02,400

不能有大的网络层，

00:05:02,400 --> 00:05:04,260

你最终会需要他们

00:05:04,260 --> 00:05:05,520

我们在 Eventbrite 学到的一件事情是

00:05:05,520 --> 00:05:07,350

就像这样设计一个面向服务的架构

00:05:07,350 --> 00:05:09,240

同时会涉及要解决很多这样那样的问题

00:05:09,240 --> 00:05:11,460

但是大部分人并不需要那些。

00:05:11,460 --> 00:05:13,320

Django 作为一个框架，

00:05:13,320 --> 00:05:15,270

不需要帮助你去做那些事情，

00:05:15,270 --> 00:05:18,150

在这样的基础上，它没有提供任何异步 IO 的 支持

00:05:18,150 --> 00:05:21,210

这段时间，Python 3 非常常见了

00:05:21,210 --> 00:05:24,270

大部分工作已经在 Python 3 下开始

00:05:24,270 --> 00:05:26,610

我们正处于一个令人惊叹的时间点

00:05:26,610 --> 00:05:29,250

我们在 pipe 上有各种库

00:05:29,250 --> 00:05:31,320

拥抱 Python 3 吧，不要在 Python 2 上工作了，

00:05:31,320 --> 00:05:33,450

虽然 Python 2 如此的了不起，

00:05:33,450 --> 00:05:35,280

感觉它就像一件来自过去的神器，

00:05:35,280 --> 00:05:37,830

这是对 Python 2.7 的最后一次欢呼声了。

00:05:37,830 --> 00:05:42,090

最后，这个设计

00:05:42,090 --> 00:05:43,680

使得我们有一种作茧自缚的感觉。

00:05:43,680 --> 00:05:45,360

因为充斥着

00:05:45,360 --> 00:05:47,250

奇怪的同步进程，

00:05:47,250 --> 00:05:49,140

核心部分工作得不是很好，

00:05:49,140 --> 00:05:51,870

很多部件都是从零开始写的，

00:05:51,870 --> 00:05:53,850

有点太容易，所有很多无法实现

00:05:53,850 --> 00:05:55,440

比如不是死锁，就能锁定一个 worker 进程，

00:05:55,440 --> 00:05:58,020

或者让某些运行过长时间

00:05:58,020 --> 00:05:59,640

总体来说，

00:05:59,640 --> 00:06:01,890

你不能像完全异步支持那样做同样多的事情

00:06:01,890 --> 00:06:04,830

所以这是一件

00:06:04,830 --> 00:06:06,180

需要我花些时间去做的事情。

00:06:06,180 --> 00:06:08,070

我必须静下来整理下然后从头开始。

00:06:08,070 --> 00:06:10,170

即使需要这样做，那我也必须承认我过去得做法是错误的。

00:06:10,170 --> 00:06:11,940

我认为很重要的是说，对于大型的项目，

00:06:11,940 --> 00:06:14,190

像我这样的情况，不得不做这么大的一个转弯，

00:06:14,190 --> 00:06:17,160

这个是非常困难的。

00:06:17,160 --> 00:06:19,800

这完全改变了你对这个问题的分析，

00:06:19,800 --> 00:06:21,750

但是这个时候，我仍然要说 channels 1.0 是一个

00:06:21,750 --> 00:06:23,970

非常好的研究项目

00:06:23,970 --> 00:06:25,890

它完成了我之前设想的大部分目标

00:06:25,890 --> 00:06:29,220

尽管它不是一个长期的解决方案。

00:06:29,220 --> 00:06:32,070

那么 Djongo 的长期解决方案是什么？

00:06:32,070 --> 00:06:35,400

Python 看起来很好，就是这样

00:06:35,400 --> 00:06:36,630

我已经尝试在 channels 2 中去完成这些

00:06:36,630 --> 00:06:39,240

channels 2.0 已经在今年的

00:06:39,240 --> 00:06:40,080

稍早前发布了，

00:06:40,080 --> 00:06:43,710

对比 channels 前几次的迭代，

00:06:43,710 --> 00:06:45,840

这次是一个变化相当显著的版本。

00:06:45,840 --> 00:06:47,880

接下来，我要进入剩下的介绍，

00:06:47,880 --> 00:06:49,770

其中的变更内容介绍

00:06:49,770 --> 00:06:52,620

和如何通过它的表面价值

00:06:52,620 --> 00:06:55,009

去获取更多价值。

00:06:55,009 --> 00:06:57,720

从整体上重新思考我对 Django 和 web 流的看法

00:06:57,720 --> 00:07:00,060

关于 channels 2，对我来说重要的事情

00:07:00,060 --> 00:07:03,270

第一个也是最重要的是

00:07:03,270 --> 00:07:05,819

原生的异步支持。

00:07:05,819 --> 00:07:07,650

这是我们重写的最重要的原因

00:07:07,650 --> 00:07:09,690

当然这么做也就意味着要使用 Python 3.5

00:07:09,690 --> 00:07:11,310

在这里异步 IO 已成为标准库

00:07:11,310 --> 00:07:13,770

更重要的是我想

00:07:13,770 --> 00:07:15,810

使用 Python 3.5 提供的异步 DEF 关键字

00:07:15,810 --> 00:07:19,110

而且我想不光支持异步代码，

00:07:19,110 --> 00:07:21,870

也希望支持同步代码

00:07:21,870 --> 00:07:24,060

这个我们稍后会讨论到

00:07:24,060 --> 00:07:26,160

但是在我看来

00:07:26,160 --> 00:07:28,139

重要的是要有能力去同时支持

00:07:28,139 --> 00:07:30,599

那些不同的东西

00:07:30,599 --> 00:07:33,000

所以把这个也考虑进去。

00:07:33,000 --> 00:07:34,560

在 Python web 编程的历史上，

00:07:34,560 --> 00:07:38,009

有一个更被人熟知的模型 channels 像这样运行

00:07:38,009 --> 00:07:40,770

它像普通的 Python web 允许的那样运行

00:07:40,770 --> 00:07:43,020

你有一个 web 服务器

00:07:43,020 --> 00:07:45,419

在这个 web 服务器上你运行你的应用程序

00:07:45,419 --> 00:07:47,430

在这种情况下

00:07:47,430 --> 00:07:51,509

你运行 Django，它非常简单，

00:07:51,509 --> 00:07:53,400

有一个移动的片段，没有网络层

00:07:53,400 --> 00:07:55,139

隐藏在那里会导致错误

00:07:55,139 --> 00:07:58,440

还有一个需求是跨进程间的通信

00:07:58,440 --> 00:08:00,750

其中一个是

00:08:00,750 --> 00:08:03,090

你会发现使用 WebSockets 的问题

00:08:03,090 --> 00:08:05,009

尤其是你的应用程序

00:08:05,009 --> 00:08:07,020

需要服务之间更多的协调

00:08:07,020 --> 00:08:09,659

和交叉串扰等等

00:08:09,659 --> 00:08:10,889

channels 提供的一项内容

00:08:10,889 --> 00:08:13,199

还是那个 crosstalk 层

00:08:13,199 --> 00:08:14,820

channel 层还是在那里，但是它

00:08:14,820 --> 00:08:17,130

现在是一个可选的部件

00:08:17,130 --> 00:08:18,750

而且大部分的流量不会通过它

00:08:18,750 --> 00:08:21,570

它仅用于广播和进程到进程的消息

00:08:21,570 --> 00:08:23,699

如果你正在写一个聊天室的应用

00:08:23,699 --> 00:08:25,979

它就是你需要的

00:08:25,979 --> 00:08:28,229

你可以说，发送这条信息给

00:08:28,229 --> 00:08:29,580

所有其他正在这些 sockets 收听的人

00:08:29,580 --> 00:08:32,940

它将那么做。

00:08:32,940 --> 00:08:35,849

而且它也更加简单，另外也更加容易保持

00:08:35,849 --> 00:08:37,890

因为他不需要

00:08:37,890 --> 00:08:39,630

再去完成中间的作用

00:08:39,630 --> 00:08:41,270

像过去做的那样

00:08:41,270 --> 00:08:44,070

最后的结果是不需要完全重写 channels

00:08:44,070 --> 00:08:46,110

大约 75% 被重写

00:08:46,110 --> 00:08:48,690

所有的过去明显

00:08:48,690 --> 00:08:51,720

奇怪的同步代码都要

00:08:51,720 --> 00:08:53,070

被重写

00:08:53,070 --> 00:08:55,650

twisted 的 code 没有被重写

00:08:55,650 --> 00:08:57,960

twist 它有非常好的异步支持

00:08:57,960 --> 00:08:59,580

所以我只是插入一个异步反应器

00:08:59,580 --> 00:09:00,870

并改变了很少的一点东西，让它继续工作

00:09:00,870 --> 00:09:03,060

但是余下的大部分需要修改

00:09:03,060 --> 00:09:04,590

特别是 Django 层

00:09:04,590 --> 00:09:08,070

而且当你来到这儿的时候

00:09:08,070 --> 00:09:10,830

你会发现一个严重问题

00:09:10,830 --> 00:09:13,980

就是你如何在 Python 中编写同步代码

00:09:13,980 --> 00:09:15,690

以及在 Python 中编写异步代码的方式。

00:09:15,690 --> 00:09:18,900

一个异步函数和一个同步函数

00:09:18,900 --> 00:09:21,150

有非常大的不同

00:09:21,150 --> 00:09:22,710

你不可能写出一个东西来

00:09:22,710 --> 00:09:26,160

满足所有的接口，也就是说

00:09:26,160 --> 00:09:28,230

基本不可能写出一个 API 来

00:09:28,230 --> 00:09:29,850

同时提供同步版本和异步版本，

00:09:29,850 --> 00:09:32,190

你也不得不坐在那里

00:09:32,190 --> 00:09:34,350

把所有的东西编写两遍。

00:09:34,350 --> 00:09:35,880

这就是其中一个原因

00:09:35,880 --> 00:09:38,040

你看到单独的库，这就比如

00:09:38,040 --> 00:09:39,840

当你同步使用 HTTP 时，要讨论各种异步

00:09:39,840 --> 00:09:42,110

它们就是不一样的接口，

00:09:42,110 --> 00:09:44,520

你不能在同样的地方操作同样的事情。

00:09:44,520 --> 00:09:47,700

所以我不得不静下来，

00:09:47,700 --> 00:09:49,860

去找到解决这个问题的方法。

00:09:49,860 --> 00:09:51,840

我不想重写

00:09:51,840 --> 00:09:54,840

把全部的 Django 的代码变成异步方式，

00:09:54,840 --> 00:09:57,210

即便我希望这么做，但是我只有一个人

00:09:57,210 --> 00:09:58,560

你知道我一周大概只有一天去做这个事情

00:09:58,560 --> 00:10:00,060

然后如果这么做，我们一直要到一千年以后

00:10:00,060 --> 00:10:03,600

才能完成，所以这个不是我

00:10:03,600 --> 00:10:05,000

面临的最大问题

00:10:05,000 --> 00:10:07,590

在我们深入下一步之前，如果你对于

00:10:07,590 --> 00:10:09,360

这个话题还有兴趣的话，

00:10:09,360 --> 00:10:11,790

你可以看看我的一个博客文章，

00:10:11,790 --> 00:10:14,790

那个里面介绍了一些背景知识去说明

00:10:14,790 --> 00:10:16,350

在 Python 里面异步和同步的差异在哪里

00:10:16,350 --> 00:10:18,210

它很好的覆盖了一些内容

00:10:18,210 --> 00:10:19,800

比如线程如何工作以及

00:10:19,800 --> 00:10:21,930

背后的含义是什么，

00:10:21,930 --> 00:10:23,610

我不打算在这里讲，而是作为背景知识阅读参考。

00:10:23,610 --> 00:10:26,250

对于他们为什么会不同

00:10:26,250 --> 00:10:28,440

这篇文章有相当高层次的看法。

00:10:28,440 --> 00:10:30,780

但是我们现在聊的核心是

00:10:30,780 --> 00:10:32,370

它们不相同，而且你找不到

00:10:32,370 --> 00:10:35,760

相同的方法，

00:10:35,760 --> 00:10:37,890

如果你想操作 WebSockets，

00:10:37,890 --> 00:10:39,420

你就不得不让 Django 部分支持异步。

00:10:39,420 --> 00:10:41,910

尤其是你在某些特定的地方必须使用异步，

00:10:41,910 --> 00:10:43,740

比如处理 sockets 的数据，

00:10:43,740 --> 00:10:44,910

处理基本业务逻辑，

00:10:44,910 --> 00:10:47,160

必须能够有

00:10:47,160 --> 00:10:49,470

在做其他事情的同时，

00:10:49,470 --> 00:10:51,870

长时间保持 socket 打开的能力。

00:10:51,870 --> 00:10:54,900

那么让我们聊一下 Django 是如何做的，

00:10:54,900 --> 00:10:58,950

Django 是一组基本层模型的序列

00:10:58,950 --> 00:11:01,530

这是一个简单的版本

00:11:01,530 --> 00:11:03,780

但是是我最喜欢的方式。

00:11:03,780 --> 00:11:05,730

认为 Django 是一系列

00:11:05,730 --> 00:11:06,840

互相层叠的层

00:11:06,840 --> 00:11:08,670

在最下面

00:11:08,670 --> 00:11:10,770

有一个 WSGI 处理程序

00:11:10,770 --> 00:11:14,220

获取输入的基本的原始 WSGI 请求

00:11:14,220 --> 00:11:17,190

转化成一个 Django 请求对象

00:11:17,190 --> 00:11:19,320

在那之上，你有一个 URL 路由来读取

00:11:19,320 --> 00:11:21,510

发现的请求对象，

00:11:21,510 --> 00:11:25,080

然后送到上层的视图，那里有

00:11:25,080 --> 00:11:27,150

中间件，所有在你检查之前

00:11:27,150 --> 00:11:28,830

你会运行一些中间件来增加一些

00:11:28,830 --> 00:11:30,930

信息，比如鉴权、时域等

00:11:30,930 --> 00:11:31,800

所有的信息。

00:11:31,800 --> 00:11:33,930

然后你来到了视图，

00:11:33,930 --> 00:11:35,670

这里是业务逻辑和展现层

00:11:35,670 --> 00:11:37,560

最后一层通常观点来看，我们讲 ORM

00:11:37,560 --> 00:11:40,050

关系对象映射。中间件我们也叫 RM

00:11:40,050 --> 00:11:41,580

但是这是一个简单的版本

00:11:41,580 --> 00:11:44,520

这个对于同步事务来说工作的很好

00:11:44,520 --> 00:11:47,250

但是我们需要想一下

00:11:47,250 --> 00:11:51,800

当异步的时候，如果反过来

00:11:51,800 --> 00:11:55,530

我们这样做，我们进入一个独立的层

00:11:55,530 --> 00:11:57,090

这里的事务在 Django 内部是

00:11:57,090 --> 00:11:59,490

异步的，并且

00:11:59,490 --> 00:12:00,600

通过堆栈复制了很多

00:12:00,600 --> 00:12:03,630

那样的行为，因此特别之处是

00:12:03,630 --> 00:12:06,690

不能使用普通的 Django URL 路由，

00:12:06,690 --> 00:12:07,950

我们必须有一个不同类型的路由

00:12:07,950 --> 00:12:10,440

具有并发的异步处理能力。

00:12:10,440 --> 00:12:14,730

就像其他东西一样，

00:12:14,730 --> 00:12:15,930

我们必须要有异步的中间件和

00:12:15,930 --> 00:12:17,670

异步视图，我们在 channels 调用，

00:12:17,670 --> 00:12:19,650

所以这些都

00:12:19,650 --> 00:12:20,790

与它们的同步组件相对应。

00:12:20,790 --> 00:12:23,340

但是有一件事情

00:12:23,340 --> 00:12:26,820

我不能轻易解决，那就是 RM。

00:12:26,820 --> 00:12:28,980

这里你可以见到，

00:12:28,980 --> 00:12:30,420

在左侧图中蓝色矩形标注出来的同步部分

00:12:30,420 --> 00:12:33,750

还是仍然需要调用同步 Django，

00:12:33,750 --> 00:12:36,690

不是只为了顶部的 RM

00:12:36,690 --> 00:12:40,590

也为了，不好意思，也为了

00:12:40,590 --> 00:12:42,870

如果你尝试调用一个正常的 Django 视图

00:12:42,870 --> 00:12:44,670

如果你有一个

00:12:44,670 --> 00:12:46,380

由 WebSockets 和普通 Django 混合的网站，

00:12:46,380 --> 00:12:48,360

当你想要使用普通的调用

00:12:48,360 --> 00:12:50,100

你必须使用正常的 Django，

00:12:50,100 --> 00:12:54,300

所以我把 WSGI 操作

00:12:54,300 --> 00:12:55,560

换成了异步的版本

00:12:55,560 --> 00:12:57,690

来创建请求对象，但是在

00:12:57,690 --> 00:12:58,860

某些时候你又不得不改为

00:12:58,860 --> 00:13:02,840

同步状态，我是如何这么做的呢

00:13:02,840 --> 00:13:05,510

你可以看那里，比如我已经让 Django

00:13:05,510 --> 00:13:08,100

变成原生异步，大部分是并行的方式。

00:13:08,100 --> 00:13:11,130

但是在某些位置我必须弥补

00:13:11,130 --> 00:13:14,490

差距，那确实

00:13:14,490 --> 00:13:17,850

导致了很多麻烦。

00:13:17,850 --> 00:13:20,040

数个周末的时间我都为此抓狂，

00:13:20,040 --> 00:13:21,930

抓狂的结果是

00:13:21,930 --> 00:13:25,980

产生了两个新的方法。

00:13:25,980 --> 00:13:29,029

第一个方法是 sync_to_async,（我的嗓子..,

00:13:29,029 --> 00:13:32,220

喝口水，好多了），第二个是

00:13:32,220 --> 00:13:34,380

async_to_sync. 我的看法是

00:13:34,380 --> 00:13:37,800

这两个方法联通了两个世界。

00:13:37,800 --> 00:13:39,540

sync_to_async 可以处理 Python 同步方法

00:13:39,540 --> 00:13:41,550

使方法与主线程分离，让它

00:13:41,550 --> 00:13:44,160

在一个后台线程中运行。

00:13:44,160 --> 00:13:46,380

async_to_sync 可以在异步过程中

00:13:46,380 --> 00:13:49,170

使用一个加权的球协程，

00:13:49,170 --> 00:13:50,880

会把它转成一个阻塞的同步方法

00:13:50,880 --> 00:13:53,610

这个方法把调用线程暂停，

00:13:53,610 --> 00:13:56,220

然后跳到主线程，那里有事件循环，

00:13:56,220 --> 00:13:57,810

在那里运行，

00:13:57,810 --> 00:13:59,149

然后再跳转回来

00:13:59,149 --> 00:14:03,269

这些就是关键部件，

00:14:03,269 --> 00:14:06,060

让我们找到方法使这两个世界交融

00:14:06,060 --> 00:14:10,350

并入 Django 中。

00:14:10,350 --> 00:14:12,089

关于这些特别的事情，

00:14:12,089 --> 00:14:13,579

让我再多讲一点技术细节。

00:14:13,579 --> 00:14:16,889

首先是 sync_to_async，

00:14:16,889 --> 00:14:20,790

这个有很多实现方式，也是两个里面比较简单的一种

00:14:20,790 --> 00:14:23,130

当然不是超级简单，

00:14:23,130 --> 00:14:24,360

只是你需要的大部分内容都可以由

00:14:24,360 --> 00:14:27,750

Python 的标准库提供，

00:14:27,750 --> 00:14:29,519

所有第一个明显的，不是明显的，第一个

00:14:29,519 --> 00:14:31,529

需要注意的，同步代码必须

00:14:31,529 --> 00:14:33,149

在线程中运行，所以我们会

00:14:33,149 --> 00:14:34,680

运行多个同步方法

00:14:34,680 --> 00:14:36,750

我们不能只是阻塞整个主线程

00:14:36,750 --> 00:14:38,790

那里异步事件循环在运行

00:14:38,790 --> 00:14:40,889

所以我们必须要有

00:14:40,889 --> 00:14:43,199

这些运行的子线程。

00:14:43,199 --> 00:14:45,420

Python 中的线程并不是很好

00:14:45,420 --> 00:14:47,279

上下文切换的效率有些低

00:14:47,279 --> 00:14:49,800

就像很多之前 Python 介绍说的那样

00:14:49,800 --> 00:14:51,300

但是它们也还是有用的，比如当你

00:14:51,300 --> 00:14:52,920

想简单运行一个方法

00:14:52,920 --> 00:14:55,139

并且再次弹出，

00:14:55,139 --> 00:14:57,329

标准库里有一个叫做

00:14:57,329 --> 00:14:59,550

线程池执行器的东西来做这个

00:14:59,550 --> 00:15:02,430

你可以说，我有一个任务，你可以生成一个

00:15:02,430 --> 00:15:04,470

线程池，然后你说在这个任务中运行这些代码，

00:15:04,470 --> 00:15:06,630

而这个任务运行在这个线程池中，

00:15:06,630 --> 00:15:09,209

然后给我返回结果。

00:15:09,209 --> 00:15:11,430

简单的代码实现像是这样

00:15:11,430 --> 00:15:13,949

这个代码之外，

00:15:13,949 --> 00:15:16,350

还应该添加更多的异常处理，但是

00:15:16,350 --> 00:15:18,660

基本流程是类似的。

00:15:18,660 --> 00:15:20,670

你找到你的事件循环，你创造一个 future 变量

00:15:20,670 --> 00:15:22,800

用来表明在一个线程池运行你的任务

00:15:22,800 --> 00:15:25,290

然后当线程池运行起来，你

00:15:25,290 --> 00:15:27,899

开始运行你的任务，

00:15:27,899 --> 00:15:30,089

你开始调用权重，

00:15:30,089 --> 00:15:32,279

使用 future 上的权重。

00:15:32,279 --> 00:15:33,700

然后合作的例行程序将

00:15:33,700 --> 00:15:35,740

等待 future 返回一次

00:15:35,740 --> 00:15:41,380

这样就完成了

00:15:41,380 --> 00:15:44,260

现在这个主要用于比如

00:15:44,260 --> 00:15:47,140

调用 ORM，渲染模板，

00:15:47,140 --> 00:15:48,580

Django 的其他部分，你看到的

00:15:48,580 --> 00:15:50,680

比如跨越边界。好吧，我需要

00:15:50,680 --> 00:15:52,990

聊一下过去的 Django 的关联内容，

00:15:52,990 --> 00:15:55,330

那就是同步。

00:15:55,330 --> 00:15:57,610

同步 Django 需要在一个线程中运行。

00:15:57,610 --> 00:15:59,880

ORM 是特别棘手的问题

00:15:59,880 --> 00:16:02,260

Django 有连接操作来拉取连接

00:16:02,260 --> 00:16:03,850

和线程，并且确保他们

00:16:03,850 --> 00:16:05,230

这些线程之间正确的共享。

00:16:05,230 --> 00:16:07,660

这在很大程度上依赖于请求和

00:16:07,660 --> 00:16:10,420

响应的顺序，

00:16:10,420 --> 00:16:12,580

所以我们必须要做一个事情是

00:16:12,580 --> 00:16:14,770

当你在一个线程中调用 arm，当

00:16:14,770 --> 00:16:16,150

线程结束时不要动，

00:16:16,150 --> 00:16:17,650

先把所有东西清理干净。

00:16:17,650 --> 00:16:19,300

我们需要关闭连接。

00:16:19,300 --> 00:16:22,030

这看起来有些奇怪

00:16:22,030 --> 00:16:24,130

如果很不幸的话，你可能遇到这样的情况，

00:16:24,130 --> 00:16:25,390

你在结束的时候有大量的出站连接。

00:16:25,390 --> 00:16:28,480

线程池默认上限是

00:16:28,480 --> 00:16:30,970

你机器 CPU 数量的 5 倍，

00:16:30,970 --> 00:16:33,070

所以如果你是一个 16 核的机器，

00:16:33,070 --> 00:16:34,510

你将有超过一百个线程

00:16:34,510 --> 00:16:36,940

都试图去连接接数据库。

00:16:36,940 --> 00:16:39,550

这很让人惊讶，

00:16:39,550 --> 00:16:42,160

但是你可以调整这些东西。

00:16:42,160 --> 00:16:43,330

而一般来说，越小的东西它会工作的确实越好

00:16:43,330 --> 00:16:46,330

不过接下来

00:16:46,330 --> 00:16:48,300

会是更加困难的问题。

00:16:48,300 --> 00:16:51,430

sync_to_async 已经很好的内置在

00:16:51,430 --> 00:16:54,670

Python 的 chat 内核中。我认为 3.7

00:16:54,670 --> 00:16:56,080

对这个会有更好的支持

00:16:56,080 --> 00:16:58,660

第二个方面的东西不太常见，

00:16:58,660 --> 00:17:03,490

这是因为异步代码

00:17:03,490 --> 00:17:06,460

需要在一个事件循环中运行，它需要

00:17:06,460 --> 00:17:07,780

能给它提供一个等待，

00:17:07,780 --> 00:17:09,280

并且提供一种方法来产生中断，

00:17:09,280 --> 00:17:13,210

如果你在一个

00:17:13,210 --> 00:17:14,980

进程中运行，

00:17:14,980 --> 00:17:16,750

在主线程中已经有一个事件循环。

00:17:16,750 --> 00:17:18,850

当你把两者嵌套的时候，

00:17:18,850 --> 00:17:21,400

特别的问题就出现了

00:17:21,400 --> 00:17:23,590

这么说把，我所做的是

00:17:23,590 --> 00:17:25,270

在同步的主线程中

00:17:25,270 --> 00:17:27,310

调用异步的方法。好吧我们现在

00:17:27,310 --> 00:17:29,710

在一个同步的子线程中，

00:17:29,710 --> 00:17:31,240

我想在 channels 中去调用

00:17:31,240 --> 00:17:33,490

它们的异步 API，所以

00:17:33,490 --> 00:17:36,610

我们退出线程，回到主线程，

00:17:36,610 --> 00:17:38,710

找到事件循环，然后

00:17:38,710 --> 00:17:41,290

再次回来继续向下进行

00:17:41,290 --> 00:17:44,200

不，非常感谢。

00:17:44,200 --> 00:17:46,060

这个有点棘手。

00:17:46,060 --> 00:17:47,710

代码并不像屏幕上显示的这么具有可读性，这个是故意的。

00:17:47,710 --> 00:17:50,500

不必担心。虽然它比这复杂的多，

00:17:50,500 --> 00:17:52,120

但它的基本流程是这样的，它试图

00:17:52,120 --> 00:17:54,659

向上找到那个线程，

00:17:54,659 --> 00:17:57,760

你也可以在子线程中，

00:17:57,760 --> 00:17:59,140

尝试并打开一个新的事件循环。

00:17:59,140 --> 00:18:00,880

因为 Python 可以让你运行足够多的事件循环

00:18:00,880 --> 00:18:02,770

像你想要的那样，但是

00:18:02,770 --> 00:18:04,059

那样会降低效率，因为你

00:18:04,059 --> 00:18:05,409

运行的循环越多，就会有越多的 sockets。

00:18:05,409 --> 00:18:07,720

所以

00:18:07,720 --> 00:18:09,309

channel 试图去做的事情是，

00:18:09,309 --> 00:18:10,750

如果你需要异步方法，它会返回并

00:18:10,750 --> 00:18:12,070

尝试在主循环中运行它。

00:18:12,070 --> 00:18:16,299

为什么我需要这样做？

00:18:16,299 --> 00:18:20,230

好，主要原因还是我

00:18:20,230 --> 00:18:24,340

只想针对一种东西编写一次代码。

00:18:24,340 --> 00:18:26,770

特别是我不想重写 channels 的认证

00:18:26,770 --> 00:18:29,620

而如果你想要一个可以在两者

00:18:29,620 --> 00:18:31,990

都可以运行的统一的 API

00:18:31,990 --> 00:18:33,940

我想编写一次，然后存在一个兼容层

00:18:33,940 --> 00:18:36,490

类似这两个方法一样，可以

00:18:36,490 --> 00:18:39,370

让它从另一个方面来说变的可用。

00:18:39,370 --> 00:18:40,870

所以不是使用同步的方式编写

00:18:40,870 --> 00:18:41,710

并且调用他们的线程

00:18:41,710 --> 00:18:43,149

我想使用未来的方式编写它们

00:18:43,149 --> 00:18:45,549

也就是使用异步运行的方式

00:18:45,549 --> 00:18:47,529

而且如果你想要使用旧的代码调用，

00:18:47,529 --> 00:18:50,649

你可以使用 async_to_sync 方法

00:18:50,649 --> 00:18:55,539

这样做确实减少了维护的工作量

00:18:55,539 --> 00:18:57,130

以及类似的事情

00:18:57,130 --> 00:18:59,169

因为我只需要写一套

00:18:59,169 --> 00:19:01,480

异步的 API，然后就可以在

00:19:01,480 --> 00:19:03,520

文档的任何地方说，嘿，如果你想要

00:19:03,520 --> 00:19:04,840

在一个同步循环中调用这些，只要

00:19:04,840 --> 00:19:07,299

使用 async_to_sync 转换一下。

00:19:07,299 --> 00:19:09,460

这确实有助于看起来像一个会话系统。

00:19:09,460 --> 00:19:11,740

所有 channel 明显提供的东西

00:19:11,740 --> 00:19:13,779

那些东西都在 Django 和 channel 中。

00:19:13,779 --> 00:19:15,580

但是

00:19:15,580 --> 00:19:16,899

还有其他东西，比如 channel 层。

00:19:16,899 --> 00:19:19,390

如果你想通过 Redis 给别人发送消息，

00:19:19,390 --> 00:19:21,399

给一群人发送广播，

00:19:21,399 --> 00:19:24,039

这些全都是原生异步的，

00:19:24,039 --> 00:19:26,860

使用 I/O Redis, 使用一个权重

00:19:26,860 --> 00:19:28,960

然后在所有地方异步，如果你

00:19:28,960 --> 00:19:30,669

像过去那样使用同步代码，那你

00:19:30,669 --> 00:19:32,559

就不能调用，这就是为什么 lacy 使用同步编写

00:19:32,559 --> 00:19:34,510

但是现在我们只需要

00:19:34,510 --> 00:19:37,000

说，嘿，它们看上去和这个同步，

00:19:37,000 --> 00:19:39,279

然后在你想要使用的地方运行它。

00:19:39,279 --> 00:19:41,260

你甚至可以在 channels 之外使用它。

00:19:41,260 --> 00:19:42,820

如果你只是在一个普通的同步应用中

00:19:42,820 --> 00:19:44,710

调用 async_to_sync,

00:19:44,710 --> 00:19:49,419

它会创造一个它自己的事件循环

00:19:49,419 --> 00:19:50,649

并且只在线程中运行，所以它

00:19:50,649 --> 00:19:53,140

真的非常实用，也很灵活

00:19:53,140 --> 00:19:54,970

在几乎每个你可能尝试

00:19:54,970 --> 00:19:56,470

并在一个同步的上下文中运行异步代码的地方

00:19:56,470 --> 00:19:59,830

这里的关键

00:19:59,830 --> 00:20:01,570

是我并不认为

00:20:01,570 --> 00:20:03,429

我们在一个地方只会写

00:20:03,429 --> 00:20:05,470

写一种代码，

00:20:05,470 --> 00:20:06,629

至少像目前表明的

00:20:06,629 --> 00:20:10,989

pythons 的异步机制不健全

00:20:10,989 --> 00:20:13,539

并且在某种程度上并不优于同步的支持

00:20:13,539 --> 00:20:16,029

它的编写更困难

00:20:16,029 --> 00:20:18,190

而且在某些特定的方面它更加危险

00:20:18,190 --> 00:20:20,529

比如如果你不是很熟悉 Python 3

00:20:20,529 --> 00:20:23,139

你就很可能会写出一个方法

00:20:23,139 --> 00:20:25,210

导致阻塞整个事件循环

00:20:25,210 --> 00:20:27,789

如果你还不知道

00:20:27,789 --> 00:20:29,919

对于事件循环有哪些好的调试模式

00:20:29,919 --> 00:20:31,629

可能整个事情都会被卡住一段时间

00:20:31,629 --> 00:20:33,309

一旦方法被阻塞住

00:20:33,309 --> 00:20:36,249

然后只能继续向前

00:20:36,249 --> 00:20:38,169

我真的不相信我自己能够

00:20:38,169 --> 00:20:40,629

写出好的异步代码。我不确定。

00:20:40,629 --> 00:20:43,149

我能相信一般的开发人员

00:20:43,149 --> 00:20:45,129

可以一直写下去，而且我也不认为

00:20:45,129 --> 00:20:48,309

他们应该这么做。我认为情况是

00:20:48,309 --> 00:20:50,729

当你需要高并发

00:20:50,729 --> 00:20:53,769

长保持支持的时候，那你可以使用异步

00:20:53,769 --> 00:20:56,080

如果你希望安全和简单，

00:20:56,080 --> 00:20:58,299

你可以使用同步。

00:20:58,299 --> 00:20:59,440

这确实就是 channels 所做的

00:20:59,440 --> 00:21:02,289

这也是为什么我要在这里保持

00:21:02,289 --> 00:21:04,179

两个系统，你可以只写

00:21:04,179 --> 00:21:06,279

同步的 Django 代码而让所有事情

00:21:06,279 --> 00:21:07,840

正常工作，而且向后是兼容。

00:21:07,840 --> 00:21:10,989

你也可以进入全新的闪亮的异步世界

00:21:10,989 --> 00:21:13,960

在那里处理所有事情

00:21:13,960 --> 00:21:15,369

你甚至可以有一个用户版本

00:21:15,369 --> 00:21:17,049

在用户层使用同步

00:21:17,049 --> 00:21:19,450

但是在 ORM 之前，

00:21:19,450 --> 00:21:20,919

如果你想要使用那样的方式写你的代码

00:21:20,919 --> 00:21:23,919

但是这个图表中的一部分

00:21:23,919 --> 00:21:25,950

还是非常有意思

00:21:25,950 --> 00:21:29,409

就是这个部分

00:21:29,409 --> 00:21:31,450

有一条来自图外的线

00:21:31,450 --> 00:21:35,499

指向我的图。现在在第一个图

00:21:35,499 --> 00:21:38,369

通常的 Django 1 是 WSGI

00:21:38,369 --> 00:21:41,049

我们都知道也喜欢 Everest GI

00:21:41,049 --> 00:21:41,979

它已经存在很久了

00:21:41,979 --> 00:21:45,940

它是一个非常成功的界面

00:21:45,940 --> 00:21:49,419

它让我们很自由的切换框架和服务器

00:21:49,419 --> 00:21:51,729

所以这让大量的

00:21:51,729 --> 00:21:53,289

新的服务器在 Python 中出现

00:21:53,289 --> 00:21:54,599

比如在我开始使用 Python 的时候

00:21:54,599 --> 00:21:57,190

你被限定在使用特定的服务器，

00:21:57,190 --> 00:21:58,869

和特定的框架，而不能使用

00:21:58,869 --> 00:22:00,940

其他的。所以我记得

00:22:00,940 --> 00:22:03,190

看到整个这一切，真的体会到

00:22:03,190 --> 00:22:04,899

它带来的自由，就比如

00:22:04,899 --> 00:22:06,359

在不同的事情之间切换

00:22:06,359 --> 00:22:10,720

使用 WSGI 的问题是非常

00:22:10,720 --> 00:22:12,279

同步性的，而且它非常依赖于

00:22:12,279 --> 00:22:14,259

HTTP 的请求/响应

00:22:14,259 --> 00:22:15,400

模型

00:22:15,400 --> 00:22:20,200

它是按照这种方式建立的，

00:22:20,200 --> 00:22:22,150

你有一个方法，你使用请求调用这个方法

00:22:22,150 --> 00:22:23,730

返回一个响应

00:22:23,730 --> 00:22:27,610

没有真正可供选择的地方

00:22:27,610 --> 00:22:29,440

让你可以把这个方法保持一段时间

00:22:29,440 --> 00:22:30,850

它不是异步的方法

00:22:30,850 --> 00:22:32,710

它来自于 Python 2 的年代

00:22:32,710 --> 00:22:35,320

所以你必须考虑

00:22:35,320 --> 00:22:37,540

如何对待这样情况，使它可以

00:22:37,540 --> 00:22:40,809

为异步工作。我的第一次尝试，如同你看到的，

00:22:40,809 --> 00:22:42,610

不是很大，就是一个奇怪的

00:22:42,610 --> 00:22:45,790

网络层，但是 channels 使用

00:22:45,790 --> 00:22:48,429

的这个版本我还是相当自豪

00:22:48,429 --> 00:22:50,559

我认为它对于那类东西是个很好的替代

00:22:50,559 --> 00:22:54,040

它被称为 ASGI

00:22:54,040 --> 00:22:56,140

因为它就像 WSGI 一样，

00:22:56,140 --> 00:22:56,530

在里面换成一个 A

00:22:56,530 --> 00:22:59,200

这是一个非常有创意的命名

00:22:59,200 --> 00:23:01,210

它基本上是 WSGI 的一个异步版本

00:23:01,210 --> 00:23:03,700

我在这里一个简要的介绍

00:23:03,700 --> 00:23:07,300

那么你的标准的 WSGI 应用

00:23:07,300 --> 00:23:09,460

像这样的，

00:23:09,460 --> 00:23:12,070

你有一个应用，它处理两件事情和

00:23:12,070 --> 00:23:15,250

是一个来自外部的

00:23:15,250 --> 00:23:16,570

字典数据 environ，

00:23:16,570 --> 00:23:18,760

包含的东西比如这是标题，

00:23:18,760 --> 00:23:20,830

这是请求，这是 HTTP 的参数，

00:23:20,830 --> 00:23:22,540

所有东西就在那里，然后启动相应，

00:23:22,540 --> 00:23:24,309

你可以使用回调来发送头文件

00:23:24,309 --> 00:23:27,190

你就得到你的 environ，

00:23:27,190 --> 00:23:29,110

你通过它来运转就像 Django 的 requests 一样

00:23:29,110 --> 00:23:31,059

读取 environ，

00:23:31,059 --> 00:23:32,890

把它的各个部分组成一个完整的 request 对象

00:23:32,890 --> 00:23:34,929

然后做路径分析

00:23:34,929 --> 00:23:36,940

然后一旦你完成了你的

00:23:36,940 --> 00:23:38,860

业务逻辑，你就调用 start_response

00:23:38,860 --> 00:23:40,840

在你的响应代码中发送头文件

00:23:40,840 --> 00:23:42,880

然后你只需要使用 yield 或者

00:23:42,880 --> 00:23:46,120

返回通过 socket 发送的数据

00:23:46,120 --> 00:23:50,050

你可以看出，它擅长于

00:23:50,050 --> 00:23:50,590

做长保持的连接

00:23:50,590 --> 00:23:52,059

但是它已经很接近了

00:23:52,059 --> 00:23:55,059

ASGI 看起来有点不同

00:23:55,059 --> 00:23:57,550

看这里，第一个大的不同是

00:23:57,550 --> 00:24:00,970

它是一个真正的类，

00:24:00,970 --> 00:24:02,590

一个可以调用的真正的接口

00:24:02,590 --> 00:24:04,420

返回一个回调，如你这里看到的这样。

00:24:04,420 --> 00:24:06,490

这个类有一个核心方法，但这是

00:24:06,490 --> 00:24:08,950

解释它的最简单的方法。

00:24:08,950 --> 00:24:10,660

你第一次调用它的时候，你给他范围

00:24:10,660 --> 00:24:13,990

范围就像 environ

00:24:13,990 --> 00:24:15,940

它是一个这样一个地方，

00:24:15,940 --> 00:24:18,010

所有和连接相关的数据都在那里

00:24:18,010 --> 00:24:20,410

当连接发生的时候

00:24:20,410 --> 00:24:22,809

所以对于 HTTP 来说，这些东西比如路径，

00:24:22,809 --> 00:24:24,700

方法，头信息等。

00:24:24,700 --> 00:24:26,290

Web Sockets 很类似，啊

00:24:26,290 --> 00:24:28,150

这是 WebSocket 的路径，这是

00:24:28,150 --> 00:24:29,100

WebSocket 的头信息

00:24:29,100 --> 00:24:31,019

这是它们需要的子协议

00:24:31,019 --> 00:24:33,269

但是对于其他协议，可以不同，

00:24:33,269 --> 00:24:35,519

比如，你是一个聊天机器人

00:24:35,519 --> 00:24:37,710

这个可以是你的聊天机器人呆的一个房间

00:24:37,710 --> 00:24:39,570

举个例子，或者 TCP 端点以及类似的东西

00:24:39,570 --> 00:24:42,750

所以你

00:24:42,750 --> 00:24:45,480

获取这些信息，然后第二个

00:24:45,480 --> 00:24:48,240

回调是一个 call 例程，

00:24:48,240 --> 00:24:50,330

你得到两个事情获取一个同意

00:24:50,330 --> 00:24:54,389

因为我们已经抛弃了那种想法

00:24:54,389 --> 00:24:56,820

就是请求发生的时候连接打开

00:24:56,820 --> 00:24:58,980

因为在 WebSocket 中

00:24:58,980 --> 00:25:00,450

你可以打开它，然后在任意时间发送

00:25:00,450 --> 00:25:03,570

我们已经取消了这样的开始请求

00:25:03,570 --> 00:25:06,059

从范围开始，我们在 init 里面

00:25:06,059 --> 00:25:08,460

做更多事情，下来进入 _call_ 方法

00:25:08,460 --> 00:25:10,950

所以发生的就是

00:25:10,950 --> 00:25:13,049

你调用 _call_ 方法，你获得

00:25:13,049 --> 00:25:15,240

这两个表。这是你的

00:25:15,240 --> 00:25:18,419

应用做的就是等在那里

00:25:18,419 --> 00:25:19,740

await 外部来的事件

00:25:19,740 --> 00:25:22,620

然后获取你要得到的所有东西。

00:25:22,620 --> 00:25:24,389

啊，你获得了一个 WebSocket 帧，

00:25:24,389 --> 00:25:26,429

你获取了一个 HTTP 请求，诸如此类

00:25:26,429 --> 00:25:29,610

但你获得一个返回的东西的时候。

00:25:29,610 --> 00:25:32,009

关键的是这些都不像 WSGI

00:25:32,009 --> 00:25:34,620

它有一个规范让事情看起来是什么样的，

00:25:34,620 --> 00:25:36,509

它非常接近 WSGI 的目的

00:25:36,509 --> 00:25:39,990

但是像 HTTP

00:25:39,990 --> 00:25:41,669

像被解码的路径

00:25:41,669 --> 00:25:43,620

为了 WebSockets 正确的东西被分离

00:25:43,620 --> 00:25:45,000

你有一个好的 diction 就像是

00:25:45,000 --> 00:25:46,679

啊，这是来自帧的文本 ID,

00:25:46,679 --> 00:25:48,629

这使来自帧的二进制数据，

00:25:48,629 --> 00:25:51,330

解码也在那里为你完成了

00:25:51,330 --> 00:25:53,159

所以它还是一个

00:25:53,159 --> 00:25:56,100

像 WSGI 那样的在那个方面是高层级的，

00:25:56,100 --> 00:25:58,049

但是它也让你可以做你想要做的事情

00:25:58,049 --> 00:26:00,059

因为这只是一个 call 例程，

00:26:00,059 --> 00:26:02,490

你不需要只是接收和发送

00:26:02,490 --> 00:26:04,379

你可以启动你自己的

00:26:04,379 --> 00:26:06,840

后台 call 例程。例如，

00:26:06,840 --> 00:26:09,480

在 channels 我们有一个包括这些的基本类

00:26:09,480 --> 00:26:12,299

有一些很酷的方法，甚至在你

00:26:12,299 --> 00:26:14,100

开始接收之前启动第二个

00:26:14,100 --> 00:26:15,659

接收线程，监听 channel 层

00:26:15,659 --> 00:26:17,549

所以它实际上做的就是

00:26:17,549 --> 00:26:19,710

监听所有 channel 层的异步事件和

00:26:19,710 --> 00:26:22,169

sockets 上的异步事件

00:26:22,169 --> 00:26:24,330

但是因为我们可以提取它

00:26:24,330 --> 00:26:26,070

就是那样，我们可以说，嘿，

00:26:26,070 --> 00:26:27,210

你有一个 call 例程，你可以做你想要的，

00:26:27,210 --> 00:26:29,610

只要你清理下，你获得了很大的自由。

00:26:29,610 --> 00:26:32,070

这意味着我们可以做一些事情，

00:26:32,070 --> 00:26:34,799

比如在你发送完响应之后

00:26:34,799 --> 00:26:36,840

做一些计算，只要在某个点退出。

00:26:36,840 --> 00:26:38,820

而且服务器有一个

00:26:38,820 --> 00:26:40,830

内置的 10 秒的超时在 socket

00:26:40,830 --> 00:26:42,480

关闭之后，你可以在后台做

00:26:42,480 --> 00:26:43,080

很多事情

00:26:43,080 --> 00:26:44,399

在不同的 sockets 上发送或者监听

00:26:44,399 --> 00:26:46,980

所有这类东西，但是还有

00:26:46,980 --> 00:26:49,169

关键它依然非常简单，

00:26:49,169 --> 00:26:51,029

而且它依然是一个对象你把它送到你的

00:26:51,029 --> 00:26:53,549

服务器，你依然有一个应用

00:26:53,549 --> 00:26:56,070

使用命令行发送到你的服务器，

00:26:56,070 --> 00:26:57,749

而它为你处理所有这类事务。

00:26:57,749 --> 00:27:00,659

这里我们通过它

00:27:00,659 --> 00:27:02,129

希望达到的一件事情是一个短语

00:27:02,129 --> 00:27:05,369

我第一次听说是在 2009 的 Django con EU

00:27:05,369 --> 00:27:09,119

被一直成为 Turtles。

00:27:09,119 --> 00:27:10,799

Django 的其中一个从未实现的目标

00:27:10,799 --> 00:27:13,230

是所有这些你看到的层

00:27:13,230 --> 00:27:14,399

都非常相似

00:27:14,399 --> 00:27:17,609

比如，为什么路由，中间件和视图

00:27:17,609 --> 00:27:20,039

都不一样，它们各自都有

00:27:20,039 --> 00:27:21,330

不同的接口，你不能按照

00:27:21,330 --> 00:27:22,619

完全相同的方式编写它们，而且

00:27:22,619 --> 00:27:25,169

WSGI 和 Django 按照这样的方式设计

00:27:25,169 --> 00:27:28,379

那是有原因的。有段时间推动

00:27:28,379 --> 00:27:30,809

WSGI 中间件，现在在

00:27:30,809 --> 00:27:32,249

Python 中依然存在这一点。

00:27:32,249 --> 00:27:34,590

Django 在不适用它的时候会非常糟糕，

00:27:34,590 --> 00:27:36,330

而且因为各种各样的原因，

00:27:36,330 --> 00:27:38,759

部分是我们自己的过错，但是想法是

00:27:38,759 --> 00:27:40,379

我会尝试并且修复它，像是我们如何

00:27:40,379 --> 00:27:42,749

回到方法并且把它变

00:27:42,749 --> 00:27:45,389

一路下来一模一样。

00:27:45,389 --> 00:27:47,039

这也是把它做成全部异步的一部分，

00:27:47,039 --> 00:27:49,320

你知道我在那个层给你显示的

00:27:49,320 --> 00:27:51,299

只是一个普通的 ASGI 应用

00:27:51,299 --> 00:27:54,029

它是一个这样的应用，

00:27:54,029 --> 00:27:56,399

你给它一个字典,告诉它

00:27:56,399 --> 00:27:57,450

按照这个模式去其他的应用程序

00:27:57,450 --> 00:28:00,359

并且他生成一个全新的应用程序，

00:28:00,359 --> 00:28:02,129

中间件就是应用程序包裹其他应用程序

00:28:02,129 --> 00:28:05,070

重点是在 Django channels 中的

00:28:05,070 --> 00:28:08,549

所有东西是通用的，而且

00:28:08,549 --> 00:28:10,440

并不特别和 Django 绑定。

00:28:10,440 --> 00:28:13,230

这里的想法是尝试并且清除

00:28:13,230 --> 00:28:15,840

一些潜在的混合和

00:28:15,840 --> 00:28:17,100

匹配 Django 的东西

00:28:17,100 --> 00:28:20,609

在现在我们从来没有真正做到的

00:28:20,609 --> 00:28:22,139

但是产生了一个非常有趣的问题

00:28:22,139 --> 00:28:25,679

我已经站在这里大概半个小时了

00:28:25,679 --> 00:28:27,330

而且告诉那你我是如何采用 Dajango

00:28:27,330 --> 00:28:29,460

制作了它的并行版本，

00:28:29,460 --> 00:28:32,249

而且它有不同的异步的东西，但是

00:28:32,249 --> 00:28:34,039

我没有真正触及核心 Django

00:28:34,039 --> 00:28:36,210

这对于核心 Django 意味着什么

00:28:36,210 --> 00:28:37,799

比如 channels 就是一个 Django 项目

00:28:37,799 --> 00:28:40,049

在 github 上的 Django 组织下，

00:28:40,049 --> 00:28:41,879

但是它也是一个独立的项目，

00:28:41,879 --> 00:28:43,289

不是基础核心代码的一部分，

00:28:43,289 --> 00:28:45,539

而且在这一点上，我们必须

00:28:45,539 --> 00:28:48,019

在未来开始考虑更多

00:28:48,019 --> 00:28:50,730

真正的问题是

00:28:50,730 --> 00:28:52,740

我们做一个同步或者异步需要花费多少

00:28:52,740 --> 00:28:54,960

代码不会免费获得。

00:28:54,960 --> 00:28:55,679

有两个原因

00:28:55,679 --> 00:28:56,730

首先，需要花费精力

00:28:56,730 --> 00:28:58,679

重写异步代码

00:28:58,679 --> 00:29:00,870

而且维护也不是免费的或者很便宜的。

00:29:00,870 --> 00:29:04,200

我很感谢每一个贡献者

00:29:04,200 --> 00:29:05,940

从我们 Django 追随者里产生的

00:29:05,940 --> 00:29:07,470

欢迎参加志愿者活动

00:29:07,470 --> 00:29:09,360

我们的同事非常忙碌，

00:29:09,360 --> 00:29:11,970

分流错误并且做一些安全工作。

00:29:11,970 --> 00:29:15,270

我们没有足够的人力

00:29:15,270 --> 00:29:16,919

可以把一个大的项目

00:29:16,919 --> 00:29:18,090

完全重写成异步的形式

00:29:18,090 --> 00:29:20,580

其中一个大的阻碍开始是

00:29:20,580 --> 00:29:22,440

这样的想法，如果我们变化，

00:29:22,440 --> 00:29:24,090

必须是一个突破性的变化

00:29:24,090 --> 00:29:27,390

我通过 channels 试图想做的就是

00:29:27,390 --> 00:29:29,970

表明我们可以转变成异步

00:29:29,970 --> 00:29:31,380

然后通过我们的 wrapper 方法

00:29:31,380 --> 00:29:33,000

你依然保持同步接口，像之前看到的。

00:29:33,000 --> 00:29:35,429

但是还有第二个问题

00:29:35,429 --> 00:29:37,620

就是速度。无论何时你

00:29:37,620 --> 00:29:39,600

在像这样的图层上模拟

00:29:39,600 --> 00:29:41,640

async_to_sync 或者 sync_to_async ,

00:29:41,640 --> 00:29:43,440

你都要舍弃性能。如果你

00:29:43,440 --> 00:29:45,210

使用使用 Python 线程运行，那么

00:29:45,210 --> 00:29:47,160

很自然性能会受损，如果你试图调用

00:29:47,160 --> 00:29:48,600

异步代码或者同步代码，

00:29:48,600 --> 00:29:50,490

必须去那个主线程，然后

00:29:50,490 --> 00:29:52,650

再回来，这将是一个性能损失。

00:29:52,650 --> 00:29:54,150

甚至我们考虑这样的事实

00:29:54,150 --> 00:29:55,650

你大概应该会不停的进入退出

00:29:55,650 --> 00:29:57,140

当你一直保持这样做的时候

00:29:57,140 --> 00:29:59,309

所以这确实是个问题

00:29:59,309 --> 00:30:01,410

就像我们看一下 Django 和 所有的

00:30:01,410 --> 00:30:03,919

Django 部件以及想法

00:30:03,919 --> 00:30:05,880

好吧，我们可以做这样的异步

00:30:05,880 --> 00:30:08,010

但是会更加慢一些，

00:30:08,010 --> 00:30:09,900

就像以前 Django 有过性能问题，

00:30:09,900 --> 00:30:11,910

我们试图加速它们，它们曾经是

00:30:11,910 --> 00:30:13,559

Django 的性能图标

00:30:13,559 --> 00:30:15,150

由于不停的发布，导致越来越慢

00:30:15,150 --> 00:30:17,840

最后不得不想办法解决。

00:30:17,840 --> 00:30:22,350

真正大问题是

00:30:22,350 --> 00:30:26,460

Django 的好坏是大部分有复杂性导致的吗？

00:30:26,460 --> 00:30:29,130

道理是哪里有大量的复杂性

00:30:29,130 --> 00:30:30,419

哪里就有大量的需要维护的工作

00:30:30,419 --> 00:30:33,059

真正的问题是

00:30:33,059 --> 00:30:34,020

那会看起来怎么样

00:30:34,020 --> 00:30:37,940

Django 的 ORM 是非常特别的

00:30:37,940 --> 00:30:40,440

它从一开始就从一个我确实非常欣赏

00:30:40,440 --> 00:30:41,970

的地方开始设计

00:30:41,970 --> 00:30:45,390

就像它不是一个关系型的

00:30:45,390 --> 00:30:47,340

特别是基于 Roman 的 SQL 更多的

00:30:47,340 --> 00:30:49,140

基于对象和抓取，而且

00:30:49,140 --> 00:30:50,790

它在过去几年变得更好

00:30:50,790 --> 00:30:52,799

而且有了更多的关系型部分，但是

00:30:52,799 --> 00:30:55,049

它非常清晰也非常简单

00:30:55,049 --> 00:30:57,510

通过这种方式你操作它。

00:30:57,510 --> 00:31:00,750

我们如何在一个异步里面做这些同样的事情？

00:31:00,750 --> 00:31:03,390

我们可以做了

00:31:03,390 --> 00:31:04,950

例如我使用 Python 3 运行遇到的

00:31:04,950 --> 00:31:08,010

一个大的问题是

00:31:08,010 --> 00:31:10,600

即使你在一个异步上下文中，

00:31:10,600 --> 00:31:12,940

属性访问依然是同步的

00:31:12,940 --> 00:31:15,010

没有异步的驱动访问，

00:31:15,010 --> 00:31:17,560

所以如果你要重写比如

00:31:17,560 --> 00:31:19,900

属性或者驱动和/或获取方法，

00:31:19,900 --> 00:31:22,840

你不能有这些的异步版本

00:31:22,840 --> 00:31:25,150

很多 Django 做的事情依赖于

00:31:25,150 --> 00:31:28,420

比如运营商的重写或是实际

00:31:28,420 --> 00:31:30,550

驱动的重写。而你无法很顺畅的

00:31:30,550 --> 00:31:32,950

把它们改成异步。

00:31:32,950 --> 00:31:34,720

我们的 channels 的一个大问题是

00:31:34,720 --> 00:31:37,750

我做了一个中间件，

00:31:37,750 --> 00:31:39,580

把用户放进范围中，这很好

00:31:39,580 --> 00:31:43,000

问题是当你试图

00:31:43,000 --> 00:31:45,340

让它从范围内采用一个 cookie

00:31:45,340 --> 00:31:47,080

把它转换成一个用户对象

00:31:47,080 --> 00:31:49,090

并且涉及到访问 ORM，

00:31:49,090 --> 00:31:51,460

这就意味着你不得不使用

00:31:51,460 --> 00:31:53,110

同步的上下文来实现，因为这是 Django

00:31:53,110 --> 00:31:55,750

它是同步的 RM。

00:31:55,750 --> 00:31:57,580

但是问题是在于请求对象

00:31:57,580 --> 00:32:00,820

用户是懒加载的，知道你第一次看到用户

00:32:00,820 --> 00:32:02,620

那里没有任何东西

00:32:02,620 --> 00:32:05,620

只是一组基本的 promise，只要你

00:32:05,620 --> 00:32:08,200

一看到它描述符触发器被触发

00:32:08,200 --> 00:32:10,600

ORM 查询并返回，然后给你对象。

00:32:10,600 --> 00:32:12,670

我们遇到的问题是

00:32:12,670 --> 00:32:14,110

这是发生在

00:32:14,110 --> 00:32:16,840

异步代码段的中间

00:32:16,840 --> 00:32:19,330

就像我们引入一个异步方法

00:32:19,330 --> 00:32:21,910

我们试图获取用户

00:32:21,910 --> 00:32:23,110

它开始在数据库中运行查询

00:32:23,110 --> 00:32:24,610

这绝对会给你造成一个阻塞

00:32:24,610 --> 00:32:28,270

有一个对于发生了什么的保护

00:32:28,270 --> 00:32:30,400

机制就是 channels

00:32:30,400 --> 00:32:31,930

搞清楚发生了什么，我说过了不可能。

00:32:31,930 --> 00:32:35,020

你不能运行同步代码和异步回调，

00:32:35,020 --> 00:32:38,080

这导致了问题。

00:32:38,080 --> 00:32:39,880

必须用一种讨厌的方式解决它，

00:32:39,880 --> 00:32:42,430

而它依然存在，就像变的更严重了

00:32:42,430 --> 00:32:43,840

当你在一个更大的范围内去考虑它

00:32:43,840 --> 00:32:45,520

我们甚至可以部分

00:32:45,520 --> 00:32:47,590

重写这些东西比如

00:32:47,590 --> 00:32:50,800

那是怎么工作的？

00:32:50,800 --> 00:32:51,970

有没有另外的方式来做呢？

00:32:51,970 --> 00:32:53,920

我们可以加入更多插件。我之前说过

00:32:53,920 --> 00:32:55,810

就像你了解的共享中间件和 WSGI

00:32:55,810 --> 00:32:58,060

中间件就是这个目标

00:32:58,060 --> 00:33:00,070

Django 从来没有完全得到。

00:33:00,070 --> 00:33:03,190

我们可以回来，这些线路中的一条是

00:33:03,190 --> 00:33:05,620

基于这类东西的。我真的

00:33:05,620 --> 00:33:08,340

希望看到 Django 更多的插件化。

00:33:08,340 --> 00:33:11,380

我几乎每年都被邀请来到这里

00:33:11,380 --> 00:33:14,680

做比如我喜欢使用 Django X 部分在

00:33:14,680 --> 00:33:16,480

Django 之外，但是当然

00:33:16,480 --> 00:33:18,340

设定经常是问题

00:33:18,340 --> 00:33:20,680

来来回回的，就像这个的一部分

00:33:20,680 --> 00:33:22,960

我们是否正在重新思考 Django，

00:33:22,960 --> 00:33:26,200

有没有方法解决这个问题？

00:33:26,200 --> 00:33:28,360

我们最终把 RM 从 模板中

00:33:28,360 --> 00:33:31,809

从视图中，从抓取中，

00:33:31,809 --> 00:33:34,029

从 URL 的路由中分离出来

00:33:34,029 --> 00:33:37,390

比如，而且所有这些都确实是

00:33:37,390 --> 00:33:38,610

困难的问题

00:33:38,610 --> 00:33:40,600

然后还有一个更大的问题

00:33:40,600 --> 00:33:44,289

那已经超出了 Django 本身，

00:33:44,289 --> 00:33:46,510

我只是在这里给你指明下

00:33:46,510 --> 00:33:49,659

我所称作 WSGI 的一个替代。

00:33:49,659 --> 00:33:51,760

这是一个大胆的声明

00:33:51,760 --> 00:33:55,630

替代不是一件容易的事情，而且可以说

00:33:55,630 --> 00:33:57,880

它不需要被替代，

00:33:57,880 --> 00:33:58,899

它运转的很好

00:33:58,899 --> 00:34:02,440

除了一些 Unicode 的问题，

00:34:02,440 --> 00:34:05,590

大部分 Python web 处理了，

00:34:05,590 --> 00:34:07,240

尤其是 WebSockets 不是一个大需求

00:34:07,240 --> 00:34:09,190

migrations 和 channels 之间的

00:34:09,190 --> 00:34:11,220

不同中的一个

00:34:11,220 --> 00:34:14,050

所有人都需要 migrations，

00:34:14,050 --> 00:34:16,690

但不是所有人都知道需要它，而大部分人不需要

00:34:16,690 --> 00:34:17,859

WebSockets，但他们认为他们需要它们

00:34:17,859 --> 00:34:19,179

它们是很闪亮，很新，也很令人兴奋，

00:34:19,179 --> 00:34:21,339

但是问题是 socket

00:34:21,339 --> 00:34:23,950

编程确实很难，如果你是一个

00:34:23,950 --> 00:34:25,540

网页开发者，你已经被宠坏了因为

00:34:25,540 --> 00:34:26,740

你有了这种完美的无状态协议

00:34:26,740 --> 00:34:28,899

在每次请求中所有东西

00:34:28,899 --> 00:34:29,679

都会被重设

00:34:29,679 --> 00:34:31,149

没有持久的状态也没有存储的 cookies

00:34:31,149 --> 00:34:32,619

它确实是一个很好的设计

00:34:32,619 --> 00:34:34,570

作为一个协议来编写的话。

00:34:34,570 --> 00:34:36,879

如果你试图从那个世界的

00:34:36,879 --> 00:34:39,159

前端和后端都进入

00:34:39,159 --> 00:34:42,220

WebSockets 的世界

00:34:42,220 --> 00:34:43,750

它需要很多额外的努力，

00:34:43,750 --> 00:34:45,669

需要学习新的调试技巧，

00:34:45,669 --> 00:34:48,159

学习负载测试的问题甚至是

00:34:48,159 --> 00:34:52,030

最糟的比如 numb 负载测试

00:34:52,030 --> 00:34:53,080

WebSockets 对你来说，

00:34:53,080 --> 00:34:55,000

甚至都不是一个好工具，

00:34:55,000 --> 00:34:56,500

那里有一些写了一半的工具，但这不是一回事

00:34:56,500 --> 00:34:58,560

我们有很多很好的练习

00:34:58,560 --> 00:35:01,660

甚至找到负载均衡器，

00:35:01,660 --> 00:35:03,490

明白了长负载均衡。

00:35:03,490 --> 00:35:05,920

如同长连接一样，

00:35:05,920 --> 00:35:08,230

也是非常困难的，所以

00:35:08,230 --> 00:35:12,900

这里真正的问题是的

00:35:12,900 --> 00:35:16,540

那个对于异步长保持协议的需求

00:35:16,540 --> 00:35:18,070

确实足够让我们替换

00:35:18,070 --> 00:35:20,800

WSGI 吗？我的意思是作为一种必然的选择

00:35:20,800 --> 00:35:23,740

当然如果喜欢，

00:35:23,740 --> 00:35:26,710

我们甚至需要那些东西，

00:35:26,710 --> 00:35:29,080

而我已经思考了一段时间，WSGI 是一个

00:35:29,080 --> 00:35:32,020

稳定态，它就像一个时尚的宠物一样被编写出来，

00:35:32,020 --> 00:35:34,119

但它至少不是一个宠物，

00:35:34,119 --> 00:35:35,140

至少现在还不是

00:35:35,140 --> 00:35:36,950

我个人认为的一个

00:35:36,950 --> 00:35:39,800

很重要的事情，可以说

00:35:39,800 --> 00:35:42,260

我们想成为规范的是

00:35:42,260 --> 00:35:45,619

有多个实现。感谢团队在

00:35:45,619 --> 00:35:47,359

Django 上的工作，

00:35:47,359 --> 00:35:49,430

Django 其他的框架

00:35:49,430 --> 00:35:51,950

现在有多 ASGI 服务器，

00:35:51,950 --> 00:35:55,040

哦，daphne 和 uvicorn 都

00:35:55,040 --> 00:35:58,280

加入了进来并运行起来

00:35:58,280 --> 00:35:59,540

我遗漏的事情是 Multiple frameworks，

00:35:59,540 --> 00:36:02,030

看起来像我编写的东西在 Django 中运行

00:36:02,030 --> 00:36:05,060

良好，我不会太高兴，

00:36:05,060 --> 00:36:06,829

直到我知道它

00:36:06,829 --> 00:36:09,320

在其他框架也运行的很好。

00:36:09,320 --> 00:36:12,500

因为这个原因就像我在很多方面沉默一样，

00:36:12,500 --> 00:36:13,820

我想要静下来，但是可能是 flask，

00:36:13,820 --> 00:36:15,710

或者金字塔，或者其他的

00:36:15,710 --> 00:36:17,180

另外一个大的 Python web 框架就像，嘿，

00:36:17,180 --> 00:36:19,520

这个可以适合他们的范例，

00:36:19,520 --> 00:36:21,440

我们可以用这种方法来做

00:36:21,440 --> 00:36:24,320

类似的事情。在 ASGI 里面

00:36:24,320 --> 00:36:26,270

有 WSGI 的适配器，你在里面可以运行一个

00:36:26,270 --> 00:36:28,190

WSGI 应用。它是一个超集，

00:36:28,190 --> 00:36:30,079

这并没有带来很多好处，

00:36:30,079 --> 00:36:32,750

你为什么要这么做？这里有一个开放的问题，

00:36:32,750 --> 00:36:36,079

我想是 AI，啊 就像 HTTP

00:36:36,079 --> 00:36:37,940

追踪，啊，我们应该加入支持

00:36:37,940 --> 00:36:39,609

对于这件事情和改造，有一些

00:36:39,609 --> 00:36:42,680

很棒的人非常非常热情地

00:36:42,680 --> 00:36:44,060

打开了它，我有一个搜索

00:36:44,060 --> 00:36:46,609

它们喜欢的东西，你不能只是

00:36:46,609 --> 00:36:48,560

去问维护者 X 事情，

00:36:48,560 --> 00:36:50,300

就像我们一样，而不给他们好处。

00:36:50,300 --> 00:36:51,829

如果我们想要很愉快的做这件事情，

00:36:51,829 --> 00:36:54,260

每个人都必须都得受益，我们不得不承认

00:36:54,260 --> 00:36:55,730

有这样一个标准，

00:36:55,730 --> 00:36:57,560

有 WSGI 可以给我们的这样一种能力是

00:36:57,560 --> 00:37:01,190

重要的，这才是

00:37:01,190 --> 00:37:02,510

我最终遇到的问题的关键。

00:37:02,510 --> 00:37:04,220

我的目标大概是努力尝试

00:37:04,220 --> 00:37:06,680

并很快带来某种形式，

00:37:06,680 --> 00:37:08,240

与其它框架和其他服务器一起协同工作，

00:37:08,240 --> 00:37:09,740

并为其添加支持

00:37:09,740 --> 00:37:12,170

但这不是直接的目标

00:37:12,170 --> 00:37:13,880

直接目标是让 Django 先工作起来

00:37:13,880 --> 00:37:15,680

然后在生产环境中，在系统中

00:37:15,680 --> 00:37:17,960

证明这些东西，来确保

00:37:17,960 --> 00:37:20,720

这一次的这个设计决定

00:37:20,720 --> 00:37:22,040

它们已经被大规模的

00:37:22,040 --> 00:37:24,380

实际工作所验证，那些我们想要

00:37:24,380 --> 00:37:25,940

在未来支持的东西。

00:37:25,940 --> 00:37:30,619

然后当然我设定了开始，

00:37:30,619 --> 00:37:32,329

我们想要每个人都编写异步，

00:37:32,329 --> 00:37:34,970

异步是可爱的，它开启了很多

00:37:34,970 --> 00:37:36,890

非常棒的新途径让我们去并行的

00:37:36,890 --> 00:37:38,930

处理事务。它也非常

00:37:38,930 --> 00:37:41,750

难并且 channels 非常多。

00:37:41,750 --> 00:37:43,849

记得这种哲学，你可以写同步代码，

00:37:43,849 --> 00:37:46,760

你也可以写异步代码，它们可以共存。

00:37:46,760 --> 00:37:48,290

但是随之你向下移动一步路径，

00:37:48,290 --> 00:37:49,790

很容易会忘记同步

00:37:49,790 --> 00:37:50,000

代码

00:37:50,000 --> 00:37:52,280

以及 Charles 做的其中一件事情，

00:37:52,280 --> 00:37:55,100

就像编写同步代码

00:37:55,100 --> 00:37:56,810

会变得越来越困难因为很多

00:37:56,810 --> 00:37:58,880

API 是同步的，而使用异步的在

00:37:58,880 --> 00:38:01,600

这里转换一下。

00:38:01,600 --> 00:38:04,010

我很诚实的但是不确定我是否希望说

00:38:04,010 --> 00:38:06,770

Python web 应该都是异步的。

00:38:06,770 --> 00:38:08,270

我不确定那将是一件安全的事情

00:38:08,270 --> 00:38:09,860

使用当前的方式

00:38:09,860 --> 00:38:12,430

可能，那有较大的可能，

00:38:12,430 --> 00:38:14,540

在语言上做改善，

00:38:14,540 --> 00:38:16,190

在代码上做改善，

00:38:16,190 --> 00:38:17,990

在框架上做改善，和我们让事情更安全的方式，

00:38:17,990 --> 00:38:20,450

比方说 HTTP 不是安全的

00:38:20,450 --> 00:38:22,370

Django 和 Flask 以及所有人都必须

00:38:22,370 --> 00:38:24,890

工作起来让它变得安全

00:38:24,890 --> 00:38:27,230

我认为同样的学习和思考过程必须要

00:38:27,230 --> 00:38:29,960

经过来处理异步事务，

00:38:29,960 --> 00:38:30,980

尤其是 WebSockets 造成这样的情况

00:38:30,980 --> 00:38:33,200

特别讨厌尝试和让这些事情

00:38:33,200 --> 00:38:35,990

正确的发生。

00:38:35,990 --> 00:38:38,570

然后这个终极问题来了，非常兴奋，是吧

00:38:38,570 --> 00:38:42,230

就像我给出的，Django 是什么？

00:38:42,230 --> 00:38:44,300

我在这个演讲中给出的，我是 Django 团队的

00:38:44,300 --> 00:38:46,520

一员，我对 Django 有一个

00:38:46,520 --> 00:38:48,740

特别远大的愿景，我知道

00:38:48,740 --> 00:38:51,140

我的一些同事不会分享

00:38:51,140 --> 00:38:53,240

最终像你知道的现在 Django

00:38:53,240 --> 00:38:55,400

如何定义的，从哪里来的，

00:38:55,400 --> 00:38:56,870

它是一个令人惊奇的框架

00:38:56,870 --> 00:38:59,510

来自于你所知道的地方

00:38:59,510 --> 00:39:00,860

有完美主义者与截止日程以及从它而来的需求

00:39:00,860 --> 00:39:03,890

从这开始，但

00:39:03,890 --> 00:39:05,420

后端是现在唯一的地方

00:39:05,420 --> 00:39:07,790

这些日子里，我们居住在一个世界包含

00:39:07,790 --> 00:39:10,700

实时网页和富 JavaScript 前端

00:39:10,700 --> 00:39:12,500

还有原生应用等这样类型的东西。

00:39:12,500 --> 00:39:15,740

Django 和 Python 还是非常非常

00:39:15,740 --> 00:39:17,630

相关性的，但是更多的还是

00:39:17,630 --> 00:39:19,820

作为一个后端系统，比如很多

00:39:19,820 --> 00:39:21,170

使用公司使用 Django 来

00:39:21,170 --> 00:39:23,360

减少模板，但是那些

00:39:23,360 --> 00:39:25,340

抱怨业务逻辑以及模型的人

00:39:25,340 --> 00:39:27,980

还在那里。这是真正的问题

00:39:27,980 --> 00:39:30,530

在某些时候我们应该

00:39:30,530 --> 00:39:32,420

清楚我们在未来的位置，

00:39:32,420 --> 00:39:34,610

就像我们开始做决定，

00:39:34,610 --> 00:39:35,750

开始抛弃旧的时候一样。

00:39:35,750 --> 00:39:38,210

让我们把所有东西都重写成异步的

00:39:38,210 --> 00:39:39,710

那是我们需要的吗？

00:39:39,710 --> 00:39:42,470

那时人们想要的吗？

00:39:42,470 --> 00:39:44,900

我发现的一个最好的方式就是只给

00:39:44,900 --> 00:39:46,370

人们选择题然后搞清楚哪个会更加

00:39:46,370 --> 00:39:47,900

流行，这个就是其中原因之一，

00:39:47,900 --> 00:39:49,790

channels 在这里存在。

00:39:49,790 --> 00:39:52,490

这是一个适度的东西，

00:39:52,490 --> 00:39:55,430

对 Django 进行有效的重写成异步

00:39:55,430 --> 00:39:56,840

这个会有很多相同的支持

00:39:56,840 --> 00:39:58,880

然后让我们看看能开发什么

00:39:58,880 --> 00:40:01,820

从它能出来什么，以及我们如何能

00:40:01,820 --> 00:40:03,260

利用这些东西来改善

00:40:03,260 --> 00:40:06,230

Django 和 Python 的未来

00:40:06,230 --> 00:40:08,200

谢谢

00:40:08,200 --> 00:40:18,350

鼓掌

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
