> * 原文地址：[Software Roles and Titles](https://medium.com/javascript-scene/software-roles-and-titles-e3f0b69c410c)
> * 原文作者：[Eric Elliott](https://medium.com/@_ericelliott)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/software-roles-and-titles.md](https://github.com/xitu/gold-miner/blob/master/TODO1/software-roles-and-titles.md)
> * 译者：
> * 校对者：

# Software Roles and Titles

![**[Photo by Henry](https://www.flickr.com/photos/lakeworth/31906927794/in/photolist-QBvm1J-XdyVXZ-26Z2ESq-UheaJA-UtS7wU-5PDxec-nprpGg-V4JVoE-rpgsab-XtiYFA-YpkUCM-2b2cNTP-nxGYfy-NMgBsn-ZtYNAh-2cHyrsf-RtTWDS-jkpXSw-T6XPfW-Zf84Ex-2dPUAN5-pMv8Vu-fEFhCj-WmaLsm-dUtnoh-nJQpxv-FrMn9i-21heJGU-QhWoxv-23XPkQs-hw1QnN-oYaiyK-W7dbhJ-RkSx2o-W8um1e-J4VV7g-qGHPif-UjK6mr-MUDHBQ-Zsr5BN-SP7PAC-TPVoHz-W66Fsf-QJS2nX-WuxJcz-RcnNTc-7HEMBk-2c1GRXt-aUxNs-SU4F53) (CC-BY-2.0)**](https://cdn-images-1.medium.com/max/4096/1*wkzd4abUJlG63bAPZWaFBQ.jpeg)

I’ve noticed a lot of confusion in the industry about various software roles and titles, even among founders, hiring managers, and team builders. What are the various roles and responsibilities on a software team, and which job titles tend to cover which roles?

Before I dig into this too much, I’d like to emphasize that every team is unique, and responsibilities tend to float or be shared between different members of the team. Anybody at any time can delegate responsibilities to somebody else for various reasons — many of them valid.

If your team isn’t exactly what I describe here, welcome to the club. I suspect very few teams and particular software roles will match perfectly with what we’re about to explore. This is just a general framework that describes averages more than any particular role or team.

I’ll start with management titles and work my way through various roles roughly by seniority.

I’d also like to emphasize that you should not feel constrained by your job title. I like to build an engineering culture which favors:

* **Skills** over **titles**

* **Continuous delivery** over **deadlines**

* **Support** over **blame**

* **Collaboration** over **competition**

I like to reward initiative with increased responsibility, and if somebody has the skills and initiative to take on and outgrow the title they’re hired for, I like to promote rather than risk losing a [rising star](https://docs.google.com/forms/d/e/1FAIpQLScDsP9hYNL347EaFhzbtI36tFHOShRT-FyK9OaSKS164fxuuA/viewform?usp=sf_link) to another company or team.

## Software Development Roles

* Engineering Fellow

* CEO

* CTO

* CIO/Chief Digital Officer/Chief Innovation Officer

* VP of Engineering/Director of Engineering

* Chief Architect

* Software Architect

* Engineering Project Manager/Engineering Manager

* Technical Lead/Engineering Lead/Team Lead

* Principal Software Engineer

* Senior Software Engineer/Senior Software Developer

* Software Engineer

* Software Developer

* Junior Software Developer

* Intern Software Developer

We’ll also talk a little about how these roles relate to other roles including:

* VP of Product Management/Head of Product

* Product Manager

* VP of Marketing

> Note: Sometimes “director”, or “head” titles indicate middle managers between tech managers and the C-Suite. Often, “Chief” titles indicate a C-suite title. C-suite employees typically report directly to the CEO, and have potentially many reports in the organizations they lead. At very large companies, those alternate titles often fill similar roles to C-suite executives, but report to somebody who is effectively the CEO of a smaller business unit within the larger organization. Different business units sometimes operate as if they are separate companies, complete with their own isolated accounting, financial officers, etc. Different business units can also have VPs, e.g., “Vice President of Engineering, Merchant Operations”.

## Engineering Fellow

The title “fellow” is the pinnacle of achievement for software engineers. It is typically awarded in recognition of people who have made outstanding contributions to the field of computing, and is usually awarded **after** an engineer writes a number of top selling books, wins prizes like the Turing Award, the Nobel Prize, etc. In other words, fellows are usually already famous outside the organization, and the company is trying to strengthen their brand by more strongly associating themselves with admired and influential people.

In my opinion, organizations should not try to hire for “fellow” roles. Instead, find the best and brightest, hire them, and then grant the title (and benefits) if the engineer is deserving of it.

A fellow typically also holds another title at the company. Often a CTO, Architect, VP of Engineering, or principal role, where they are in a position to lead, mentor, or serve as an example and inspiration to other members of the organization.

## CEO

The CEO is the position of most authority in an organization. Typically, they set the vision and north star for the company. They rally everybody around a common understanding of why the company exists, what the mission is, and what the company’s values are. Frequently, CEOs are also the public face of the company, and in some cases, become synonymous with the brand (e.g., Steve Jobs with Apple, Elon Musk with Tesla/SpaceX, etc.)

In some cases, CEOs are also the technical founder of a software organization, in which case, they also often fill the CTO role, and may have a VPs of Operations, Sales, Strategy, and Marketing helping with some of the other common CEO responsibilities.

The CEO of a small company frequently wears a lot of hats, as you may have picked up from all the other roles that fell out of the CEO title when I mentioned that some CEOs lead the technology team.

In any case, if there are important organizational decisions to be made, you can’t run it up the chain of responsibility any higher than the CEO.

If you are a CEO, remember that you’re ultimately responsible, and you should trust your instincts, but don’t forget that even most famous CEOs have mentors and advisors they consult with on a regular basis. Trust your gut, but seek out smart, insightful people to challenge you to improve, as well.

## CTO

Like the CEO role, the CTO role shape-shifts over time. At young startups, the CTO is often a technical cofounder to a visionary or domain-driven CEO. Frequently they are not qualified to take the title at a larger company, and hopefully grow into it as the company grows. Frequently, a startup CTO finds that they prefer more technical engineering roles, and settle back into other roles, like Principal Engineer, VP of Engineering, or Chief Architect.

In many organizations, the mature CTO role is outward facing. They participate in business development meetings, frequently helping to land large partnerships or sales. Many of them hit the conference circuit and spend a lot of time evangelizing the development activities of the organization to the wider world: sharing the company’s innovations and discovering opportunities in the market which match up well with the company’s core competencies. CTOs frequently work closely with the product team on product strategy, and often have an internal-facing counterpart in engineering, such as the VP of Engineering.

CTOs also frequently set the vision and north star of the engineering team. The goals for the team to work towards.

## CIO/Chief Digital Officer/Chief Innovation Officer

The Chief Innovation Officer (CIO) is like a CTO, but typically employed by a company that would not normally be considered a “tech company”. The goal of the CIO is to reshape the company into one that consumers perceive as tech-savvy and innovative: To show the world what the future of the industry looks like, no matter what that industry is. For example, a home remodeling superstore chain might have a CIO responsible for partnering with tech companies to build a mixed reality app to show shoppers what a specific couch or wall color would look like in their living room, or using blockchains and cryptocurrencies to enhance the security and efficiency of supply chain logistics.

Not to be confused with a Chief Information Officer (CIO), a title which is typically used in companies who are even more detached from technology, interested about as far as it aids their core operations. Unlike a Chief Innovation Officer, A Chief Information Officer is more likely to be leading tech integration and data migration projects than building new apps and trying to figure out how a company can disrupt itself from the inside. There are Chief Information Officers who act more like Chief Innovation Officers, but in my opinion, they should use the appropriate title.

Most tech-native companies (app developers, etc) don’t have either kind of CIO. Instead, those responsibilities fall to the CTO and VP of Engineering.

## VP of Engineering/Director of Engineering

While CTOs often face outward, the VP of Engineering often faces inward. A VP of Engineering is frequently responsible for engineering culture and operations. The CTO might tell the engineering team what needs to get done on the grand scale, e.g., “be the leading innovator in human/computer interaction”. The VP of Engineering helps foster a culture that manages the “how”. The best VPs of Engineering at first come across as somebody who’s there to help the team work efficiently, and then they almost disappear. Developers on the team collaborate well, mentor each other, communicate effectively, and they think, “Hey, we’re a great team. We work really well together!” and maybe they think that’s all a lucky accident.

The truth is that almost never happens by accident. It happens because there’s a VP of Engineering constantly monitoring the teams progress, process, culture, and tone of communications. They’re encouraging developers to use certain tools, hold specific kinds of meetings at specific times in order to foster better collaboration with fewer interruptions. The best VPs of Engineering have been engineers, both on dysfunctional teams, and on highly functional teams. They know the patterns and anti-patterns for effective software development workflows.

They work with the heads of product and product managers to ensure that there’s a good product discovery process (they don’t lead it or take charge of it, just make sure that somebody is on it and doing it well), and that product and design deliverables are adequately reviewed by engineers prior to implementation hand offs. I’m going to stop there before I write a book on all the work that goes into leading effective development operations. For more of my thoughts on this topic, check out [How to Build a High Velocity Development Team](https://medium.com/javascript-scene/how-to-build-a-high-velocity-development-team-4b2360d34021).

Many startups are too small to hire a full time VP of Engineering, but it’s still very important to get engineering culture right as early as possible. If you need help with this, [reach out](https://devanywhere.io/help).

## Chief Architect

At small organizations, the chief architect could be a technical co-founder with the self-awareness to realize that they won’t want the responsibilities of a CTO as the company grows. Maybe they don’t like to travel, or are simply more interested in software design than conference talks, business development, and sales calls that infiltrate the lives of many CTOs. The chief architect may be responsible for selecting technology stacks, designing collaborations and interfaces between computing systems, assessing compute services offerings (AWS, Azure, ZEIT Now, etc.), and so on. A chief architect may evaluate a wide range of industry offerings and make pre-approved or favored recommendations to work with particular vendors.

As the company matures, the chief architect may also need to work closely with the CTO, and sometimes partner organizations to develop integrations between services. At many companies, the CTO also serves as the chief architect.

## Software Architect

A software architect serves many of the purposes of a chief architect, but is generally responsible for smaller cross-sections of functionality. Architects will often work with the chief architect to implement their slice of the larger architectural vision. Software architects often make tech stack choices for particular applications or features, rather than company-wide decisions.

## Engineering Project Manager/Engineering Manager/Project Manager

An Engineering Project Manager (also called “Engineering Manager” or simply “Project Manager”) is in charge of managing the workflow of an engineering team. They typically interface with both product leaders and an engineering leader such as VP of Engineering, CTO, or a middle manager to cultivate and prune the work backlogs, track the progress of work tickets, detailed progress reports (milestone burn down charts, completed vs open tickets, month/month progress reports, etc.) You can think of them as the analog of a shop manager for a manufacturing assembly line. They watch the work floor and make sure that the assembly line runs smoothly, and work product isn’t piling up on the floor in front of a bottleneck.

The best Project Managers also spend a lot of time classifying issues and bugs in order to analyze metrics like bug density per feature point, what caused the most bugs (design error, spec error, logic error, syntax error, type error, etc.) and so on. Those kinds of metrics can be used to measure the effectiveness of various initiatives, and point out where improvements can be made to the engineering process.

Engineering Managers tend to develop a good understanding of the strengths of various team members, and get good at assigning work tickets to the appropriate responsible parties, although, this should be a collaborative effort, seeking feedback from individual developers on what their career goals are and what they want to focus on, within the bounds of the project scope available.

If there is time pressure or work backlogs piling up, the Project Manager should collaborate with the engineering and product leaders to figure out the root cause and correct the dysfunction as soon as possible.

Wherever possible, the Project Managers should be the only ones directly delegating tasks to individual engineers in order to avoid the multiple bosses problem. Engineers should have a clear idea of who they report directly to, and who’s in charge of delegating to them. If you’re a different kind of engineering leader, and you’re guilty of delegating directly to engineers, it’s probably a good idea to coordinate with the Engineering Manager in charge of the report you’re delegating to and delegate through them so that the work receives correct, coordinated prioritization, and the Engineering Manager is aware of what each engineer is actively working on at any given moment.

At very small organizations, the Engineering Manager is often also the CTO and VP of Engineering (with or without the corresponding titles). If that’s you, don’t worry about the previous paragraph.

A common dysfunction is that the Engineering Manager can begin to think that because product hands off work for engineering to implement, and Engineering Managers work closely with product teams, that the Engineering Manager reports to a Product Manager. In every case I’ve seen that happen, it was a mistake. See “Avoiding Dysfunctions…” below.

## Tech Lead/Team Lead

The Tech Lead or Team Lead is usually the leader of a small number of developers. They are usually senior engineers who act like mentors, examples, and guides for the rest of the team. Usually, engineers report to the project manager or engineering manager, but a tech lead may be responsible for the team’s code quality measures, such as ensuring that adequate code reviews are being conducted, and that the team’s technical standards (such as TDD) are being upheld.

## Engineer Career Progressions

Generally, engineers can take one of two career paths: move into management, or keep coding. Management positions aren’t for everyone. Lots of engineers prefer to stay on the technical path. That progression can take many directions, twists, and turns, but could look something like this:

Intern -> Junior Software Developer -> Software Developer/Engineer -> Senior Software Engineer -> Principal Software Engineer -> Software Architect -> Senior Software Architect -> Chief Architect -> CTO -> Engineering Fellow

Alternatively, for those engineers interested in a people leadership role, a progression might look something like this:

Intern -> Junior Software Developer -> Software Developer/Engineer -> Team Lead/Tech Lead -> Engineering Manager/Project Manager -> Senior Engineering Manager -> Director of Engineering -> VP of Engineering

## Avoiding Dysfunctions in Engineering Leadership

IMO, VP of Engineering, CTO, VP of Product, and VP of Marketing should all report directly to the CEO. Each of them needs to be in charge of their own process. External facing CTOs should not have direct reports (if they do, it usually means they are filling both the CTO and VP of Engineering Roles). Instead, the Engineering leaders report to the VP of Engineering. This is to avoid the two bosses dysfunction, but also because these roles are fundamentally different: one focused on the customer and how the organization fits into the wider world, and the other focused on internal, day-to-day operations. They’re two wildly different skill sets, with sometimes competing priorities.

I’ve seen a lot of dysfunction in engineering leadership because of confusion about which engineering leaders are responsible for what, and it tends to be a recipe for disaster. Whatever is right for your organization, make sure that responsibilities and chain of authority are clear, in order to avoid engineers feeling torn between two or three different “bosses”.

Likewise, in an organization of sufficient size, product and engineering need to be two separately led teams. What I mean by that is that the product managers should own the product roadmap. They should be evangelists for the users, and they should be really plugged into the users, often engaging with them 1:1 and learning about their workflows and pain-points in great depth. They should be experts on what the market needs, and they should be very familiar with the company’s strengths and capabilities to fill those needs.

That said, the VP of Engineering (or whomever is filling that role) needs to be in charge of **delivery, and production pace.** While the product managers should own the roadmap, the engineering managers need to be responsible for taking those roadmap priorities, matching them to the engineering capacity, and reporting on the timing. Product and marketing teams will have strong opinions about **when** something should ship, but only the engineering management has a good gauge of whether or not those delivery timelines are possible given the roadmap requirements. The engineering team needs the authority not simply to push back on timing, but in most cases, to completely own timing, working with the CEO, product, and marketing teams to figure out priorities, understand strategic needs of the company, and then help shape a development cadence that can meet those needs without imposing drop-dead deadlines that ultimately hurt the company’s ability to deliver quality products at a reliable pace.

The best performing teams I’ve ever been involved with subscribed to the no deadlines approach. We build great products without announcing them in advance, and then let the marketing teams promote work that is already done. Alternatively, when you’re working in the public view, transparency is a great solution. Instead of cramming to meet an arbitrary deadline, actively share your progress, with ticket burn-down charts, a clear view of remaining work, progress, pace, and remaining scope, and change over time that can indicate scope creep. When you share detailed information about the progress being made, and share the philosophy that we can’t promise a delivery date, but we can share everything we know about our progress with you, people can see for themselves the work and the pace.

Because of differing, often competing goals, product, marketing and engineering need to be separate roles reporting directly to the CEO where none of them can dictate to each other. If your team feels time pressure to work overtime, or crunch to get some key deliverable out before some drop-dead deadline, it points to a dysfunction here. Either the engineering managers are reporting to the wrong people, or the team lacks a strong engineering leader who understands the futility of software estimates and the need for a collaborative give-and-take between engineering and product in order to ensure the flexibility of shipping scaled-back MVPs to hit delivery targets.

Product should own the continuous discovery process. Engineering should own the continuous delivery process. Marketing should work hand-in-hand with the product team to ensure that product messaging to the wider world is on-point. The whole thing should fit together like a pipeline, creating a smoothly flowing, positive feedback cycle. Like an assembly line, the slowest bottleneck in the process must set the pace for the rest of the process, otherwise, it will lead to an ever-growing backlog that piles up so much that backlog items become obsolete, and backlog management becomes a full-time job.

Product teams who feel like engineering is not keeping pace should focus first on quality of engineering hand-off deliverables. Have we done adequate design review? Has an engineer had a chance to provide constructive feedback before handoff? [80% of software bugs are caused by specification or UX design errors](http://ttendency.cs.ucl.ac.uk/projects/type_study/documents/type_study.pdf), and many of those can be caught before work ever gets handed off to an engineering team. Once you have that process finely tuned, ask yourself if you’ve really explored the product design space thoroughly enough. Did you build one UX and call it done, or did you try multiple variations? Building and testing variations on user workflows is one of the most valuable contributions a product team can make. Do you have a group of trusted users or customers you can run A/B prototype tests with?

One of the biggest dysfunctions of software teams is that the product team is producing sub-par deliverables (sometimes little more than a few rushed, buggy mock-ups), and failing to run any of them by customers or engineers prior to handing them off. That dysfunction causes a pileup of re-work and engineering backlog that often gets blamed on engineering teams.

Make sure that the delegation of responsibilities makes sense, that you’re not putting undue time pressure on engineering, and that you have a great product team engaged in a collaborative product discovery process, working with real users to build the best product.

Engineering managers, I’m not letting you off the hook. If these dysfunctions exist on your team, it’s your responsibility to address them with product, marketing, and business leadership, and spearhead requirements for engineering hand-offs. It’s also your responsibility to protect the productive pace of your team, go to bat for additional resources if your team is being pressured to produce more than your current capacity can handle, to report clearly on the work pacing and backlog, and to demo completed work and ensure that your team is getting due credit for the fine work that is being done.

Don’t place blame, but do demonstrate that your team is doing their very best work.

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
