> * 原文地址：[Scrolling and Attention](https://www.nngroup.com/articles/scrolling-and-attention/)
> * 原文作者：[Therese Fessenden](https://www.nngroup.com/articles/author/therese-fessenden/)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/scrolling-and-attention.md](https://github.com/xitu/gold-miner/blob/master/TODO1/scrolling-and-attention.md)
> * 译者：[Ivocin](https://github.com/Ivocin)
> * 校对者：[Moonliujk](https://github.com/Moonliujk), [CoderMing](https://github.com/CoderMing)

# 从 2010 到 2018，你不知道的关于网页滚动和用户注意力的变化

**摘要：** 人们比以前更多地纵向滚动网页，但是新的眼动追踪数据表明：注意力没有变化，人们仍然更关注首屏上的内容，而非首屏以下的内容。

人们的行为相当的稳定，[可用性指南一直鲜有变化](https://www.nngroup.com/articles/usability-guidelines-change/)。但是，从网络出现早期至今，有一个用户行为发生了变化，那就是滚动网页的趋势。一开始，很少有人纵向滚动网页，但[到了 1997 年，随着长页面的普及](https://www.nngroup.com/articles/changes-in-web-usability-since-1994/)，大多数人学会了滚动网页。然而，首屏上的信息仍然受到了最多的关注：我们的眼动追踪研究表明，[即使早在 2010 年，](https://www.nngroup.com/articles/scrolling-and-attention-original-research/)用户 80% 的页面浏览时间都花在了首屏上面。

自 2010 年以来，随着[响应式设计](https://www.nngroup.com/articles/responsive-web-design-definition/)和[极简主义](https://www.nngroup.com/articles/characteristics-minimalism/)的出现，许多设计师转向了具有负空间的长页面（覆盖几个“屏幕”）设计。现在是时候再次探究由于这些网页设计趋势的普及，用户行为是否发生了变化。

## 眼动追踪数据

### 关于本研究

为了回答这个问题，我们分析了 1920×1080 分辨率屏幕上超过 130,000 个凝视点（eye fixations）的 x, y 坐标。这些凝视点来自 120 名参与者，他们是我们最近的眼动追踪研究的一部分，该研究涉及来自各行各业的数千个网站。在本研究中，我们重点分析了广泛的用户任务，这些任务涵盖各种页面和行业，包括新闻，电子商务，博客，常见问题解答和百科全书页面。我们的目标不是分析某个网站，而是总结出用户行为的一般性。

我们将这些近期数据与我们之前在眼动追踪研究中获得的数据进行了比较，之前的数据是在 1024×768 分辨率屏幕上获得的。

### 研究结果

我们的前后两次研究之间发生了两处变化：（a）更大的屏幕，（b）用户可能已经适应了的新的网页设计趋势。我们无法单独考虑某一变化所带来的影响。但没有关系，因为两者都是由于时间的流逝造成的变化。即使我们想要，我们也无法撤消任何一个。

在我们最近的一项研究中，用户将大约 **57% 的页面浏览时间用于首屏。74% 的浏览时间花费在前两个屏幕上**，浏览的长度最高可达 2160px。（本分析不关心页面的最大长度 —— 结果可能是由于页面长度较短或者是用户在浏览了前两个屏幕内容后就放弃了阅读。）

这些发现与我们在[2010 年的发表的文章](http://www.nngroup.com/articles/scrolling-and-attention-original-research/)完全不同：在那篇文章中，用户 80% 的页面浏览时间花费在了首屏。然而**首屏后页面关注度急剧下降**的现象在 2018 年和 2010 年相同。

![图表：浏览时间的百分比](https://media.nngroup.com/media/editor/2018/04/04/percentageviewingtimeverticalattention.png)

**首屏上的内容在浏览时间中占据比最高。大约 74% 的时间花费在前两个屏幕内容中（首屏加上首屏下方的屏幕信息）。剩余的 26% 部分随着页面长度的增加少量递减。**

能够理解的是，并非每个页面的长度都相同。为了确定人们如何在页面上分配他们的注意力（无论页面有多长），我们将页面分成 20％ 的分段（即每页的五分之一）。在一般网站上，超过 42% 的浏览时间花在了页面的前 20% 区域上，超过 65% 的浏览时间花在页面的前 40% 区域上。在搜索结果页面（SERPs）上，结合我们在 2010 年的调查结果，47% 的浏览时间花费在页面的前 20% 区域上（超过 75% 的浏览时间花在了页面的前 40% 区域上）—— 可能反映了用户更愿意查看热门搜索结果的现象。

![图表：浏览时间百分比（按内容分段划分）](https://media.nngroup.com/media/editor/2018/04/04/percentageviewingtimesegmentsvertical-graph.png)

**人们花费更多时间浏览页面的前 20% 区域。**

如果我们只关注首屏的内容 —— 在第一个屏幕中 —— 屏幕顶部的信息比底部信息更受关注。用户超过 65% 的浏览时间集中在视窗的上半部分。在 SERP 上，首屏超过 75% 的浏览时间花费在了第一个屏幕的上半部分。（这是一个古老的事实，但也是老生常谈：你在谷歌的搜索结果要么是前两名，要么就在互联网上几乎不存在。[“轻信谷歌”](https://www.nngroup.com/articles/user-skills-improving-only-slightly/)的现象至今依然强烈，和我们 10 年前发现这种用户行为时一样。）

![图表：首屏浏览时间百分比](https://media.nngroup.com/media/editor/2018/04/04/percentageviewingtimeabovefoldvertical-graph.png)

**即便在首屏上，注意力也集中在页面顶部 —— 尤其是 SERP。**

## 浏览和阅读模式

我们已经发现首屏上的内容得到了最多的关注（占浏览时间的 57%），第二屏内容浏览时间约占三分之一（占浏览时间的 17%），剩余的 26% 浏览时间表现为长尾分布。换言之，一条信息离页面顶部越近，它被阅读的可能性就越大。

个人阅读模式证实了这一发现。许多用户在扫描内容结构不合理的页面时会[使用 F 模式](https://www.nngroup.com/videos/f-pattern-reading-digital-content/)阅读 —— 他们倾向于更仔细地查看靠近页面顶部的文本（文本的前几段），页面越往下阅读信息的时间越少。

即使网页是列表形式或信息以结构化的方式呈现，人们也会在页面顶部投注更多的目光（即阅读时间），因为他们需要了解页面的组织方式。一旦他们这样做，他们倾向[有效地关注](https://www.nngroup.com/articles/eyetracking-tasks-efficient-scanning/)与手头任务相关的信息，因此在远离顶部的内容上投注更少的目光（即阅读时间）。

![Crowdrise 网站“慈善”一词的搜索结果页面的凝视数据图](https://media.nngroup.com/media/editor/2018/04/04/charities-gazeplot.png)

这是一个典型的凝视图，图中显示大多数用户的凝视点都集中在页面的顶部，但并不总是位于最顶部。凝视点的实际分布取决于页面的具体设计和用户访问页面的目标。如果信息看起来很有趣，用户有时可能会阅读一点点，但总体而言，浏览会在页面的下方逐渐消失。

## 2010 年 vs 现在

2010 年，用户 80% 的浏览时间都花在了首屏上。今天，这个数字只有 57% —— 可能是由于长页面普遍流行的结果。这意味着什么？

首先，总的来说，设计师们很好地创造了指示符以抵消[页面完整的错觉](https://www.nngroup.com/articles/illusion-of-completeness/)，并引导人们滚动页面。换言之，他们了解了长页面的缺点并在一定程度上缓解了这些缺点。其次，它可能意味着用户已经习惯了滚动阅读 —— 需要滚动阅读的页面的流行让滚动页面植入到了用户的行为中。

至少在某种程度上。人们仍然不会滚动很多 —— 他们几乎不会滚动到三屏之外。基本上，首屏的界限已经被推到了第三个屏幕 —— 8 年前，用户浏览网页时间的 80％ 的停留在了在第一个屏幕信息中（首屏）；而今天，用户浏览网页时间的 81％ 停留在了前三个屏幕上。

我们总是说人们会在有理由的情况下滚动页面。人们的注意力仍然停留在页面顶部 —— 页面顶部是网页内容中最易发现且可能被用户查看的部分。滚动页面的[交互成本](https://www.nngroup.com/articles/interaction-cost-definition/)使用户几乎不会阅读较长页面下游部分的内容。

有趣的是，屏幕分辨率的增加并没有像人们预期的那样导致滚动的减少。原因可能是设计师和开发者没有利用更大的屏幕来减少滚动，而选择将内容进一步分散。无论好坏，现在鼓励用户滚动网页比过去更多 —— 但不能更多了。在网络的早期，[信息密度](https://www.nngroup.com/articles/utilize-available-screen-space/)可能太高了（这导致了拥挤和杂乱的布局），但现在的页面设计绝对是太稀疏了。

## 启示

鉴于用户在页面的顶部花费了更多的阅读时间，特别是在首页上，这里有一些你需要记住的事情：

*  **将高优先级内容放到页面顶部：关键业务和用户目标**。页面的下半部分可以放置次要信息或相关信息。将主要的 CTA 放到首屏。
*  **重要的内容使用合适的字体样式来引起用户注意**：用户根据标题和粗体文本等元素来识别信息的重要程度，并且定位新的内容片段。确保这些元素在视觉上与众不同，并在整个网站中保持风格统一，以便用户可以轻松地找到它们。
*  **注意不要使用“假地板”**，这在现代简约设计中越来越常见。完整性的错觉可能会干扰滚动。包括指示符（例如截断的文本），告诉人们下面还有内容。
*  **通过用户代表测试您的设计**，以确定[“理想的”页面长度](https://www.nngroup.com/articles/infinite-scrolling/)，并确保用户能够轻松地查看到他们想要的信息。

## 结论

虽然现代网页往往很长并且包含负空间，并且用户可能比过去更倾向于滚动页面，但人们仍然将大部分浏览时间花在了页面的顶部。内容优先级是您在内容规划过程中的关键步骤。强大的视觉指示符有时会诱使用户滚动页面并发现首屏以下的内容。要确定理想的页面长度，请与真实用户一起测试，并记住，很长的页面会增加失去客户注意力的风险。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
