> * 原文地址：[Scarcity in UX: The psychological bias that became the norm](https://uxdesign.cc/scarcity-in-ux-the-psychological-bias-that-became-the-norm-3e666b749a9a)
> * 原文作者：[David Teodorescu](https://uxdesign.cc/@davidteodorescu?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/scarcity-in-ux-the-psychological-bias-that-became-the-norm.md](https://github.com/xitu/gold-miner/blob/master/TODO1/scarcity-in-ux-the-psychological-bias-that-became-the-norm.md)
> * 译者：[Starrier](https://github.com/Starriers)
> * 校对者：[wavezhang](https://github.com/wavezhang)、[rydensun](https://github.com/rydensun)

# 用户体验中的稀缺性：成为常态的心理偏差

## 简要分析了现状，并给出了几个注意事项。

![](https://cdn-images-1.medium.com/max/1000/1*-XgzQw76IgZE2gwbOrNSCA.png)

你知道它的工作原理。

随便看了一篇 Unbox Therapy 关于这个杯子的测评，显然这个杯子的特点是不会倒。我在笑，但在视频的结尾，我很好奇人们对它的需求是什么。

在 Amazon 上可以找到，原价 $24.99 限时特价 $14.99，不锈钢版本的杯子只剩下三件。。我喜欢不锈钢，这很便宜，它们很快就会被卖光。也许我只能继续在自已之前的杯子中喝咖啡了，如果真是这样就太可惜了。💸

![](https://cdn-images-1.medium.com/max/800/1*r1wMSvUUzF8eccxymhsRbg.jpeg)

是的，大多数时间不会倒下。

* * *

### 这就让事情令人满意了

稀缺性是一种心理上的偏见，它使我们对稀缺的东西赋予了更高的价值。基本上，我们倾向于喜欢较难获得的东西。

* * *

### 它已经成为了常态

就像大多数事情一样，稀缺性是从线下开始的。昂贵的餐厅在大盘子上只供应小部分，这表明食材是稀缺的，名牌大学保持排他性的有限名额。

![](https://cdn-images-1.medium.com/max/800/1*Vt56n6UejBd6GOLn9NyW4A.jpeg)

这看上去非常昂贵。

但随着科技企业越来越成熟，数字产品也越来越精致，稀缺性很快在网上被采用，它现在是提高需求最受欢迎的方法之一。

我们已经到了这样一个地步：人们已经习惯于在网上浏览时看到并期待某种形式的稀缺，在你的产品中实现一种稀缺性已经不再是一种竞争优势，而是任何旨在满足用户需求目标的起点。

* * *

### 它结合了多种认知偏差

稀缺性之所以流行，是因为它非常强大，而且相当容易实现。它之所以如此有效，是因为它将多种认知偏差结合在一起：

#### 1. 损失规避

如果我们不对稀缺性产品采取行动，这基本上意味着我们将在短期内失去产品本身，但从长远来看，我们将失去选择它的自由。双倍的损失 = 加倍的痛苦。

![](https://cdn-images-1.medium.com/max/800/1*kMA-FslhlGIDlrYzOqVXsA.png)

#### 2. 社会证明

通常情况下，当需求很大时，产品就会变得稀缺。一旦发生这种情况，它意味着其他人在过去购买了它，所以它必须是有价值的，我们应该抓住这个机会。

![](https://cdn-images-1.medium.com/max/800/1*vYQJeMv3Ig2rVsngSQiIvQ.png)

#### 3. 预期遗憾

当我们面对一个决定时，我们不仅预料到事件的发生，而且预料到我们可能会经历与之相关的遗憾。决定现在采取行动是我们试图消除这种可能性的努力。

![](https://cdn-images-1.medium.com/max/800/1*3lDEBvknnYRvpuU-AmeM7w.png)

* * *

### 它有不同形式

尽管稀缺性可应用于质量或体验等无法量化的特性，但在评估可测量的资源（如对象或地方）时，它的效果要强大得多。这也是 Amazon 和 Booking.com 等公司接受并广泛使用它的原因。

基于这些可衡量的资源，主要有三种稀缺性形式：

### 1. 限时稀缺性

当时间有限制时，它会创造一个期限，让人们在时间结束之前行动起来。当截止日期未知时，人们不确定他们是否还能得到目标，除非他们现在就采取行动，这增加了压力，但从用户体验的角度来看，显示出缺乏同理心。

**例如：**

#### 在 Amazon 上的秒杀产品：好

它们持续会几个小时并显示最后期限。与之相伴的还有其他人为强调紧迫性而提出的百分比。

![](https://cdn-images-1.medium.com/max/800/1*-o8SOwM2cuwNsXvWk9Ykkw.png)

#### **交互设计基础课程：明智**

在注册结束前显示时间。全部预定的课程仍然展示给人们看，来让他们体验错过这个机会是什么感觉。

![](https://cdn-images-1.medium.com/max/800/1*gI1o7e2uhFVbPlDurYQhsg.png)

#### 在 eBay 上买东西：槽糕

限时产品有红色图标和模糊到“几乎消失”的标签。没有显示优惠结束时间是不合时宜和糟糕的操作。

![](https://cdn-images-1.medium.com/max/800/1*tbadRIMbFesPQPtSAZfrEQ.png)

#### 在 Airbnb 搜索地点：公平

它通过显示剩余列表的低百分比和一个“稀有”标签来显示人们对报价的限制，使他们对搜索感到幸运。

![](https://cdn-images-1.medium.com/max/800/1*Wx7V4DkqclV1Y-Gd3lJHKw.png)

### 2. 数量有限的稀缺性

人们认为有限或稀缺的物资会对他们的选择自由构成威胁，从而引起对抗威胁并保持对资源访问的反应。

> **数量有限的稀缺被认为比时间有限的稀缺更有效，因为供应的终点是不可预测的，完全取决于需求而非时间。**

**比如：**

#### 在 Booking.com 上查找酒店：令人印象深刻

预定是 Usain Bolt 的稀缺性，而且大部分成功都归功于它。它们显示房间的数量，但同时也显示了大量的标签，而且这些标签让你觉得你的生活非常舒适。

他们使用所拥有的大量数据的方式很明智，尽管这些数据非常庞大，但它们都是有用的。

![](https://cdn-images-1.medium.com/max/800/1*9F03hEXKTnjETwY0TR3zBQ.png)

#### 通过 Ryan Air 预定航班：非常好

他们利用便宜的座位先出售的事实，来突显以最低价格出售的数量有限的席位。

![](https://cdn-images-1.medium.com/max/800/1*ZFpVSmeUx9_ZSx6pcAZvBw.png)

#### 在 Selfridges 买衣服：Subtle

产品的详细信息显示可用和不可用尺寸。这样，它使得可用的感觉更稀缺。这微妙而有用，因为有些人的尺寸需求介于给定尺寸之间。

![](https://cdn-images-1.medium.com/max/800/1*4jmFwuyTRB9MwwIjFWkP5Q.png)

### 3. 访问受限的稀缺性

它指的是信息，组或空间等功能的有限访问。研究表明，审查制度使得人们更重视受限功能，而不是因为排他性使他们感到特别。

**例如：**

#### 订阅 Medium

如果你希望可以阅读其平台的所有内容，Medium 会收取费用。一旦你决定那么做，也意味着你成为了 Medium 特权用户。

![](https://cdn-images-1.medium.com/max/800/1*YnpAAetpwd1celecktHz-g.png)

#### 加入 Tinder Select

Tinder 使用 “Elo” 排名系统，根据需要来对成员进行评级，并邀请顶级用户加入名为 Tinder Select 的封闭版本。尽管对其他用户不公平，但它也只是做了它应该做的事情：通过给予活跃用户重视度来奖励他们。

![](https://cdn-images-1.medium.com/max/800/1*OCrjwQajhoWi5_CArlBf_g.png)

* * *

### 它拥有不应该存在的争议

如果适合我们设计的产品，稀缺性可以优化用户流程并影响商业目标。在紧急情况下，它会重构信息并通知用户。

> 可能有人会说，这迫使他们做出决定，但只要数字是真实，我们别无它选！是因为我们没有及时告知他们产品稀缺而造成的遗憾和沮丧？如果发生这种情况，我们不是在提供糟糕的用户体验么？只要我们向他们介绍事实，促使人们匆忙做出决定似乎是相当公平的。

话虽如此，我同意一些企业利用这一优势，不道德地利用它，制造假库存和会员身份。但对于任何其他使用可疑意图的方法而言，久而久之，导致信誉受损是毫无疑问的。

![](https://cdn-images-1.medium.com/max/800/1*0yTyOzOVgnL-XbRRj3escA.png)

* * *

### 它应该遵循一些规则

为了避免此类情况发生，以下建议可以充分利用稀缺性，而且可以切实改善用户体验：

#### 可以做的事情

*   使用**稀缺性**来提高感知价值并加速转换
*   使用**时间稀缺性**来推广对时间敏感的产品
*   使用**数量稀缺性**让人们意识到库存短缺
*   使用**访问稀缺性** 来突出受限功能的特性
*   使用 **A/B 测试**来测试那些稀缺性消息对受众最有效
*   使用**可用性测试**来测试消息对可信度和信任度的影响
*   使用**动画元素**来强调紧迫性（例如，显示一个发光的红色图标以突出实时状态）

#### 不可以做的事情

*   不要在**没有测试**的情况下使用稀缺性，因为它首先应与用户结合使用
*   如果库存**不可信**，不要使用稀缺性
*   如果信息**没有缺陷**，不要使用稀缺性
*   不要使用**虚假数字**人为制造稀缺产品

* * *

### 结论

稀缺性让我们对稀缺事物有了更深层次的认识，随着时间的推移，它已经成为提高效益的方法。它很强大，因为它结合了很多种认知偏差（损失厌恶，社会证明和预期遗憾），而且存在多种实现形式（时间，数量和访问）。 

但这不应该存在争议，因为对人们隐藏信息不是一个真正的选择。如果你遵循一些简单的规则，还可以提升用户体验。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
