> * 原文地址：[Responsive design ground rules](https://polypane.rocks/blog/responsive-design-ground-rules/)
> * 原文作者：[Polypane](https://polypane.rocks/blog/)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/responsive-design-ground-rules.md](https://github.com/xitu/gold-miner/blob/master/TODO1/responsive-design-ground-rules.md)
> * 译者：[Pingren](https://github.com/Pingren)
> * 校对者：[Moonliujk](https://github.com/Moonliujk)，[Chorer](https://github.com/Chorer)

# 响应式设计的基本原则

创建响应式设计令人胆战心惊：它由许多移动的部分构成，而且经常不像你期望中一样排列；你在设计的时候还要惦记着所有不同的视口（viewports）。通过遵守这些基本原则，你可以创建出更加健壮和可预测的响应式设计。

## 原则 #1：保持简单的视口

当初刚实施视口元标记（viewport meta tag）的标准时，基本常识是你必须添加各种值，从而阻止用户缩放，以及设置最大和最小的屏幕尺寸。结果表明，这其实是对用户不友好的做法。

事实上你只需要做两件事：把宽度设置为展示你的网站的设备宽度，以及保证初始缩放为 1。这么做代表了你 CSS 中的 1 像素等于 1 设备独立像素，像这样：

```
<meta name="viewport" content="width=device-width, initial-scale=1">
```

## 原则 #2：移动优先

你在一台大笔记本电脑或桌面显示器上开发网站，并且，通常情况下你的客户更在意网站的桌面设计。因此，你可能自然觉得就先从桌面设计开始开发。但是，优先开发移动端其实更简单，而且会让你的代码更少。

如果你先开发移动端，你将在开发中逐渐增加 CSS 的复杂度。你的手机视图通常简单许多，需要更少的 CSS。手机视图通常永远只有一列，缺少许多额外的装饰和效果。毕竟在更大的屏幕才有空间展示它们。若你的开发“移动优先”，随着你为越来越大的媒体查询增加样式，你在**补充**设计。

如果你先开发桌面端，你已经有了所有的样式，仅仅为了撤销你高级的桌面样式，你就需要写**更多**的 CSS。你写了更多的 CSS，如果其中有一处不小心没写好，就会出现诸如布局水平溢出或是文本大小不合适的问题。

通过移动优先，你将避免大量**非必需**的 CSS，使你的 CSS 更轻，网站更快。

## 原则 #3：根据内容设计

你可以选择使用 320 px，375 px，768 px 以及 1024 px 这样的值作为你的断点（breakpoint）。它们对应了真实设备的宽度。这就是基于特定设备的设计。但是当新的设备变得更流行 **(#375IsTheNew320)**，在那些新设备上，你的设计看上去可能就不是很好了。

[Stephen Hay](http://the-haystack.com/)，[响应式设计工作流](http://www.peachpit.com/store/responsive-design-workflow-9780321887863) 的作者，建议你从小屏幕开始，接着“增加屏幕宽度直到丑出天际，是时候加入断点了！”

专注于内容，让你不得不把网站当成自然流动的布局。你无法只为完美像素的宽度设计，因为这些宽度**不存在**。

经验：当你想要行宽在 70 个字符左右时，那差不多等于（取决于字体！）36 到 40em。

## 原则 #4：在媒体查询中使用 em

既然特定的设备宽度不再重要，你也应该把像素单位的宽度断点改成 **em 单位的宽度**。你的媒体查询基于内容。这样一来，即使用户把浏览器的基础字体调大/调小或缩放浏览器，你的网站依然看上去很棒。

如此调整你设计的其余部分，让你的网站更加健壮。

## 原则 #5：最小或最大宽度，只选一个

响应式设计实现了一个十分复杂的系统。当你的媒体查询使用最小宽度和最大宽度，或是混合使用它们时，复杂度便极度增加，理解这个系统也更难了。

如果所有的媒体查询“向上”或“向下”工作，而某个尺寸下你的网站看上去和预期不同时，你总能知道该看看哪儿的代码。在新的媒体查询中写 CSS 永远不会影响你之前已经写好的屏幕尺寸。你只需要找出从哪个媒体查询之下（或上）去更新 CSS 就好。

## 原则 #6：避免固定的尺寸

将元素设置成固定的尺寸也许很吸引你。毕竟，你最喜欢的设计交接工具可能让你轻松地拷贝它们。如果你不小心，固定宽度（或边距）很容易破坏你的布局。

尝试把元素的尺寸设置成与它们的环境相关。使用百分比或者视口单位。避免设置 `width` 和 `height`，尝试设置相应的 `min-` 和 `max-`。如果你发现 `width` 对布局造成了破坏，一个 `max-width:100%` 可以创造奇迹。

## 原则 #7：使用现代布局技术

基于上条原则，例如弹性盒子（Flexbox）和网格（Grid）的现代布局方法，天生就很灵活，还能根据它们的环境改变大小。如果你使用这些布局方法，你只需要更少的媒体查询就能实现相同的设计。更少的媒体查询意味着更少的事情需要你推理，而你的代码也变得更简单。

[Every-layout.dev](https://every-layout.dev/) 上你可以（重新）学习如何使用弹性盒子和网格布局构建常用布局。它列出了一些常用的布局，并且解释了如何使用现代技术构建它们。

## 原则 #8：为字体渲染的不同预留空间

在一个不合适的换行处创建一个断点很吸引你。为了让“像素完美”。当然，我们知道 web 从来没有过所谓的“像素完美”。

如果你的断点距离可读的换行太近，它可能在**你**的浏览器可用。在不同浏览器和不同操作系统下有着不同的渲染方式。这意味着一行字可能会宽或窄几个像素，从而破坏你的设计。

尝试对你的媒体查询宽松一点，用一些像素为可能的错误预留一点空间，防止你的设计发生巨大的变化。

## 原则 #9：在浏览器内决定

为了遵守这些规则，在设计工具里创建所有断点是不明智的。另一方面，在浏览器内设计整个网站也很难。那么折中办法是什么？

你可在设计工具里创建设计，以及一些粗略的响应式版本。但是，在你在浏览器内**工作时**才可以决定转换到另一个设计。Sketch 画板的宽度可能是 750 px，但如果你在浏览器内发现布局已经在 44 em（相当于 704 像素）工作得很好，那么就在 CSS 中使用 44 em。

## 原则 #10：尝试 Polypane

通过 Polypane，以移动优先，内容优先的方式创建网站和 App 变得十分自然。从一个小面板开始设计你最小的屏幕。接着，添加一个新的面板，将它变宽直到它如同 Stephen 所说的 “丑出天际”。然后检查面板的宽度，并用那个 `em` 值作为你的新断点。设置样式然后不断地重复直到完成。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
