> * 原文地址：[React Native vs Flutter: Which Is More Startup friendly?](https://hackernoon.com/react-native-vs-flutter-which-is-more-startup-friendly-c6e412d0b9ab)
> * 原文作者：[Mantra Malhotra](https://hackernoon.com/@valuecoders.vc?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/react-native-vs-flutter-which-is-more-startup-friendly.md](https://github.com/xitu/gold-miner/blob/master/TODO1/react-native-vs-flutter-which-is-more-startup-friendly.md)
> * 译者：[tanglie1993](https://github.com/tanglie1993)
> * 校对者：[davelet](https://github.com/davelet)

# React Native 对 Flutter：哪一个对创业公司更加友好？

![](https://cdn-images-1.medium.com/max/800/1*Qnt_ctP0ZrlL959Dj3HZAw.jpeg)

由于对移动应用的大量需求，很多公司已经把他们应用开发的重心转移到移动应用上了。

移动应用开发是一个不断有更好的技术、平台和框架流入的领域。这使得移动开发者可以创建革命性的移动应用。

现在，跨平台应用开发正在创业公司中变得越来越流行。开发者可以用它来设计电子商务应用、各种交互应用和社交应用。

因此，react native 和 flutter这两个移动应用开发框架引起了广泛的讨论，并且互相竞争，试图证明自己是跨平台移动应用的最合适的宿主。

React native 是被 Facebook 开发的，并且很快获得了大众的欢迎，使得公司从中获益。Google 的 flutter 是移动应用开发的新技术，但它能够创建美丽的原生应用，并且帮助开发者轻松创建跨平台应用。

在这篇博客中，我们基于下述的各种参数，比较了这两个移动应用开发框架（react native 和 flutter）。

这将有助于创业公司轻松选择最适合他们开发移动应用的框架。你也可以从顶级的移动应用开发公司 [**招聘开发者**](https://www.valuecoders.com/hire-developers?utm_source=hiredev_reactflutter_medium&utm_medium=mantra)来使你的开发工作更加出色。

**比较所基于的参数如下：**

**1）用户界面**

![](https://cdn-images-1.medium.com/max/800/1*geJ1v8mM6-GTA6PDvdFKbw.jpeg)

在用户界面中创建块，在 React Native 和 Flutter 中有很大的不同。Reactive Native 是基于 native 组件的。但是，Flutter 的情况是完全不同的。它通过用户私有的控件集来良好地工作。实际上，用户私有的控件非常令人激动，它能给你完全自定义的 UI 设计，并提供了与原生环境良好交互的能力。

不幸的是，这也有一些缺点。举例来说，Cupertino 库缺少 iOS 风格的控件。这对于[**移动应用开发者**](https://www.valuecoders.com/hire-developers?utm_source=home_reactflutter_medium&utm_medium=mantra)来说，是一个很大的问题。在 react native 对 flutter 的战争中，react native 的用户体验要好很多。

**胜者（react native 与 flutter 的比较）：** React Native

**2）开发时间**

![](https://cdn-images-1.medium.com/max/800/1*Jv0iakVUFYTAhDpBQeMbXA.png)

最近出现的移动应用开发公司擅长按时交付项目，而 React Native 一直是这些公司最好的伙伴之一。这个框架缩短了移动应用开发的时间表，为用户界面添加了内容并减少了开发项目所需的时间。

在 react native 与 flutter 的比较中，Flutter 是新的，并且需要大量的时间开发项目。React Native 具有完整可用的组件，它帮助开发者加速移动应用开发，而不会给开发者带来太多额外的问题。Flutter 也承诺具有很高的可用性，但这个开发框架还需要更多用户的认可。

**胜者（react native 对 flutter）：** React Native

**你可能会喜欢：[如何做出一个省钱的移动应用？](https://www.valuecoders.com/blog/technology-and-apps/make-budget-friendly-mobile-app/?utm_source=blog_reactflutter_medium&utm_medium=mantra)**

**3）性能**

![](https://cdn-images-1.medium.com/max/800/1*Nu2WBSE8G_GilhJ0gzqmmw.png)

对这些框架（比如react native 和 flutter）的一个好的比较，可以给我们很有信息量的结果，特别是在性能方面。了解这些语言的移动应用开发者们，会同意在这方面给 Google 的 Flutter 加分的。由于 Dart 框架的存在，Flutter 和它的竞争对手相比是有优势的。而且，Javascript 层可以使开发者更容易地和原生组件通信。

在另一方面，React Native 有很多的支持者，但开发者们知道创建 hybrid 应用的痛苦。但是，对于 native 应用而言，这个框架特别能够适应需求。这个框架意味着开发者在创建具有 native 环境的应用时不会遇到问题。

React Native 在 hybrid 应用中的使用使得开发者在运行架构、native 组件和库方面难以不遇到问题。在另一方面，Flutter 使开发者很容易复用现有的代码。它的 C++ 引擎支持这种语言，这对开发者也有一定吸引力。

**胜者（react native 对 flutter）：** Flutter

**扩展阅读:** [**适合创业公司和中小型公司的印度移动应用开发公司 | 2018**](https://hackernoon.com/top-mobile-app-development-companies-in-india-for-startups-and-smes-2018-4059ed17a0ca)

**4）稳定性**

![](https://cdn-images-1.medium.com/max/800/1*sO7kdtL_RaVhGTCHf881FA.png)

说到 react native 和 flutter 的比较，稳定性是对 [**移动应用开发公司**](https://www.valuecoders.com/mobile-application-development?utm_source=home_reactflutter_medium&utm_medium=mantra) 而言最重要的方面之一。竞争看起来有些难，因为 Flutter 只有 alpha 版本，不太有竞争力。这个版本不适合大型项目。

但是，在去年，Google 发布了 Flutter beta 2，它给开发者提供了出色的 beta 工具。React Native 有来自一个大社区的支持，并从发布以来一直很稳定。由于 Flutter 仍然在努力争夺业界支持，React Native 似乎是 react native 和 flutter 的战争中这个方面的赢家。

**胜者（react native 对 flutter）：** React Native

**相关材料：[Native 应用对 Hybrid 应用开发：选择什么？](https://www.valuecoders.com/blog/technology-and-apps/native-app-vs-hybrid-app/?utm_source=blog_reactflutter_medium&utm_medium=mantra)**

**5）客户**

![](https://cdn-images-1.medium.com/max/800/1*dyDl69cH8Vr-8X0U2PZMkA.jpeg)

React Native，目前在业界的流行程度是不用说的。对于各种年龄的开发者而言，它一直是最有前途的移动应用开发框架之一。他对于开发所有规模的项目而言都有合适的组件。在这个框架的客户中，有一些重要的名字，如 Skype、Facebook、Tesla、Airbnb、Instagram 和 Walmart 等等。

因为 Flutter 是在几年前被发布的，它仍在试图在业界创造一些存在感。作为一个仍在奠基阶段的框架，它还需要一段时间来扩大发展势头。目前，你在应用商店只能看到一个 “Hamilton” 应用。但是，随着时间的流逝，你将肯定会发现更多的著名品牌。

**胜者（react native 对 flutter）：** React Native

**6）文档 & 工具箱**

![](https://cdn-images-1.medium.com/max/800/1*B18aQH_4ZDsIoudtJ2gv1g.png)

使用文档和工具箱的过程可能是相当复杂的。对于写文档而言，Flutter 加快了这个过程。另外，它使得[**移动应用开发者**](https://www.valuecoders.com/hire-developers/hire-mobile-app-developers?utm_source=home_reactflutter_medium&utm_medium=mantra)在写文档时可以更轻易地使用它们。因此，Flutter 和它的竞争对手相比，无疑是出色的选择。

在另一方面，React Native 的文档处理显得有些笨重。另外，这个框架省略了一系列可以改善开发体验的工具。所以我们可以发现，两种框架在开发工具方面的竞争很激烈。Flutter 有广泛的支持 React Native 的 IDE 和工具。它和 Visual Studio Code、Android Studio 等具有良好的兼容性。这使得这个框架更加出色。

**胜者（react native 对 flutter）：** Flutter

**扩展阅读：[9 个最好的 JavaScript 移动应用开发框架](https://www.valuecoders.com/blog/technology-and-apps/top-javascript-frameworks-for-mobile-app-development/?utm_source=blog_reactflutter_medium&utm_medium=mantra)**

**结论：**

所以，我们已经看到了两个[**移动应用开发框架**](https://www.valuecoders.com/mobile-application-development?utm_source=home_reactflutter_medium&utm_medium=mantra)是否适用于创业公司的一个详细的比较。如上所述，他们在稳定性、性能、文档等方面都各有优缺点。

然而，很难确定其中哪一个是胜者，因为它们各自都有优缺点。按我的观点，Flutter 是新框架，它需要一些时间稳定下来，并且和已经很流行的移动应用开发框架 React native相比还有一段路要走。因此，React native 是一个好的选择。在目前可以被视为胜者。

无疑，Flutter 也可作为一个好的选择，因为它可以创建漂亮的移动应用，并能帮助创业公司在更少的时间中获取收入。而且，它有一个好的未来。如果你计划开发出色的移动应用，从像 ValueCoders 那样顶尖、可靠的移动应用开发公司[**雇用专业的应用开发者**](https://www.valuecoders.com/hire-developers/hire-mobile-app-developers?utm_source=hiremobile_reactflutter_medium&utm_medium=mantra)吧。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
