> * 原文地址：[Rage Against the Codebase: Programmers and Negativity](https://medium.com/@way/rage-against-the-codebase-programmers-and-negativity-d7d6b968e5f3)
> * 原文作者：[Way Spurr-Chen](https://medium.com/@way)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/rage-against-the-codebase-programmers-and-negativity.md](https://github.com/xitu/gold-miner/blob/master/TODO1/rage-against-the-codebase-programmers-and-negativity.md)
> * 译者：[Badd](https://juejin.im/user/5b0f6d4b6fb9a009e405dda1)
> * 校对者：[TokenJan](https://github.com/TokenJan), [Tina92](https://github.com/Tina92), [江五渣](http://jalan.space)

# 冲冠一怒为代码：论程序员与负能量

![他们怎么能这么对我们](https://cdn-images-1.medium.com/max/2800/0*txg_xQ7yZ5ucNocs)

**（本文已被译为[俄文](https://habr.com/ru/company/mailru/blog/448956/)和[西班牙文](http://blog.pabloreyes.es/personal/programadores-negatividad/)，十分感谢译者们。）**

此刻我正凝视着一段代码。这段代码，可以说是我见过的最烂的代码之一。为了更新数据库中的单条记录，其作者竟然把集合中的每条记录都获取到，更新后再为数据库中的**每条记录**都发送一个请求 —— 而不仅仅是只操作需要更新的那一条。代码中还有一个 map 函数，除了返回传入的值以外别无他用。还有一些条件判断语句，似乎是用来检查值相同而命名风格不同（驼峰风格和下划线风格）的变量。每一次的更新操作（动辄操作每条记录，包括没有变动的条目），都要向消息总线发送一条消息，用以调用另一个无服务方法，此方法为同一个数据库中的另一个集合执行所有工作。我是不是还没提到这是面向云“服务”的“架构”中的一个无服务函数，像这样的函数每个环境里都有 100 多个？

这还是人干的事吗？我把脸深深埋进手掌，禁不住边笑边哭出了声。同事们都问我怎么了，于是我向他们绘声绘色地描述了这段 Chuck Parsley 出品的 2018 年年度 BulkDataImporter.js 最垃圾代码榜单。每个人听了都同情地点头，我们都觉得：他们怎么能这样对我们？

## 负能量：编程文化中的情绪工具

负能量是编程中的重要组成部分。负能量在多个层面上根植于我们的文化，这是我们分享经验和撕逼故事（“代码写成这样，**你敢信**？”）、表达和同情挫败感（“皇天在上啊！怎么能干出这种事啊！”）、把我们自己粉饰得更优秀（“换做是我，才不会写得**这么烂**呢”）、甩锅踢皮球（“我们失败了是因为 Chuck Parsley 的代码烂泥扶不上墙”）或者在氛围差劲的组织中羞辱并操纵别人（“写代码能不能走点心？赶紧修复你的 Bug！”）的方式。

![来自 [ProgrammerHumor](https://www.reddit.com/r/ProgrammerHumor/comments/b4jfr7/i_cant_be_the_only_one/)](https://cdn-images-1.medium.com/max/2000/0*pa37xHLBNNcqhOrg)

对程序员这个群体来说，负能量太重要了，因为这样传达价值观最有效。当我在一个编程培训班执教时，用适当的恶搞图、传闻逸事和视频向学生灌输行业文化是标准做法，而这些素材中最流行的主题就是围绕[程序员在外行面前的挫败感](https://www.youtube.com/watch?v=BKorP55Aqvg)的。想要指出哪些行为习惯是好的、坏的、坏到家了绝不要犯的，借助情绪工具来表达再合适不过了。应该帮助新手程序员们做好心理建设，让他们知道他们会被非技术行业的同事以这样那样的方式误解；会有朋友们来安利他们的“价值百万”的 App 创意；会被压在“祖传代码”的五指山下，任你一个筋斗 8848 光年也难以脱身。

当我们刚开始学习写代码时，我们通过观察他人对代码的情绪反应来判断代码的好坏。看一看 [ProgrammerHumor 版块](https://www.reddit.com/r/programmerhumor)吧，那里到处都是新手程序员，看看里面的帖子你就会深切体会到这一点。许多帖子表达的幽默带有各种各样的负面情绪：挫败感、悲观、愤怒、幻灭感和傲慢等等。（如果你想见识见识真正的负能量，那就读读评论吧。）

![来源：[ProgrammerHumor](https://www.reddit.com/r/ProgrammerHumor/comments/b7mlgt/programmers_d/)和 [Twitter](https://twitter.com/type__error/status/1111972689609138177)](https://cdn-images-1.medium.com/max/2000/0*jpOE1g8Udhv_0WRk)

我注意到，程序员的负能量常常随着经验的增长而增长。当程序员还是萌新的时候，他们不知道有什么坎坷等着他们，所以他们踌躇满志地迈开脚步，愿意相信路途艰险只是因为他们经验还不足、眼界还不宽，他们自信最终能够掌控一切。

随着时间的流逝和学识的增长，当初的萌新现在已经能够分辨代码的优劣。一旦进入这个阶段，他们就会直接体会到工作中遇到的烂代码带来的挫败感，如果他们身处于一个团体（无论是线上团体还是一个实际团队）中，团体中比他们资深的程序员的情绪习惯，会频频出现在他们身上。现在他们能够头头是道地分析代码、区分代码的优劣，这种方式让他们显得很“懂行”，负能量通常就是在这种过程中积压起来的。越是消极越是有好处：表达挫败感能帮你轻松与同事打成一片、融入团队，并且贬低烂代码能够抬高自己，让你表现得更加像个优秀的工程师 —— [消极地表达观点的人通常被认为更聪明、更能干](https://www.wired.com/2014/11/be-mean-online/)。

这种负能量的增加并不一定是件坏事。探讨编程时最主要的就是非常关注所写的代码的**质量**。代码的质量决定了性能（不考虑硬件、网络等因素），因此能够针对代码表达出自己的观点很重要。几乎所有的关于代码的讨论都可以归结成是对于代码质量的评定，简单的一句评语里就蕴含着评价代码质量的情感：

* “那个模块里有很多地方的逻辑都前后不一致，应该优先进行重要性能优化”
* “那个模块写得挺烂的，应该重构”
* “那个模块狗屁不通，赶紧回炉重造吧”
* “那个模块写得真垃圾，需要修补修补”
* “那个模块就是一坨屎，把它写出来就是犯罪，Parsley 脑子里想他喵的什么呢”

（顺便说一句，这种“情感的火花”会使开发者们用“性感”来形容代码，这样的形容不太应景 —— 除非你在 PornHub 上班。）

当然了，问题在于，人类就是一种奇怪的、摇摆不定的情绪化动物，接收**和**表达的情绪都能改变我们 —— 这种改变一开始是细微的，而经过漫长的历程后，这种改变就扎根深处了。

## 负能量是一条曲折泥泞的下坡路

几年前，我是一个非正式的团队领导，为我司面试过一位开发者。我们非常喜欢他；他敏锐、善于发问、有技术才能，并非常契合公司文化。我特别欣赏他的积极向上和踏实肯干。因此我们聘用了他。

彼时，我已经在公司任职多年，意识到了公司文化中缺乏进取意识。我们曾几次三番想要推出一个产品，甚至在我入职前就已经失败过好几次，屡次不成导致耗资巨大，换来的结果不过是连续挑灯夜战、一推再推的交付日期和好歹算是能用的产品。虽然我还在尽职尽责地努力工作，但对于管理层下达的最后期限，我的怀疑态度溢于言表。每当和同事讨论起代码中某些令人生厌的部分时，我就信口开骂。

几周后，那位新聘进来的开发者表达出了和我一样的负能量（连骂法都一模一样）—— 其实这本在情理之中，却出乎我意料之外。我感觉这并不是他的本色表现，或者换一家文化不同的公司，他的举止又该有所不同。但他偏偏吸收了**我传达的**文化，只是为了融入团队。我肠子都悔青了。只因为我自己的主观感受，就给新员工设定了一种消极的基调，而我觉得他**本不**至于如此。就算那些负能量的表现并非他的真实感受，只是为了体现他和同事脾气相投，那也要怪我把恶劣的态度展示给他了。常言道，近朱者赤，近墨者黑。

![来源：[Nedroid](https://nedroidcomics.tumblr.com/post/41879001445/the-internet)](https://cdn-images-1.medium.com/max/2000/1*GIkVcbGg5anbC_ONap_1FA.png)

## 负能量的阳关道和独木桥

对于我们现在的中级开发人员来说，能从过往经历中获得一些智慧和经验是一个快乐的故事：他们在编程行业的见识越来越广，意识到烂代码无处不在、如影随形。就算在那些最先进、最注重代码质量的公司中，烂代码同样存在。（而且我跟你说，现代化并不总是治愈烂代码的良方。）

因此到后来，这些开发者开始接受这样的事实：烂代码注定就是软件的一部分，而他们的工作就是优化这些烂代码。若不少见，则无需多怪。他们采取佛系心态，专注于如何解决摆在眼前的问题或者任务，学着如何精确评估软件的质量情况，并传达给利益相关者，他们凭多年经验，将软件质量吹得天花乱坠。最终凭借卓越而一贯地奉献，他们得到了丰厚的奖励。他们功绩丰伟，故此得到上千万美元的奖金，然后退休去做他们想做的事，以此度过余生。（我的结局可千万也要如此美满啊！）

![就像这样](https://cdn-images-1.medium.com/max/2000/1*TeH2pZNcdmMlT8QyDsSWXg.png)

而另一部分人则走上了一条黑暗之路。他们没能觉悟到烂代码是避无可避的，他们笃信烂代码是软件中的痈疽，他们毅然扛起大旗，势要干掉烂代码。他们之所以拒绝与烂代码安然共处，确有很多充分的理由：人们应该越来越聪明，不能越来越笨；烂代码是对程序员的冒犯；烂代码影响生意；消灭烂代码能证明我是个小机灵；要是我不指出这代码有多烂，那我们整个公司就要破产倒闭关门大吉了。

不幸的是，由于业务需求推着他们持续开发功能，他们无暇去操心代码**质量**，于是无力去实施那些优化代码的宏伟计划，最终只好变成了“怨妇”。由于他们还是能胜任工作的，所以暂时没被辞退，但会被发配到公司的角落，这样既不会打扰到别人，又能保证关键系统的运转。于是他们没法获得新的开发机会，他们的技能逐渐萎缩，逐渐被业界所边缘化。他们胸中的郁结溃烂流脓，而后结成坚硬的痂，他们会发现自己喜欢和二十多岁的 CS 学生争论那些他们最爱的老旧技术如何如何可行、怎么怎么好用 —— 以此来维持自尊。最终，他们退休了，终日对着鸟儿发脾气泄愤。

现实情况可能处于两种极端之间。

有些公司在极端消极的、颇具地盘观念的、强势的文化氛围下，能够发展得相当好 —— 例如[迷失年代](https://www.vanityfair.com/news/business/2012/08/microsoft-lost-mojo-steve-ballmer)之前的微软，这些公司往往拥有一款市场前景极好的产品并急需扩张；或者往往以命令和控制为结构（Steve Jobs 鼎盛时期的苹果公司），所有人都只听一人号令，至于他们自己的看法嘛，不重要。然而，现代商业调查（现在已经成为常识）一次次表明，要做到宏观层面的革新和微观层面的尽善尽美，需要顶级的创造力，而顶级的创造力来自不受高压限制的流畅、有创造性且有条理的思路。当你担心同事会对你写的每一行代码出言不逊时，你很难开展语言驱动的、创造性的工作。

## 码农“流行”文化中的负能量 

如今，工程师们的态度正受到前所未有的关注。[“不犯浑原则”](https://www.amazon.com/Asshole-Rule-Civilized-Workplace-Surviving/dp/1600245854)的概念在工程组织中越来越常见。Twitter 上涌现了越来越多的奇闻轶事，说的都是人们因为无法（不愿）忍受排外观念和地盘观念，而彻底退出编程行业。即使是 Linus Torvalds，也为自己多年来对其他 Linux 开发者（总是因为 Linux 的效用性而争吵）的敌意和斥责发表了[道歉声明](https://arstechnica.com/gadgets/2018/09/linus-torvalds-apologizes-for-years-of-being-a-jerk-takes-time-off-to-learn-empathy/)。

> 我们的编程领域正在逐渐敞开大门，欢迎那些并非成长于早期技术大爆炸时期的极客文化中的人们，而他们最终会成就一个崭新的编程领域。

Linus 如今已经摈弃了过度苛刻的态度，可有些人却仍旧对那种态度点头称是 —— 这些人本该对负能量的利弊深有体会。在正确性上较真倒是没错（就算是称为基本原则也不为过），但当你问起他们为何非要用带刺伤人的方式表达消极观点时，他们开始端起家长做派或者青春期少年的自负腔调：“他们太蠢了活该被骂”、“我得确保他们不会再犯”、“如果他们没出错，我也不会冲他们吼啊”等等。（关于领导者的情绪趋向会多大程度地影响开发社区，我再举一个例子，我们可以看看 Ruby 社区的八字真言 MINASWAN：“Matz is nice and so we are nice” —— Matz 是 Ruby 的创始人。）

我发现，大多数持有“干掉傻瓜”心态的狂热分子往往是那些深切关心代码的质量和正确性的人，他们将身份认同建立在代码质量上。可惜，他们常常分不清忠言逆耳和出言刺耳。这种心态的至暗面来自于人类向他人秀优越的原始欲望，这种欲望完全合乎人性，但毫无价值。那些不能战胜这种欲望的人，往往会陷于黑暗的困局。

![来源: [ProgrammerHumor](https://www.reddit.com/r/ProgrammerHumor/comments/bcb4w3/a_meme_i_had_in_the_back_of_my_mind_for_a_while/)](https://cdn-images-1.medium.com/max/2000/0*nlR4DmkDp0WRnV4h.png)

编程领域正在迅速扩张，即将触碰到其边界 —— 非编程领域。（又或者说，编程领域包裹着非编程领域？欲知答案如何，且听下回分解。）

随着我们的行业发展得越来越快、编程变得越来越平易近人，“大神”和“龙套”的差距也在迅速缩小。编程领域正在逐渐敞开大门，欢迎那些并非成长于早期技术大爆炸时期的极客文化中的人们，而他们最终会**成就**一个崭新的编程领域。并且，无论何种社会或年代，资本主义的对效率的要求终将体现在企业文化和招聘实践中：最好的企业根本不会雇佣那些不能与他人平和地相处的人，更不用说那些待人不善的人了。

## 我从负能量中学到了什么

我们不能任由过度的负能量支配思维和交流方式，更不能使之形成流毒，因为这对生产团队是很危险的，也会让企业付出高昂代价。我数不清我看过（和听过）多少软件项目下马、以高昂的代价完全重造，仅仅是因为某个受信任的开发者的一己之私见，认为即使是一项技术、一个之前的开发者的遗留代码或一个文件，都能代表整个项目的质量，一丁点不合格就要磨刀霍霍。散发负能量也会使人泄气，使人际关系紧张。就因为我把 CSS 代码写进了错误的文件里，被一位同事严厉地斥责，这让我闷闷不乐，好几天都心神涣散，我一直对此耿耿于怀。我以后也不太可能让那种人接近我的团队。（但谁能说得准呢？士别三日当刮目嘛。）

负能量也[确实对你的健康有害](https://medium.com/the-mission/how-complaining-rewires-your-brain-for-negativity-96c67406a2a)。

![我设想的亲切欢快的工作氛围](https://cdn-images-1.medium.com/max/2000/0*P7DjTZk4qoRsoIhG.jpg)

这并不是说只保留积极向上的态度，每发起一个 Pull Request 都要配上 100 亿个表情符号，或者必须保持愉快的工作氛围。（当然了，如果那就是你所希望的，那就去做吧。）负能量是编程中（也是人生中）极其重要的部分，它是表示代码质量情况、表达感受以及同情同胞的方式。它代表着一个人具有发现症结的洞察力和判断力，它标志着问题的严重程度。我常常说，当一个开发者开始从胆怯和不确定的状态变得敢于表达质疑时，这意味着他已经跃升到了一个新的层级。这能证明他的洞察力和对自己观点的信心。消极的表达方式是不可能完全避免的 —— 除非是奥威尔式的社会。

然而，负能量应该与其他基本的人类品质相搭配，如：同情、耐心、含蓄和幽默。在必要时，你可以告诉某人他搞砸了，但不必用吼叫骂人的方式。（可别小瞧这样的方式，如果有人用完全无感情的方式指出你完全搞得一团糟，你也会心惊肉跳一番。）

几年前我还在那家公司的时候，CEO 找我谈话。我们略微聊了一会项目的当前状态，然后他问我觉得自己表现得如何。我告诉他说我觉得还不错，项目进展顺利，我们也一直在努力，可能有些东西有所遗漏，需要着重关注一下。他说他对我在办公室发表的某些消极观点有所耳闻，并且其他人也已经注意到了。他解释说，如果我有什么顾虑，都可以随意向管理层传达，但注意不要在同事间传播。作为公司里一位开发领导，我必须谨言慎行，注意自己的举止对他人的影响，不管我自己是否能意识到，我的影响力都是很大的。他非常和善地说了这些话，最后说如果我也有同感，就应该考虑考虑自身和职业生涯的诉求是什么。他把“好自为之，不然就滚”的辞令表达得非常和风细雨了。我很感激他能够诚恳地知会我，让我明白过去六个月里，自己的态度下滑影响到了他人而不自知。

> 归根结底，我来到这里是为了完成一项任务，大发牢骚无益于理解、评估或修复代码。

这个例子诠释了什么是优秀而高效的管理，什么是怀柔策略的力量。我意识到，当我开始完全信任公司和其实现目标的能力后，我和他人交流的方式真的完全不同了。我还意识到，就算我对正在跟进的项目持怀疑态度，也没必要向同事们表达出来，这样的消极情绪会像瘟疫一般蔓延，导致军心不稳，顺利完成项目的可能性也就更小了。正确的做法是直言不讳地向管理层反映实际情况。如果我觉得他们没听进去，我还可以潇洒走人嘛。

后来我得到了一个新的机会，成为了一名正式的人力资源绩效评估经理。作为一个合格的开发经理，我更加注重自己对（持续优化的）遗留代码表达观点的方式。要实施改变，你必须认清现状，但如果你陷入了哀叹、消极怠工或任何消极反应，你将一事无成。归根结底，我来到这里是为了完成一项任务，大发牢骚无益于理解、评估或修复代码。

事实上，我越是约束我对代码的情绪反应，我对代码看得就越清晰透彻，内心的混乱就会越少出现。当我用委婉的方式（“这里可能还有些改进空间”）表达时，我和他人都开心，更能显示出对事不对人的态度。我还意识到，通过完全地（招人烦地？）保持理智（“你是对的，那个代码**确实**相当糟糕，但我们会改进的”），我可以化解他人的负能量。我很期待自己能在佛系路线上走得更远。

重要的是，我反复不断地参悟到一个深层次的道理：生命太短暂了，没有时间去发火或痛苦。

![来源: [xkcd #1024](https://xkcd.com/1024/)](https://miro.medium.com/max/533/0*5-f0--cc80oJF26i.png)

附言：如果喜欢本文，请啪啪啪。（听起来并不怪怪的。）如果你对我所尝试的佛系路线感兴趣，[欢迎加入我司](https://www.volusion.com/careers)。

—

***Chuck Parsley 属虚构角色。若您恰巧同名，我向您道歉，我相信您是一位不写烂代码的优秀开发者，或者至少有志于此。若未同名，相安无事。热爱生活吧。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
