> * 原文地址：[Project Worlds — Achieving God Mode in Digital Design](https://uxdesign.cc/project-worlds-achieving-god-mode-in-digital-design-b7242dbe5770)
> * 原文作者：[Marek Minor](https://medium.com/@tristanminor)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/project-worlds-achieving-god-mode-in-digital-design.md](https://github.com/xitu/gold-miner/blob/master/TODO1/project-worlds-achieving-god-mode-in-digital-design.md)
> * 译者：[Charlo-O](https://github.com/Charlo-O)
> * 校对者：[Baddyo](https://github.com/Baddyo)

# 项目世界 —— 在数字设计中实现上帝模式

>一种对系统抽象的、简单的，却十分有效的基于我们如何感知周围的世界的思考方式。

![](https://cdn-images-1.medium.com/max/6400/1*-VcoMexO96JKZvvujUxPUg.png)

我想通过这篇文章分享这两年来我对设计系统和设计工具的研究成果，叫做项目**世界**。

说到这儿，我意识到我没有另起炉灶。我意识到类似的想法、概念和产品也在不断涌现，比如 [React](https://reactjs.org/)、[Figma](https://www.figma.com)、[Sketch](https://www.sketch.com/)、[Modulz](https://www.modulz.app/) 或 [Framer X](https://www.framer.com)。所有这些对游戏开发者来说也许也不新鲜。

但是，我认为当我们从不同的视角不同的视角（字面意思的“视角”）观察设计系统时，我们可以获得很多。我希望能以这样的一种方式来看待这些系统，即使到百年之后，这种方式仍然不过时，仍然会有无限可能。

让我们一探究竟。

## 模块统治世界

岁月如梭，日新月异。我们周围的一切都在不断地变化 —— 行星绕着太阳转，天气不断地变化，你的身体也在不断地变化……每时每刻，每一种情况都是独一无二的。

为了让我们的大脑在这样一个瞬息万变的浩瀚宇宙中生存，我们必须去繁就简。我们变得非常善于识别模块，因为它们让我们的大脑走捷径，让我们的生活更容易(实际上更宜居），而不会让我们不知所措。

因此，在设计时使用模块是必不可少的。你可以说**一个设计系统是一个有非常高频模块出现的系统** —— 颜色、尺寸、形状、数字、百分比……任何设计都可以包含某种形式的设计系统。只是我们通常所说的**设计系统**相比其他的具有更高的组织层级。但在继续之前，让我们先熟悉几个关键概念。

### 涌现

[涌现](https://en.wikipedia.org/wiki/Emergence)是指更复杂的东西在更高层次上从更简单的东西中**涌现**出来。就像一个家庭由一个个家庭成员组成，一张图片由一个个像素组成，或者身体由一个个器官组成。**这意味着为了构建复杂的东西，你需要从更小（更简单）的部分开始**。你如何搭建自己的基本组件是非常重要的。

这让我想到 —— 为了使设计工具更强大，我们可能需要**从底层**重建它们。我开始问自己，设计系统中是否有一套完整的基本因子或规则，如果设置正确，可以在更高的层级上增加复杂性，而不需要真正的获得上级权威的指导。

[涌现 —— 愚蠢的个体如何变成聪明的集体](https://www.youtube.com/embed/16W7c0mb-rE?wmode=opaque&widget_referrer=https%3A%2F%2Fuxdesign.cc%2Fmedia%2Fa36a89cab939e54dfc586d0093b67301%3FpostId%3Db7242dbe5770&enablejsapi=1&origin=https%3A%2F%2Fcdn.embedly.com&widgetid=1)：强烈推荐关于涌现概念的视频。说真的，去看吧！


### 混沌理论

[混沌理论](https://fractalfoundation.org/resources/what-is-chaos-theory/)是数学的一个分支，主要研究对初始条件高度敏感的动态系统的行为。乍一看可能很混乱的东西其实很容易描述。这意味着你可以**用一些简单的规则创造出非常复杂并且变化巨大的东西**。通常是相同的模块以不同以尺度不断重复。

![](https://cdn-images-1.medium.com/max/2000/1*sOUyfU6wbCMTgWqis-oOgw.jpeg)

![](https://cdn-images-1.medium.com/max/4000/1*SZwqyABoXmimD5LfH3lETg.jpeg)

![](https://cdn-images-1.medium.com/max/2048/1*7cxFI9Tt1pw6iT1rGJIKoA.jpeg)

![](https://cdn-images-1.medium.com/max/2000/1*5E5GV8s8PGJCDbWHTvJPHg.jpeg)

### 信息理论

[信息理论](https://en.wikipedia.org/wiki/Information_theory)是对信息编码的数学研究，通过各种不同的方式，如符号序列或脉冲序列，以及该信息能传输得多快。对我来说这个理论的主要结论是信息究竟是什么,如何编码并存储在基础的组件中，为了定义一些你必须解释**如何**使用这些组件的过程而这一个抽象的概念世界的元数据描述了我们周围的世界。

### 相对论

相对论缺乏绝对和普遍适用的标准。这意味着任何事情都没有普遍的真理可言。观察结果因观察点或观察者而异。

## 介绍：世界

我们周围的一切都是它自己的世界。一棵树、一杯水、一座城市、一款应用、一个按建、一种颜色、一个字体……任何东西。我们设计人员和开发人员使用变量、函数、（React / Vue）组件、类、符号或系统将这些概念封装到可反复使用的数据块中。我想把它们叫做**世界**。它听起来简单而且贴切，但同时包罗万象，富有想象，功能强大。

世界就像一个可重复的函数。一个接收输入（在 React 中称为 **props**）的盒子，对其执行操作并呈现输出。一个简单的世界（灰色-500）可以选择一种颜色（#ccc），并输出相同的值，当做一个样本。更复杂的世界可以接受许多输入（尺寸、类型、状态、布局等）并输出一个按钮。

![](https://cdn-images-1.medium.com/max/2800/1*-AOTKkYq25BBoG7CkppIhQ.png)

创建设计系统的一种流行方法是 [Atomic Design](http://bradfrost.com/blog/post/atomic-web-design/)。虽然我并不完全**反对**这种由原子、分子、有机体、模板和页面组成的方法，但我确实认为它是有局限性的。通过使用这种严格的级别划分，你将自己限制在一个框中。你所做的每件事最终都会呈现出相同的结构。

更简单的基础，更广阔的舞台。

有些世界可能是静态的，像**蒙娜丽莎**的原作那样永远不会改变(至少在**构思**上是这样)。你总会得到同样的结果。但世界上大多数世界都可以改变自己的状态。想象一下你有一些控件能够操纵输出。有时，我把它想象成一个定制的仪表盘，上面满是按键、滑块和旋钮，但它可以像调整矩形的颜色和大小一样简单。

![](https://cdn-images-1.medium.com/max/2800/1*AJJLD_UVPHYALjj2ZeZXkQ.png)

通过调整这些控件，来改变世界所处的状态以适应其属性或者说**维度**。

## 世界的维度与状态

**维度**，或通常称为**属性**的东西，是组合在一起定义世界状态的可能性的列表。它们使世界充满活力的因素。 维度越多（即尺寸，颜色，重量等）—— 或维度的值越（8px、20px、8%、20%、#000000 和 #efefef 等）—— 世界可能的状态就越多。

![](https://cdn-images-1.medium.com/max/2800/1*AA0dQhoMx7rVUzSm358UXg.png)

**静态**世界没有维度。这意味着你无法控制结果，因此你将始终获得相同的结果。这种静态世界的一个例子可能是图像，如果图像始终保持不变就无法进行任何编辑。

**动态世界** —— 你可以操纵的世界 —— 可以有一个或多个维度。将这些维度组合在一起，可以为不同的场合生成同一个世界的各种版本 —— 例如图标，

![](https://cdn-images-1.medium.com/max/2800/1*nvCpBXDQlsBbxzty2jkaHQ.png)

一个按键，

![](https://cdn-images-1.medium.com/max/2800/1*PIsjKKFu3FsL8Mr1qz2t1g.png)

或一种颜色。

![](https://cdn-images-1.medium.com/max/2800/1*76-l2N0QuwF7dWosugCYYQ.png)

假设你想看到一个世界的所有可能形态。例如，查看按钮的所有可能形状。为了让你看到它，你需要先计算它。你可以通过将每个维度的所有可能值相乘来计算它们。如果 S 是所有可能的形态的数量而 Vₐ 所有 A 维度下的可能值中的一个，那么它会是这样的：

S **=** Vₐ **\*** Vₐ * Vₐ * …

或者视觉上：一个维度的两种可能的状态产生了两种可能的形状。

![](https://cdn-images-1.medium.com/max/2800/1*S2HtL3rxXhdUyVcgy1dhwg.png)

这种情况产生了 8 种 (2*4)，

![](https://cdn-images-1.medium.com/max/2800/1*wA2uQ793KoBT-IqDaUSjyw.png)

而这种情况就产生了 16 种（2*4*2）。很简明的东西。

![](https://cdn-images-1.medium.com/max/2800/1*0-JFRJMpqrwx3YgoaeFWsA.png)

但通常，在复杂的世界中，有太多的状态，以至于几乎不可能数的清，例如一杯水。为了让事情变得简单（它仍然是一个包含大量可能状态的系统），让我们用以下两个维度来定义它：

* 杯子的材质（玻璃或塑料）

* 水量（0-100 ml）

![](https://cdn-images-1.medium.com/max/2800/1*930RzEm4ezNnBoVtJFihQw.png)

你如何计算这个世界的所有可能的状态？所有可能的材料的种类是 2 种，这很简单。但在 0 ml 到 100 ml 之间可能存在的状态太多了。

为了达到我们想要形态，追踪所有可能的状态是没有意义的。你只需要追踪其中的一些，就像设计一个按键。你所需要知道的就是这些维度是什么，它们定义了什么，你将根据你的需要组合得到你想要的世界。

既然我们已经定义了世界以及它们的维度和状态，让我们来谈谈使它们如此强大的世界的特性 —— 把所有世界都当作**独一无二**的。

## 每个世界都是独一无二的

编程中有一句话: **“不要重复自己的劳动”**。这意味着你手工重复的方式完成的所有事情都应该是自动化的。对我来说，这也意味着不应该有第二次。**一切都应该只存在一次**。如果你正在引用两个实体，而它们之间没有任何区别，则它们是相同的独立实体。每一个体系、每一个维度、每一种状态都应该是独一无二的。设计系统在某种程度上是一个每个节点只存在一次的关系网络。

例如，如果在矩形填充和文本填充中使用颜色 ＃1cc55f，则应该指向唯一的颜色。我并不是指一种**颜色样式**或一种**变量** —— 这种颜色只存在一次，因为它是同一种相同的颜色。

![](https://cdn-images-1.medium.com/max/2800/1*jdm9tJ7H-0eMyIC23DUHzw.png)

同样适用于维度 —— 或者我们通常称之为**属性**。如果在两个对象中使用一个 border radius，便是在引用它。

![](https://cdn-images-1.medium.com/max/2800/1*HWIMnJVmiivfezdwvvxDIQ.png)

所以每次你使用一个值 —— 一个颜色、一个数字或一个角半径 —— 来创建一个新的东西（比如一个按键、一个开关），你都在引用它。你也可以看到你世界里的各种值，和其他的体系一样。所以在某种程度上，我们正在构建的体系，源于其他的世界**内部**，总是这样。

## 复杂的世界从简单的个体中涌现出来

如果你足够仔细地观察任何设计，即使是在微观层面，从内部来看，它都是由更小、更简单的世界构成的：

![](https://cdn-images-1.medium.com/max/2800/1*EhC8Yjxk0y6VGIAR9ARO8w.png)

如果看得再仔细一些，你会发现所有的值都由数字构成：

![](https://cdn-images-1.medium.com/max/2800/1*UKkedP_SD2UENNiIeukLtQ.png)

……如果不是纯粹的 0 和 1（但这对我们来说并不重要，因为它太细微了）。

## 创造你自己的世界

让我们稍微缩小一下，谈谈我们在设计和构建数字环境时经常使用的世界。在更小、更基本、更“内在”的层面上，你在使用更简单的世界，如形状，文本或图像：

![](https://cdn-images-1.medium.com/max/2800/1*ayRDig-GT8j1Txomu8KxSQ.png)

你可以用这些小的世界来创造更大的世界，比如按键、图标、头像，

![](https://cdn-images-1.medium.com/max/2800/1*zE4efCJdGen1QBZjPTNdkw.png)

或从更简单的体系中涌现更大更复杂的体系，比如列表项、顶部栏或页面：

![](https://cdn-images-1.medium.com/max/2800/1*Sv8dv2S43k7csNB0eCOrng.png)

就像你要调整形状、文本或图像的维度一样，

![](https://cdn-images-1.medium.com/max/2800/1*xVUmYKf2vit2yzx4OUkr0g.png)

我们的工具应该为我们提供创造和调整我们自己世界的尺寸的方法，无论它们是小而且相对简单，如按钮、图标或头像，

![](https://cdn-images-1.medium.com/max/2800/1*iDxf7nekKucg1blESDCgCQ.png)

进度条、自定义文本或颜色，

![](https://cdn-images-1.medium.com/max/2800/1*a0bcRffJBmGs_hbpYroFwg.png)

或更复杂的列表项、栏或页面：

![](https://cdn-images-1.medium.com/max/2800/1*sXnq6MYHmFRdAn0KVRLL5w.png)

我们的工具应该使我们能够从已经存在的基本系统中创建任何东西，因此复杂的东西将会从几个基础的组件中涌现。

## 没有层级 —— 只有一系列的可能性

那么，这种“世界中的世界中的世界”结构是什么样子的呢？如果你熟悉 HTML 对象在 [DOM](https://en.wikipedia.org/wiki/Document_Object_Model) （文档对象模型）中呈现的方式，或熟悉 React 组件，你会说它类似于一棵树。

![](https://cdn-images-1.medium.com/max/2800/1*r40twjR3-Ma5MUniMsdnEg.png)

![示例：HTML 结构和 React 组件](https://cdn-images-1.medium.com/max/2800/1*kkMKItZe6idW0JnhYd_-vA.png)

但是一旦你认真考虑到这**万物皆独特**的哲学，它开始变得有点复杂了，并不是真正的树状。类树形结构只从一个视角看所有的东西，但是对于设计系统，可能有数百万个视角。

![](https://cdn-images-1.medium.com/max/2800/1*sQltac7lMa7NaLyF4rUJ0g.png)

在一个一切都是独一无二的，几乎任何世界都可以相互贯通的环境中，你需要准备好所有这些，并且可以从任何位置接触到它们。你需要有一个所有世界的清单，你最终使用的取决于你所处视角。

要描述任何设计系统（或一般的系统），你需要**一个包含所有可能的独立体系的列表，这些体系之间相互引用**。

![](https://cdn-images-1.medium.com/max/2800/1*sGCpuG5Em2duVHM-Vn1tDg.png)

你也不能真正移除一个被另一个世界引用的世界 —— 否则事情可能会崩溃。如果在矩形中使用 #ccc颜色，则无法删除它；或者删除在 Frame 中使用的按键。你需要用另一个世界来代替它 —— 这就是你在 Figma 里常做的移除颜色框架这样的事。

## 多角度看问题

除非你决定观察其中一个世界，否则没有层级。由于所有可能体系的列表都不是可渲染的树形，要实际渲染或显示**某些东西**，你需要选择一个体系 —— 应用程序，颜色、大小、数字、按键、任何东西。这个世界成为一个**观察者**，你可以展现出你视角中的体系 ——无论向内还是向外。

![](https://cdn-images-1.medium.com/max/2800/1*RMkOF2VHC6UMECOpGwvDZQ.png)

这个体系将成为你视角的中心。在某种程度上，**你**和你的观察者是一体的。这意味着你可以从这些世界（颜色、数字、不透明度等）的任何角度观察和控制视图，并在**你的设计中实现几乎不可能的预览境界**。

## 上帝模式

 一个设计系统（或一般的任何系统）可以被描述为一种关系网络，其中每个节点仅存在一次。每个体系，每个体系的维度和每个体系的状态都是独一无二的。

现在，如果你将每个系统都记录为一个独特的文件，你只能更改一次规则，要么通过更改独特文件，要么通过更改文件之间的关系。更改列表项目大小的字体后，不再需要再手动调整 1000+ 的屏幕。

这将允许你从对任何事的看法来审视你的设计系统：所有的颜色，

![](https://cdn-images-1.medium.com/max/2800/1*pixyXcPc7PfeIs7rCqmjlw.png)

一个特定的颜色，

![](https://cdn-images-1.medium.com/max/2800/1*vKAECrqowtMy0vFMa8GWvQ.png)

或一种颜色样本/款式，

![](https://cdn-images-1.medium.com/max/2800/1*VAPIKLi9HWkdXcEgCdshww.png)

只要改变其中任何一件事一次。咚！你可以根据你所需要的任何类型的结构和需求创建你自己的体系结构 —— 体系将扮演中继器的角色，有效地改变信息的流量，并允许你在同一时间一次性改变任何类型的规则。

除了一些基本的世界，如框架、文本或图像，你应该能够创建自己的世界，指向其他体系 —— 类似于我们在代码中的**变量**或 Figma 中的**颜色样式**。但这应该适用于任何规则，而不仅仅是颜色或文本样式。你应该能够同步到任何东西，例如字符串，

![](https://cdn-images-1.medium.com/max/2800/1*1RcivOg9mtLmJU7EZ5UxpQ.png)

百分比，

![](https://cdn-images-1.medium.com/max/2800/1*17mLJo-s9DkeAUQOmaGhaA.png)

或尺寸，

![](https://cdn-images-1.medium.com/max/2800/1*W61O5gfqs1vxzCFSUCQTRQ.png)

并以高度可视化的方式进行所有这些操作，不需要编码。

## 探索与一致性

就像在 Figma、Framer X 或 Sketch 中一样，使用这种方法，你可以在没有规则集的情况下进行探索，也可以用符号、组件、变量或样式的形式设置一套严格的规则来构建你的东西。

但是这种方法真正好的地方是，你可以开始自由地探索，不附加任何限制。然后，在任何给定的点上，你都可以通过发现新出现的模块并将它们封装为单个独立规则，从而使其更加精确更加组织性。疯狂地使用任何你想要的字体大小、颜色或命名规则，你随时都可以清理和组织它。你也可以反过来做：在精确的设计系统规则中添加一些混乱。

这可能是在自由探索和设计系统严格限制规则之间的永恒冲突的答案 —— **一种在过程中的任意给定点发现新出现的模块并定住它的能力**。

## 设计助手

我不认为我们需要制造能为我们做所有工作的机器人。我认为我们更需要的是**更多的辅助，这将帮助我们更好地做好我们所做的** —— 我们所有人，包括那些对设计原则知识有限的人。只要跟踪设计系统中的每一个节点、每一条规则和每一段关系，就可以造出令人惊叹的辅助算法。

你可以制作一些算法来分析你的设计系统，并向你推荐你将使用的程序预测。它会促使你使用那些已经被用来创造更多一致性的东西。最简单的方法是，它可以根据已经使用了多少次来提示颜色或大小：

![](https://cdn-images-1.medium.com/max/2800/1*pMnAa0-uIC9N9SD8LaSsww.png)

作为一个更复杂的例子，它可能会建议一个颜色基于更多的上下文元数据，而不是它使用了多少次 —— 例如，颜色通常用于一个对象，所有颜色的整体色调，填充和描边颜色的使用……

![](https://cdn-images-1.medium.com/max/2800/1*M9NDH_DpKQ6cTiDxL1zeHQ.png)

或者 —— 当使用元数据进行适当的适当的训练时 —— 根据不同的属性给出更复杂的建议：

![](https://cdn-images-1.medium.com/max/2800/1*8El4Bmy2JmvbouOUxu6fPA.png)

你可能能够分析任何设计系统（如 Google 的 Material Design）或个人设计师的风格，并促使用户做出符合“风格”定义的选择。这可以帮助没有设计原则知识的人通过实践来学习。

我们的工具不仅应该促使我们做出更一致的选择，而且应该做出有助于易用性和易读性的选择。设想一个设计工具不允许你使用不合适的字体颜色 —— 将易用性融入设计工具的核心。

![](https://cdn-images-1.medium.com/max/2800/1*ucD9XP00wym2U087n7WvSg.png)

## AB 测试

测试并选择最佳版本是设计过程的另一部分，可以从系统化中受益。想象一下，可以选择将整个设计系统分成两个或多个平行的宇宙，以便看到它们之间的区别，并测试哪一个更好。类似 git，内置在我们的设计工具的核心中，但是更好。

![基于抉择将设计系统分解为多元宇宙](https://cdn-images-1.medium.com/max/2800/1*FT-a96s9BTh1D8d3yXhSsQ.png)

因为我们跟踪了每一个组件，每个设计系统中的规则，使这一切都成为可能。你可以继续对任何一个多元宇宙进行更改，进行更新迭代，因为这个差异也是一个独立于其他规则的惟一规则（或一组规则）。例如，你可以测试一个应用程序的许多不同的视觉主题，这些主题，完全独立于设置屏幕流的整个交互过程。

![](https://cdn-images-1.medium.com/max/2800/1*DPKVByhwS_2QKKtCgk7F9A.png)

## 屏幕是什么？

设计师和程序员之间存在这种冲突。在谈论流程时，设计师会谈论**屏幕**或**页面**，但程序员会谈论**视图**或**路线**。但我们都只是想做相同的事情，对吧？所以它可能应该是相同的一个。或者介于两者之间。我确实认为存在一个地方，可以让两者相遇交汇。我确信**屏幕是观察体系状态的快照**，有意地创造 —— 例如讲述故事或展示概述。

![](https://cdn-images-1.medium.com/max/2800/1*Z6HgBLYSWbK2CdOa8c8RBw.png)

通过整个环境**状态**的快照，我的意思是可能有与应用程序的可能状态一样多的屏幕。只是其中一些状态比其他状态更“有趣”和“重要” —— 你不会在预订屏幕中显示日历选择器的所有可能组合，你只显示默认状态或另一个你想要与之沟通的。

快照的生成是带有目的的。它们是从所有可能的组合中挑选出来传达一个特定的故事。这意味着**你不是在设计屏幕——你是在设计动态的世界**，从这些体系中，你可以通过将几个选定的快照排列在一起来生成故事或概述。屏幕是次要的，它们是动态系统的副产品。

## 一个关于交互的小说明

也许你已经注意到我还没有提到交互。到目前为止，我所描述的只是一个充满可能性的体系，观察者可以在这个体系里从任何角度看到一个概览，但却无法与之真正互动。本文的主题是**定义**设计系统，而不是使用它们。

我选择不谈这个是因为：a)我还没有理清我对交互的想法；b)谈论它将是一个浩大而漫长的任务，所以这会是另一篇文章。请继续关注。

但我确定的是 —— 此刻你可能会说：“真的吗？” —— 通过增加时间作为另一个维度，交互性以更高的层从所有这些设计系统的离散组件中涌现。我敢把交互定义为一个观察者，**可以在这些被允许状态时间流中穿越** —— 例如，一个应用程序的交互实例，测试一个特定按键的工作方式，或者只是检查蓝色的颜色样本：

![](https://cdn-images-1.medium.com/max/2800/1*CFHHcYr2VIV3a0pgC5Wv-g.png)

就像当 2D 游戏逐渐演变成 3D 世界时，游戏开发者最初认为制作游戏是相当容易的，因为它只是增加了一个维度。这被证明是不正确的，因为在三维中制作游戏带来了许多新的细微差别，所以它变得非常非常困难。

## 如何实际构建这种不同类型的设计工具

我花了大量的时间把这个理论付诸实践并做了无数的原型。我要给你们展示的这个正在进行中的版本是我最接近我的期望的版本。使用什么编程语言来实现这个工具并不重要。或者这是一个已经存在的设计工具的插件。这些思想应该是通用的，并且适用于任何编程语言或设计工具。这是我所期望的。

### 架构

为了构建基于这些想法的设计工具，我开始考虑我需要具备哪些系统。这就是我想出的：

![](https://cdn-images-1.medium.com/max/2800/1*oUBMNX83EI5tJ83lmR2cGA.png)

* **可能性** —— 一个你将创建**什么**可以存在并**如何**存在的地方。一个所有管理和规则都在的地方。把它想象成你**创造**设计系统的地方 —— 选择颜色、字体大小、制作按键或开关等等。

* **实例** —— 一个管理**真实**存在的地方。你可以根据设计系统中允许的规则从母版创建实例的位置。您可以将其视为实际**使用**您正在创建的设计系统的地方 —— 例如，通过制作应用程序或网站，就像在任何其他设计工具中一样。

* **渲染器** —— 实时渲染动态结果的算法。

* **（动态）结果** —— 你可以与你所做的以任何角度互动的地方 —— 看到/管理一个按钮，一个特定的颜色或整个应用程序。

或者，可能性和实例在工具界面中搭配在一起，这样你就可以使用它来管理你的设计系统 —— 就像在 Figma 的工具栏中直接添加颜色样式而无需进入单独的屏幕一样。但是这有什么样的界面并不重要 —— 我所说的只是你需要在合适位置有这些系统。这些系统如何在 UI 中显示是一种观点。

### 在独特文件中存储事实

你还需要一个数据库，其中包含每个体系、维度或状态的文件列表。这非常简单：你所需要的只是大量带有键和值的文件，其中大多数键和值只是对其他文件的引用。在某种程度上，**任何设计系统（或一般的系统）都可以看作是关于元数据的元数据**。

![](https://cdn-images-1.medium.com/max/2800/1*XRHKmKwo0MFJH-ISK-SfCw.png)

你并不是真的想从头开始设计。你需要一些基本的文件来建立你自己的世界，例如：

![](https://cdn-images-1.medium.com/max/2800/1*3zj0XuoGbMbWHw2jZFGY2A.png)

维度也是如此，例如：

![](https://cdn-images-1.medium.com/max/2800/1*wm1LMTkWr7L1C85z5-MUCw.png)

这些基本的体系将成为文件：

![](https://cdn-images-1.medium.com/max/2800/1*VP1REi3d6DkVOUVwgIY08w.png)

对于那些想要更仔细观察的人来说，这里有一个更详细的例子：

![](https://cdn-images-1.medium.com/max/10928/1*IxhWaifBfZf6CnQMtTBP3Q.png)

## 总结

结论：

1. 设计系统中每个独特的可重复使用的组件都是一个**世界**。

2. 世界接收输入，对其执行操作并输出结果。

3. 世界是由名为**维度**的可操纵输入定义的。这些维度的所有值一起定义其**状态**。

4. 通过跟踪所有这些独特的世界，你会发现一些非常强大的东西。。你只能做一次更改（规则、颜色、形状、图像、名称、不透明度），并将其应用于所有其他事物。

5. 添加时间这个维度来观察这些组件以形成交互。这个庞大课题留到下次探讨。

![世界嵌套世界，无穷匮也](https://cdn-images-1.medium.com/max/2800/1*GwzN3f_DAige-7OPwQRNRw.png)

现在的设计工具试图从（A）一切都被绘制，绘画和静态的地方进入到（B）一切都被编程，动态和可互动的有交互地方。我相信还有另一种更好的方法。对于项目世界，我是从抽象的思维状态开始的（C），在那里纯粹的信息被表示和处理。

![](https://cdn-images-1.medium.com/max/2800/1*7Sw-OAbtvFyKy5Dg-9bZ8Q.png)

我相信，如果我们真正了解我们如何以极其有组织的方式感知我们周围的体系并有效地利用这一点，那么没有什么是遥不可及的。

—

所以，对于这个你有什么想法？ 请在下面的评论中告诉我或在 [Twitter](https://twitter.com/TristanMinor) 上关注我。

––

**郑重感谢 [Daniël van der Winden](https://twitter.com/dvdwinden) 和 [Ivana Žišková](https://twitter.com/fluidpills) 对本文提供的帮助。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
