> * 原文地址：[Product Management Mental Models for Everyone](https://blackboxofpm.com/product-management-mental-models-for-everyone-31e7828cb50b)
> * 原文作者：[Brandon Chu](https://blackboxofpm.com/@brandonmchu?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/product-management-mental-models-for-everyone.md](https://github.com/xitu/gold-miner/blob/master/TODO1/product-management-mental-models-for-everyone.md)
> * 译者：[EmilyQiRabbit](https://github.com/EmilyQiRabbit)
> * 校对者：[zhmhhu](https://github.com/zhmhhu)

# 产品管理思维模式适合每一个人

![](https://cdn-images-1.medium.com/max/1600/1*b61UVOBxXM0yEyzLME0tuw.gif)

思维模式是对复杂的过程和关系的简单表达。这些模式会随着时间的推移由个人逐渐积累，并能让人作出更快更好的决策。

一个例子是：帕累托原理（Pareto Principle）指出，大约 80% 的产出来自 20% 的努力。

在产品管理的语境中，模型建议你应该更希望寻找如何付出 20% 的努力解决 80% 机会的方法，而不是去试图创造 100% 的客户机会。产品团队在一直权衡这一点，结果通常看起来像是特性发布后，20% 的有着更复杂用例的用户没有被支持。

尽管思维模式非常强大，但它们的效用取决于它们所处的背景条件。为了防止这种情况发生，你应该不仅仅依赖一个或几个模型，而是应该持续的建造一个思维模型的**框架**，你可以从中吸取教训，做出更好的决定。

查理·芒格（Charlie Munger）普及了这个概念，他是著名的伯克希尔哈撒韦公司副董事长，他在一次[演讲](https://old.ycombinator.com/munger.html)中提到了如何获取智慧：

> 什么是基础的、世间通用的智慧呢？第一条规则是，如果你只是记住孤立的事实，然后进行尝试和重复，你就什么都不知道。如果从这些事实没有总结出一致的理论体系，它们就没有可利用的形式。

> 你的脑海中已经有很多模型了。你必须要整理你的经验 — 间接的或者直接的都要 — 整理到这个模型框架中。你可能已经注意到有些学生只是试图记住并重复已经记住的东西。好吧，这样他们在学习和生活中都会失败的。你必须要将经验和脑海中的思维模式连接起来。
>
> 什么是模型呢？第一个规则就是你必须拥有很多模型 — 因为如果你只有一个或两个使用着的思维模型，人类心理自然就会让你将现实世界折射得符合你的模型，或者至少你认为是符合的。你会成为像脊椎按摩师那样的人，毫无疑问，他是医学界的笑话。
>
> 就像老话说的，“对于一个只有一把锤子的人来说，每一个问题都像一颗钉子。”当然，这也就是脊椎指压治疗者对医学的处理方式。但这是一种世界上的极其灾难性的思维和操作方式。所以你必须有多个模型。

**这篇博客概述了一些在我职业生涯中积累下的最有用的思维模型**。如果我又获悉了新的模型，我将会持续更新博客。

这篇博客也**不**仅仅适用于产品经理，而是所有为产品作出工作的人们。产品思维对于产品经理的作用并不是神圣的，事实上，它被构建者掌握可能更**有用**。

#### 我们将会提及的思维模型被分为如下几类：

1.  找到投资点
2.  设计与范围
3.  运输与迭代

* * *

**找到投资点 —** 接下来的这一组思维模型对于决策团队应该构建或“投入”什么非常有用。

### 1. 投资回报

一个财务概念：你投资的每一元，获取到了多少回报？在产品中，把你拥有的资源（时间，财力，人员）当成是投资，把对客户的影响当成是回报。

![](https://cdn-images-1.medium.com/max/800/1*WzqwU7lp6E5nRgART7XJxw.png)

#### 如何应用

对于一个产品团队来说，可用的资源包括时间，金钱以及人的数量和能力。当你在对比手里的项目时，你应当选择那个能够**使你手里的每一个资源对客户产生最大化影响力**的项目。

### 2. 交付的时间价值

对于客户而言，产品提前交付要比延后更加有价值。

![](https://cdn-images-1.medium.com/max/800/1*JVAnPRwoPhnVSKWN2oQRDw.png)

#### 如何应用

当在困难或者机会中抉择如何投入的时候，你应该不仅仅权衡你构建的不同功能所能获取的收益（当然如果你这样做了，你一定会选择收益最大的那个功能）。

相反的，为了作出最好的投资决策，你也要考虑这些功能的交运速度，并对那些能够更快交运的功能多加关注。

### 3. 时间范围

和**运输的时间价值**相关，最佳决策会根据优化的时间段而变化。

![](https://cdn-images-1.medium.com/max/800/1*lD889xYiJSidoYfrzDO5SA.gif)

考虑到足够长的时间范围，3 个月与 9 个月构建的成本都是微不足道的。

#### 如何应用

选择追问 **“你在接下来三个月中如何能够获取最大影响”** 或者 **“你在接下来三年中如何能够获取最大影响”** 所能够导致的结果将会非常不同。

接下来，通常情况下团队和股东的第一次讨论通常都是协调关于在哪个时间范围上进行优化。

### 4. 期望值

预测未来是不准确的。相反，所有的决策都会给未来带来多种可能的结果。这些结果的概率加权和就是决策的**期望值**。

![](https://cdn-images-1.medium.com/max/800/1*_QclBIKqkgEehi61jVu7xQ.png)

#### 如何应用

当考虑项目的影响时，找出所有的可能结果并分配概率。结果的可变范围通常包括它可能会需要比期望更长的时间，以及它可能并没有解决用户提出的问题。

一旦你列出了所有的结果，并对所有结果的价值进行概率加权求和，你就能更好地了解投资的收益。

* * *

**设计和范围 —** 在选好了投资目标后，下一组思维模式对于确定产品的范围和设计非常有用。

### 5. 反向工作（反转）

为了找出应该从哪里入手，应该从一个完美的解决方案开始，然后反向工作，而不是从一个有问题的部分开始，然后寻找解决方案。

![](https://cdn-images-1.medium.com/max/800/1*v-dFL3r4rPFo6xPjr0VQ8w.png)

注意，反向工作并不总是更好的方法，它仅仅是创造出了一个不同的视角。

#### 如何应用

大多数团队更倾向于**正向工作**，它优化了实用性，但是代价却是最终的影响力。

反向工作则帮助你确保你将专注于对用户最有影响力的长期工作上，因为你总是在一个完美的方案上逆向开展工程。

注意，反向工作并不总是更好的方法，它仅仅是创造出了一个不同的视角。同时采用两种不同视角进行规划也是很不错的。

### 6. 对产品的信心决定速度与质量

你所拥有的信心 i) 对于解决问题非常重要，并且 ii) 你正在构建的解决方案的正确性，应该会决定你在产品构建中，多大程度上愿意去权衡速度和质量。

![](https://cdn-images-1.medium.com/max/800/1*rqE-5eVKXLmkVLFux92d0g.png)

#### 如何应用

这个思维模型可以帮助你建立一个晴雨表，用来更巧妙地权衡速度和质量。通过观察上面频谱的两端，解释这一点是很容易的。

**在最右侧**：对于用户来说，你正在专注的问题十分重要，对于这点你十分自信（经过用户验证，你的自信还会巩固），**并且**你十分肯定解决问题需要构建什么。在这种情况下，你不应该接受任何缺陷，因为你知道用户将来将会十分需要它，所以最好是高质量的（例如：可扩展性，用户友好）。

**现在我们再看看左侧**：你甚至还没能确定这个问题对用户是否重要。在这种场景下，你投入项目构建的时间越长，就有大风险会生成某些之前不存在的问题。因此，你应该推出某些能**快速**迭代的产品来试错，并获得用户的认可，证实它确实值得最终高质量的构建。例如，在这些情况下，你可以为一个甚至是现在还不存在功能配置落地页面，来衡量客户的兴趣。

### 7. 全面解决用户体验问题

用户体验不止于界面。在用户使用产品之前和之后会如何，也是很重要的设计点。

![](https://cdn-images-1.medium.com/max/800/1*D_JfpzBPTU906raJzZVNPA.png)

#### 如何应用

在设计产品时，我们趋向于过度关注产品内的用户体验（比如软件内部的用户界面）。

但是市场体验的设计（如何获取用户，以及如何在他们使用产品之前设定他们对产品的期望），还有产品支持/事故的用户体验（公司如何应对产品失误）也是同等重要的。

特别的，产生较大产品事故时的体验，是获取用户长期信任的大好机会。例如，**当作为客户的你不得不退回某些东西的时候**，亚马逊赢得了你很大部分的信任。

### 8. 实验，特征，平台

产品开发有三种类型：实验，特征和平台。每个都有他们自己的目标，以及最佳方式来权衡速度和质量。

![](https://cdn-images-1.medium.com/max/800/1*ilzmNU-5V1n8w4FLen4nVA.png)

#### 如何应用

认清项目的产品开发类型，你将能够为每个类别定义更合适的目标，并且为速度和质量与产品之间的权衡找到合适点。

实验意味着要给出**经验**，因此你可以投入新的功能或者用户认可的平台。如果你是为了获取经验而作出的优化，你要考虑那些不经过实验就不合适的事情：比如使用你打算丢弃的 hacky 代码，以及伪造复杂的软件，它们只是人们仅在幕后会做的事情。

和实验相反，平台则是永久性的。其他人会在它们之上建立新的特性，因此，在平台生效后对平台进行更改是非常具有破坏性的。

因此，平台项目需要高质量（稳定，性能良好，可扩展，等等），并且它们需要实际构建有用的功能。构建平台最好的法则就是和你的第一个客户一起构建它，即和一个在平台之上创建功能的团队同步开发 -- 这样，你就能确保平台实际上启用了可用的功能。

### 9. 反馈循环

产品中的因果关系，是由正面和负面反馈回路所连接的系统产生的结果。

![](https://cdn-images-1.medium.com/max/800/1*eIrnHqDy24SmYTM5VT9uBw.png)

#### 如何应用

反馈循环帮助我们记住，一个产品增长和下降的最大驱动因素可能来自系统的其他部分。

例如，比如你是支付团队，你的 KPI 就是增加信用卡支付总额。你和用户获取的团队之间存在一个正向反馈循环，因为当他们增长了用户，你就有更多将会用信用卡支付的潜在用户。但是，你和现金支付团队之间有一个负向反馈循环，他们的目标是帮助用户更方便的使用现金交易。

知道了这些反馈循环，可以帮助你调整方案（例如，你可以选择将获取一般用户作为增加支付量的最佳方式），或者了解指标的负面变化（例如，信用卡支付量下降，但是是因为现金支付团队做得很好，而不是信用卡产品糟糕）。

### 10. 飞轮（递归反馈循环）

这是一个正向或逆向反馈回路能够以自身的动量为动力并加速的状态。

![](https://cdn-images-1.medium.com/max/800/1*dQZTwGbDzYxyehti9NdUNg.png)

#### 如何应用

飞轮和反馈循环是相关的概念，但是对于管理平台和交易市场非常重要。例如，假设你在运行苹果 iOS 应用平台。你有两种用户：应用开发者，和应用使用者。

飞轮就是更多应用用户吸引到更多应用开发者（因为有更多的机会可以售卖应用），然后反过来又会吸引更多的应用使用者（因为有更多的应用可以买），反过来又继续吸引更多的开发者，这样循环的现象。只要你培育好这个飞轮，就不仅是普通的增长，增长的速度也会提高。

如果你正在管理一个飞轮，你就要倾尽全力来确保它向正向旋转，因为它逆向旋转的时候力量同样很大。例如，如果平台上的应用过多，新的应用无法被发现，应用开发者的增长速度就会下降，这将打破飞轮 -- 你需要解决类似这样的问题。

* * *

**构建和迭代 —** 当你在构建、操作和迭代已有产品的时候，下一个系列的思维模型就非常有用。

### 11. 收益递减

当你专注于改进相同的产品领域时，随着时间的推移，每一份努力创造的客户价值也将随之减少。

![](https://cdn-images-1.medium.com/max/800/1*4Mk9GlI3Wze0M80vwdIpqA.png)

#### 如何应用

假设你正在基于用户反馈和调研对产品进行有效的迭代，你最终都会达到那个无法使产品做得更好的程度。 那就是您的团队继续前进并投资新事物的时候了。

### 12. 本地最大

和收益递减相关，本地最大指的是增加优化但根本不产生用户价值，它迫使你在产品功能上作出改进。

![](https://cdn-images-1.medium.com/max/800/1*G5jRnVstTrkTKcFVLozunw.png)

#### 如何应用

这个思维模型与收益递减紧密相关，增加了一个限制，继续维持改进实际上将没有任何实质性的差异。**迭代**现在已经毫无意义，唯一继续的方法是**革新**。

最近，由于 Eugene Wei 的病毒帖 [Invisible Asymptotes](http://www.eugenewei.com/blog/2018/5/21/invisible-asymptotes)，这个概念很流行，帖子中包含这样一个例子：亚马逊的预见引领他们创造了 Prime。

### 13. 第二版是谎言

在构建产品时，请不要依赖版本二的产品。确保版本一是一个完整的产品，因为它可能永远存在。

![](https://cdn-images-1.medium.com/max/800/1*m2032S9-aWtyxgLnKwBCdg.png)

当软件在货架上出售时，团队必须永远使用版本一。

#### 如何应用

当你定义产品的第一个版本时，你将聚集所有你希望在以后的版本中添加的令人惊叹的功能。你要认识到，一些功能可能永远也不会发布，因为你不知道将会发生什么：公司政策调整，你的工程师总监辞职，或者你的团队被重新分配到了其他项目中。

为了避开这样的场景，确保你发布的是一个“完整的产品”，就算它再也不升级，在可预见的未来里，它对于用户来说也依旧是可用的。不要发布一个依赖于未来改进才能解决问题的新功能。

### 14. 免费锦标赛

指的是通过快速发布，损失很少而收益很大的场景。

![](https://cdn-images-1.medium.com/max/800/1*eSuVg7xMVDoUCXtCEmrsrA.jpeg)

#### 如何应用

**免费锦标赛**通常在这样的产品中出现：当前的用户体验非常差，以至于作出任何一点基于直觉的合理的改变都很有可能带来很大改善。它们与修复 bug 不同，因为 bug 指的是没有按照设计工作的东西。

如果你正在这样一种情境下：你的团队正在考虑，**“我们就这么做吧...反正也不能更糟了”**，也许你面前就正有一个免费锦标赛的机会。

（Reddit 上的 [r/CrappyDesign](https://www.reddit.com/r/CrappyDesign/) 是一个上述情况的宝库）

### 15. 大部分价值在第一个版本之后被创造出来

在你发布了产品之后，你将会从用户那里学到很多，不要浪费了在这些经验之上构建产品的机会。

![](https://cdn-images-1.medium.com/max/800/1*20d6A7nktJGqINckdVSelQ.png)

#### 如何应用

在用户大规模地使用产品之前，一切都是假说。你的团队在发布前所投入的 — 用户访问，原型测试，定量分析，测试，等等 -- 都能大幅度支持你成功的可能性，一旦你将功能发布给所有的用户，总会出现产品行为（异常）和偏离的情况。

学习一部分客户的审美价值后，你将会在产品发布**后**获取很多知识经验。如果不通过迭代产品（有时是大幅度的修改）进行相应的投入，那么学到了这些也是毫无意义的。

### 16. 失败的关键指标（KFI）

将关键绩效指标（KPI）与你**不希望**看到的指标走向配对，以确保你专注于产品的健康成长。

![](https://cdn-images-1.medium.com/max/800/1*ks8KCX4L9LVP88fiJzb_xQ.png)

#### 如何应用

团队经常选择能够直接反应他们正在寻求的正面结果的 KPI，而不考虑实现这些结果的负面影响。一旦他们开始为这些 KPI 优化，对于公司，他们实际上创造的是很糟糕的产出。

一个经典的例子是，当登陆页面上注册转换翻倍了的时候，一个团队认为他们取得了成功，但是却发现（为时已晚）总用户量并没有增长，因为由于相同的变化，转换率下降了 60%。

KFI 能控制团队绩效，并确保您只为公司创建净健康产出。

**流行的 KPI <> KFI 配对的例子包括：**

1.  维持毛利率的同时增加收入
2.  在不取消采用功能 B 的情况下，逐步采用功能 A
3.  在不增加支持负载的情况下，逐步采用功能 A

* * *

### 使用框架，而不是清单

对于读者来说，它可能并不让人很满意，但是据我所知，并没有使用这些思维模型的方法论。如果你试图将他们作为一个清单来使用 — 逐个尝试每一种方法来看看它们是否适用 —— 你最终会发现你只是在做思维训练，这会让你和周围的人都感到困惑和沮丧。

相反，它们成为了你的思维框架的一部分，帮助你做出更好的产品决策，并为您提供一种语言，以便为您的团队传达复杂决策背后的原因。

当你累积了更多的模型，同时模型随着经验的累计变得更理想，你将会更加优秀。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
