> * 原文地址：[Predicting your game’s monetization future: An analysis on how top games developers calculate lifetime value](https://medium.com/googleplaydev/predicting-your-games-monetization-future-ce176169b056)
> * 原文作者：[Ignacio Monereo](https://medium.com/@ignacio.monereo?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/predicting-your-games-monetization-future.md](https://github.com/xitu/gold-miner/blob/master/TODO1/predicting-your-games-monetization-future.md)
> * 译者：[NoName4Me](https://github.com/NoName4Me)
> * 校对者：[mingxing47](https://github.com/mingxing47)，[hanliuxin5](https://github.com/hanliuxin5)

# 预测你的游戏的货币化未来

## 一个关于顶级游戏开发商如何计算终身价值的分析

![](https://cdn-images-1.medium.com/max/800/0*UGIPy81djFEPC-0u.)

我们中的许多人都梦想构建下一代现象级游戏，这款游戏将以其独特的视觉效果和创新的玩法被未来几代人所铭记。因此，我们通常会花费大量时间思考可持续业务背后的一些基本业务问题。例如：我能为获取一个新玩家花费多少？一个用户对另一个用户的潜在价值是什么？我该如何量化人们分享我的游戏和引入新玩家所带来的社会效应？我的用户何时会感到厌烦，我该如何预防这样的事情发生？

游戏玩法产生的数据广度和以用户层面为目标的能力使客户分析成为游戏业务的核心部分。手游货币化和行业竞争的复杂性意味着，从数据中找到更多的创新方法来采取行动，以便为你的业务带来优势，会有压力。一种方法是建立模型来帮助预测游戏玩家的终身价值（LTV）。本文提供了关于顶级游戏开发商如何计算终身价值的分析。如果你想了解更多关于该主题的信息，[**请阅读完整的白皮书**](http://services.google.com/fh/files/blogs/insights_for_evaluating_lifetime_value_for_game_developers.pdf)。

![](https://cdn-images-1.medium.com/max/800/1*5B4ls2quAGfimJVMHrB0Mg.png)

### 游戏里的终身价值

#### LTV 是什么？

顾名思义，LTV 是对一个特定玩家在其一生的总货币价值的评估。

尽管终身价值是一种比较泛化的指标，它可以让游戏开发商了解游戏玩家的价值，但至今还没有标准的计算方法。大多数开发商要么使用自定义方法来计算 LTV，要么在使用第三方工具。无论何种计算方法，开发商在使用 LTV 时都会犯三个主要错误。

1. 许多开发商犯的第一个错误就是在计算 LTV 时没有包含所有的收入来源。对于开发商来说很普遍的做法是：仅为 IAP（译者注：In-App Purchase ，是一种智能移动终端应用程序付费的模式）计算 LTV，最后在其基础上增加一个百分比作为其他收入来源（例如广告）。LTV 应尽可能包括所有货币化业务模式，例如 IAP ，广告收入等，否则我们可能因为没有包含合法收入，而错失增长机会。

2. 一些开发商犯的第二个错误是在评估不太明显因素的影响，比如：竞争对手发布新游戏，公司所处的阶段，汇率变化等。这些可能导致游戏在没有做任何改变的情况下，LTV 却出现显著偏离。总的来说，我们需要将 LTV 视为一个随着游戏的不断发展而变化的动态指标：a）内部变化 - 新内容或新功能，游戏内经济，玩家行为。b）外部变化 - 游戏趋势，竞争，货币波动，平台变化。

3. 最后，一些开发商将 LTV 视为竞争优势。但是，LTV 仅仅是一个指标，因此它不代表对其他开发商的竞争优势。此外，它不是一个确切的值，因此它也应该被视为一个范围（例如 LTV 介于 1 和 1.2 之间）或在一定的准确度内（例如 85％ 的置信度）。最终目的是避免因过于乐观/悲观的终身预测出现的不良行为。

#### LTV 将如何帮助我做出业务决策？

![](https://cdn-images-1.medium.com/max/800/1*GKSGpj7VPBXjK1mPLN49Fg.png)

LTV 通常用于玩家的获取，但它也可以用于许多其他目的：如整体业务盈利能力，优化在线运营以及管理新特性发行。在 LTV 的常见用法中，我们发现：

1. **盈利能力**：LTV 是用户在一生内可提供的总现金流量的估计。因此，如果我们将估算收入与相关成本进行比较，就可以估算出每个用户对企业现金流量影响的底线。
2. **用户获取**：只要获取新玩家的成本不高于净 LTV，理论上我们仍然可以投资到获取用户上。许多开发商在玩家获取中应用的好的经验法则是，成本应该理想地低于总 LTV 的 1/3，但取决于许多其他因素（预期增长，市场格局）。
3. **新功能和实时操作**：内容更新可能影响保留率，参与度和货币化，以及所有终身价值的驱动因素。顶级开发商在启动之前测试新更新的效果，以了解 LTV 的整体影响。
4. **构建新游戏**：某些开发商通过查看处于测试阶段的 LTV 来评估未发布游戏的可行性。

### 在手游中计算 LTV 的流行方式

![](https://cdn-images-1.medium.com/max/800/0*dD8kMd26WgTCGPcw.)

如上所述，目前还没有标准的 LTV 计算方法。然而开发商通常认为 LTV 至少基于两个变量：生命周期（查看用户参与度和留存率）和货币化（平均交易次数，货币价值，转换率）。

虽然大家都同意这两个变量必须是计算时要考虑的，但在计算它们的确切方法上仍存在争议。

#### 1. 生命周期

生命期通常以留存率来衡量。争议也是从这里开始的，对如何计算留存率有下面三种不同的看法：

1. 经典的
2. 范围的
3. 起伏的

经典的日留存率计算方法仅观测在安装日期后的特定日期上线的玩家，而范围留存率则查看在一段时间内（例如周）玩家的回归情况。起伏留存率则关注在一段时间后玩家的回归情况。

每种计算方法都可以更好地适用于特定类型的游戏。比如，一个剧情为主的游戏在某个时间段发布新剧情或新季 - 因此玩家只有在新季发布后才会回归 - 此时经典留存计算方案不再适用，他们可能对范围留存和季/剧集完成率更感兴趣。一些超级休闲游戏开发商会考虑每小时而不是几天的留存率，因为这种情况的存在，游戏的成功取决于第一个小时（而不是第一天）。

关于留存率的最后一句提醒：留存率通常被定义为用户打开应用程序这个动作。值得注意的是，打开应用程序之间仍然存在显着差异 - 例如（打开应用后）收集每日奖励，或者在线多人游戏中进行一场战斗。因此，我们可能会需要重新定义留存率为打开应用并执行特定操作的行为。

#### 你希望 LTV 的有效期是多长？

在计算 LTV 指标之前，开发商通常会就 LTV 计算的目的确定一个时间段，例如，评估 LTV 是未来 90 天，180 天，1 年，2 年甚至 5 年的。

请注意，有些人可能会觉得这个概念是矛盾的，因为术语“生命周期”本身理论上是指一个人生命的总持续时间。然而，由于 LTV 通常是一种平均估算，开发商可能希望保持保守，并计算一段时间内的 LTV。同样需要注意的是，你对未来的评估时间越远，准确性就越低。

有几个因素会影响你对时间段的选择，开发商通常会考虑许多因素，其中包括：

* 游戏的类型/流派：根据游戏类型预期的更具体的生命周期。例如，超级休闲游戏的寿命可能比作为服务运行的硬核游戏寿命短，因此将在不同时期计算 LTV。
* 商业模式：IAP 、订阅还是广告。例如，一般订阅用户的寿命可能更长，因此选择的时间可能更长。
* 公司阶段：早期与成熟阶段。在计算LTV时，早期阶段的公司通常会选择更长和更乐观的时间段，因为它们依赖于某项技术的未来发展，或者仅仅是由于缺乏历史数据。
* 投资回报周期：资金充足的公司可能能够投资更长时间在用户的获取上，从而延长游戏的生命周期。例如 180 天是允许足够收入达到盈亏平衡点的时间段。

#### 2. 货币化

就留存率而言，关于如何计算货币化变量存在争议。大多数游戏开发商都会考虑 ARPDAU（每日活跃用户的平均收入），但有些则考虑ARPU（每月用户的平均收入）或ARPPU（每个付费用户的平均收入）。正如我们稍后将看到的，它取决于用来估计 LTV 的模型，我们将使用其中一个。

无论你选择哪种货币化变量，重要的是要与你选择的时间段保持一致，并且要了解平均结果数量的一些限制。例如，如果我们根据最后一个季度，一个月或一周来估算游戏的ARPDAU，其可能会大幅波动。

#### **游戏中常见的 LTV 模型**

假设随着复杂性的增加，模型的准确性也会提高，我们可以按照以下方式对它们进行聚类：

![](https://cdn-images-1.medium.com/max/800/0*kNETtCUGtgyOy8nQ.)

* **历史平均数和基准**：基于历史数据或旧游戏。
* **简单的预测模型**：预测一些变量，如留存率或花费。
* **先进的预测模型**：例如来自Pareto / NBD 和 BG / NBD 模型或机器学习模型的“购买直到你不再活跃的模型”（BTYD）。

> [**如果你想了解更多关于各种模型的信息，请阅读完整的白皮书，其中提供了有关游戏 LTV 的更多最佳实践和见解。**](http://services.google.com/fh/files/blogs/insights_for_evaluating_lifetime_value_for_game_developers.pdf)

### 收尾的想法

正如我们所看到的，终身价值指标有各种用途，并在手游行业被广泛采用。然而，我们也看到，目前还没有标准的计算方法，因此可能有多种有效的方式来实施，这取决于几种内部（游戏性质，公司资源，可用数据）或外部（观众类型，竞争对手）因素。

因此，无论何时计算我们的玩家的终身价值，我们都需要做好在准确性和所需资源方面进行权衡的准备，从而充分利用这一宝贵资源。

在把终身价值指标用于用户获取或在线运营时，我们需要试着避免一些常见的错误，例如：过于乐观的计算，遗漏一些收入来源，或将其视为竞争优势，从而可能导致估计不足或过高估计。我们也可能要考虑关键方面，例如计算净 LTV，贴现现金流量，或充分分割计算。

希望这篇概述有帮助你更好地了解 LTV 在推动更好业务决策方面的潜力。鉴于该主题的复杂性以及关于此主题的更多见解，可以[下载我们的白皮书](http://services.google.com/fh/files/blogs/insights_for_evaluating_lifetime_value_for_game_developers.pdf)以了解更多有关计算游戏 LTV 的最佳实践。

* * *

### 你怎么看？

你对游戏开发商有没有其他关于 LTV 的想法？加入以下评论中的讨论或使用标签 **#AskPlayDev** 发推特，我们会通过 [@GooglePlayDev](http://twitter.com/googleplaydev) 来回复，我们会定期在上面分享有关如何在Google Play上取得成功的新闻和技巧。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
