> * 原文地址：[Lessons Learned at Instagram Stories and Feed Machine Learning](https://instagram-engineering.com/lessons-learned-at-instagram-stories-and-feed-machine-learning-54f3aaa09e56)
> * 原文作者：[Thomas Bredillet](https://instagram-engineering.com/@thomasbredillet)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/lessons-learned-at-instagram-stories-and-feed-machine-learning.md](https://github.com/xitu/gold-miner/blob/master/TODO1/lessons-learned-at-instagram-stories-and-feed-machine-learning.md)
> * 译者：[TrWestdoor](https://github.com/TrWestdoor)
> * 校对者：[haiyang-tju](https://github.com/haiyang-tju), [kasheemlew](https://github.com/kasheemlew)

# 从 Instagram 故事流和信息流机器学习中吸取的教训

自从我们在 2016 年宣布信息流排名以来，Instagram 机器学习有了显著的提高。我们的推荐系统定期为超过 10 亿的用户提供服务。我们现在不仅仅在信息流和故事流排名上使用机器学习：我们从你关注的标签中收集并推荐文章，将不同类型的内容混合在一起，并为智能应用预抓取提供动力。

Instagram 使用机器学习方法的所有不同方式都值得一贴，但是我们想讨论一些在构建机器学习流水线时得到的一些教训。

#### 模型选择

我们在这里对如何建模做一些决定，这些决定对我们很有帮助，要么可以提高模型的预测能力和提供顶线改进，要么可以在维持精度的情况下降低内存消耗。

首先我们选择 [caffe2](https://caffe2.ai/) 作为我们的基础模型框架，这意味着我们通过这个平台来编写和设计模型。相比于其它选项，Caffe2 对我们的工作流提供了明显的优化，并且它在推理时为每个 CPU 周期的模型权重提供了最大空间。“堆栈占用”在机器学习团队中是一个很重要的度量标准，因为我们在网络中使用了多个 CPU 密集型统计技术（池，等）。

我们也使用带有排序损失的模型和 point-wise 模型（例如对数损失）。这让我们在最终的价值函数中拥有更多的控制权，这样我们就可以在关键的投入指标中进行微调。

在核心机器学习中，通过考虑我们模型中的位置偏差，我们可以得到一些非常好的准确性。我们在最后的全连接层添加了一个稀疏位置特征，以此避免过多的影响模型。一般来说，共同学习稀疏嵌入是另外一个有影响力的领域，它以多种方式来恰当地捕捉用户的兴趣。。

通过拟合高斯过程，我们定期调整最终的价值函数，以了解通过一系列 A/B 测试测量的价值函数参数对顶线指标的影响。

![](https://cdn-images-1.medium.com/max/1600/1*gkKF0o5RqOubUXvJgAK83Q.png)

图 1：一个我们用来进行预测的经典模型结构的例子

#### 数据新鲜度和趋势

用户习惯会随着时间而改变。同样，生态系统也会受到趋势效应的影响（比如在超级碗这种季节性事件中）。正因为如此，数据新鲜度是很重要的。陈旧的模型不能捕捉到用户行为的变化或者理解新的趋势效应。

量化数据新鲜度的影响对我们是有帮助的。我们监测关键行为分布之间的 KL-散度偏移，来告知我们的流水线的“不稳定性”。

保持我们的模型新鲜的一个方法是有一个在线学习模型或者至少进行周期性的训练。在这种设定中，我们面临的最大挑战之一是提出一个合理的自适应学习率策略，因为我们希望新的例子在梯度更新中仍然有用（即使对那些已经在数月的数据上进行了训练的模型）。

#### 新颖效应

新颖效应是我们面临的另外一个难题。我们经常进行 A/B 测试，在早期对照组表现出正向的作用，并且逐渐趋向于中性。

一方面，可以明确的是，一些细微的变化可以暂时提高参与程度。我们相信这源于一个事实，即长期运行模型会倾向于“挖掘”的过多，并且这些测试会带来一些新的探索领域。

这些影响的时间尺度也很有趣。我们已经看到了一些变化，这些变化需要持续一个多月的时间后才能趋于平稳（参与度呈上升或下降趋势）。

另一方面， 我们艰难地认识到，新颖效应可以是很微妙的，所以在推出可能会产生影响的新体验时，应该小心控制。我们最近进行了一次严重的事后分析，发现两个容易产生新颖效应的实验在启动后的几个小时内相互作用，变得非常糟糕。

虽然这并不完美，我们现在有了一些模型可以预测容易新颖的实验的数量和长度。借此我们可以通过减缓风险和提前终止测试来更快的进行迭代。

![](https://cdn-images-1.medium.com/max/1600/1*99xykWyce5eGX5h6ha9dJA.jpeg)

图 2：在我们运行的 A/B 测试之一上观察新颖性

#### 实验（A/B）小影响

大规模机器学习和 A/B 测试有许多不同的复杂性。除了上述提到的新颖性之外，我们也面临统计学上的问题。想象一下有 10 个排名工程师每人启动一个新的测试 **everyday**：很有可能这其中的一些测试提高了参与度指标，这很有统计意义。

最重要的是，这些实验中的一些可能只是为了一些特定目标的用户，因此这个测量结果不是对所有用户起到同样的重要性的。这就使得测试结果很难评估。

我们当前的最佳实践是在工程师的迭代速度和我们启动的变化置信区间之间做出权衡。在我们批准进行 A/B 测试之前，这些最佳实践需要在大量用户中进行严格的复制。

#### 学习作为影响和科学方法

根据定义，机器学习是一种随机过程。当我们进行性能评估时，我们的工程师和科研人员根据在稳定项目上的传统软件工程师来进行校准。做所有正确的事情都是有可能的，但是在底线方法方面会让人失望。

在 Instagram 上，我们热衷于坚持科学的实验方法。即使 A/B 测试不会直接导致产品发布，我们也可以经常利用它在未来提供有趣的产品洞察力。

这也防止了在训练流水线中进行超参数随机遍历以寻找局部最优解的糟糕的科学模式。我们现在称这种模式为“人类梯度下降”。有了这一点，我们需要在启动测试之前验证原则假设。

作为一个机器学习工程师，我们并非仅仅盯着特征看，我们还想要学习。每个实验都有其特定的输出，我们并不是随机游走。

#### 正则化

混合不同类型的内容是我们面临的另外一个挑战。例如，一个视频和一张照片有不同可能操作的分布。例如你可以想象“喜欢”一张照片和“评论”一张照片或者“完成”一部视频是三种不同的行为，并且有着不同的分布（如喜欢比评论更常见，等）。

简单来说，它就像是对照片用 P[喜欢]（一个观众喜欢这个照片的概率）和对视频 P[完成]（一个观众观看一部视频超过其 X% 长度的概率）来进行排序一样。当我们想要合并这个列表来完成对观众的最终排序时，机器学习工程师就处在一个很为难的位置。

我们通过拟合一个映射来解决这个问题，即从一个价值函数分布（如 P[喜欢]）映射到一个合理的分布如高斯分布。在那样的输出空间中，列表现在是可比较的，并且我们可以清楚的说出一部分内容优于另外一部分。

![](https://cdn-images-1.medium.com/max/1600/1*jgHr3apEde5SFp0IMPOKZA.jpeg)

**图 3：我们的价值模型在归一化前的对数分数，分布很不均匀**

#### 迭代速度 - 离线分析

我们添加适当的后验框架已经太晚了。对非常大规模且有影响的机器学习系统来说，工程师和科研人员真的需要去打开模型并且仔细的理解他们实验产生的效果。在没有可靠的工具下这是很难做到的。我们开发了一个重播工具来接收你想要测试的新模型/排名配置，并且输出一组有用的测量结果来帮助理解你的改变对整个生态系统的影响。

我们的目标是尽量减少在线实验，尽可能减少给用户暴露糟糕的实验结果的风险并且加速我们的迭代速度。

![](https://cdn-images-1.medium.com/max/1600/1*neNMnbd7f7yKWdfs7qBMJw.png)

**图 4：我们的离线分析工具在模型指标上的表现（每个点表示了一个不同的训练模型）**

#### 工具和基础设施

所有大规模系统都需要严格的基础设施，幸运的是，在 Instagram 中我们有一个稳定的机器学习基础设施团队（他们最初建立了反馈排名并从其分离出来）。所有模型推理、特征提取、训练数据生成和监控都由其基础设施负责。

不必去担心规模问题，全神贯注于统计模型对我们工程师而言是最有效的提高之一。最重要的是，机器学习基础团队创建了工具让我们更加深入的理解我们的模型，从而帮助我们提高用户体验。

#### 个性化

另外一个有利的特征是精调我们的最终价值函数的能力。将我们的模型作为输入，添加我们的业务逻辑，然后返回每个媒体的最终得分。**个性化**价值函数兼具了有效性和复杂性。我们选择对那些从我们的推荐系统中获益较少的用户群体进行高层次的启发式分析，并专门为他们调整价值函数。

另一个显示早期结果的个性化策略是在一些用户亲和力模型中进行因子分解。试图量化一个用户与其他用户/内容类型之间的亲和力有多大，这有助于我们专门为观众定制和适应我们的功能。

#### 价值模型

最后，我们有了我们的价值模型：公式化描述，它将不同的信号组合成一个分数，并且合并我们的业务逻辑。这是一个复杂的代码，产品启发法满足统计预测。

过去这些年通过调整这个价值模型，我们看到了显著的增长。我们经常使用高斯处理和贝叶斯优化来跨越模型的超参数空间，并且找到一个适合我们的区域。有一篇在[这里](https://research.fb.com/efficient-tuning-of-online-systems-using-bayesian-optimization/)详细的描述了这个过程。

![](https://cdn-images-1.medium.com/max/1600/1*wSOPR-9Q0YclynQAcIShZw.png)

**图 5：我们怎样调节不同的归一化价值模型并且测量不同的影响程度**

### 后记

我们希望对我们的机器学习管道和我们面临的问题的总结是有帮助的。在未来的文章中，我们将更深入的讨论上述的一些问题。

无论我们是在预测用户行为，构建内容理解卷积神经网络，还是创建潜在的用户模式，这些课程都有助于我们减少错误并更快地迭代，这样我们就可以不断地为 Instagram 上的每个人改进机器学习！

**如果你很高兴应用机器学习技术为我们的全球化社区提供价值，我们一直在寻找更多优秀的人才来[加入我们](https://www.instagram.com/about/jobs/)。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
