> * 原文地址：[Imaginary problems, the root of bad software](https://medium.com/@george3d6/imaginary-problems-d4f2921bd1b8)
> * 原文作者：[George](https://medium.com/@george3d6?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/imaginary-problems.md](https://github.com/xitu/gold-miner/blob/master/TODO1/imaginary-problems.md)
> * 译者：[ssshooter](https://github.com/ssshooter)

# 虚构问题，低质量软件的根源

从使用的工具，到团队内部的沟通质量，到开发人员的利益，以及你使用的测试方法，有许多因素可以成为低质量软件的催化剂。

我认为其中最主要的问题是，几乎所有低质量软件的根源：**虚构问题**。

复杂的软件并非设计之初就过于繁杂或功能失调。只是因为它在制作过程中添油加醋，最终结果有别于初心。

### 播客应用

假设您是播客主持，想拥有自己的网站，可以在其中销售促销产品，可以不经第三方接广告，最重要的是，向您的观众提供播客，视频和博客文章。

你这个小小的网页应用可能有如下要求：

*   北美地区可以快速加载内容，播客直播与下载。
*   99.99% 的用户在前 15 分钟内不会遇到应用崩溃，当然，最好永远不会发生。
*   与 Google AdWords 较好地集成，有时间的话再接入其他广告商。
*   动态链接到我的 Zazzle 上的最新产品，可以的话，根据用户观看的剧集向用户提供推荐。
*   因为我在 Facebook 做直播，所以要集成 Facebook 直播模块。如果可以自己做出一套直播系统，不依赖于 Facebook，那就更好了。

你把这些要求交给一个承包商，聊了一下。两个月后，他们向你展示 MVP，你气炸了，你觉得浪费了 15000 美元在一件垃圾上，你只想把你的钱要回来。

看着这东西生气是正常的，因为第一次打开它时屏幕像死机一样。你问他如何修改网站上的广告，他指了指那个又丑又让人看不懂的自定义 UI。Zazzle 的商品链接有一半是破损或是缺少图像的，Facebook 直播流还有延迟！

但开发团队对你的愤怒感到困惑，从他们的角度来看，他们已经为你赴汤蹈火了。

他们全心全意编写了这个应用，它有一些惊人的特性：

*   最先进的推荐系统。
*   转播你的视频或直播的算法（用于前面提到的推荐系统）。
*   世界各地可在 200ms 内加载你的首页。
*   几乎从头开始构建流媒体协议和客户端，你随时可以从 Facebook 直播切换过来。
*   可让你轻松集成 20 多个广告平台的服务。

问题来了，你需要的仅仅是核心功能，如果有余力实现，才加入其他特性。然而，开发团队收到的需求可能截然不同了。开发团队听到了一些激动人心的挑战……还有一些无聊的基本功能，他们不怎么在意。

最惨的是你没有直接与开发者沟通，而是像在玩传话游戏一样，跟一个销售人员谈过，销售人员与中层管理人员会面，然后编写了套业务规范并将它们交给了 PM，PM 编写了一些技术规范并将它们交给了团队负责人/架构师，负责人开始与他的团队设计产品。每经过一层交接，需求都可能被扭曲。

### 这是一种应对机制

想象问题通常比实际问题更好玩。天才喜欢玩竞技游戏，构建和解决数学问题，甚至编写试图回答有关人类状况这种抽象问题的书籍，所有这些都是免费的。不过，一般程序员可能会向您收取相当数量的费用，为你构建一个相对简单的 Android 应用。这不是因为平庸的程序员比天才更难找到，只是因为前者做的事情都很有趣，后者可能会比较无聊。

大多数程序员希望获得报酬并同时获得乐趣。但是，对大多数情况下，这相当困难。当然，对于我们大多数人来说，“乐趣”的定义是完全不同的，但对于许多工程师来说，“乐趣”可以归结为，可解决性范围内，有趣并具有挑战性的问题。

你给一个有点头脑的人一堆不能自动化完成的无聊任务，他们迟早会被逼疯。不过经历了数十亿年的进化，人类大脑在保持理智方面非常有才能。就像童年困难或虐待的受害者可以在童话书中得到解脱，企业编程或自由网络开发的受害者可以在解决虚构问题中得到解脱。

![](https://cdn-images-1.medium.com/max/1000/1*8jPa3TYWKxx2PU5A87_4Xg.png)

软件工程师为自己创造虚构问题的数量，与他们的想象力和他们应该解决的实际问题的难度有关。

我们应该意识到，这个问题并不是开发人员所独有的。管理，销售，HR，顾问，法务甚至会计都有自己独有的方式来创造虚构问题。当他们出席的会议内容很少涉及到自己的时候，他们主动让自己更多地参与决策，过分强调与他们角色有关的问题（例如法务：我们的狗狗日托 App 必须从上线第 1 天 101% 符合 GDPR，我们不能成为法律先例）。尽管没有必要，他们还是雇用了一整个团队处理这个问题，这么做显得他们在这个项目中很重要，有做实事。

人是活的，问题是死的，所以聪明人总能找到**一种应对方式**。

### 传话驱动式设计

虚构问题不仅仅因为开发人员太无聊，也因为沟通链太长。

我偶尔会接一些外包。以前，外包客户是不能自己挑的，这就意味着我甚至可能会在工作中遇到 DID（人格分裂）和 ADHD（多动症）病例。我曾收发了 100 多封邮件，仅仅是讨论 MVP 里微不足道的细节；曾遇到有人在一周内把项目中的每一个需求都改了个遍的情况；曾有客户问过诸如“这可以发行虚拟货币吗？”或“我们可以在这里加人工智能吗？”等问题。

当然，大多数客户还是理智的，但他们往往因为缺乏相关知识，无法清晰表达他们的需求。但这没问题，因为这是我作为“计算机专业人员”工作的一部分，帮助人们根据他们的使用场景，判断他们的软件需要或不需要什么。但是当你和客户之间相隔数层，这件事便会变得十分困难。

大多数公司喜欢雇佣销售人员安利潜在客户，协商价格并概述这个价格可以得到什么功能。还有另一批[善于交际的人](https://www.youtube.com/watch?v=hNuu9CpdjIo)与客户讨论更多深度要求和细节，其实他们也算是销售人员，只是职位名称不同。接着是内部领导层的意见，多级管理层以及技术团队内部的层级结构。

需求经历这么多人，即使这些人的意见是好的，事情也会发生变化。有些会因其无意义而被改变，这些定义是愚蠢的，所以需要重新定义。销售人员可能会说“只要多付 39999，我们就可以在区块链上实现这个功能”……然后后面的人要思考“在区块链实现这个功能”是什么鬼意思。

所以通常需求变化的原因有两点，在多级传递中有人误解了某些事情，或者有人使用上述应对机制来使他或团队的工作更有趣和令人印象深刻。

因此，最原始的需求，最迫切需要解决的问题，在各级传达中丢失。并被虚构问题和一片空白所取代，接着，大家都用他们自己虚构问题填补这些空白，因为现有的问题真的很让人乏味，他们一个**应对方式**便是填补这些空白。

### 过度复杂和自然选择

通常情况下，存在虚构问题更深层的原因是，它们有助于团队或公司的壮大，虚构问题成为维持公司不可或缺的一部分。

> People who are bred, selected and compensated to find complicated solutions do not have an incentive to implement simplified ones. — Taleb

你听说过仅靠三位工程师就能轻松地搭建网上银行系统的情况吗？他们使用功能设计理论和内存安全语言，从头开发了一些完美无瑕的银行软件，然后开始将大型银行迁移到他们惊人的基础设施。

可能没听过，因为根本不存在。甚至，还有成千上万的团队[成千上万的开发人员，连“回滚”这么简单的概念都不清楚](https://www.theguardian.com/business/2018/apr/28/warning-signs-for-tsbs-it-meltdown-were-clear-a-year-ago-insider)，而恰恰是他们，在日复一日地编写银行软件。

数字的存储和传输的技术要求并不高。建立整个互联网的索引，在 2 秒内提供问题搜索结果才是一个难题，[只有少数聪明人去想方设法解决这个问题](https://en.wikipedia.org/wiki/History_of_Google)。

问题在于银行生态系统非常善于保持一种无人监管的状态。这台运行良好的机器保留了自己的敛财机制。它的领导者是掠夺于社会的腐败者，但组织的领导者只是其成员的一个象征。

我的意思不是在银行工作的人都是坏人。相反，他们通常是很友善，致力于为家人提高生活质量。但他们要的不是修复银行软件，而是保持就业。在现在的经济环境中，丢了工作可不是开玩笑的。在银行业中，话多，主动可以让你更有存在感。

所以银行业这风气，不是因为行之有效，而是已经产生了惯性。这种惯性以处理虚构问题的形式出现，以避免解决实际问题。如果点明了的真正的问题，给其他人的工作带来威胁，可能会导致你被解雇，甚至像高盛这样特别令人讨厌的“机构”，[给一些联邦调查局官员寄了封信，然后毁掉你一生。](https://en.wikipedia.org/wiki/Sergey_Aleynikov)

> **It is difficult to get a man to understand something, when his salary depends upon his not understanding it!** — Upton Sinclair

企业最高管理层（C-suite）不会在意他们的高层管理人员（upper management）将90％的时间花在“客户会议”上，这些在热带岛屿举办的“会议”还花费了百万美元的“其他费用”。因为高层管理人员对他们本身的腐败视而不见。

高层管理人员不会在意中层管理人员（middle managers）买下几个古怪的办公室，雇佣三名秘书和十几名实习生。因为有了中层管理人员，他们能活在华尔街之狼的幻想中。

中层管理人员不会在意直线经理（line managers）将时间花在怎么修改“改进我们的敏捷方法”的 PPT，而非降低成本。因为直线经理满足了他们对独裁的幻想。

直线经理不会在意技术团队负责人和架构师满口都是“下一代系统间的接口使用 JRPC 和 使用 Hibernate 和 Spring 的微服务”，而不是优化那成吨的 Mysql 查询要查老半天。因为团队负责人假装不知道他们的上司甚至连 Excel 都用不好，还几周到办公室一次。

团队负责人不会在意开发人员使用新的 JS 框架，一年改 10 次 UI，而不是检查以下数据库查询为什么这么慢。因为开发人员假装不知道他们的领队根本没写代码，最多也就画个 DOT 图。

这是一个解决虚构问题的恶性循环，从 CEO 假装不知道多赚三千万也不能解决自己的家庭问题，到 UX 实习生假装不知道重新设计一个“提交按钮”，他们的密码还是以明文传输。

但是每个人都需要不断解决虚构问题，因为一旦他们停下来关注真正的问题，他们可能会意识到整个系统的崩塌。他们可能会发现 Debra 已经坐在那个角落，盯着内部机房的监控图表 10 年，尽管该公司 5 年前已经迁移到 AWS。他们可能会意识到他们 99% 的工作就是延续别人的工作……这个事实对绝大部分人都难以接受，所以我才说，他们一定会找到了一种**应对方式**。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
