> * 原文地址：[How To Write a Front-End Developer Resume That Will Land You an Interview](https://medium.com/better-programming/how-to-write-a-front-end-developer-resume-that-will-land-you-an-interview-f188ba4fe68b)
> * 原文作者：[Gareth Cheng](https://medium.com/@garethcheng)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-write-a-front-end-developer-resume-that-will-land-you-an-interview.md](https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-write-a-front-end-developer-resume-that-will-land-you-an-interview.md)
> * 译者：[febrainqu](https://github.com/febrainqu)
> * 校对者：[Gesj-yean](https://github.com/Gesj-yean)、[kanweiwei](https://github.com/kanweiwei)

# 如何写一份能让你获得面试机会的前端求职简历

> 这是一篇从面试官角度描述的，为初中级前端开发人员所写的文章。

![](https://cdn-images-1.medium.com/max/4120/1*zbDy-S2TCDK93sO7FhcyXA.png)

作为一名前端开发，你会构建可见的东西，并且你希望能让它看起来不错。同样的道理也体现在你的简历上。间隔合理，可读性强，令人舒服。

#### 通过这篇文章你将学到的：

1. 针对软件开发人员的基本简历写作技巧。
2. 如何将 IT 技能和技术能力写在简历上。
3. 有关如何介绍你过去的工作经验的分步指南。
4. 如何建立你的前端作品集。
5. 使用[简历生成器](https://www.cakeresume.com)编写简历。

## 1. 从基础开始

![](https://cdn-images-1.medium.com/max/3840/1*wk6xlKGvlqrbFoKmTkoMcg.jpeg)

#### 你的联系方式

联系方式应该放在简历的顶部。尽可能多的展示你想要分享的信息。

#### 总结性陈述

你的总结性陈述应该是一个简短而引人注目的专业概要，包括你的职业成就和未来规划。

在编写时，请记住以下几点：

* 除非职位明确要求，否则不要声明你自己是一个 Angular[JS]/React 开发人员。把自己标记为 X 开发人员意味着告诉别人你只想做 X 开发，而且会使别人认为你可能是一个死板的人，或者在其他方面不能适应。
* 问问自己，我应该包括哪些关键字以确保目标受众能继续阅读我的简历的其余部分？
* 阅读公司发布的岗位介绍，记住关键词和关键短语。他们在找什么？什么能让你和其他申请者不同？

#### 教育

除非你是应届大学毕业生，否则无需列出你的 GPA。你的职业成就比 GPA 更重要。

## 2. 技术技能

![Photo by [Filiberto Santillán](https://unsplash.com/@filijs?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText) on [Unsplash](https://unsplash.com/s/photos/react?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText)](https://cdn-images-1.medium.com/max/12000/1*9JIvQ9NwFCmdo0VNGaTu6Q.jpeg)

对于软件开发人员来说，这是让你脱颖而出的最重要的部分。在你列举你的技能时，你需要表现出深入的理解关于这项技能是什么、在什么背景下使用、什么级别下使用。这里需要尽量做到诚实和清晰。

#### 入门技巧

* 如果你列举了 HTML5，则无需列出 HTML4。HTML5 暗含了 HTML4 及其以下版本。CSS3/CSS2 也是如此。
* 具体说明你的熟练程度，并且要诚实。通过你的熟练程度描述，读你简历的人会很快对你有一个更清楚的了解，这将节省你们双方的时间。
* 如果一项技能与这个职位没有直接关系，但可能与整个行业相关，那么就把它写进去。这会让你有更多被招聘人员挑选出的机会。

![](https://cdn-images-1.medium.com/max/3840/1*UbhkE5vN-FOzYoFQ7jT5TA.jpeg)

#### 什么样的技能不需要展示

![](https://cdn-images-1.medium.com/max/3840/1*HwvJtfNwyAg0dcP0Ddfeyw.jpeg)

不要像这样写。这是整个 IT 部门。

尽量不要像上面的示例那样展示你的技能。如果你刚开始学习一项新技能，不要将其放在简历中。这样能避免招聘人员推荐你从事不适合的工作。

## 3. 工作经验

![](https://cdn-images-1.medium.com/max/3840/1*Dd1dVcccqN6gd6KUgfCFdA.jpeg)

#### 使用动词

在这一部分，你需要简洁的呈现信息。使用动词来给招聘人员留下深刻印象，但要避免夸张。

#### 定制化

突出你所申请职位的相关信息，并保持简短。这将使你从那些任何岗位都投递同样一份简历的人中脱颖而出。

#### 少即是多

但是，请不要夸大你的经历，因为面试官会根据你简历呈现的内容提问。记住少即是多。

#### 包括相关的关键词

这样做的目的是击败 AOS（申请者追踪系统），并编写一份能被猎头公司和招聘经理发现的简历。

你可以通过分析目标职位的职位描述，确定最能描述它的特定单词和短语，然后将其应用于简历来做到这一点。

#### 遵循下面的分步指导：

```
// 首先，写下你的公司名称，你的职位，以及你在这里工作的时间。
```

ABC 公司，前端开发人员，2017 年至今

```
// 如果你的公司不是很出名，就简短的介绍
```

ABC 公司是一家让世界变得更美好的公司，我们试图解决人们的问题。

```
// 列出几个主要的成就，并写上相关的关键词
```

* 使用 React，Antd 和 Deck.gl 开发了一个用于可视化运输路线的原型。
* 使用 React 和 Material-UI 构建了一个以甘特图形式呈现的调度工具。
* 平衡的需求，用户体验和截止日期，以便在有限的时间内获得大部分商业价值。

```
// 列举你使用的技术
```

技术：React、Deck.gl、Python、Recharts、Node.js

#### 你的工作经历应该这样来描述：

![](https://cdn-images-1.medium.com/max/4484/1*GfaGcGu8oOVsTNG5FNcJDg.png)

## 4. 作品集 — 使你从同行中脱颖而出

![[Trantor Liu’s Portfolio on CakeResume](https://www.cakeresume.com/trantorliu/portfolio?ref=resume-header-portfolio)](https://cdn-images-1.medium.com/max/3836/1*e-lvUJN69OBx3GOhmqM94A.png)

因为编程培训机构增加了前端开发人员的数量，大量的开发者[涌入开发人员就业市场](https://medium.com/@marceldegas/san-francisco-bootcamp-bubble-cee59e48bf3e)。

加上一点你独特的经验或项目绝对会让你在同行中脱颖而出。此外，建立自己的作品集也很重要，因为“经验”的定义因人而异。

展示你过去的工作和项目可以快速证明你的 web 开发能力，这会增加你在竞争激烈的市场中获得面试的机会。你可以在 [CodePen](https://codepen.io/) 或 [CakeResume](https://www.cakeresume.com) 上面上传你的作品。

#### 描述一下你作品集中的工作

不过要记住，提供你的作品的链接并不是在构建作品集。同样，一个无法体现你的想法的线框图或者你的应用程序的视觉效果，也是一个糟糕的想法。

当你建立作品集时，可以包含这些内容：

* 屏幕截图或现场演示链接。
* 你的工作是什么？
* 你的贡献是什么？
* 你使用的语言、框架和设计模式。

一些例子：

[**ThisIsMe Web App Information Architecture - Jayd Gibbon 的作品集**](https://www.cakeresume.com/portfolios/thisisme-web-app-information-architecture)

[**Seul Landing Part 1 - Stefan 的作品集**](https://www.cakeresume.com/portfolios/seul)

#### 如果你是从零开始，我有一些建议

* 模仿你常用的网站。
* 开始写一个技术博客。这也可以是你作品集的一部分。
* 去参加黑客马拉松，并做点什么。
* 开始解决你自己的问题。

## 5. 线上简历生成器

在我们开始写一份出色的简历之前，试着想想你希望你的简历是什么样的板式。就个人而言，我建议软件开发人员使用线上简历生成器来写简历，例如 [CakeResume](https://www.cakeresume.com/)（免费的）。

这是线上[简历生成器](https://www.cakeresume.com)的优势：

* 他们帮你使用最新的设计来创建你的简历，这会给你未来的雇主留下好印象。
* 它们能节省你的时间。特别是对于那些不知道从哪里开始以及不想在调整列和边框上浪费时间的人。
* 它们有助于确保你不会遗漏任何重要信息。
* 它们能更容易的更新简历和置换信息。你可以根据不同的雇主的要求稍微调整简历的信息。

## 6. 善用超链接

如果你决定使用在线简历构建器来构建简历，则可以使用超链接。即使你把你的在线版本转换成 PDF，你的链接仍然可以使用。

#### 什么时候使用超链接

* 你想展示你一直在做的网站 —— 你只需提供该网站的 URL。
* 你需要提到你使用的第三方服务或 sdk。
* 你想在个人博客或媒体上展示你先前尝试解决的问题的解决方案的记录。

## 了解更多：

* [求职信（求职信样本，求职信模板，申请信）—— 多合一教程](https://www.cakeresume.com/resources/cover-letter-all-in-one-tutorial?locale=en)
* [如何写一份能让你获得面试机会的 iOS 求职简历](https://medium.com/better-programming/how-to-write-an-ios-developer-resume-that-will-land-you-an-interview-43cf66c6d4fa)

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
