> * 原文地址：[How to simplify your design](https://uxplanet.org/how-to-simplify-your-design-69d97fde11b9)
> * 原文作者：[Taras Bakusevych](https://medium.com/@taras.bakusevych)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-simplify-your-design.md](https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-simplify-your-design.md)
> * 译者：[shixi-li](https://github.com/shixi-li)
> * 校对者：[ezioyuan](https://wushouyuan.com/), [renyuhuiharrison](https://github.com/renyuhuiharrison)

# 如何简化你的设计

> 20+ 易于遵循的图示

![](https://cdn-images-1.medium.com/max/6642/1*vQ-7uBDYnOAR23XeamDffQ.jpeg)

各个公司都一直致力于打造简单实用的产品。并在轻量且易于使用的框架下，它们开发出更多的特性、新的技术和更高级的功能。通常来说，简单反而是最困难的事情。

## 什么是 “简单”?

我们可以这样定义“简单” — 没有任何困难就可以理解和完成的事物。我们无法定义简单，它是一个主观的概念，一个人认为简单的事物对于另一个人来说可能并不简单。通常，我们会在三个阶段的过程中快速的形成我们对于简单和困难的个人观感：

![](https://cdn-images-1.medium.com/max/4080/1*LiHaOX6BjtCHutZclqWoeg.jpeg)

**消除那些阻碍用户实现目标的困难** — 将帮助你将产品变得简单。在简单法则中，John Maeda 提供了十条法则用于平衡业务，技术和设计的复杂程度，这正是少即多的准则。

![简单法则, John Maeda: [http://lawsofsimplicity.com/](http://lawsofsimplicity.com/)](https://cdn-images-1.medium.com/max/4080/1*LDHS0cnrBa78ruUoUjcx5Q.jpeg)

Maeda — 一名麻省理工学院媒体实验室的教授，也是世界知名的平面设计师 — 探讨了应该怎么来重新定义“提升”这个概念，让它不总只是意味着更多。这本书真的挺不错，我强烈推荐你看看。

**复杂又是什么样子？**  
讨论简单的同时我们当然也应该讨论一下它的对立面。通常意义上的复杂是一个主观的感受。通过适当的学习，就算是火箭科学也不是那么的困难。但是有几个因素却会让最简单的事情也变得很复杂。它们应该在实际的产品设计中尽可能被避免：

![](https://cdn-images-1.medium.com/max/4080/1*RLs6G5NC4NYDIqDXs4Xgeg.jpeg)

## 那么我们应该怎么将这些理念应用到产品设计？

### 1. 专注打造产品的核心价值

有太多的软件试图为受众做到太多的事情，它们都希望成为一个行业的瑞士军刀。但是如果你希望让你的产品变得简单，你需要为你的产品定义一个真正核心的价值并且确定该产品的真正目标用户。并不是每一个产品都需要内置一个 Facebook。

![](https://cdn-images-1.medium.com/max/4080/1*rfjBL4vNYlUfXfjxEe_vng.jpeg)

### 2. 移除所有不必要的东西

实现简单最容易的方式就是在深思熟虑后做减法。当你心存疑虑，请果断删除。比如次要信息，不常使用的控件和分散注意力的样式。就这样简单。一旦你使用这个原则，你将会马上看到效果。但是在做减法的时候一定得小心。

![](https://cdn-images-1.medium.com/max/8160/1*RhLi0SirFV906aqBOt7-Iw.jpeg)

> “简单不是没有杂乱，那只是简单的一个结果。简单是在某种程度上描述了事物和产品的位置和目的。没有杂乱只能称作一个没有杂乱的产品。但那并不是简单。” — Jonathan Ive

### 3. 将数据转化为有意义的格式

我们每天设计的大多数产品都在关注用户需要使用的大量数据，以便有效地执行他们的日常工作。但是你的用户如果是对数据的趋势和变化更加感兴趣，请用可视化的展示呈现给他们而不仅仅是一堆数字。你可以按需展示所需要的额外数据。请尽量从你有的数据中提取出有意义的部分并将其展示在用户前面。

![](https://cdn-images-1.medium.com/max/4080/1*Cu7y8fOmfomTWAEQs3mhFA.jpeg)

### 4.支持快速决策

面对接踵而来的各种选择，用户不得不花时间去理解和判断，这是他们不喜欢干的事儿。这件事在著名的希克定律（Hick’s Law）中得到解释。希克定律（Hick’s Law）认为决策本身所需要耗费的时间和精力随着选择的增加而增加。所以如果你希望你的用户体验变得更加简单，那么你得让用户能够快速选择，这样的设计要尽可能的多些。去掉那些并不需要的决策、指引和用户操作。

![](https://cdn-images-1.medium.com/max/4080/1*ocxCNCeaGxcjztbxa8fOTA.jpeg)

### 5. 太多的选择会吓跑客户

目前的心理学理论和研究认为通过个人选择会产生积极的情感和后果。这些发现导致了一个流行的观念，就是选择越多越好 — 人类的决策能力和对选择的渴望似乎是无穷无尽的。但是事实上研究证明了正好相反：

果酱实验（Jam Experiment）是消费心理学中最著名的实验之一，它表明提供较少的选择更加有助于销售。至关重要的是，它表明了精确提供较少的选择可能会更加有助于你的销售。

![](https://cdn-images-1.medium.com/max/4080/1*UCydCFrlZPYxUqWhv4JygQ.jpeg)

这个实验表明，与那些有很多选择的客户相比，选择较少的客户购买的可能性似乎要高10倍。这一直是作为证明让选择不要过多的关键例子，因为为用户提供太多的选择实际上会抑制用户的购买欲望。

![](https://cdn-images-1.medium.com/max/4080/1*cFVvbcfBmbf0JpaLgsfGtQ.jpeg)

### 6. 提供多个选择的建议

如果无法避免选择，请尝试限制它们。可以提供一个你个人的建议或者分享其他消费者更喜欢的内容。明确告诉用户不同选项之间有什么差别。这个方案通常应用于计算价格的页面。

![](https://cdn-images-1.medium.com/max/4080/1*FSlZMbvX0fw6wVtz35gfuQ.jpeg)

### 7. 吸引用户的注意力到正确的方向

当你了解你的用户实现目标的过程后，那么在这个过程的每个阶段都有着与那个目标更加相关的事情。找到那些关键的领域并将用户的注意力转向它们。

![](https://cdn-images-1.medium.com/max/4080/1*I0za3tgVOtgwRhhYJvpUNA.jpeg)

### 8. 使用颜色和布局来表达内容的层次结构

你听过多少次这句话 — “用户是不会浪费时间在阅读上”。这并不是假话，我们只会阅读那些我们需要去记忆或者实际了解的东西。如果你没有读过一个单词就接受了大量的用户条约，那你就应该明白我说的什么意思。有很多特征可以用来对交流产生影响：字体样式，大小，字距，前导，大小写和颜色。可以用它们来传递内容的层次和结构。正确的使用颜色和排版可以让你的产品反映出易于识别的品牌形象，并且更加具有吸引力和让人难忘。

![](https://cdn-images-1.medium.com/max/4080/1*FmTXPGd7AVMxyfirpCsxkg.jpeg)

### 9. 让系统有序组织，简单且更易管理

让我们来做一个简单的测试吧。以下我们有两张图片。使用秒表来测量你计算这两张图片中的黑点数量所需的时间（和精力）。

![](https://cdn-images-1.medium.com/max/4080/1*NRumh73N7gg7pk0givoXZQ.jpeg)

完成了吗？结果正如你自己所看到的那样，计算无序的点阵会耗费更多的时间，并且还会给你带来更多认知上的负担。但如果方块的点数相同，为什么我们还会得到这个结果呢？

将点映射到特定矩阵会帮助我们直观地浏览它们并在计数时进行分组。在无序的方块上我们不得不一个一个地数数。此外，大多数人可能都会错误的估计或者被迫用左图去检查你的答案。

![](https://cdn-images-1.medium.com/max/4080/1*JZoY7mAf-3rcNywnq3XLBw.jpeg)

元素的组织不仅提高了识别率，而且还使其更容易记忆。操作任何机器时，记住所有控件的位置和功能都非常重要。让我们来做另一个小练习。就在一分钟以前你刚才计算了两张图片里面的点数，现在请回想这两张图片里面所有黑点的位置。对于大多数人来说记住无序的结构几乎都是不可能的。

![](https://cdn-images-1.medium.com/max/4080/1*nVBG5GJnXDCWKz_F-K-u5w.jpeg)

### 10. 对相关内容分组

通常，一个简化复杂页面的简单方法就是开始对组件进行分组。这样用户处理的就是少数几组而不是大量不相关的组件。在元素或者一组元素周围设置边框（创造共同区域）是将周围元素分离的一个简单方法。在格式塔心理学中有多种原则可以帮助元素构建相关性：接近性，相似性，连续性，闭合性和连通性。

![](https://cdn-images-1.medium.com/max/4080/1*p1mdTyxWZLT3L7vELVSuGw.jpeg)

### 11. 将大型任务拆解为小步骤，并且尝试单列布局

几乎在任何产品中都存在不同形式的表格。这是你获取用户信息的方式。甚至有的时候已经移除掉所有不必要的东西之后，但表格内容依然非常庞大。用户可能非常不想完成这些表格。所以我们能做的就是把这个巨大的任务分解成一系列较小的任务。这会让人突然觉得好像会轻松很多的去完成这个任务。完成小的子任务会为用户提供一些内啡肽和满足感来继续下去。

设计表单时，请使用一列布局而不是多列。单列布局更容易填写。这样，用户无需考虑接下来要填写的内容，只需径直向下移动页面即可。

![](https://cdn-images-1.medium.com/max/4080/1*p_pu1I-ZpAn09sgtrqc8nA.jpeg)

### 12. 对流程进展和系统状态保持透明

不确定性会使我们感到焦虑，所以应当尽可能避免这种情况。这也就是为什么除非是显而易见的情况，在任何时候用户都应该能够了解到他目前在流程的什么位置，过去已经发生了什么以及他还需要去做什么。保存先前提供的信息摘要也是一个好办法，它让用户不用记忆太多东西并且也无需返回以仔细检查先前的步骤。

![](https://cdn-images-1.medium.com/max/4080/1*6vVsEhwGQHIgarwU--CpNw.jpeg)

### 13. 帮助用户做算术

人类的大脑不擅长进行原始计算。与算术运算相比，进化的压力更有利于优化大脑识别物体的能力。所以应当尝试利用系统来代替用户进行所有计算。

![](https://cdn-images-1.medium.com/max/4080/1*rfcPCcf1nDCWbmsTk04g_w.jpeg)

### 14. 通过渐进式的展现来隐藏复杂

渐进式的披露是用户体验设计中的一个设计模式，用来更好的将用户界面对用户进行解释。它通过跨多个屏幕对信息和操作进行排序以免使用户不知所措或隐藏无关信息，直至信息变得相关。渐进式披露遵循从“抽象到具体”的典型概念，包括用户行为或人机交互的顺序。渐进式披露的一个很好的例子是iOS嵌套导航。

![](https://cdn-images-1.medium.com/max/4080/1*IzCm0KYUujM3M2JXrrA8Ng.jpeg)

### 15. 基于普遍接受的模式和互动方式

用户的大部分时间其实是花费在其他产品上。这就意味着用户更希望你的网站交互方式能够跟其他他们用过的网站差不多，所以这也就让他们对产品的外观和行为有着特定的期望。这种说法反应了消费者的心态，并且适用于从社交网络到冰箱的任何虚拟或现实产品。但这并不意味着你应该停止创新，但应该更谨慎的评估怎么去更改传统意义上的导航或者控制，向用户证明改变他们的心理模型是正确的。

![](https://cdn-images-1.medium.com/max/4080/1*ZxMxsNcdwI3sAq5MAswpuw.jpeg)

### 16. 让初次体验变得简单

任何设计的主要目标都应该是尽快将用户与提供的价值产品联系起来。好好考虑下这一点吧。因此，用户和操作系统之间存在的其他东西除非是功能需要，否则都是障碍。在任何过程的首次体验都是非常重要的，如果不满意的话，人们会很快地对产品形成看法并立刻离开。

在你初次尝试的时候，即使是简单的任务也很具有挑战性。在我们操作产品之前，有时需要额外的培训。在数字产品的设计中我建议不要太关注手动操作，用户期望产品应该是简单易懂的，并且只有在出现问题或者他们需要时才提供帮助。而且应该是基于上下文的情形提供帮助，而不是通过过多的学习资料给用户传授空洞的概念。

![](https://cdn-images-1.medium.com/max/4080/1*zFovfmPuRSfy97sKEqFTzg.jpeg)

### 17. 考虑人体工程学和使用产品的环境

我们已经定义的简单就是使用产品的难易程度，这也就是基于人体工程学。人体工程学是设计或安排工作场所，产品和系统的过程，以便适合人们的操作。大多数人认为这与座椅或汽车控制装置和仪器的设计有关 — 但是不仅仅如此。人体工程学适用于涉及人的任何设计，包括数字产品。
在 1954 年，心理学家保罗菲茨测试人体运动系统，表明移动到目标所需的时间取决于与目标的距离，并与其大小成反比。所以请保证较大的常用元素放在尽可能靠近用户的位置。

![](https://cdn-images-1.medium.com/max/4080/1*54_6Zfey3wd3VKN1vIUawg.jpeg)

### 18. 支持行内编辑和自动提示

移除每一个过程中不必要的交互、视图和步骤。用户应该以最佳速度操作系统，这被称为“流畅”。不要用弹出窗口打破这种流程。对于以后所有支持更改的操作或值，请尽可能的支持行内编辑。当有大量可用的值时可以进行自动提示。

![](https://cdn-images-1.medium.com/max/4080/1*k175kgaxJIPS9PzlbI5SKw.jpeg)

### 19. 通过智能设置默认值来减少认知上的负担

智能设置就是将选项的答案默认进行选择。这能帮助用户尽快的完成表单。填写表单需要用户去解析表单，编辑答案，然后将他们的结果输入到表格提供的位置上。而定义相关默认值时，设计人员需要了解用户以及他们将使用产品的上下文。只有通过深入研究和测试，才有可能理解用户并根据用户的历史数据和使用模式调整默认值。当需要明确选择时，始终将绝大多数用户（例如，90 - 95％）会选择的选项设置为默认值。

![](https://cdn-images-1.medium.com/max/4080/1*dh-NbWdErhYIt4neyb1xWw.jpeg)

### 20. 减少错误提示

错误信息会带来很多压力，并让用户觉得他搞砸了或者没有完成任务。所以请确保自动检查输入的数据，并为异常的输入提供警报或提醒以减少错误。要么消除容易出错的情况，要么检查它们并在用户提交操作之前向用户再次进行确认。并且应该通过强制功能来保护破坏性和不可恢复的行为，以确保用户意识到他们的选择将产生的影响。

![](https://cdn-images-1.medium.com/max/4080/1*fgjZ21IDG2wp9Z_0cgUBHw.jpeg)

### 21. 可访问性设计

作为设计师，您的目标是支持可访问性，确保你的产品能被广泛的受众使用，而没有特例。全世界有超过 10 亿人患有残疾。所以不要使用颜色作为传达信息的唯一视觉手段。还可以确保文本与其背景之间有足够的对比度，支持键盘导航等等。可访问性不仅仅针对于具有不同能力的一组用户，当你设计可访问性时，您应该改善使用该产品的每个人的体验。

![](https://cdn-images-1.medium.com/max/4080/1*P93k8CP68naqhhPB4SGzPQ.jpeg)

### 总结

设计简单好用并且易于理解的产品并不容易，但这是我们需要做的事，并且有这些窍门能帮我们走向简单。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。

