> * 原文地址：[How to Save UI Designers & Front-End Developers up to 50% of Their Time](https://uxplanet.org/how-to-save-ui-designers-front-end-developers-up-to-50-of-their-time-39a30254ec05)
> * 原文作者：[Henry Latham](https://uxplanet.org/@LathamHenry)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-save-ui-designers-front-end-developers-up-to-50-of-their-time.md](https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-save-ui-designers-front-end-developers-up-to-50-of-their-time.md)
> * 译者：[meterscao](https://twitter.com/meterscao)
> * 校对者：[rockyzhengwu](https://github.com/rockyzhengwu), [Park-ma](https://github.com/Park-ma)

# 如何提升设计到开发的协作效率

## 为什么一月会有圣诞节

**提示：这篇文章有很多有趣和无趣的表情包，也有很多大图。除非你不在乎流量费用，建议最好还是先连上 Wi-Fi 。而且这篇文章真的非常长，你还可以准备一桶爆米花和可乐（笑）。**

### 一月的圣诞节？

当你还是个小孩的时候，圣诞节真的真的非常令人兴奋。一想到圣诞老人带来的礼物，以及打开礼物时的场景，让整个月都充满了难以想象的兴奋和喜悦。

![](https://media.giphy.com/media/l1AvyLF0Sdg6wSZZS/giphy.gif)

在我作为UI设计师的生涯里，当我第一次使用 Sketch App 时，我也像个孩子一样的兴奋：

> “你是认真的吗？！在过去的 3 个月里，我可能已经在 Photoshop 那些愚蠢的小像素图形中浪费了 90％ 的时间，它们甚至看起来都不是我想要的样子。为什么之前没有人告诉我有这个 App ？！太难以置信了。”

作为一名设计师，我的职业生涯中只有两个阶段：Sketch 之前的生活（BS）和 Sketch 之后生活（AS）。

我不想说 Sketch 之前的生活，简直糟糕透了。所有的东西看起来都……有些不一样，有些怪，呃……有点像素化。设计一个标题就差不多要花掉一个星期的时间，更不用说设计一个完整的页面了。

有了 Sektch 之后的生活简直不要太爽。我敢说你甚至可以跟一帮小朋友组建一个设计团队。

你可以重复使用各种元素。它们都是精美的，矢量化的，有条理的，并且非常简洁和直观。

好吧，如果你是产品经理，设计师或前端工程师，现在你也会孩子一样地兴奋。

可能现在是一月初，但我感觉就像圣诞节一样。**欢迎来到对象驱动设计的世界。**

**作者注：当我在耶路撒冷和约旦河西岸写这篇文章的时候，看到一些圣诞树还摆在上面......从那时起就注意到一些东正教基督教日历中圣诞节实际上是在 1 月的。然后发现我的标题有点荒谬和吸睛......**

![[免费下载这个 UI 工具包](http://eepurl.com/dhWTbP)](https://cdn-images-1.medium.com/max/2000/1*Nb36bdEIFdzIPcrk3Zlc3w.jpeg)

在这篇内容丰富且充满乐趣的文章中，我将解释：

1.  什么是对象驱动的设计
2.  为什么这些问题仍然没有解决
3.  为什么不使用面向对象的设计会有很大的风险
4.  如何在设计流程中采用面向对象的设计

通过我的方法，让 UI 设计师可以花更多的时间做快乐的设计，让前端开发能集中精力开发功能，而不是在那里一个像素一个像素地调间距。设计到开发的流程（我简称为 “D2D”）效率将真正提高十倍。

![你一定会大吃一惊](https://media.giphy.com/media/q4sdF9tchap6E/giphy.gif "你一定会大吃一惊")

## 你为什么要关心这个？

许多产品经理和UI设计师读到这里都会想，

**“我已经用了 3 年 Sketch 的 Symbols 和 Typography  功能，说一些我不知道的东西吧，然后停止你那愚蠢的圣诞节比喻。”**

他们并没有错。我猜想大多数设计师**一定程度上**都会在 Sketch 文件里创建可重用的 Symbols（类似于编程术语中的“对象”）。

**但是，在过去的两年中，和我合作的设计师里从来没有人能找到一种全面的方式，来改善 D2D 交付过程中的低效问题。**

## 这个问题存在的 3 个原因

在深入研究 D2D 问题之前，首先要说明白：既然已经有这么多的设计工具了，为什么仍然存在 D2D 效率低下的问题。

### 1. 平庸的标准

不幸的是，许多读者会自信地认为，这不是他们或他们的公司会遇到的问题。

因为生产力和效率是相对的。很少有 UI 设计师和产品经理能意识到：可能会存在一个比现在更好的设计流程。

我们倾向于以我们周围的其他创业公司和 UI 设计师为标准。如果每个人都以相同的方式工作，那么它可能就是最有效的，对不对？

不对。

我们有一种最常见的偏见，会基于我们的认知对这个世界上的事物产生刻板的印象，就像我们现在说的“效率”。

![](https://cdn-images-1.medium.com/max/1600/1*vBBSJ4W5Y4NxOAtlLP2qPQ.jpeg)

举个例子：

**假如我有些超重，但我所有的朋友都很胖。当我周围的人都比我胖的时候，我很可能会认为自己是一个健康的人，因为我的参考点（我肥胖的朋友们）比我更糟糕。**

**然而，仅仅因为他们不如我健康，并不一定意味着我就是健康的。我的体重依旧超重。**

因此，为了实现效率的明显**飞跃**，就得去打破平庸的标准，并且不断尝试创新。

> “如果我问人们想要什么，他们会说更快的马。”
> **—— 亨利·福特**

### 2. 盲目相信现有的流程

D2D 效率低下一直存在的一个原因是，我们总是假设我们在公司使用的这些流程和方法都已经是最优的。

但是事实并非如此。

首先，不管是否真的遵循敏捷开发的思想，效率低下的问题总会存在。特别有些是你甚至都可能意识不到的问题。

其次，你一定能意识到，由于缺乏统一的合作和竞争体系，项目一开始就会立即进入“互相抢占资源，而非高效合作”的局面，正如 LeanUX 的作者 Jeff Gothelf 所描述的那样。

这样的场景往往意味着设计师资源变得紧缺，通常在少数产品经理和大量程序员之间共享。设计师对应多个产品和开发，这导致他们之间的合作也可能会变得混乱和无序。因此，UI 设计师很少能够停下来，尝试做一些系统化的设计方案，使其具有更高的灵活性。

只有遵循对象驱动的设计流程，才能实现真正意义上的速度和敏捷。

![产品开发周期的（夸大的）现实](https://media.giphy.com/media/HUkOv6BNWc1HO/giphy.gif "产品开发周期的（夸大的）现实")

### 3. 设计师和程序员是完全不同的人

在我们美好的想象中，设计师每周都能进行设计评审和回顾，无所不能的产品经理也能高效地与每个人沟通和配合。没错，对于检验**做没做**很容易，但是对于**怎么做**就很难。

这可以归结为：UI设计师和前端工程师之间的根本误解，或者说是专业鸿沟。

![典型的 UI 设计师形象：精心修剪的胡须，新颖时尚的装扮](https://cdn-images-1.medium.com/max/1600/1*4sv72hGSswh5z5oUBLjQGA.jpeg "典型的 UI 设计师形象：精心修剪的胡须，新颖时尚的装扮")

**UI设计师**倾向于认为自己是艺术家，他们的作品是**艺术品**。**只要**用户能够理解他们作品中的美，他们的产品就能拥有**数百万**用户。

他们喜欢排版，并热衷于手工艺和手冲咖啡。他们最喜欢的颜色是 #FEB4B1。

![典型的程序员形象：毫不在乎的打扮，极其小众的兴趣爱好，比如 Magic The Gathering（译者注：一种集换式卡牌游戏。）](https://media.giphy.com/media/Pch8FiF08bc1G/giphy.gif "典型的程序员形象：毫不在乎的打扮，极其小众的兴趣爱好，比如 Magic The Gathering （译者注：一种集换式卡牌游戏。）")

**程序员**，他们只想创造很酷炫的东西，他们并不太关心它们看起来的样子和视觉表现。对他们来讲，“样式” 这个难以捉摸的概念是留给艺术家的，对他们来说就像“约会”一样陌生。他们并不能理解为什么红色的阴影是**更**红的，为什么标题文本应该往左边**一点点**。

当不被打扰地独自为一些复杂的新项目写代码的时候，才是他们最开心的时候。

---- 

**从本质上讲，他们是不同的人。** 不同的专业技能，不同的思考方式，不同的兴趣爱好。

他们每个人都认为彼此的专业领域都是令人难以置信的复杂和费解的。因此，他们不惜一切代价避免介入彼此的领域。

![程序员眼里设计师的工作](https://cdn-images-1.medium.com/max/1600/1*u3XoSRSQpivSn1gcCwsfxQ.jpeg "程序员眼里设计师的工作")

![设计师眼里程序员的工作](https://cdn-images-1.medium.com/max/1600/1*RZ5gOgjgtvslNcqYrZ78Hw.jpeg "设计师眼里程序员的工作")

也许两个群体都不知道，或者坦白地说不关心，现在UI设计师的视觉工作和前端工程师的工作已经有很多重合的部分。

基于此，如果这两个角色建立了一种明确的设计语言（也就是 Sketch 中的 Symbols）的话，那么 D2D 流程将会非常简单和快速。

但是，由于每个角色对彼此孤立的工作并不感兴趣，因此他们之间仍存在非常明显的知识差距，这是另一个导致团队 D2D 流程低效的原因。

因此，UI设计师和前端工程师使用统一的设计语言，对改善低效是非常有意义的：

> “产生良好结果的模式应该被推广，而那些造成问题的人应该得到纠正。”
> —— Jeff Gothelf，Lean UX 的作者

![React Native — 对象起的作用](https://cdn-images-1.medium.com/max/1600/1*CRotLNVwJOkvunucRFr9eg.png "React Native — 对象起的作用")

![Sketch — Symbol 起的作用](https://cdn-images-1.medium.com/max/1600/1*CtF2FIGBm9GuUWnDP-TS0g.png "Sketch — Symbol 起的作用")

## 4. 无法遵循对象驱动设计存在的问题

### 1. 设计系统的缺失会浪费设计师和程序员大量的时间

![简单的 UI 与复杂的 UI](https://cdn-images-1.medium.com/max/1600/1*VQlMEHrQOCI5LtgcZf4VuA.jpeg "简单的 UI 与复杂的 UI")

**UI 设计师**

理论上，D2D 交付流程应该是直接的。

理论上，UI 设计师已经与前端开发能达成一致，并且可以无缝地协作。

理论上，他们会事先约定好统一的设计语言，并且使用可重用的组件和元素。设计师在 Sketch 中复制粘贴一下，前端开发一两行代码就能搞定。

然而，理论却很少能转化为现实。

实际情况是，大多数 UI 设计师会花大量时间设计一些新的自定义元素。

首先，因为他们不是程序员，所以他们不明白实现这些新的设计元素需要额外做很多的工作。

其次，许多 UI 设计师认为他们的作品是艺术，而不是科学。因此他们并不情愿为了实用主义而牺牲作品的美感。

![成为 UI 设计师后发现竟然不能挣到钱，梦想破灭了。](https://media.giphy.com/media/l0GRkzJhkMlJotMFq/giphy.gif "成为 UI 设计师后发现竟然不能挣到钱，梦想破灭了。")

他们喜欢花费大量的时间对现有元素进行细微的调整，而不是把很容易实现的设计稿尽快交付给前端工程师。

他们花了太多的时间和精力在细节上（比如把文本移动几个像素）而不是项目重心上（比如设计和体验一个新的功能）。

细节是很重要，但是当已有的 UI 元素已经很好地满足需求和场景了，很难证明这些细节的调整真的会带来有效的提升。

UI 设计师过分关注细节导致项目进度减缓，这个事实也让问题变得更加显著。设计评审被推迟，产品经理的信息同步也不及时，设计师也只愿花更多的时间在他们各自的设计工作中。

**前端工程师**

当前端工程师拿到设计最终稿时，应当已经进行了几轮评审，以确保每个人都清楚最终的预期。

但是，我们仍然发现问题仍旧存在，因为：

1.  **前端工程师过分相信设计稿**。他们通常会认为最终实现的效果必须跟设计稿上**完全相同**，尽管有些设计稿实现起来很困难，但是他们将所有 UI 设计师都视为专家。因此，他们不会试图简化或讨论设计方案，他们相信一切背后都有一些合理的原因，UI 设计师的设计稿就是最终完美的方案。
2.  **前端工程师比其他人更讨厌会议**。因此，他们并不想为了纠结字体大小是 12px 还是 14px 进行冗长和无聊的辩论，**他们只是想尽快开完会，与设计师达成一致**，然后愉快地回去写代码。
3.  **前端工程师通常比较内向和腼腆**。因此，他们不太可能 PK 得过自信的产品经理和自负的 UI 设计师。

因此，尽管在前期有设计评审和讨论环节，他们最终还是去做了一些重复的、不合理的、或者实现起来很困难的东西。

![假装在认真评审的工程师们，实际上已经满脑子都是最喜欢的代码了](https://media.giphy.com/media/CU94B6y3UhjHO/giphy.gif "假装在认真评审的工程师们，实际上已经满脑子都是最喜欢的代码了")

### 2. 随着时间的推移，D2D 效率愈来愈低下

D2D 效率低下的时间越长，对现有和未来团队成员的资源浪费就越大。这道理看起来很明显，但通常总是被我们忽视。

我们常常更专注于短期目标（加班加点完成手头上堆积的事情），而不是着眼于长期的目标和最终的成功。

在实现短期的冲刺目标和完成大量项目功能的过程中，我们根本无暇去改善合作中的低效问题。

因为关注短期的目标很容易，因为大家都面临很大的压力，[因为我们很少会停下来思考我们如此忙碌的真正目的是什么](https://medium.com/punchintheface/the-art-of-being-busy-fdcf9b5a2d65)。

![随着时间的推移，最理想的效率和当前的效率](https://cdn-images-1.medium.com/max/1600/1*ax3hgfnBOf0XqFVV865J6w.png "随着时间的推移，最理想的效率和当前的效率")

### 3. 没有设计系统 = 设计缺陷

在设计流程中，UI 设计师的设计越不系统化，在后期的工作中将会面临更多的问题。

我们来举个例子：

假如所有的图标都没有统一的尺寸，有些是 24x24，有些是 40x24，有些是 12x16。这不仅会浪费程序员的时间（正如我在第一点所强调的那样），而且还意味着将来任何的变化都会变得非常麻烦。如果将来希望更改某些图标，就必须针对每一个图标每一个特定的尺寸进行重新设计和导出，否则这些图标在最终的展示时候要么错位，要么会被拉伸。

![所有的图标都使用统一的尺寸，对设计师和前端工程师来讲都是非常方便的](https://cdn-images-1.medium.com/max/2000/1*JojPssOu2NqC5VWmPS8lfw.png "所有的图标都使用统一的尺寸，对设计师和前端工程师来讲都是非常方便的")

此外，如果 UI 设计师在 Sketch 文件中，不创建严格的文本样式、取色板，以及可重复使用的 Symbols（比如所有按钮尺寸都是24x24）的话，就会严重阻碍我们编辑现有元素的效率。

假如想要对整个产品中的文本样式进行统一的调整，我们只能对 Sketch 中的每一个页面挨个进行手动的调整。但是如果使用了 Typography 的话，完全不用如此麻烦。对于一个拥有大量页面的完整 App 来说，这样的调整和更新会浪费UI设计师大量的时间。

### 4. 不建立设计系统会妨碍团队协作

如果没有设计系统，UI 设计师的大部分时间都会花在创建新的元素或者对现有的设计不断地修改上面。

这意味着他们没有更多的时间进行脑暴或者在 Sketch 里面与前端工程师一起尝试新的想法。

团队可以通过组织设计评审来测试不同的方案，或者调整正在讨论的设计，这非常有利于整个团队对设计的投入和支持。

> “持续相互反馈的团队将会创造更好的产品。”
> _—— Jim Semick，[InVision](https://www.invisionapp.com/blog/product-ux-team-collaboration/)_

此外，设计系统能避免了 UI 设计师为了相同的方案进行重复的设计评审和返工，这为整个团队节省了大量时间。

---- 

![在这里下载我的免费 UI 工具包：http://eepurl.com/dhWTbP](https://cdn-images-1.medium.com/max/2000/1*Nb36bdEIFdzIPcrk3Zlc3w.jpeg "在这里下载我的免费 UI 工具包：http://eepurl.com/dhWTbP")

## 如何实现对象驱动的设计

现在，希望你已经明白实施设计系统是多么的重要。

下一节中，在深入研究构建和维护设计系统的细节之前，我将讨论更改 UI 设计师的工作方法的重要性。

### 第1步：获得 D2D 流程的主导权

在承诺遵循对象驱动设计之前，必须确保 UI 设计师能得到适当的激励。

如果他们做这个的理由很含糊：“这能让团队更高效”、“我们只是被要求这么做”，如果是这样的话，那就算了吧。

但是，如果设计师打心底认可 D2D 交付流程是他们的角色和责任中很关键的部分，那么他们不仅更有动力和积极性去构建一个设计系统，而且会长期地维护和完善它。

让我强调一下：**建立设计系统不仅仅只是个一次性的任务。每当你开始新的设计或验证方案时，你都应该把他们准确地组织在你的设计系统中，这样可以供将来使用。**

UI 设计师必须是完全认可他们应该为 D2D 流程负责任。否则，他们对于如何用编程的方式实现设计从而改进设计流程的过程，也不会特别的好奇和投入。

他们需要阅读一些关于设计和开发流程的文章，参加基础编程的课程，学习 Material Design 指南，了解前端工程师的工作，向产品经理、前端工程师或者其他设计师学习，等等。

**总之，他们要跳出舒适区，不能为了只专注于他们喜欢的和感到舒适的东西而放弃那些更重要的学习，不能最后又回到了 Sketch 和 Dribble 上来。**

### 第2步：构建设计系统

构建设计系统的核心目的，是基于面向对象的编程思想创建一个完整的元素列表。期望的结果是通过你在 Sketch 中创建的设计系统，让设计师和程序员能够更加紧密的合作，从而让整个团队也运作得更加的高效。

设计师和程序员之间互相的沟通会带来更加深彼此的理解，也会让整个团队创造出更优秀的产品。

![](https://cdn-images-1.medium.com/max/2000/1*4iHUG2t0eN-ohh9v5UbH4A.jpeg)

**1/7 从基础开始：颜色和文本样式**

对象驱动的设计必须从基础开始：定义颜色和文本样式。因为所有其他的元素都需要这些信息：比如，一个按钮需要明确背景颜色、边框颜色；一行文本需要明确字体、字号和行高。

![为单个页面创建独立控件](https://cdn-images-1.medium.com/max/2000/1*eOnRXOD1lBOwvgTqNrJE0g.png "为单个页面创建独立控件")

**2/7 为单个页面创建独立控件**

通过创建一个示例页面，你就很快能理解对象驱动设计的原理，并指导怎样在实际的工作中运用。根据我的经验，只有不断以迭代的方式来**践行**对象驱动的设计理论，才能真正有效地学习如何创建一个完整的设计系统。

在开始尝试的时候，不要担心不全面。因为当你创建过一些示例页面之后，你很快就能明白怎么合理地创建这些元素。

可以从标题栏（带有文本和按钮的那种标题栏）、或者文本段落开始，也可以用其他任何你想尝试的控件。请记住，从最小的元素起，就要开始保证设计的一致性。

**元素指的是一组 Symbols ，比如一个标题栏或者一个段落文本**

* YouTube 视频链接：https://youtu.be/5MGNi24hHAE （已经打不开了）

**3/7 Override（更改元素的信息）**

在 Sketch 中如果选中一个 Symbol，在右侧的面板（在 “Override” 中）就能看到这个对象包含的那些可以被修改的信息，比如标题栏中包含的文本。

但需要注意的是，这样的修改并不会改动到 Symbol 本身的样式。因为这个本质上很像前端的工作方式：

你定义展示给用户的界面（比如，字号、排版、对齐方式等），但是最终填充的内容（比如名称、地址、图标等等）是从数据库中拉取来的。

比如，你可以定一个图片按钮的位置、大小，但是实际展示的图片是存放在 CDN 中。

![](https://cdn-images-1.medium.com/max/2000/1*sjN8qeLawj0NKzrQKrNfXA.png)

**4/7 创建一组示例页面**

现在你已经看到了 Overrides 的强大功能，你知道需要创建哪些类型的 Symbols，以及 Symbols 之间是怎么关联和组合起来的（例如标题栏中的按钮）。

希望你也意识到这个过程需要多么周密的规划和组织了。你可能已经自己定义了一些 Typography ，但我怀疑只是在为左对齐，中对齐还是右对齐创建了一个变体。

现在尝试创建 4-5 个页面，并且所有的页面都只能基于先前定义的 Symbols 来创建。不要担心它们是不是缺少组织或者搭建起来很不方便：意识到这些问题，并从中学习和思考，本质上也是学习的一个过程。

![信息架构：逻辑清晰地组织你的 Symbols](https://cdn-images-1.medium.com/max/2000/1*9LAZ3Zd3znKMWmmPipqImA.png "信息架构：逻辑清晰地组织你的 Symbols")

**5/7 为 Symbols 准确地命名**

现在，你应该对如何创建一个完整的设计系统有了清晰的理解。

但是在深入研究完整的设计系统之前，我建议花一些时间了解下信息架构。

信息架构本质上是指用最符合逻辑最优的方式来组织信息。

在有设计系统的情况下，所有的对象都处在清晰的层次结构里，并且都有符合逻辑的命名，常用的元素也非常便于使用。

搭建一个全面的设计系统前，首先要确保你已经熟悉整个产品，明确所有你需要创建的 Symbols ，并且明白如何才能找到最佳的方式来组织它们。哪些元素是最常用的？其他设计师怎么能找到这些 Symbols？他们会期望每个 Symbol 应该怎样命名？

如果不能做到以上所说的点，将来在 Symbols 的查找和重命名上就会耗费大量的时间，而且也无法用一种逻辑清晰的方式来添加新的 Symbols。

![一个全面的设计系统](https://cdn-images-1.medium.com/max/2000/1*mbfLtwW8TkOGxM12LGY6WQ.png "一个全面的设计系统")

**6/7 创建全面的设计系统**

现在你已经创建了一些 Symbols ，很明确你的产品需要哪些 Symbols，并且有一套清晰的命名体系，所以现在是时候来完成整个设计系统了。

为了保证设计系统的结构清晰，你需要留出专门的时间来完成它，并且全身心投入其中。

当你在完成的过程中，可能会发现一些命名上的错误和缺陷。因此，请随时检查你的命名规则，创建一些用于测试的页面并且验证一致性。

因为你的产品是独一无二的，因此你需要创建的这些 Symobls 也是独一无二的。所以，你必须去思考如何最好地架构这个设计系统，以及这个系统究竟需要包含哪些内容。

**7/7 设计评审**

与产品经理，UX/UI 设计师，还有前端工程师一起组织设计评审，来展示新的设计系统。

你会发现团队的所有成员都会立即意识到它的价值。前端工程师很高兴，因为他们有一个明确的交付文件可供参考和使用；产品经理也很高兴，因为他们可以与设计师快速地搭建产品原型；其他的设计师也很高兴，因为他们都可以在 Sketch 内的同一设计系统中协同工作了。

当你将你的设计系统保存到 Sketch 中的 “Template”，并与其他 UI 设计师共享后，你们就可以开瓶酒好好庆祝下了。

![疯狂地庆祝...](https://media.giphy.com/media/mp1JYId8n0t3y/giphy.gif "疯狂地庆祝...")

### 第3步：维护你的设计系统

当你完成设计系统后，你还需要维持它继续向前迭代。

任何新的设计元素，不管是否会在最终的产品中体现出来，都应该将它们正确地归类和组织为 Symbols。

很可能你的工作非常的繁忙，项目的节奏也非常快，你不太可能会有机会重新将最终的设计稿再一点一点地重构成结构清晰命名规范的 Symbols。与其在将来浪费更多的时间，不如在一开始就用最优的方式来设计。

**无论你有多忙都请记住：磨刀不误砍柴工。**

另外，如果你的团队中还有其他的设计师的话，你们都需要为设计系统的发展作出贡献。

团队中的每个成员都必须遵循设计规范。还应该有专门的设计师来负责将新的 Symbols 添加到产品的 “Library” 中，以确保所有的人都能访问到已有的和新增的 Symbols。

这个设计师还应定期更新主干上的文件，以便所有团队成员都可以访问到最新版本，避免因未保存文件而浪费任何时间。我建议使用 Github 或 [Sketch Cloud](https://sketch.cloud/) ，你还可以使用付费版的 [Abstract](https://www.goabstract.com)，用一种更直观、对设计师更友好的方式来管理文件的版本。

如果你们仅仅是一个很小的团队，似乎就不太需要这样的组织方式。但是在某些时候，你可能需要提前慎重思考：如果没有最新的设计系统，新的 UI 设计师怎样知道从什么地方开始工作？你们怎么互相协作？

### 第 4 步： 创新永无止境

正如我在步骤 1 中所说的，这个过程的核心要素是承担责任。坚持期望很容易，承担责任却很艰难。

但是，这对成功至关重要。

您必须保持警惕，不断学习，不断寻找新工具来提高技能并改善你的工作流程。

[Sketch App](http://sketchapp.com) 正在不断改进，Sketch 社区也不断出现很酷的[新插件](https://www.sketchappsources.com)。同时其他的设计工具也正在出现，比如 [Adobe XD](http://www.adobe.com/il_en/products/xd.html)，你可以关注这些软件并且尝试一下。

[顶级公司将 5-15％ 的收入用于培训员工](https://www.amazon.com/Oversubscribed-How-People-Lining-Business/dp/0857086197)，如果你是设计师，坚持每周花些时间了解新的技术，体验新的产品。

**永远记住：投资自身不断学习，并且着眼于公司的长远目标才是成功的关键，而不是眼前那些看起来很紧急或者很重要的事情。**

---- 

![作者在葡萄牙波尔图共同拥有的一个弹出式酒吧里](https://cdn-images-1.medium.com/max/2000/1*FCYtMc3I98p3WaBaCQ6qMw.jpeg "作者在葡萄牙波尔图共同拥有的一个弹出式酒吧里")

## 关于作者：

**Henry Latham 是一名位于柏林的自由职业 UX / UI设计师，正在寻找潜在的联合创始人。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
