> * 原文地址：[How to gain widespread adoption of your design system](https://medium.com/hubspot-product/how-to-gain-widespread-adoption-of-your-design-system-29d1b142b158)
> * 原文作者：[Julie Nergararian](https://medium.com/@julienerg?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-gain-widespread-adoption-of-your-design-system.md](https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-gain-widespread-adoption-of-your-design-system.md)
> * 译者：[Ryden Sun](https://juejin.im/user/585b9407da2f6000657a5c0c)
> * 校对者：[Moonliujk](https://github.com/Moonliujk)

# 如何让你的设计系统被广泛采用

## 使用文档系统培养设计和开发的共同所有权

**这篇文章是关于 [_HubSpot Canvas_](https://canvas.hubspot.com/)，我们新的设计语言系列的第二篇。点击[这里](https://github.com/xitu/gold-miner/blob/master/TODO1/how-building-a-design-system-empowers-your-team-to-focus-on-people-not-pixels.md)阅读第一篇文章。**

![](https://cdn-images-1.medium.com/max/1000/1*wCQVZ3pzhC6wPZEVa54r8A.png)

在活动进行时，我是作为一个带薪实习的软件工程师来到 HubSpot 的。设计团队在过去几个月时间里，创造了一套华丽的文字设计，颜色和基本组件组合，这套组合是我们在重设计整个平台主要部分的奠基石。

但因为之前这里并没有任何一个设计风格指导 —— 没有单一数据源 —— 那意味着，现实中，我们需要完全重写我们产品的前端。它意味着，我们需要分解超过 40 个团队的工作产出并且完全使用一套新的组件来重建几百个页面，以此实现新的设计。

我加入了 HubSpot 的前端基础架构组，这个团队负责搭建我们整个内部构造系统，并且为 HubSpot 开发者们提供从测试到第三方依赖的全部服务支持。他们自然成了这次重设计的先锋，因此 5 个开发者，包括我自己，被分配去帮助每一个团队升级我们新的设计系统，HubSpot Canvas。当我得知我的任务时，第一想法就是：**史上最好的工作**，后面跟着：**哇，这工作量就恐怖了。**

确实，它确实有很大的工作量。但是如果我们不能从中体会到重要启示的话，那就会有**更多**的工作需要做。 

> 重新的设计只有在设计师和开发者达成共识时才会有效。

我们培养这种共识，在很大程度上，是通过构建良好的工具和文档。我们的文档作为团队中每一个人的单一数据源，同时我们的开发者和设计师使用工具来互相呼应，让每一个人都能使用同一种语言，并且让他们参与到设计系统的管理中来。

这张图描绘了文档是如何在帮助我们实现大量的重设计的同时，还让我们作为一个团队变得更好。

![](https://cdn-images-1.medium.com/max/1000/1*CD9fkMcNzSmnqzfyRO1syw.png)

### 不利因素与有利因素

任何大型项目，都会有利于你的因素在起作用（tailwinds），也会有不利于你的因素在起作用（headwinds）。对我们来说，它们是：

### 有利因素

**我们整个的产品是构建在一个颇为相似的技术栈上。** JavaScript 的生态系统会在转眼之间改变，因此我从来没有期望任何一家像 HubSpot 这样体量的公司会永远处于同一个技术栈上。但在内部，由开发者推动的趋于 React 的趋势，它远离主干，已经获得大范围成功。这意味着，团队们可以重新设计他们的 app，而不需要迁移到其他的技术栈，并且我的团队也可以相对轻松地维护它们之间的一致性。

**我们已经有一个可复用的组件库和相对应的文档工具。** 随着团队开始向 React 迁移，我们其中的一个工程师迅速搭建了一个可复用的 React 组件库，这个组件库易于维护，示例代码可以直接编辑，这意味着我们不需要从头开始写文档。

### 不利因素

**和我们的 app 不同，我们的组件库没有一个完善的 QA 流程。** 我来自一家金融软件公司，在他们真正引入 QA 之前，我可能第一个周就问了我技术老大五遍 QA 工程师在哪里。我们现在不仅处在自己做自己的质量保证阶段，而且我们做的每一个改动都会影响后续的构建版本 —— 并且因为我们的团队一天要部署超过 1000 次，这表明任何的改动都会迅速被扩散到每一个 app 上。 

我们需要前端基础架构组和产品团队协调工作，来确保，我们每一次启动时，每一个屏幕都是准备好了的，同时要注意非主观意识造成的 bug。但是随着我们迅速的发展，可以轻易恢复任何不好的改动，我们可以将损失最小化。

**HubSpot 的产品是由多个小型，自治化的团队组成的。** HubSpot 的团队对产品每一个部分都有完整的所有权，有权利自由地调查，迭代和寻找解决方案。我们也曾担心过，对于这些有高度自治化文化和历史的团队，为开发一个新的设计系统来最终让他们保持一致，是很棘手的。

在转变过程中，他们需要完全停止新功能的开发，并且我们也会开发一些流程和标准，整个团队接下来都必须严格遵守这些流程和标准。在使用一套新系统来帮助你的同事和拿走他们的创造力之间达到一个微妙的平衡。但我们也相信，通过移除掉那些低级的，重复性的问题，我们可以解放我们的同事让他们把更多的创造精力放到解决更大的问题上来。

我们所担心的事情大多数没有发生。团队们也为一个系统级的重设计做好了准备，因为：

1.  没有人需要改变他们的技术栈或者商业逻辑。
2.  不一致性正在拖我们后腿。产品经理们在用户反馈中看到了这点。设计师在产品无数的阴影中看到了这点。开发者们在**太多**的日期选择器库中看到了这点。一个由其他团队打造和维护的可靠的，可复用的组件库，看起来像是一个不错做解决方案。
3.  我们的新设计体系，HubSpot Canvas，看起来不错。看起来，[相当不错](https://medium.com/hubspot-product/people-over-pixels-b962c359a14d)。

### 从项目到流程

当别的公司在做大的重设计时，他们经常上来就吹嘘自己，就像汽车发布新款时 —— 昨天你有的是一个旧的，但今天你会拥有一个全新的。

> 这对我们来说是没有用的。

我们的产品和产品团队太繁杂，以至于没法一次性做完。比起一个一个地处理产品的不同部分，我们决定从那些不怎么有用户使用的产品开始，循序渐进地发展到软件的核心部分。这个流程会**极大**地减少破坏性，意味着在新的设计系统广泛使用之前，我们可以对它不断进行优化。

我们想快速进行，因此我们制定了一些规则。我们强调第一个版本将只是一个简单的视觉刷新 —— 没有新的功能。我们想要重新粉刷我们的房子，而不是额外建造一个。如果团队们在重构产品时不断添加新的功能，我们将会无限地拖延时间线。

![](https://cdn-images-1.medium.com/max/1000/1*7oIds6pKssXqqh0iWfqgMQ.png)

我们将每一个设计团队的初始工作产出作为指导，将少数已存在的组件转变成基础性的一组可响应的，易用的，浏览器兼容的 React 组件。为了尽快完成工作，我们在不同团队的 app 内部工作，将组件替换掉。

但是。

这并不快。我们团队只有 5 个工程师，并且是基于不熟悉的代码进行工作，因此我们进行得很慢。更糟糕的是，因为**我们**是开发设计系统的，app 团队并没有机会掌控整个设计语言，留给了他们一个部分代码他们了解，部分完全不了解的 app。我们意识到，这个重设计需要从亲自动手的项目，转变为一个真正的**流程**，所有的团队都可以自己解决。

我们促进这个流程的发展是从提供技术支持和搭建并维护组件库开始的。我们和设计团队协作，让每一个产品设计者重设计他们所负责的产品模块，使用一个包含我们所有设计系统组件元素的 [Sketch kit](https://medium.com/hubspot-product/people-over-pixels-b962c359a14d)。随后我们进行了一次组件回顾讨论，因为每一个团队已经开始了他们负责的重设计，所以我们通过这次回顾讨论来探索潜在的新组件，新的变化或者已存在组件的新的功能性。

然后，我们的团队在 GitHub 上创建 issue，这样在搭建组件的过程中，我们可以持续地在开发与设计间进行协作，并且每一个团队都可以追踪他们需要的组件的搭建过程。我们与每一个 app 的时间进度交错安排，这样我们可以保证我们团队的待办任务不会拖慢别的团队的重设计进度。

它平稳运行了一段时间。随着各团队完成了他们的重设计，他们又重新返回了新功能的开发，但他们的 app 完全由闪闪发光的全新组件组成。

但有些时候，团队们并不知道如何来以及何时来正确地使用组件，亦或是一个组件的表现是否符合意向的。随着他们把问题提给我们，我们被咨询和说明的请求狂轰滥炸。我们越来越背离最初的想法，我们原本想尝试提供支持给那些已经完成的团队，然后我们也支持了那些正在进行重设计的团队。

解决方案比较明确，但是并不简单。

#### 我们需要更好的文档系统。

* * *

### 创建一个套生动的风格指南

良好的文档系统是一桩很好的买卖。你花费的每一秒，写的每一行字，都会在未来节省你无数的时间 —— 时间花费，比如你正在尝试记住一个超有创意的东西，突然你要停下来去给你同事找一个链接来解释组件相关的东西，比如，提示框和弹出框的区别。你应该把这些时间放在**新的**问题上，而不是已经被讨论过，解决过并且确定好的问题上。

我们知道我们希望我们的文档系统是这样的：

*   **易于探索的。** 我们并不希望任何人花时间来创建一个已存在的组件或是其变种，亦或是需要询问管理者这个组件在哪里。
*   **相关并且有用的。** 它应该是设计系统中的决定性资源，每一个人都应该有信心在上面找到他们想找的问题。
*   **自我维护和自动化的。** 因此没有东西会过时。

### 埋下种子

为了让我们的文档系统正确的发展，我们决定像为客户搭建产品一样搭建它。我们从采访各种产品团队中的人开始，他们包括设计师和开发者，有已在 HubSpot 工作多年的，也有到刚加入的。我们进行了一个卡片排列练习，我们将已有组件的屏幕截图打印出来，要求 HubSpot 的成员来对他们命名，然后他们这些组件分类并且给分类命名。

![](https://cdn-images-1.medium.com/max/800/1*ZihMIjp4j6ERZkSTVJ4EWw.jpeg)

令人惊讶的是，我们发现开发者和设计师对于我们的组件所使用的语言存在巨大的差异。开发者们经常会引用其他前端库（比如 [jQuery](https://jquery.com/) 和 [Bootstrap](https://getbootstrap.com/)）中的对象名称。设计师们常引用 Google [Material Design System](http://www.material-ui.com/) 中同类型组件的名称。我们发现人们会使用相同的词语来描绘两个极其不同的组件，亦或是不同的名字来描绘同一个组件。

![](https://cdn-images-1.medium.com/max/1000/1*iMdDJWb8GJ0a9jBmhS01NQ.png)

没有失败，每一个设计师或开发者都不希望因为其设计方案中的用户体验（设计师的原型）和实际的用户体验（开发者开发的产品）产生的不同而被否定。并且他们知道，确定这些东西并不仅仅是设计或者开发的责任 —— 这是每一个人的责任。

![](https://cdn-images-1.medium.com/max/1000/1*ak_ooSUtwtfOnEzIkrolRQ.png)

相对于构建另一个组件库，专注于开发者，我们意识到我们需要搭建一个资源，它适用于团队中的每一个人。这一套文档系统和工具会在设计师和开发者之间，对设计系统建立一个共享的所有权。

我们从重命名一小部分组件开始，对一些组件添加一些标签，以便于更好的发现和搜索，并且在组件设计之初就询问一些推荐的名字，这样设计师和开发者可以共同地决定一个合适的名字。同时我们根据组件的相似性将它们分组 —— 目前，举个例子，所有提醒和消息的组件已经可以在同一个页面中找到了。

为了让设计师们可以无缝地在 Sketch 和组件文档系统中切换，我们决定在 Sketch kit 和 UI 库中使用同样的导航，结构和术语，并且同时开发了一个系统，来保持 Sketch kit 和 UI 库同步更新。

### 完全绽放

随着基础工作完成，我们随后通过将调研中的理解的剩余部分应用于实际，让设计师和开发者每天的工作变得更简单并且更有效率。

由于开发者们提到他们经常会在寻找匹配设计师原型的 React 组件时遇到问题，因此我们添加了一层可见的搜索视图，提供了真实的，全自动生成的屏幕截图，让他们更容易找到他们想要的。他们也需要一个地方来看到每个组件包含的所有选项，还有一个地方他们可以找到组件的 API 信息，因此我们把它们展示出来并放到组件描述的中心位置。

![](https://cdn-images-1.medium.com/max/800/0*g_pMS8mB5qVbV7Cs.png)

开发者们也需要一个沙盒来快速测试组件，因此我们提升了组件库中组件的实时编辑的体验，让每一个规划中的组件都包含一个 React 代码编辑器（用语法高亮和 [Prettier](https://prettier.io/) 的功能完成）。我们将它变得更简单，把所有的例子都移动到一个免受干扰的编辑器，它会即时的渲染组件，这样开发者们可以使用它来构建设计的初始版本或者来测试一组特殊的组件组合。接着，他们可以轻易地与其他同事分享它，让他们迅速的迭代，调试，并且便于分享想法和提出解决方案。

设计师们需要一个地方来引用和分享资源，因此我们为我们的颜色，文字设计，插画，图标和产品复制指南创建了浏览页面，和一个可以下载最新版本的 Sketch kit 的链接。我们也将全部的设计流程文档化处理，放到了 UI 库，帮助新的设计师能跟上进度。

无论设计师或者开发者都一直清楚，哪一个组件允许用户完成一项特定的交互模式（例如复制一条连接或者在随着流程一步一步操作前进），我们也创建了模式的页面来解释哪一个组件应该在常见的用户场景中使用。

我们想让更多的开发者参与到设计语言中，所以我们将如何创建组件的指南分享出来，并且在基础组件上开始构建，将它们和我们最喜欢的开源框架结合。这给尝试 OSS 社区中的新工具提供了自由，给我们的技术栈添加了更多功能性和生产力，并且，诚实来说，让 HubSpot 所有希望创造的开发者去创造。因为我们最初目标就是让我们的组件作为所有前端 app 的**视觉基础**，这给在他们上层添加额外的图层留下了很多空间（或者需求）。这给我们的开发者对于一致性的尝试做了选择。

![](https://cdn-images-1.medium.com/max/800/1*T84-hO6EzGz_PXzkCyMRPw.png)

为了鼓励大家日常和文档系统有所交互，我们增加了一些按钮，点击按钮可以建议添加一个新的组件、对一个已存在的组件做出修改、报告一个 bug，或者是请求一个插图，这些按钮就存在于组件库的内部。这些按钮会提前创建好 GitHub issues，包含必要的标签和相关的问题，这样流程中所有的问题都会排好队。对于新来的设计师和开发者，在到来的第一天就提供给他们一个如何使用我们整个的 HubSpot Canvas 生态系统的统一参考源。

![](https://cdn-images-1.medium.com/max/1000/1*H81q1SJECA9bglCiOKte6Q.png)

### 效果

现在，设计师和开发者对于我们的设计系统都共同分享一个单一数据源，而且彼此的理解也加深了。对于文档系统的信任得到加强，也意味着整个设计系统有了更强的信任度。我在几个星期之前看到我们其中一个前端技术负责人发了这个 tweet，这让我感到很骄傲：

![](https://i.loli.net/2018/09/15/5b9cc23122666.png)

我们每年都会对工程师做两次平台基础架构的调查，自从我们开始将 UI 库的问题包含进来之后，我们不断地收到类似这样的反馈：

> **100,000/10**
> **我的天啊，前端 UI 框架实在是太美了，领先了任何现有的开源 react UI 框架好几年** 

我们的努力让文档系统变得完善，活跃的文档永远不会过时，但是像这样的反馈会帮助我们知道，我们还在正确的轨道上。

### 自己来看一下吧

下面来看一下你是如何可以迅速从一个提前做好的模板开始，使用我们 UI 库中的沙盒编辑器来构建一整个页面。

* YouTube 视频链接：https://youtu.be/Jw__JImMhXE

看，这就是我们的开发者如何使用 UI 库编辑器和我们的可复用的 React 组件来[构建和原型中一模一样](https://medium.com/hubspot-product/people-over-pixels-b962c359a14d)的页面。

我们已经做了一个我们 [HubSpot Canvas UI 库](https://canvas.hubspot.com/)的公开版本。在这里面，你会找到我们组件和风格指导的一部分，直接从我们的产品代码中拉取出来的。这对了解我们在 HubSpot 是如何打造产品，提供了一个窗口，我们将它分享出来，是因为我们对于我们在开发我们的设计系统和为设计师和开发者们不断优化以让它保持长青上所付出的时间和努力感到很自豪。我们邀请你们来看一看并且分享你的想法 —— 我们等不及想听到它们了。

**感谢 [Sue Yee](https://dribbble.com/suechews) 制作的插图**

**最初发布在** [_HubSpot Product Blog_](https://product.hubspot.com/blog/how-to-gain-widespread-adoption-of-your-design-system)

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
