> * 原文地址：[How to avoid these 7 mistakes I made as a Junior Developer](https://medium.freecodecamp.org/how-to-avoid-these-7-mistakes-i-made-as-a-junior-developer-a7f26ce0f7ed)
> * 原文作者：[Chris Blakely](https://medium.com/@chrisblakely01)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-avoid-these-7-mistakes-i-made-as-a-junior-developer.md](https://github.com/xitu/gold-miner/blob/master/TODO1/how-to-avoid-these-7-mistakes-i-made-as-a-junior-developer.md)
> * 译者：[whatbeg](https://github.com/whatbeg)
> * 校对者：[yinguangyao](https://github.com/yinguangyao), [renyuhuiharrison](https://github.com/renyuhuiharrison)

# 如何避免我作为初级开发者时所犯下的 7 个错误

![](https://cdn-images-1.medium.com/max/4000/0*c7djDqc-mTOweLhT.jpg)

开发者职业生涯伊始你可能会觉得有点害怕。你将面临许多未知的挑战、要学习很多东西，还要做出很多艰难的抉择。有时我们可能会选错。这是很正常的，当我们面对这种情况时不要自责。

我们应该从中吸取教训。在成为高级开发者的过程中，我犯过许多错误。本文讲述了当我还是初级开发者时犯过的 7 个严重错误，以及如何避免这些错误。

## 承担第一份工作

如果你一直在自学代码，或者即将结束学生生活，那么你的首要目标就是找到第一份工作。这是黑暗隧道尽头的一束光。

但找工作并不容易。初级开发者越来越多。[你要写一份一击必中的简历](https://www.chrisblakely.dev/how-to-write-an-awesome-junior-developer-resume-in-a-few-simple-steps/)，并经过几轮面试，这个过程也可能会一直循环下去。

抓住任何一个可以胜任的工作机会，对你来说很有吸引力。这点可以理解。

但这种行为可能并不明智。无论是从学习还是享受工作的角度而言，我的第一份工作都远远谈不上理想。开发者抱着「呃，有态度就行」的想法，对待工作并不认真。这样就会产生一种责备文化，我常常为了满足紧迫的截止期限而被要求缩减内容。最糟糕的是我没能从这份工作中学会任何东西。

我在面试中忽略了这些警告信号，因为得到工作机会蒙蔽了我的双眼。当我收到**报酬还不错**的 **offer** 时，我将我所有的担忧都抛到了脑后。

真是大错特错。

你的第一份工作非常重要。它让你体验到成为一名真正的开发者的感受，你从这份工作中获得的经验和指导也将为你之后的职业生涯奠定基础。这就是为什么在接受任何工作前，你都要对你的职位以及这家公司进行全面调查。你一定非常不想从中获得糟糕的经验或遇到糟糕的领导！

所以，在申请或接受任何工作之前，你需要：

### 调研这家公司

在 [Glassdoor](https://www.glassdoor.co.uk/) 和互联网上搜索这家公司、登录他们的网站，找一些关于这家公司的评论。如果这家公司符合你的目标和需求，那将会给你吃一颗定心丸。

### 询问你认识的人

如果你的关系网中有人曾在这里工作，或者他认识这里的员工的话，你可以和他们聊聊。了解一下他们对这家公司的褒贬评价以及他们的经历。

## 在面试中问恰当的问题

面试是你了解一家公司的绝佳机会，面试前要确保你已经准备好要提的问题了。你可以问的事情包括：

* 开发过程（他们用的是什么方法？他们有代码审核吗？他们的分支管理策略是什么样的？）

* 测试相关的问题（他们用什么样的方法进行测试？他们有专门做测试的工程师吗？）

* 公司文化（这家公司的氛围轻松吗？有什么针对初级开发者的支持吗？）。

## 不选择一条路

毫无疑问，成为成熟开发者的道路充满困惑。有很多可用的语言、框架和工具。我最开始犯的一个错误是**什么都想学**。有趣的是，我最后什么都没学好。

一会学 Java，一会学 JQuery，一会学 C#，一会学 C++ ...

我没有专注于一种语言，而是根据那天的心情在不同语言间跳跃。相信我，这绝对是一种非常低效的学习方式。

如果我选择一条路或者一门技术，坚持下来，那我本能得到更好的结果，并晋升得更快。例如，如果你想在前端发展，那可以学习 JavaScript、CSS 和 HTML，还要选择一个框架。如果你想在后端发展，那就选一种语言并好好学。你不需要了解 Python、Java 和 C#！

集中注意力、选择自己要走的路、制定计划，并成为你选择的领域的专家（[这张图](https://www.chrisblakely.dev/the-10-minute-road-map-to-becoming-a-junior-full-stack-web-developer/)可以帮助你制定计划）。

## 写代码的时候太「花哨」

假设你在准备一个项目，这个项目可能是给面试官看的，也可能是你找到第一份工作后的第一个项目。你想给别人留下深刻的印象。最好的方法是做什么呢？用你学过的极其花哨的编码技术来完成项目，对吗？

错了。

这是我犯过的一个重大错误，也是初级开发者常犯的错误。通常初级开发者会尝试重新造轮子，或者试图用一些复杂的解决方案来给人留下深刻印象。

最好的方法是参照 K.I.S.S（“**越简单越好**”）原则写代码。让一切都尽可能简单，你就可以写出**可读性强、可维护性高的代码**，这会带来很多好处（在你之后继任的开发者会很欣赏这样的代码！）。

## 生活比代码和工作更重要

我早期还有一个坏习惯：没有学会在生活和工作中切换。我会在一天工作结束后还把电脑带回家，端坐好几个小时来解决**可以留到第二天的任务或漏洞**。不出所料，这样的习惯让我精疲力尽。

我这样做的部分原因是我觉得要尽快完成所有的事情。但实际上，我本该意识到工作是一个持续的过程，它往往可以在下一个工作日再继续进行。重要的是要记得生命中还有别的需要关注的事情 —— 朋友、家庭以及兴趣爱好。当然，如果你想夜以继日地写代码，那当然可以！但如果不怎么享受这个过程，那你可以考虑停下来做一些其他事。

明日何其多！

## 不敢说「我不知道」

在你要完成的问题或任务上遇到困难是很常见的，它会经常发生，即便你成为高级开发者也是如此。作初级开发者时我犯的错误是：我不愿意承认「我不知道」。如果管理者问了一个我不太清楚的问题，我会糊弄一个答案，而不是直接说**「我不知道」**。

我觉得如果说「我不知道」，人们就会觉得**我不知道自己在做什么**。但事实并非如此。没有什么都知道的人。所以如果有人问了你不知道答案的问题，直说就好。这样做的好处是：

* 你表现了你的坦诚，而且不会误导提问的人

* 如果有人向你解释的话，你也会学到新的东西

* 你直说自己不懂这个问题的话，会得到别人的尊重。不是每个人都敢承认自己的无知。

## 试图进展太快

我相信你一定听过「在学会跑之前你要先学会走」。没有什么领域比 web 开发更贴合这句话了。当你以初级开发者的身份获得第一份工作时，你会急于产出，马上着手处理大型编码任务。你甚至想到了如何快速晋升到下一级。

虽然有雄心壮志是很好的事，但现实是很多事情不会立即发生在初级开发者身上。当你刚开启自己的职业生涯时，你可能要处理相对更小、更简单的任务和错误。这可能不是什么令人兴奋的工作，但却是必须经历的过程。这可以让你快速上手并熟悉这个开发流程。其次，这个过程可以让你的团队和你的上级更好地评估你作为团队一员的工作范围，以及你的技能在团队中处于什么样的位置。

我当时犯的错误是对处理小任务感到沮丧，而且这种沮丧的感觉影响了我的工作。耐心点，尽你所能完成你要处理的每一个任务，激动人心的工作随后就来！

## 没有加入任何社区，也没有建立任何关系网络

开发社区很棒。社区中总有人愿意提供帮助、反馈，甚至是动力。成为开发者是很难的，有时候可能会付出一些代价。你加入社区越早，就越容易渡过初级开发者的艰难时期。

参与也是一种很好的学习方式。你可以为开源项目做出贡献，看别人是怎么写代码的，还可以看到开发者是如何协作完成一个项目的。这些技能你都可以应用在日常工作中，而且从长远角度看，这会让你成为更好的开发者。

找到并加入你感兴趣的社区 —— freeCodeCamp、CodeNewbies、100DaysOfCode 都不错！你还可以参加一些你所在城市的线下聚会。详情见 meetup.com。

这也可以让你**建立关系网**。这个网络基本是由你所在行业认识的一群人组成的。为什么关系网很重要？假设你想跳槽，通过网络，别人可能会推荐特定的职位给你，甚至可能向一些公司推荐你。这让你在面试中有了坚实的优势，因为有人为你担保，这样你就不再只是「一叠简历中的一个名字」

感谢阅读！

***

想获得初级开发者的最新指南和课程，可以加入 [www.chrisblakely.dev](https://www.chrisblakely.dev/#sign-up) 的邮件列表！

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
