> * 原文地址：[How Apple beat Swiss watchmakers at their own game](https://medium.com/s/story/from-clockworks-to-computers-on-our-wrists-11a709a20000)
> * 原文作者：[Adrian Zumbrunnen](https://medium.com/@azumbrunnen)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/how-apple-beat-swiss-watchmakers-at-their-own-game.md](https://github.com/xitu/gold-miner/blob/master/TODO1/how-apple-beat-swiss-watchmakers-at-their-own-game.md)
> * 译者：[noturnot](https://github.com/noturnot)
> * 校对者：[Wangalan30](https://github.com/Wangalan30), [Marszht](https://github.com/Marszht)

# 从发条手表到手腕上的计算机

## 苹果公司如何弯道超车颠覆传统瑞士制表业

![Go to the profile of Adrian Zumbrunnen](https://cdn-images-1.medium.com/fit/c/60/60/1*AvC-bmqPn1Ja9cDFPG9vZw.jpeg)

众所周知，世界上很多最知名的手表品牌都来自瑞士，这已经不是一个秘密了。尽管“瑞士制造”的产品概念似乎已经存在很久了，它却是一个相对近期的现象。

在 16 世纪，住在纽伦堡的德国锁匠 Peter Henlein 构想了与今天的腕表最为相似的第一款手表。这款 “Taschenuhren” 表在当时是一种早期的配饰，同时也是地位的象征，只有上层阶级和社会精英才买得起。在长达一个世纪的时间里，怀表的设计始终没有改变。接着，正如我们所知，英国的一系列革新改变了制表业。

![](https://cdn-images-1.medium.com/max/800/0*dzeCpT5mZopdgvBp.png)

不同类型手表和精密计时器的游丝。图片：Frederick J. Britten and Harry L. Nelthropp via [Wikimedia Commons](https://commons.wikimedia.org/wiki/File:Balance_spring_types.png)/[Public domain](https://en.wikipedia.org/wiki/public_domain)

在十八世纪末，游丝、工字轮式擒纵机构、精密计时器的发明使得英国成为世界上最受尊敬的制表业国家之一。它们是能用钱买到的最精确、技艺最精湛的手表。然而，它们却有一点重要的缺陷：这些早期的手表太过厚重，以至于佩戴起来并不舒服。

> 早期制表业存在的问题恰好反映了今天智能手表生产者所面临的挑战。

由于时尚度和舒适性都要求更轻薄的手表，全欧洲的钟表匠开始研究构造更加轻盈的钟表装置的方法。[早期制表业](https://watchponder.com/2016/12/20/how-the-swiss-became-the-best-watchmakers-a-series-of-choices-and-fate/)存在的问题恰好反映了今天智能手表生产者所面临的挑战：怎样让手表变得更轻薄和更强大。

正是瑞士大师级钟表匠 Abraham-Louis Breguet 的技艺和视野启发了我们今天所知的现代腕表——面积大、扁平、光滑以及时髦。如果说英国人是押注在精确性上，那么瑞士人则押注在风格上。没过多久，瑞士通过第一款精确计时器认证腕表确立了一系列高质量手表生产地的地位，尤其是浪琴、IWC 万国表、以及劳力士。

从 20 世纪早期到 1960 年，瑞士人作为世界顶级制表商的地位是至高无上的。他们开始在手表上刻上标志。不同版本的标志均保持了最初的样式，由于表盘面积太小，这种方式开始出现问题，因此手表业将标志凝聚为两个简单的单词：“瑞士制造”。

不久，“瑞士制造”成为生活消费品历史上最受欢迎的标志之一。

一项由圣加伦大学在 2016 年开展的[调查](https://www.unisg.ch/en/wissen/newsroom/aktuell/rssnews/forschung-lehre/2016/juli/swissnessworldwide-markeschweiz-14juli2016)显示，相对于不知名的原创产品，调查对象愿意支付多一倍的价格购买瑞士奢侈手表。瑞士政府的网站上甚至也有关于这一标志的[夸耀](https://www.eda.admin.ch/aboutswitzerland/en/home/dossiers/einleitung---schweizer-uhren/schweizer-qualitaet----swiss-made-.html)：“‘瑞士制造'不仅仅是一个简单的原创商标。它是让顾客们知道他们正在购买一款具有杰出质量和可靠性的产品的一个信号。”

### 石英危机

正当瑞士人还在坚持传统的制表方法时，日本精工株式会社（Seiko）在 1969 年介绍了世界上第一款电池驱动的腕表。这在制表行业引发了另一场革命。

新电池腕表的低生产成本使得手表的全球价格驱车直下，瑞士制表业丢掉超过六万个工作岗位。到 1982 年底，超过一千家手表制造商在世界上消失。这个时刻——在日本精工公司于 1969 年发布 Quartz Astron 35SQ 手表之后——成为人们熟知的“[石英危机](https://en.wikipedia.org/wiki/Quartz_crisis)”。

为了在钟表业巨变中生存下来，瑞士人需要创新。

通过激进的思想和令人吃惊的设计，Nicolas Hayek 通过他新成立的斯沃琪集团彻底改造了瑞士手表。对于这个新的手表生产线，他的准则是**“创新，激情，有趣，永恒。”**这个准则不仅仅体现在产品本身，同样也体现在[广告宣传中](https://clickamericana.com/topics/beauty-fashion/the-new-swatch-the-new-wave-of-watches-1980s)。

![](https://cdn-images-1.medium.com/max/600/1*eMc7p0R0_HwKFotDOBFpTQ.png)

Vintage ’80s Swatches. Photo: [Jon Rawlinson via flickr](https://www.flickr.com/photos/london/14474851198/)/[CC BY 2.0](https://creativecommons.org/licenses/by/2.0/legalcode)

斯沃琪集团让塑料手表变得酷。这引发了完全不同的[产品定位](https://www.bloomberg.com/news/articles/2017-11-21/how-swatch-started-a-revolution-history-of-fashion-watches)。斯沃琪拆解了手表的核心计时功能，并将它转换为时尚宣言。

手表不再仅仅和复杂的钟表装置有关 —— 它现在是自我表达的渠道。在智能手机和智能手表的时代，这一从技术到时尚的转换将会变得更为重要。但是这一转变就像距离有人知道 “Home” 按钮是什么，仍然有数十年的时间。

在斯沃琪手表创立后的三十余年里，这个行业明显保持着瑞士重新确立制表业全球领导者地位的局面。

这要求另一个巨头的想象力和市场力量去再一次冲击手表行业。

### 智能手表疲劳

智能手表并不是个新概念。自从日本精工公司注意到[詹姆斯·邦德在《007 之八爪女》](https://www.youtube.com/watch?v=rp2IqwWhTkE)中所佩戴的，我们一直梦想着将屏幕放置在我们的手腕上。不幸的是，早期的全部尝试都拥有笨重的设计和短暂的电池寿命。这也导致了，没有一个在商业上获得成功。

改变发生在 2012 年，Eric Migicovsky 为他的 Pebble 智能手表（与手机配对）开启了一项 kickstarter（译者注：美国众筹网站）活动。尽管这次活动的目标是筹集十万美元用于生产，他们最终以令人震惊的一千万美元结束。由于它独特的用户体验、持久的电池寿命以及无缝连接 iOS 和 Android 系统的特性，Pebble 手表成为 2000 年代第一款在[商业上成功的智能手表](https://www.punchkick.com/blog/2016/01/06/history-of-the-smart-watch)。

![](https://cdn-images-1.medium.com/max/800/1*jX3V6HHVB00ZhU9CS4x19Q.jpeg)

Pebble 智能手表。Photo：[Orde Saunders via flickr](https://www.flickr.com/photos/79578508@N08/12031245446/in/photolist-pXB3DS-jkagzC-jk7qA6-jkah7j-jk65Ki-isiwvB-mhLcow-j8A1u9-iCGR44-6M5a7Z-jk5YR4)/[CC BY 2.0](https://creativecommons.org/licenses/by/2.0/legalcode)

不幸的是，Pebble 将会很快败给一个即将入场的智能手表新玩家。

在 2014 年初，新闻报道披露苹果公司试图与瑞士制表商展开合作的消息。斯沃琪集团的 CEO [Nicolas Hayek告诉媒体](https://www.ft.com/content/bd77bd76-b600-11e3-b40e-00144feabdc0)“我们找不到任何理由去参与合作协议的讨论。”

Hayek 曾因早先与微软的一次智能手表失败合作被指责，他坚定地相信技术限制最终将毁灭这类设备。

2014 年，就在苹果公司产品发布前的一周，[Jonathan Ive告诉《纽约时报》](https://www.nytimes.com/2014/09/04/fashion/intel-and-opening-ceremony-collaborate-on-mica-a-stylish-tech-bracelet.html) ，瑞士人将会遇到麻烦。几天之后，人们将有机会亲眼见到。

在 2014 年的 9 月，就在展示 iPhone 6 之后，Tim Cook 走上舞台，告诉拥挤的观众，苹果公司还有一款产品将要展示。他以 Apple Watch 的名称揭开神秘面纱，而不是预料中的 iWatch。Cook 称它为“……[苹果公司的下一篇章](https://www.techtimes.com/articles/15267/20140912/apple-watch-unveiled-next-chapter-in-apples-story.htm)”。

> 我们相信这款新产品将会重新定义人们对它的期待。

许多专家对 Apple Watch 的工业设计提出质疑。[Tag Heuer 的 CEO Jean-Claude Biver 告诉媒体](https://www.telegraph.co.uk/technology/apple/11088667/Apple-Watch-too-feminine-and-looks-like-it-was-designed-by-students-says-LVMH-executive.html)，“老实说，它看起来像是一个学生在第一学期时设计的。”没过多久，Biver 就改变了他的言论。

这些批评与反馈没有停止苹果公司推动行业前进的脚步。发布后不久，第一代 Apple Watch 成为有史以来卖的最好的智能手表。伴随着系列三的发布，Tim Cook 更进一步，阐明 Apple Watch 将彻底定位在手表业之内。

![](https://cdn-images-1.medium.com/max/800/1*afPj9eEdyVQoIc2xhOlxYw.png)

Tim Cook — from Apple’s Special Event 2017

为了那些依然不愿意接受现实的瑞士朋友，直到 2017 年 9 月，Cook 才提醒大众，他们的[智能手表是卖得最好的，嗯](https://www.businessinsider.com/how-the-apple-watch-just-became-the-number-one-watch-in-the-world-2017-9)。

但是那一年的苹果发布会有一些基础性的不同：Apple Watch 是在新款 iPhone 之前被展示的。

### 苹果公司对传统制表业的敬意

第一代 Apple Watch 和早期设备的不同之处并不仅仅体现在硬软件间的无缝相互作用，而是苹果公司让新技术为人们所熟知的独特能力。不同于他们的早期竞争者，苹果公司拥有另一张关键王牌：他们在传统腕表熟识度的基础之上，结合了他们早已在 iPod 和 iPhone 上成功搭建的 Apple 设计语言。

![](https://cdn-images-1.medium.com/max/800/1*FGqEfVEmvzG_kZmjZX7jkQ.jpeg)

The Apple Watch Sport. Photo: [Yasunobu Ikeda via flickr](https://www.flickr.com/photos/clockmaker-jp/17298404111/)/[CC BY-SA 2.0](https://creativecommons.org/licenses/by-sa/2.0/)

或许更为引人注目的是，在过去三年中，苹果公司鲜少对手表的工业设计做出改变。这一相当缓慢的更新周期或许正是手表的设计能够如此形象的部分原因吧。你要么拥有 Apple Watch，要么没有。无论是系列一、二还是三，都没有关系。通过坚持原始设计，苹果公司打赌消费文化中的喜新厌旧现象不会发生，也就是虔诚地每年替换科技配件。

> 苹果公司更进一步，采用传统钟表的术语去描述用户界面。

Apple Watch 几乎是在对传统制表业致敬。通过 Apple Watch 设计的持久特性，苹果公司也许是在说智能手表应该比智能手机更永久一些。

苹果公司更进一步，甚至采用传统钟表的术语去描述用户界面。许多电脑设计者发现 [“complications”](https://en.wikipedia.org/wiki/Complication_%28horology%29)（译者注：多功能表，手表专用术语）这一术语并不合适，但是钟表匠们曾经这样称呼。本质上来说，“complications” —— 在制表业术语中代表着这个单词所暗示的含义：他们通过增加日期、秒表、发条等使得手表变得更加复杂。但是，机械手表的 “complications” 设计主要是用来炫耀技艺，而智能手表中的 “complications” 旨在合适的时间传达相关信息。苹果公司采用 “complications” 这一术语去描述表盘上的[应用程序数据](https://developer.apple.com/videos/play/tech-talks/208/)。他们还采用了传统制表业的另一个术语“[表冠（crown）](https://www.hautehorlogerie.org/en/encyclopaedia/glossary-of-watchmaking/s/crown-watchmaking-1/)”，命名为“数字表冠”放置在设备的一边。

通过使用相同的语言和制表业的基本原则，苹果公司确保他们的产品独特到让人们觉得新颖，却又相似到可以在我们的手腕上发现它的位置。

### 感知上的改变

新产品并不会取代彼此，就像他们也改变不了其他产品所代表的意义。购买自动手表的人并不是在购买一款配件，他们是在购买历史和技艺。购买智能手表的人并不是在购买一种更好地查看时间的方式，他们是在购买更健康和更好连接自我的创意。

Steve Jobs 坚信 Phone app 是 iPhone 的“杀手级应用”。的确是这样，Phone app 的第一个版本是一个杰出设计的软件部分，这帮助 iPhone 确立了作为手机的地位。但是从那时到现在，对于 iPhone 的期望逐渐进化。现在，Phone app 成为 iPhone 的一款代表性副产品。

> 手表从专属极客、可有可无的科技配件进化成我们和我们所爱之人的救生工具。

智能手表正在重新定义它特有的范畴，就像斯沃琪在 1980 年代末所做的那样。智能手表曾经用来保持联络，然而它们现在配备了易上瘾的技术，旨在帮助你成为更健康的你。它们从专属极客、可有可无的科技配件进化成我们和我们所爱之人的救生工具。

Apple Watch 的进化如此平缓以至于我们中的大多数都没有意识到它的发生。在制表行业打败瑞士制表业是一件不小的壮举。但苹果公司做到了。

他们使手表成为第一款可购买的、批量生产的、面向最终消费者的心电图，我们可以期待这个领域令人激动的更多新发展。

### 展望未来

腕表一直以来都是我们身体的延伸。随着智能手表变得越来越强大，以及技术越来越有效地与我们的身体相融合，我们正处在计算新纪元的前列。

今天，技术不只是被使用，而是被滥用。我们感官的增强正在为过去完全不可能存在的新体验类型做准备。鉴于 Apple Watch 可能会成为自石英革命以来手表行业最大的颠覆，手表业的历史教会我们，过去的成功很难预测未来的发展。

我的祖父 Peter Werner Jenny 曾发明了第一款[防水深度一千米的瑞士潜水手表](https://monochrome-watches.com/introducing-jenny-caribbean-300-cool-1960s-rice-bead-bracelet/)，他怀着巨大的兴趣关注着这一行业近期发生的巨变。我等不及去看接下来它将带我们去哪儿。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
