> * 原文地址：[10 heuristic principles for mobile interfaces](https://uxdesign.cc/heuristic-principles-for-mobile-interfaces-c226fbaa1d16)
> * 原文作者：[Jordan DeVos](https://medium.com/@jordandevos)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/heuristic-principles-for-mobile-interfaces.md](https://github.com/xitu/gold-miner/blob/master/TODO1/heuristic-principles-for-mobile-interfaces.md)
> * 译者：[Hyde Song](https://github.com/HydeSong)
> * 校对者：[portandbridge](https://github.com/portandbridge)，[sunui](http://github.com/sunui)

# [译] 移动界面设计的 10 项启发式原则

![](https://cdn-images-1.medium.com/max/3440/1*IRIxsMuVD4AUlChUyZzOAA.png)

当 Jakob Nielsen 开始研究设计模式时，他正在从事人机交互方面的可用性工程的咨询和教学工作。所以在 1994 年，他收集并发布了一套可用性启发式 [评估原则](https://www.nngroup.com/articles/ten-usability-heuristics/)，这些原则反映了他所研究的东西。如今，经过了近 25 年的时间，随着电脑向智能手机的转变，Nielsen 的原则依然站得住脚。 

以人为本的设计强调了用户的重要性，设计过程也相应地进行了调整；然而，虽然 Nielsen 的原则在所有屏幕类型上仍然是通用的，但是随着移动设备使用量的不断增加，设计的重心已然在 [移动界面](https://www.toptal.com/designers/mobile/mobile-app-design-mistakes) 上了。

在网上搜索启发性原则，你会列出很长的一份清单，但内容略有差异。以下是十项原则的精选集，这些原则由以人为本的设计和可用性思想倡导者所启发。

## 可用性启发从用户需求开始

在开始讨论这十项原则之前，必须认识到用户的重要性正在不断增长。[GOV.UK](https://www.gov.uk/) 虽然是一个政府网站，但它的重新设计是用户主导的产品因其可用性获得全球认可的一个典型例子。

项目设计总监 Ben Terrett 以一套用户界面 [设计原则](https://www.gov.uk/guidance/government-design-principles) 为起点，这套原则涵盖从产品策略到视觉设计方法的方方面面。正是第一项原则指引了产品的成功：“永远从用户需求出发。如果不知道用户需要什么，就无法构建正确的东西。做调查、分析数据、与用户交流。不要假设。对用户要有同理心，记住他们要求的并不总是他们需要的。”

可用性评估的启发式原则有助于确定 UI 设计在哪些方面不能提供用户友好的体验。

## 一、系统结构的透明度

**让某些元素和结构可见的做法，让用户对上下文有足够的理解。**

 UI 应该允许用户相信一切在控制之中。用户应该能够轻松地回答这些问题：“我现在在哪里?” 和 “从这里我能去哪里?” 当一个系统是透明的，用户可以决定接下来会发生什么。用户获得了使用界面的自主权和随后的信心。

![导航菜单变为汉堡包菜单，指示稍后可以在何处找到信息。（由 [Gal Shir](https://galshir.com/) 设计）](https://cdn-images-1.medium.com/max/3360/0*BAE8DM_ocDtJZg-c.gif)

## 二、操作反馈的即时性

**对用户操作响应证明系统已收到请求。**

任何用户操作都应该有一个即时的界面反馈。即时反馈让用户放心，系统正在做预期的事情。[Nick Babich](https://www.smashingmagazine.com/2016/12/best-practices-for-animated-progress-indicators/) 是 Smashing Magazine 的 UX 专家，他使用进度指示器作为一个很好的例子，来明确传达操作状态。他认为，它可以直观地通知用户，他们的操作已经被接受，系统很快就会指示下一步操作。如果没有指示器，用户就会面临不确定性和挫折感，从而导致用户访问中断。

![用一个简单的动画来确认收到了下拉刷新操作，下面的内容是最新的。（由 [jiangxiaobei](https://dribbble.com/jiangxiaobei) 设计）](https://cdn-images-1.medium.com/max/3360/0*9VP-bybmPpAQo8Ns.gif) 

## 三、让用户知悉错误信息

**用户操作错误之后可以得到提示信息和对应的操作选项。**

有时候，用户总是以一种意想不到的方式与移动界面进行交互，在使用的时候感到沮丧和烦恼，无法满足自己的需求。用户不能流畅轻松地使用是用户提早离开的常见原因。UI 应该提供足够的提示信息来帮助用户识别、判断和从错误中恢复。

用户应该总是容易获得帮助信息；然而，要取得平衡并不容易。给用户太多的选择反而会让用户应接不暇。应该让用户对如何解决错误有一个清晰的认识，并让用户了解以后如何防止错误的再次发生。

![移动界面的空状态解释了用户为什么会看到这个错误页面，并提供了两个操作来解决错误。（由 [Murat Mutlu](https://dribbble.com/shots/1738412-Project-empty-state) 设计）](https://cdn-images-1.medium.com/max/3360/0*uPupo3gf8fjFHJTD.jpg)

## 四、使用的灵活性

**界面应该能让经验不同的用户都能直观有效地使用。**

移动端的交互体验不应依赖外部的用户操作指南。不管用户第一次使用移动 app 还是第一百次使用，界面都应该适应这两种场景。

要让老用户快捷地访问、更深入地整体地理解应用，但也不要让新用户因简单的困惑陷入无助的境地。有了 UI 的灵活性，用户就可以找到符合自身能力和满足自己需求的途径。

[Jill Gerhardt-Powal 的](https://en.wikipedia.org/wiki/Heuristic_evaluation#Gerhardt-Powals.E2.80.99_cognitive_engineering_principles) 认知工程学原则建议设计师“在适当的时候提供多种数据编码 —— 系统应该提供不同格式和/或细节级别的数据，以提高认知灵活性和满足用户偏好。”无论是让用户感到压力的还是感到约束的界面必然会让用户在使用的时候感到烦恼。

![应该向新用户介绍工具的功能，但是老用户永远不会看到这些常规的工具提示。（由 [Lakshmi Karuppiah](https://dribbble.com/lakshmikaruppiah) 设计）](https://cdn-images-1.medium.com/max/3360/0*Hx11UX6AHVjOPMrT.jpg)

## 五、贴合大众习惯的用户体验

**使用符合人们常识的意料之内的设计元素。**

[图形界面的历史](https://www.wired.com/1997/12/web-101-a-history-of-the-gui/) 始于苹果计算机公司在第一个用户友好的计算机界面设计中对照了现实世界的物品。“Lisa”的图形界面中使用了比如用文件夹图标表示文件组织结构的类似的设计元素。当大多数人都不熟悉数字交互时，这些现实的对照是有用的，但是随着人们数字素养的提高，大多的对照就不再需要字面化了。

随着人们花更多的时间与屏幕交互，共同的用户预期已经形成。我们希望“+”可以展开更多信息，导航菜单停留在移动屏幕的顶部或底部。利用大多数用户都能理解的对照，界面变得直观。

![这两个图标可以立即识别，并清楚地表示大多数用户都能理解的操作。（由 [Mohammad Amiri](https://dribbble.com/shots/4832226-Search-Icon-Interaction-Search-Close) 设计）](https://cdn-images-1.medium.com/max/3360/0*1StwrCYHxA3AV3xE.gif)

## 六、防止过多信息和过度设计

**创建精简的设计，排除可能影响流畅的且有目的性的用户体验的非必要元素。**

一般原则是，数字交互设计不要让用户产生困惑。为了减少决策时间和错误，Jill Gerhardt-Powal 向设计师提出了一个挑战，通过以一种清晰而明显的方式显示数据来减少不确定性。这可以通过去除不必要的内容以及使用颜色、布局和排版引导用户通过屏幕来实现。不应该让用户分心，而应该向他们提供足够的指导，然他们更容易实现目的。

Ben Terrett 经常使用 [GOV.UK](https://www.gov.uk/guidance/government-design-principles) 的第四条设计原则:“努力让事情变得简单。”他认为，设计团队应该完全理解他们正在处理的问题，以及提供直观、信息丰富和成功用户体验的最佳解决方案的过程。在这个 [案例研究](https://gds.blog.gov.uk/2014/07/28/doing-the-the-work-to-make-things-simple/) 中，记录了他们的方法。

![英国政府数字服务部门 (British Government Digital Services) 对信息进行分解，以确定用户需要知道什么，并创建了视觉设计，消除了一切不必要的东西，以支持信息的清晰性。（由 [英国政府数字服务](https://designnotes.blog.gov.uk/2014/07/14/things-we-learnt-designing-register-to-vote/) 设计）](https://cdn-images-1.medium.com/max/3360/0*4XbF10wLsf_RzW9S.jpg)

## 七、功能优先于形式

**设计决策是由元素的作用来驱动的，而不是优先考虑它的视觉风格。**

**“如果你认为某件事很聪明、很复杂，要小心 —— 这可能是自我放纵。” —— Don Norman，高产的产品设计师，《The Design of Everyday Things》的作者。**

界面的视觉设计应该总是从定义的功能开始。当风格和趋势被优先考虑时，结果可能看起来很漂亮，很引人注目，但最终可能导致脱节的 [用户体验](https://www.toptal.com/designers/mobile-ux)。视觉形式无法拯救功能失调的设计。

视觉提示可以用来在应用程序的功能中引导用户。[Fritt 法则](https://www.interaction-design.org/literature/article/fitts-s-law-the-importance-of-size-and-distance-in-ui-design) 指出，形状、间距和大小可以引导用户了解情况并采取所需的行动。正是在这里，形式支撑并放大了功能。

![这种数字登机牌考虑了旅客对信息有怎样的需求，并使用视觉技术使信息具有功能性。（由 [Marin Begovic](https://dribbble.com/marinb) 设计）](https://cdn-images-1.medium.com/max/3360/0*3bb_fgKD3wieHvVP.gif)

## 八、信息要容易获得

**把界面元素放在用户触“指”可及的最佳位置，这样用户就不必凭记忆来操作。**

认出某物比回忆某物要容易。如果移动界面的功能以少量信息或受众不太熟悉的系统为基础，那么就应该让信息容易获得，方便用户使用。

[Nielsen 的](https://en.wikipedia.org/wiki/Heuristic_evaluation) 启发式原则之一建议，设计人员应该“通过使每个对象、动作和选项都是可见的来减少用户记忆的负担。用户不必记住会话的每个部分的信息。使用该系统的指示应是可见的，或在适当时容易检索。”

Jill Gerhardt-Powal 建议“将较低层次的数据整合到较高层次的总和中，以减少认知负担。”她还表示，“显示名称和标签应该与上下文相关，这将提高回忆和识别能力。”重要的是要意识到，第一次看到界面的用户不会像设计师那样了解和熟悉信息。对于经验丰富的团队来说，重复信息似乎有些冗余，但对于新用户来说却是必不可少的。

![Uber 的 app 提供了三种级别的出租车服务，让用户在需要的时候很容易地访问每个选项。（由 Uber 设计）](https://cdn-images-1.medium.com/max/3360/0*x9HW0XVOKQKc_6tQ.gif)

## 九、可靠的一致性

**使用一致的和标准化的元素，如措辞、场景和操作来创建一个有凝聚力的体验。**

人类被模式所吸引 —— 我们用模式来理解世界。在移动界面中创建模式，它将成为一个训练工具，让用户了解应该期望什么以及如何与 [界面设计](https://www.toptal.com/designers/ui/ui-styleguide-better-ux) 交互。

“这不应该成为束缚。每一种情况都是不同的。” GOV.UK 的设计原则表明，界面风格应该是一致的，但不应该是千篇一律的。正如 Jill Gerhardt-Powal 所呼应的，“新信息应该在熟悉的框架内呈现(例如，模式、隐喻、日常用语)，这样信息更容易被人们接收。”

![google 对设计的高度关注体现在其所有 UI 设计的详细指南中。（由 [Material](https://material.io/) 设计）](https://cdn-images-1.medium.com/max/3360/0*uBKIdRuzxPspM8e2.gif)

## 十、明智的冗余

**在设计过程中不断进行反思，以确保用户界面设计原则和可用性启发与产品的目的和用户需求保持一致。**

Jakob Nielsen 是第一个承认不可能为 [UI 设计](https://www.toptal.com/designers/ui) 提供通用细节的人。例如，他的两条启发式原则可以相互矛盾 —— #6：提供用户做出决策所需的所有信息；#8：消除任何不必要的东西。

为特殊用例确定最佳策略的责任就落在了启发式评估人员和设计团队肩上了。如果产品是以人为本而设计的并围绕用户需求构建的，团队了解这一点后在做决定时有明确的目标。

## 扩展阅读：

* [Heuristic Analysis for UX — How to Run a Usability Evaluation](https://www.toptal.com/designers/usability/usability-analysis-how-to-run-a-heuristic-evaluation)
* [The Principles of Design and Their Importance](https://www.toptal.com/designers/ui/principles-of-design)
* [The Importance of Human-Centered Design in Product Design](https://www.toptal.com/designers/ux/human-centered-design)
* [Creating a UI Style Guide for Better UX](https://www.toptal.com/designers/ui/ui-styleguide-better-ux)
* [Mobile App Design Best Practices and Mistakes](https://www.toptal.com/designers/mobile/mobile-app-design-mistakes)

***

**本篇文章最初发表在 [www.toptal.com](https://www.toptal.com/designers/usability/mobile-heuristic-principles)。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
