> * 原文地址：[Great Design Vs Good Design: What’s The Difference? Here’s The Truth](https://medium.com/truthaboutdesign/great-design-vs-good-design-whats-the-difference-here-s-the-truth-da08557f6fdd)
> * 原文作者：[Jamal Nichols](https://medium.com/@jamalnichols)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/great-design-vs-good-design-whats-the-difference-here-s-the-truth.md](https://github.com/xitu/gold-miner/blob/master/TODO1/great-design-vs-good-design-whats-the-difference-here-s-the-truth.md)
> * 译者：[Mirosalva](https://github.com/Mirosalva)
> * 校对者：[Qiu Hu](https://github.com/whatbeg), [Charlo-O](https://github.com/Charlo-O)

# 伟大设计与好设计之间区别是什么？这里告诉你真相

![](https://cdn-images-1.medium.com/max/5120/1*oFxtwD8CyvpVvLRbhPxrzQ.jpeg)

过去十年内界面设计的最低标准已经上升，你现在看到这样的情况要少得多：

![](https://cdn-images-1.medium.com/max/3312/1*ka6-MHyRe2UnlcCM9iYKZg.png)

我们已经搞清楚如何让用户的界面看起来不错并且表现相当好。正如在其他成熟行业中一样，你能获得的行业标准已经出现：在汽车中，你不会切换加油和制动两种踏板的位置，也不会将座椅放在汽车外部。在用户界面，你不会添加闪烁文本或者自动播放音乐，而且你希望界面上的东西相对整洁。

对于工业来说这是一个大的进步，但是我们现在做什么呢？仅仅不再犯下最惊人的错误就足够了吗？或者我们应该争取更多？

我觉得数字设计领域正处于亟需我们力争伟大，而不仅是满足于好的状态。

但是伟大设计长什么样呢？它跟好设计有什么区别？让我们来看看一些原则。

## 好设计提供人们想要的，伟大的设计用意想不到的方式解决人们的问题

大约一年前，Samsung 宣布正在研发一款可折叠的智能手机。有一句话引起了我的注意：

> DJ Koh 曾说过『是时候交付一款可折叠设备了』这样的话，就在三星消费者调研表明这类设备存在市场之后。

三星几乎自豪地说客户调查是该公司研发可折叠智能手机的原因，这一事实令人感到恐慌。

向你的客户发送有关他们使用产品的满意度或者最近的产品维修进展如何是一回事。但是基于客户调研的产品研发却是令人非常质疑的。

客户调研不会导向类似 iPhone、iPad 以及 Apple Watch 这类产品。

这是一个过度引用 Henry Ford 的经典例子：“如果我们问了别人他们想要什么，他们大概会说『更快的马』”。

伟大的设计源于对此事的理解：普通的外行人无法总能明确地说出解决方案，有时候他们只知道他们遇到了问题。提出解决这类问题的新方法这件事，却取决于生活在技术和创造性艺术交叉点的设计师，设计师可以在主题之间建立意想不到的联系，并使用新方法来解决问题。

***

## 好设计是数据驱动的，伟大的设计是会产生广博数据的

『数据驱动』是一个有趣的词组。它字面上意思是数据**驱动**了你的决策。数据点在驾驶员的位置，而不是你。

这种情况是有风险的，因为并非所有事情都是可以通过数据来解决的优化问题。把你所有的决策都基于你可以正确测量的数据点，可能会导致你失去对你正在尝试解决的重要宏观层面问题的聚焦。

数据只是去解决问题的一种信息来源。因此，如果你想产出伟大设计，保持『数据知情』可以是你需要走的路子。

Booking.com 是数据驱动型设计的一个好例子。他们做了大量的 A/B 测试，来了解用户如何最好地转换到他们平台上来预定机票和酒店。

通过测试，他们发现添加『告急消息』会促使用户预定量变多。告急消息就是类似于『嘿！这个酒店只剩 4 个房间了，快订吧』。这很好，但是这些年来，booking.com 已经添加了一个接一个的消息，这里现在就更像是一个摇摇欲坠过度使用的汽车，而不是一个可以预订酒店的正经地方。

![基本相同](https://cdn-images-1.medium.com/max/3840/1*3sxLm9wyllJHpOJ1DBZcQw.jpeg)

最近，它开始显示一些你甚至都不能订的酒店，就为了强调这个意思『大家都在这里 booking.com 订酒店，所以你也来吧』

![你在开玩笑吧](https://cdn-images-1.medium.com/max/3840/1*AsIGA9pPt_FR_9B2uRJL8Q.jpeg)

我相信它可以将转化率提高 0.4%。但是如果看下整体体验，它真的已经开始下降了。不考虑总体体验，这是你在数据点和转化率的个位数提升的基础上对产品做短期优化时得到的结果类型。

跟 Hotel Tonight 比较一下，它是一个快速增长的酒店预定应用，最近被 airbnb 以几百万美元收购。

![](https://cdn-images-1.medium.com/max/3840/1*zcBZpuGKBjxGN44_9MqrtA.jpeg)

Hotel Tonight 明白人们想要寻找一间好屋子来入住，并且优化这一点。它显示的酒店房间预览图比 booking.com 显示的更大，并且有一点点告急消息，但是并没有占据一整片页面布局。他们专注于整体体验而非仅仅是由数据驱动产生小的转化率提升。

***

## 好设计试图取悦每个用户，伟大的设计有自己的想法并会挑战共识

伟大的设计有一个世界观以及价值观，它会持续地践行这些。它并不会试图取悦所有的人。

思考一下 Apple 的 MacBook 和 iPad 对比 Microsoft 的 Surface。Microsoft 采取的方式是『我们不想决定什么是消费者的最佳体验』。在某种程度上，他们让消费者设计他们自己的体验，而非自己设计。

你从那样做得到的结果就是一台包含触摸屏和手写笔的笔记本，它可以双向折叠，你也可以拆下屏幕。它看起来不错，但你用它真的做什么呢？

![啊……](https://cdn-images-1.medium.com/max/4800/1*CzRlfWcS9D-kBUZeCw9yVQ.png)

同时，苹果采用的这种方式『让我们把技术变得更加个性化，并且围绕着特定使用场景去创造工具和外形』。

iPhone 和 iPad 被设计成处理**某些**以前被分配给笔记本和台式机的任务。在创造这些新型外观的过程，iPhone 和 iPad 也可以处理整体新任务。类似的过程也发生在 Apple Watch 上，它可以处理之前分配给 iPhone 的任务，同时还可以处理新任务。

在 Apple 的视野，iPhone 和 iPad 需要与 Mac 分离开，因为每个类别都需要相较于忠实原有外形因素变得更强一些。我们的想法并不是让这些产品共享相同的用户输入，去让用户可以在桌子上的台式机和笔记本上以及智能机上做任何可能的事情。相反的，每个产品都具有基于用户输入方法和外形因素的不同功能。

**这**是设计设备的一种固执己见的方法。不是所有人都赞同 Apple 的方法，但是结果却很清楚：[苹果产品](https://www.theverge.com/2016/2/1/10886720/apple-ipad-pro-outsold-microsoft-surface-sales)已经比 Microsoft 的产品[卖得多](https://www.inc.com/john-brandon/why-the-apple-ipad-pro-has-massively-outsold-the-microsoft-surface.html)，[过去 4 年](https://www.imore.com/apple-outselling-microsoft-powered-computers-it-may-not-be-fair-it-mobile-centric-future)有 30:1 的比例之多。

***

## 伟大的设计关注细节的同时也不会忽略整体情况

现在你已见识了许多公司谈论设计的重要性。Salesforce 发布了一个全面的设计系统，其包含一个奇妙的名字（『Lightning 设计系统』）和许多插图吉祥物。

然而，他们忽略了在该设计系统中正确地设置排版去优化屏幕的可读性。他们有如此宏伟的愿景，却忽视了设计的基本原理。

![讽刺](https://cdn-images-1.medium.com/max/4792/1*H9o8HSUg2wGO2aQy2hQnoA.png)

另一个你经常看到被忽视的基础要素是图形对比：图像表层的文字不可读...尽管一直在讨论『好设计』的重要性。

![Intercom 的 [loves](https://www.intercom.com/blog/product-and-design/) 谈论了他们的设计如何好](https://cdn-images-1.medium.com/max/5012/1*5ic1paS7UtNIcY8C_2wxcA.png)

专注于设计的表面部分而忽视了基本要素，就像棒球比赛中专注于本垒打，或者篮球比赛中只扣篮。看起来有趣，但是在现实的竞争环境中检验时，忽略游戏基本要素的玩家将会崩溃。

> 伟大的设计永远不会忽视寻求给周围世界留下深刻印象的基本要素。

就那个说明...

## 好设计试图给人留下好印象，伟大的设计让人难以忘怀

> “一位优秀的设计师会找到一种优雅的方式将你需要的一切放在一个页面上。一个伟大的设计师会让你相信一半内容都是不必要的。”
> — Thomas Hutchings (@Dear**Impossible) 2013年 11 月 14日**

好的设计旨在通过『令人愉快的动画』和『漂亮的用户界面』给人们留下深刻印象。你会发现好的设计，将其分解并记录下你喜欢的内容和操作方式。

伟大的设计是不可见的，几乎完全感觉不到它是设计过的。就像你的 MacBook 在你佩戴 Apple Watch 情况下会自动解锁，或者你的 Nest 恒温器在你进入一个房间时会自动调节到你选择的温度。但它也可以像超市里的鸡蛋盒一样简单（你有没有尝试设计一个更好的鸡蛋盒？）。

> 伟大的设计是不可见的，几乎完全感觉不到它是设计过的。它源于极致的关怀和助人的渴望。

***

## 伟大的设计拥有愿景、勇气和自我约束

目前在硅谷中有一种趋势：尝试去将设计转化为可复制和再生产的流程，而不管你将谁放到这个位置。

创造一个清晰定义的流程是一个好想法，尤其对大公司来说。但是当你在一个组织中按照这个水平一天接一天的工作，很容易过度关注于优化流程并且失去了你正在构建何物的视角，以及它的原因。你最终会在不重要的事情上做迭代和优化。有时候这在我们所有人的身上都有可能发生。

> 做伟大设计的一部分工作是创造一个令人信服的未来愿景，并且在面对逆境时有勇气和自我约束里取坚持那个愿景。

仅仅跟随按部就班地跟随流程并不能产生伟大的设计品。通过那种方法你可以得到一个『足够好』的设计。但是好设计和伟大设计的区别就在于好的成功和伟大成功的区别。

Jared Spool 最近有关[创造一个体验愿景](https://medium.com/@jmspool/the-experience-vision-a-self-fulfilling-ux-strategy-ce4cdb58227e)的文章在我看来，创造伟大设计的精髓就是：

> 创造有效的体验愿景故事的方法是由当前体验开始。是什么让今天的产品或服务体验使我们的用户感到沮丧？
> 我们可以问：**什么是我们可以想象出来提供给用户的最好体验？** 我们紧密地跟踪着沮丧点并想象出这些沮丧点不会发生的体验场景。
> 接下来是确定基线的时间范围。[…]我们的大部分愿景体验都距 5 年基线较近了。[…]在 5 年内（或者任何我们选择的基线），我们可以想象的最佳体验是什么？因由我们把所有的沮丧点解决后人们生活会有多大的改善？

一个令人信服的愿景是什么会使组织中的『流程机器』定位去创造伟大的产品。

 对于一个资深的设计师来说，以那种方式来定义一个体验愿景是相当容易的。追寻这一愿景所需要的持续自我约束使其几乎无法实现。这就是为什么市场上有那么多奇怪的产品，以及为什么大多数应用和网站长得都一样。只是保持『足够好』更容易做到。

## 拥抱伟大的设计

有许多原因让我们尝试去做伟大的工作而不仅仅是『足够好』的工作：它将你变得与众不同。它让你周围的人更加幸福，它让你更幸福，它是非常有趣并令人满意的。

但最重要的是，对你的生活你还有其他想做的事情吗？除了尽你最大的努力去让周围的世界变得更好，究竟还有什么更好的事情值得你花时间呢？如果每个人都这么做的话想想我们将会生活在什么的世界，这由你开始。

### 分享你的故事

能否举一些伟大设计的例子？发表评论与我们一起分享吧。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
