> * 原文地址：[Frontend vs Backend: Which One Is Right For You?](https://dev.to/molly_struve/frontend-vs-backend-which-one-is-right-for-you-5gjg)
> * 原文作者：[Molly Struve](https://dev.to/molly_struve)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/frontend-vs-backend-which-one-is-right-for-you.md](https://github.com/xitu/gold-miner/blob/master/TODO1/frontend-vs-backend-which-one-is-right-for-you.md)
> * 译者：[YueYong](https://github.com/YueYongDev)
> * 校对者：[Chorer](https://github.com/Chorer)，[Zavier Tang](https://github.com/ZavierTang)

# 前端 vs 后端：哪一个适合你？

![](https://res.cloudinary.com/practicaldev/image/fetch/s--sQXuMr9C--/c_imagga_scale,f_auto,fl_progressive,h_420,q_auto,w_1000/https://thepracticaldev.s3.amazonaws.com/i/xtuhivk785yvj2pden2g.png)

经常会有初学者来问我刚开始学习编程的时候应该学些什么？问这个问题就跟一个医学生询问应该专注研究哪个领域一样。根本没有一个标准答案。但我还是想提供一些指导，并就这个问题提出一些自己的看法。希望这篇文章可以给刚开始职业生涯的你一些值得思考的东西。

## 定义

在刚开始学习软件开发的时候，首先要经历的心理斗争就是我应该把关注点放在哪，前端还是后端？在我们深入了解两个领域的特征之前，我们先来看看它们的定义。

### 前端

> 指的是网站的表示层以及它与后端数据的交互方式。例如 HTML、CSS、JavaScript 和 Angular 等。

[![](https://res.cloudinary.com/practicaldev/image/fetch/s--rYiDNsAL--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/e0vm7fc5bzuqxuhmt80f.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--rYiDNsAL--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/e0vm7fc5bzuqxuhmt80f.png)

### 后端

> 指的是应用程序的数据处理层。这一层负责与数据库通信，并确定将哪些信息发送到要显示的前端。例如 Ruby、Rails、Python、Java 等。

[![](https://res.cloudinary.com/practicaldev/image/fetch/s--K81Tz4o2--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/bqj0p9v42macnqlis6ow.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--K81Tz4o2--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/bqj0p9v42macnqlis6ow.png)

好的，现在我们知道它们是什么了，但是你又该如何选择哪一个作为职业的方向呢？老实说，它取决于你的个人喜好以及你选择成为一个开发者的初衷。

## 职业满足感

如果你选择成为一名开发人员是因为你想获得职业满足感，并做一些你喜欢的事情，那么我的建议是，当你开始时，前后端都要做。同时涉猎前端和后端，这样你就能感受到你更喜欢的是什么。这么做会很辛苦吗？当然会，但是这也会极大地增加你找到喜欢做的事情的机会。

在前端和后端生态系统中，仍然有许多你可以选择并且能做得非常出色的专业。当你开始的时候，试着去了解一些基本的东西，不要太担心会沉迷其中。试一试水，看看当你用它的时候，其中一个方向是否真的能吸引到你。同时，你要意识到，无论你选择哪个，一开始都会很困难。我想说的是，在你决定要把重点放在哪里之前，给自己一年或两年的时间来研究整个流程。这将给你足够的时间来解决最初的“哇，这太糟糕了，因为它很难”的问题，同时还能让你真正评估它是否是你喜欢使用的技术。

虽然每个人都有不同的品味，但是看看其他开发人员喜欢使用哪些语言和技术也是很有趣的。2019 年 StackOverflow 调查了[最受欢迎的语言](https://insights.stackoverflow.com/survey/2019#technology-_-most-loved-dreaded-and-wanted-languages)。

[![](https://res.cloudinary.com/practicaldev/image/fetch/s--Jzs_nPT6--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/85q0iiaxn4q1gfx9w2ny.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--Jzs_nPT6--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/85q0iiaxn4q1gfx9w2ny.png)

前后端通吃的另一个好处是，你可以了解它们之间是如何协同工作的。无论你决定在未来关注哪个方面，这都非常有用。如果你了解另一半的工作原理，那么你就可以在项目中创建更好的代码和接口。

最后，当你在工作时横跨前后端，你可能会决定不进行选择了！你可能希望通吃前后端，并成为一个全栈工程师。这也是完全可以的！

## 工资/稳定性

如果你从事开发的职业动机是为了工资和稳定，那么同时学习这两个方向可能是在浪费你的时间。如果你想尽快从事一行职业，那么就对你想从事的领域做一些调查。找出前端和后端的工资趋势。此外，尝试找出市场上最需要哪种类型的开发人员。

我不知道前端和后端哪个工资更高，但有一些调查试图回答这个问题。我们可以看看 2019 年 StackOverflow 的调查，该调查将开发者的[薪资按类型](https://insights.stackoverflow.com/survey/2019#work-_-salary-by-developer-type)进行了细分。

### 全球

1. 全栈工程师 $57k  
2. 后端工程师 $56k  
3. 前端工程师 $52k

### 美国

1. 后端工程师 $116k  
2. 全栈工程师 $110k  
3. 前端工程师 $103k

此外，它还[根据技术](https://insights.stackoverflow.com/survey/2019#top-paying-technologies)细分了薪资。下面是每项调查的样本。

### 全球

* Clojure $90k
* Go $80k
* Python $63k
* Swift $59k
* JavaScript $56k
* HTML/CSS $55k

### 美国

* Scala $143k
* Clojure $139k
* Go $136k
* Swift $120k
* Python $116k
* JavaScript $110k
* HTML/CSS $105k

需要注意的是，这些工资和趋势可能会因你的工作地点和是否在寻找远程工作而有所不同。因此，你需要自己做好调查。这很简单，只需要查看求职公告板并搜索后端和前端技术，看看都有哪些。

## 我为什么选择后端

我想我应该在这里加上一段为什么我最终选择了后端，希望它可以在其他人做决定时帮助他们。当我转行成为一名开发人员时，我寻求工作满足感，并决定开始跨整个工作栈。在真正转向后端之前，我做了 3 年的全栈开发。吸引我来到后台的是 Ruby 的简洁。JavaScript 和前端语言对我来说总是缺乏组织性。我还热衷于优化代码性能。我喜欢想办法让事情运行得更好更快。后端似乎给了我更多的机会。

最后，我不是一个非常注重视觉或艺术的人。有些人可以看看网页，然后想办法把它放在什么地方。我从来都不擅长这个，所以后端让我更自然、更舒服。

如果你想深入了解其他人的观点，请查看这个讨论前端和后端 Web 开发的 [CodeNewbie Chat](https://wakelet.com/wake/7d71f467-89ba-49cb-a196-4e32657369ac)。你还可以查看周二开始的 dev.to thread，我将会询问人们如何选择在前端还是后端工作以及其原因。

[Frontend vs Backend, which do you prefer and why?](https://dev.to/molly_struve/frontend-vs-backend-which-do-you-prefer-and-why-5a9e)

## 没有什么是永恒的

无论你决定专注于什么，要知道没有什么是永恒的。如果你走错了一条路，你总是可以悬崖勒马的。软件工程的一个伟大之处在于，它把所有的东西都整合在一起。了解一个领域只会帮助你的成长并在另一个领域做得更好。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
