> * 原文地址：[眼动追踪和移动世界的最佳用户体验实践](https://medium.com/nyc-design/eye-tracking-and-the-best-ux-practices-in-the-mobile-world-a101f67f20dd)
> * 原文作者：[Naman Sehgal](https://medium.com/@sehgal.naman)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/eye-tracking-and-the-best-ux-practices-in-the-mobile-world.md](https://github.com/xitu/gold-miner/blob/master/TODO1/eye-tracking-and-the-best-ux-practices-in-the-mobile-world.md)
> * 译者：[Charlo](https://github.com/Charlo-O?tab=repositories)
> * 校对者：[Long Xiong](https://github.com/xionglong58)、[PingHGao](https://github.com/PingHGao)

# 眼动追踪和移动世界的最佳用户体验实践

![](https://imgkr.cn-bj.ufileos.com/2c668962-2d6a-4f85-96a0-5b3485f64c45.jpeg)

在当今世界，可用性测试对于设计用户友好的界面至关重要。这些测试采用不同的形式和方法来帮助设计师发现可用性问题。这在把握设计期望和用户行为之间的关系时至关重要。诸如眼动追踪一类的以传感器为基础的技术，在深入了解用户如何与技术交互方面具有革命性意义。

眼动追踪是一种可用方法和工具，它可以在给定的界面上显示用户的焦点和访问模式。它能够为设计者提供详尽反馈，界面哪些元素能够吸引用户的眼球。它还可以有效地评估设计/内容层次结构。眼动追踪是一种很有洞察力的研究技术，它决定了用户的关注焦点和用户的注意力。

![](https://imgkr.cn-bj.ufileos.com/56680bdb-32e8-491f-9990-a041a6a7818b.jpeg)

## 移动互联网中的眼动追踪

考虑到超过 80% 的人口可以使用移动设备，移动互联网的使用率正在超过传统计算平台。今天的世界是以移动为中心的。因此，关注移动设备的可用性非常重要。

用户体验专家珍妮弗·罗曼诺·伯格斯特伦(Jen Romano Bergstrom)进行了一项研究，利用眼动追踪技术，在多个设备之间比较同一界面的用户体验。结果，她在不同的设备上发现了不同的问题。下面是数据的热点图。红点是主要的焦点，绿色和黄色是用户关注较少的区域。很明显，用户在不同的设备上对相同的界面有不同的关注点。

![**Image from Jen Romano Bergstrom’s eye-tracking research**](https://imgkr.cn-bj.ufileos.com/00330430-8823-4131-ae2f-50f3e6a5954c.jpeg)

## 移动设备的最佳用户体验实践

史蒂夫·克鲁格（Steve Krug）是一名信息架构师和用户体验专家，以著作《点石成金 —— 访客至上的网页设计秘笈法》闻名。他在书中提到，用户在采取行动前会先看。在仔细选择和点击其他链接之前，会先阅读文本。事实上，人们并不是什么都看，他们只是看他们想看的。这是一个重大突破，它强化了可用性工具(如眼动追踪设备)的重要性。

![**图片源自史蒂夫·克鲁格的著作 ——《点石成金 —— 访客至上的网页设计秘笈法》**](https://imgkr.cn-bj.ufileos.com/5fef551e-8671-4dae-9d1d-db1b95243746.jpeg)

珍妮弗·罗曼诺·伯格斯特伦(Jen Romano Bergstrom)解释了一些最佳用户体验实践的关键准则，每个用户体验专家都应该遵循。这些准则是在进行了几次眼动跟踪研究后起草的。

**1、跨设备的功能图标**

>图标和图像应该像用户希望的那样，能在不同的设备下被点击，从而产生交互。让主页上的元素可点击将使网页更直观。 

**2、清晰而准确的错误信息**

如果出现一个错误消息，它应该解释这个错误消息与什么有关。下面是 Jen 研究中的一个例子。在左侧，弹出一个错误消息。但是，尚不清楚应填写哪个必填字段。右边是用户的注视图。用户试图在整个屏幕上搜索剩下的必填字段。因此，错误消息应该清楚地指出问题所在，便于用户快速进行下一步操作。

![**图片源自珍妮弗·罗曼诺·伯格斯特伦的眼动跟踪研究**](https://imgkr.cn-bj.ufileos.com/fd2bac1b-49f5-4b2c-9f18-5027fc434148.png)

**3、统一页面布局**

请记住，用户可以访问多个设备，一个界面的布局应该在各种移动设备之间保持一致。信息流应该保持不变，因为好的设计可以在所有平台上为用户提供一致的心智模型。

##  结论

尽管眼动追踪是一个耗时且昂贵的过程，但它是一种非常有用的技术，可以让你对特定产品有更深刻的了解。就移动设备中眼球追踪的使用而言，这一领域还有很多值得探索的地方。遵循这些建议的 UX 实践将极大地改善用户体验。

## 参考文献

[http://bit.ly/2AGPlkz](http://bit.ly/2AGPlkz)

[https://www.slideshare.net/JenniferRomanoBergstrom/eye-tracking-the-ux-of-mobile-what-you-need-to-know](https://www.slideshare.net/JenniferRomanoBergstrom/eye-tracking-the-ux-of-mobile-what-you-need-to-know)

[https://www.youtube.com/watch?v=JfzTevZZ-z0&t=326s](https://www.youtube.com/watch?v=JfzTevZZ-z0&t=326s)

Don’t Make Me Think, Steve Krug, 2006

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
