> * 原文地址：[Every single Machine Learning course on the internet, ranked by your reviews](https://medium.freecodecamp.org/every-single-machine-learning-course-on-the-internet-ranked-by-your-reviews-3c4a7b8026c0)
> * 原文作者：[David Venturi](https://medium.freecodecamp.org/@davidventuri?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/every-single-machine-learning-course-on-the-internet-ranked-by-your-reviews.md](https://github.com/xitu/gold-miner/blob/master/TODO1/every-single-machine-learning-course-on-the-internet-ranked-by-your-reviews.md)
> * 译者：[davelet](https://github.com/davelet)
> * 校对者：[Ivocin](https://github.com/Ivocin), [lsvih](https://github.com/lsvih)

# 基于评论的机器学习在线课程排名

![](https://cdn-images-1.medium.com/max/2000/1*vBLkfW8S-ZqHb8TmNEW1XA.jpeg)

_Kaboompics_ **的[木头人](https://www.pexels.com/photo/wooden-robot-6069/)**

一年半以前，我退出了加拿大最好的计算机科学课程之一，开始使用线上资源创建我自己的[数据科学研究生课程](https://medium.com/@davidventuri/i-dropped-out-of-school-to-create-my-own-data-science-master-s-here-s-my-curriculum-1b400dcee412#.5fwwphdqd)。我意识到只要通过 edX、Coursera 和 Udacity 就能学到所有我需要的东西，而且学习得更快更高效，学费还比大学低！

现在我马上就完成了！我学习了很多数据科学相关的课程而且评估了更多课程的部分内容。我知道了如何选择，也知道了什么技能对于打算成为数据分析师或者数据科学家的学员是必需的。所以我创建了一个评论驱动的指南，该指南推荐了数据科学领域内各学科最好的课程。

在本系列的第一篇指南中我给刚入门的数据科学家们先推荐一些[编码课程](https://medium.freecodecamp.com/if-you-want-to-learn-data-science-start-with-one-of-these-programming-classes-fb694ffe780c#.42hhzxopw)，然后是[概率统计课程](https://medium.freecodecamp.com/if-you-want-to-learn-data-science-take-a-few-of-these-statistics-classes-9bbabab098b9#.p7pac546r)，然后是[数据科学概论](https://medium.freecodecamp.com/i-ranked-all-the-best-data-science-intro-courses-based-on-thousands-of-data-points-db5dc7e3eb8e)，还有[数据可视化](https://medium.freecodecamp.com/an-overview-of-every-data-visualization-course-on-the-internet-9ccf24ea9c9b)。

### 欢迎来到机器学习

我为了这篇指导花费了十几个小时尝试找出截至到 2017 年 5 月的所有在线课程，从这些课程的摘要和评论中提取了关键信息，并搜集了它们的评分。**我最终的目标本来是找出最好的三门课程呈现出来以飨读者。**

为了实现这个目标，我特意到开源社区 Class Central，它的数据库中有数以千计的课程评分和评论。

![](https://cdn-images-1.medium.com/max/1000/1*u1dxHyShejSN3cgXGFQIAA.png)

*Class Central* **的[主页](https://www.class-central.com/)**。

自从 2011 年起，[Class Central](https://www.class-central.com/) 的创始人 [Dhawal Shah](https://medium.com/@dhawalhs) 可以毫无争议地说比世界上其他任何人都更加关注在线课程。Dhawal 个人也帮我一起收集了这个资源列表。

### 我们如何甄选课程

每一门课程都必须满足如下三条准则：

1.  **必须包含大量的机器学习内容**。原则上机器学习应该是首要主题。注意，只涉及深度学习的课程应该被排除，后面会详述。
2.  **必须按需或每隔几个月提供一次。**
3.  **必须是可交互的在线课程，不能使用书本或只读的指南**。尽管那些也是学习的途径，但是这里只关注课程。完全的视频教程（也就是说没有测验或课后作业等）也要排除。

我相信我们已经包含了所有符合上述准则值得关注的课程。[Udemy](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14494&RD_PARM1=https%253A%252F%252Fwww.udemy.com%252F) 上面有几百门课程，我们只选择其中留言最多、评分最高的课程。

不过由于精力有限，一定还是有可能我们会忽略掉某课程的。如果你发现我们漏掉了一门好课程，请在评论区留言让我们知道。

### 我们如何评估课程

我们从 Class Central 以及其他点评网站汇集了每门课程的平均评分和评论的数量，以此来计算它们的加权平均分。我们阅读了文字评论，通过那些课程反馈来补充分数。

我们根据三个因素进行了教学大纲的主观判断：

1.  **对机器学习工作流程的解释程度**。课程是否描绘了成功运行一个 ML 工程的必要步骤？ 有关典型工作流程的含义，请参阅下一节。
2.  **对机器学习技术和算法的覆盖程度**。是否涉及了各种技术（例如回归、分类、聚类等）和相关算法（比如分类算法：朴素贝叶斯、决策树、支持向量机等），还是只简单挑选了几个？我们更倾向没有省略细节的、覆盖更多机器学习技术和算法内容的课程。
3.  **对通用数据科学和机器学习工具的使用程度**。课程教学上是否使用了流行的编程语言，比如 Python、R 或 Scala？对这些语言的流行类库使用如何？这些当然不是必需的但是是有用的，所以对这些课程我们略有偏好。

### 什么是机器学习？工作流程如何？

一个流行的定义起源于 1959 年 [Arthur Samuel](https://en.wikipedia.org/wiki/Arthur_Samuel "Arthur Samuel") 的说法：机器学习是计算机科学的一个分支，能够“**让计算机自主学习而无需显式编程**”。实践中，这意味着开发的计算机程序可以根据数据进行预测。就像人类可以根据经验学习一样，计算机也可以。对于计算机，数据 = 经验。

机器学习工作流程是执行机器学习项目所需的过程。尽管单个项目可能不同，但是绝大多数工作流程都需要这么几个通用任务：问题评估，数据探索，数据预处理，模型训练、测试、部署，等等。下面你会看到这些核心步骤有用的可视化展示：

![](https://cdn-images-1.medium.com/max/1000/1*KzmIUYPmxgEHhXX7SlbP4w.jpeg)

[UpX Academy](https://upxacademy.com/introduction-machine-learning/) 提供的典型机器学习工作流程核心步骤

理想的课程能够介绍完整的过程并提供交互式的例子、课后作业、小测试，学员们能自己完成每个任务。

### 这些课程包含了深度学习吗？

首先咱们来定义一下深度学习。简洁点的定义是：

> “深度学习是机器学习的一个分支，关注的是受大脑结构和功能启发的人工神经网络算法。”

> — Jason Brownlee，来自[掌握机器学习](http://machinelearningmastery.com/what-is-deep-learning/)

可能如你所希望的，我们的课程正好有一些包含了深度学习的内容。但我是没有选择那些只包含深度学习的课程的。如果你就是对深度学习感兴趣，我们建议你学习一下下面的[文章](https://medium.freecodecamp.com/dive-into-deep-learning-with-these-23-online-courses-bf247d289cc0)：

* [在线 12 课深入理解深度学习：每天都有关于深度学习如何改变我们周围世界的头条。几个例子：](https://medium.freecodecamp.com/dive-into-deep-learning-with-these-23-online-courses-bf247d289cc0 "https://medium.freecodecamp.com/dive-into-deep-learning-with-these-23-online-courses-bf247d289cc0")

列表里面我最推荐的 TOP 3 是：

*   **[使用 TensorFlow 编写深度学习创意应用](https://www.class-central.com/mooc/6679/kadenze-creative-applications-of-deep-learning-with-tensorflow)**，Kadenze
*   **[用于机器学习的神经网络](https://www.class-central.com/mooc/398/coursera-neural-networks-for-machine-learning)**，多伦多大学 (Geoffrey Hinton执教) 发布于 Coursera
*   **[深度学习 A-Z™：手把手教你写人工神经网络](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fdeeplearning%2F)**，Kirill Eremenko，Hadelin de Ponteves 和 SuperDataScience Team 发布于 Udemy

### 推荐的先修课程

下面列出的一些课程要求学员有编程、微积分、线性代数和统计学经验。鉴于机器学习是一门高级学科，这些先修课程是可以理解的。

有些科目不懂？好消息！其中一些经验可以通过我们在头两篇关于“数据科学生涯指导”的推荐文章（[编程](https://medium.freecodecamp.com/if-you-want-to-learn-data-science-start-with-one-of-these-programming-classes-fb694ffe780c#.ld31z08y5), [统计学](https://medium.freecodecamp.com/if-you-want-to-learn-data-science-take-a-few-of-these-statistics-classes-9bbabab098b9)）中学习到。下面的几个顶级课程还提供了简单的微积分和线性代数复习，并着重突出了与那些不太熟悉的机器学习最相关的方面。

### 我们甄选的最佳机器学习课程是……

*   [机器学习](https://www.class-central.com/mooc/835/coursera-machine-learning)，斯坦福大学发布于 Coursera

斯坦福大学发布在 Coursera 的[机器学习](https://www.class-central.com/mooc/835/coursera-machine-learning)在评分、评论和大纲匹配上是目前最明确的赢家。课程由著名的 Andrew Ng 讲授，他是 Google 大脑的创始人，[百度](https://en.wikipedia.org/wiki/Baidu)的前首席科学家。这是促成了 Coursera 成立的课程。它有 422 条评论，加权平均得分 4.7 星。

这门课程发布于 2011 年，涵盖了机器学习工作流程的所有方面。尽管它比自身基于的最初的斯坦福大学课程范围小了一点，依然成功包含了大量的技术和算法。预估的时间是 11 周，包括两周的神经网络和深度学习。课程还提供了免费版和收费版两种选择。

Ng 是一位有活力而又温柔的导师，而且经验丰富。他激励自信，尤其是在分享实际实施技巧和常见陷阱警告的时候。他帮助学员复习线性代数并强调与机器学习最相关的微积分知识。


课程评价由每节课后的多项选择测验和编程作业自动完成。这些作业（一共有八次）可以使用 MATLAB 或 Octave 完成，后者是 MATLAB 的一个开源版本。Ng 常解释他对语言的选择：

> 以前我总是尝试使用各种不同的语言讲授机器学习，包括 C++、Java、Python 和 NumPy，当然还有 Octave，等等。在我教了十年机器学习之后我发现使用 Octave 做为编程环境会让你学得最快。

尽管 Python 和 R 在 2017 年有着[上升的人气](http://blog.codeeval.com/codeevalblog/2016/2/2/most-popular-coding-languages-of-2016)，似乎更引人注目，评论家们注意到那不应该阻止你学习这门课。

一些着名评论家注意到以下内容：

> 作为 MOOC 世界中长期以来的知名课程，斯坦福大学的机器学习确实是这一主题的权威介绍。该课程广泛涵盖了机器学习的所有主要领域。Ng 教授在每个部分之前都有激励性的讨论和例子。

> Andrew Ng 是一位有天赋的老师，能够以相当直观清晰的方式解释复杂主题，包括概念后面的数学原理。强烈推荐！

> 我看这门课的唯一问题是，它是否为其他课程设置了太高的期望值。

![](https://cdn-images-1.medium.com/max/800/1*viCB-ayFFQi-4Fs_NYLVVQ.png)

* YouTube 视频链接：https://youtu.be/e0WKJLovaZg

Andrew Ng 的[机器学习](https://www.class-central.com/mooc/835/coursera-machine-learning)课程预览视频。

### 一门由杰出教授讲授的常春藤大学课程

*   [机器学习](https://www.class-central.com/mooc/7231/edx-machine-learning)（哥伦比亚大学发布于 edX ）

哥伦比亚大学的[机器学习](https://www.class-central.com/mooc/7231/edx-machine-learning)是他们发布在 edX 上的《人工智能微硕士》（Artificial Intelligence MicroMasters）课程的一个相当新的部分（**译者注**：《微硕士》课程是由 edX 推出的一系列在线研究生课程，可以用来学习职业发展的独立技能或从各自大学获得研究生同等学力证书，相当于一个完整硕士学位的学期）。尽管它太新了还没有太多的评论，但是已有的评论却异常给力。授课教授 John Paisley 以杰出、授课简杰、聪明而闻名。这门课程有 10 条评论，加权平均得分 4.8 星。

这门课程覆盖了机器学习工作流程的全部方面，而且在算法上比上面的斯坦福课程还多。哥伦比亚的课程是更加高阶的入门课程，评论中有提到说学员需要很熟悉我们前面推荐的先修课程：微积分、线性代数、统计学、概率论和编程。

它的毕业评估由 11 次测验、4 次编程作业和期末考试组成。学员们可自行选择 Python、Octave 或 MATLAB 完成作业。课程的总预计时长是 12 周，每周 8 到 10 课时。课程本身是免费的，不过提供认证证书可供购买。

下面是一些上文提到的课程的高质量[评论](https://www.coursetalk.com/providers/edx/courses/machine-learning-5)：

> 在当学生的这些年，我经历了各种教授：不够杰出的教授、自身杰出但是授课能力一般的教授、杰出而又擅长授课的教授。Paisley 博士就属于第三种。

> 这门课太棒了！老师的语言太精准了，在我看来这也是这门课最突出的亮点之一。课程质量很高，PPT 也超棒。

> Paisley 博士和他的导师都是机器学习之父迈克尔·乔丹的学生。Paisley 博士因为授课清晰成为哥伦比亚大学最好的 ML 教授。这个学期有将近 240 个学生选他的课，这个数字是哥伦比亚大学所有讲授机器学习的教授中最大的。

![](https://cdn-images-1.medium.com/max/800/1*q4Qa-kxC6MXFwct_9635ug.png)

* YouTube 视频链接：https://youtu.be/mANw77caYSI

哥伦比亚大学发布于 edX 的《微硕士》课程预览视频。[机器学习](https://www.class-central.com/mooc/7231/edx-machine-learning)课程简介开始于大约 1:00。

### 来自工业专家的 Python 和 R 实用简介

*   [机器学习 A-Z™：手把手教你用 Python 和 R 实战数据科学](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fmachinelearning%2F)（Kirill Eremenko，Hadelin de Ponteves 和 SuperDataScience Team 发布于 Udemy）

发布于 Udemy 的[机器学习 A-Z™](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fmachinelearning%2F) 课程的详细程度让人印象深刻，它同时提供了 Python 和 R 的实现用法。这是罕见的，其他任何顶级课程也不会有这种评价。它的评论数是在我们推荐课程中最高的，高达 8119 条，得到 4.5 星的加权平均得分。

它覆盖了全部的机器学习工作流程，还通过 40.5 小时的按需视频教程提供了数量近乎荒谬（好的那种）的算法讲解。这门课比上面两门课更实用，数学要求也低。每个部分都以 Eremenko 的“直觉”视频开始，视频中总结了将被讲授的概念中的重要理论。然后 de Ponteves 会通过一些分开的视频讲述如何通过 Python 和 R 实现出来。

一个“福利”是这门课程包含了 Python 和 R 的代码模版供学员下载以便在他们自己的项目中使用。课程也提供了测验和家庭作业挑战，不过不是这门课程的有力得分点。

Eremenko 和 SuperDataScience team 最受学员爱戴的是他们有能力“把复杂的事情搞简单”。此外，这门课程先修课程的要求也“只是一些高中数学”，所以对于被斯坦福和哥伦比亚课程难倒的学员可能是较好的选择。

一些突出的评论者[强调了](https://www.udemy.com/machinelearning/#reviews)以下内容：

> 这门课是专业出品，音质棒极了，释义也特别简洁清晰。你金钱和时间的投资绝对有难以估量的回报。

> 在一门课中同时用两种语言学习简直太令人惊叹了。

> Kirill 绝对是 Udemy 上最好的老师之一（如果不是在网上），我推荐他讲的所有课程。这门课有丰富的内容，丰富到爆！

![](https://cdn-images-1.medium.com/max/800/1*gl_KL2hhIkodQpznSzu8ZA.png)

* YouTube 视频链接：https://youtu.be/JbuYJTbmYEk

[机器学习 A-Z™](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fmachinelearning%2F) 的预览视频。

### 比拼

我们的首选课程通过 422 条评论得到了 4.7 星的加权平均得分。我们看一下其他可选课程，以分值降序排列。再次提醒：纯粹深度学习的课程不包含在这篇指导里（那些课程可以在[这里](https://medium.freecodecamp.com/dive-into-deep-learning-with-these-23-online-courses-bf247d289cc0)查看）。

[《走近数据分析》](https://www.class-central.com/mooc/1623/edx-the-analytics-edge)（麻省理工学院于 edX）：更关注一般分析，虽然也有一些机器学习主题；使用 R 语言；使用我们熟悉的现实世界的例子进行强悍的表述；有挑战；12 周，每周 10 到 15 学时；可自愿购买经过认证的证书；有 214 条评论，加权平均得分 4.9 星。

* YouTube 视频链接：https://youtu.be/1BMSOBCe07k

这门麻省理工学院梦幻课程的推广视频：[走近数据分析](https://www.class-central.com/mooc/1623/edx-the-analytics-edge)。

[《数据科学和机器学习 Python 训练营》](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fpython-for-data-science-and-machine-learning-bootcamp%2F)（何塞波蒂利亚大学于 Udemy）：包含了完整数据科学流程的内容，有大块的机器学习内容；更详细的 Python 入门；优秀的课程，不过不在本文的理想课程内容范畴；21.5 小时的按需视频；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见；有 3316 条评论，加权平均得分 4.6 星。

[《数据科学和机器学习 R 训练营》](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fdata-science-and-machine-learning-bootcamp-with-r%2F)（何塞波蒂利亚大学于 Udemy）：上面对波蒂利亚大学课程的评价同样适用于此，只不过语言换成 R；17.5 小时的按需视频；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见；有 1317 条评论，加权平均得分 4.6 星。

[《机器学习系列课程》](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fuser%2Flazy-programmer%2F)（Lazy Programmer 公司于 Udemy）：由具有不凡工作经验的数据科学家、大数据工程师、全栈软件工程师讲授；Lazy Programmer 目前在 Udemy 有 16 门聚焦机器学习的课程；总体上看，课程由 5000+ 评分，基本都在 4.6 星以上；每门课的描述中都有一个有用的课程排序；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见。

[《机器学习》](https://www.class-central.com/mooc/1020/udacity-machine-learning)（佐治亚理工学院于 Udacity）：三门独立课程组合而成：监督学习、无监督学习和强化学习；是该网站机器学习工程师 Nanodegree 和该校在线硕士学位（OMS）的一部分；信息量刚好可消化的视频大小正是 Udacity 的风格；友好的教授们；估计 4 个月可毕业；免费；9 条评论，4.56 星。

[《在 Azure HDInsight 中使用 Spark 实现预测分析》](https://www.class-central.com/mooc/4151/edx-implementing-predictive-analytics-with-spark-in-azure-hdinsight)（微软与 edX）：介绍了机器学习的核心概念和一些算法；利用了一些大数据友好的工具，包括 Apache Spark、 Scala 和 Hadoop；Python 和 R 都用到了；预计 6 周，每周 4 课时；可自愿购买经过认证的证书；有 6 条评论，4.5 星。

[《使用 Python 学习数据科学和机器学习：手把手教你！》](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fdata-science-and-machine-learning-with-python-hands-on%2F)（Frank Kane 于 Udemy）：使用 Python；Kane 在亚马逊公司和 IMDb有 9 年工作经验；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见；有 4139 条评论，4.5 星。

[用于大数据和机器学习的 Scala 和 Spark 技术](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fscala-and-spark-for-big-data-and-machine-learning%2F)（何塞波蒂利亚大学于 Udemy）：关注“大数据”，尤其是使用 Scala 和 Spark 实现；10 小时的按需视频；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见；607 条评论，4.5 星。

[机器学习工程师 Nanodegree](https://www.class-central.com/certificate/machine-learning-engineer-nanodegree--nd009)（Udacity）：Udacity 的旗舰机器学习课程，这种课程具有一流的项目评审系统和职业支持；该课程由几个都是免费的独立课程组成；与 Kaggle 联合创建；预计 6 个月学完；目前是每月 199 美元，12 个月之内毕业可享受 50% 的学费退款；2 条评论，4.5 星。

[《从数据中学习（机器学习介绍）》](https://www.class-central.com/mooc/1240/edx-learning-from-data-introductory-machine-learning)（加州理工学院于 edX）：课程报名当前在 edX 上关闭了，不过依然可以通过 CalTech 的独立平台报名（见下面）；42 条评论，4.49 星。

* YouTube 视频链接：https://youtu.be/KlP0DpiM7Lw

Caltech 和 Yaser Abu-Mostafa 的[从数据中学习](https://www.class-central.com/mooc/366/learning-from-data-introductory-machine-learning-course)介绍视频。

[《从数据中学习（机器学习介绍）》](https://www.class-central.com/mooc/366/learning-from-data-introductory-machine-learning-course)（Yaser Abu-Mostafa 于加州理工学院）：“真正的 Caltech 课程，不是阉割版”；评论强调它在理解机器学习理论上很优秀；Yaser Abu-Mostafa 教授在学生中很流行，还写了这门课使用的教科书；上传到油管的视频是上课录音（带有 PPT 的画中画功能），家庭作业是 PDF 文件；学生在线学习的课程体验并不如 TOP 3 推荐那么精彩；7 条评论，4.43 星。

[《海量数据集挖掘》](https://www.class-central.com/mooc/2406/stanford-openedx-mining-massive-datasets)（斯坦福大学）：关注“大数据”的机器学习课程；介绍了现代分布式文件系统和 MapReduce；7 周，每周 10 小时；免费；30 条评论，4.4 星。

[《AWS 机器学习：使用 Python 的完整指导》](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Faws-machine-learning-a-complete-guide-with-python%2F)（Chandra Lingam 于 Udemy）：唯一关注基于云端的机器学习课程，尤其是 Amazon Web Service。使用 Python；9 小时按需视频；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见；62 条评论，4.4 星。

[《机器学习介绍和使用 Python 进行面部识别》](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Fintroduction-to-machine-learning-in-python%2F)（Holczer Balazs 于 Udemy）：使用 Python；8 小时按需视频；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见；162 条评论，4.4 星。

[《StatLearning：统计学习》](https://www.class-central.com/mooc/1579/stanford-openedx-statlearning-statistical-learning)（斯坦福大学）：基于超优秀的教科书[《统计学习入门，使用 R 程序》](https://www.amazon.com/Introduction-Statistical-Learning-Applications-Statistics-ebook/dp/B01IBM7790)并由编写书的教授上课；评论说 MOOC 引用了书中“薄弱”的练习和平庸的视频，没有书好；9 周，每周 5 课时；免费；84 条评论，4.35 星。

[《机器学习规范》](https://www.class-central.com/certificate/machine-learning-specialization)（华盛顿大学于 Coursera）：超棒的课程，可惜最后两课（包括顶点课程）被删掉了（**译者注**：顶点课程是美国大学开设在实用性很强的专业中让学生整合所学领域的知识并充分利用的课程）；评论说该系列课程比那些顶级机器学习课程 —— 也就是斯坦福和 Caltech 的 —— 更容易消化（对那些没有很强工科背景的学员来说）；记住该课程在推荐系统和深度学习上并不完整，还缺少课程总结；有免费和收费版本；80 条评论，4.31 星。

![](https://cdn-images-1.medium.com/max/1000/1*fgFqV9nyUKHi7txzgKcW4w.png)

Coursera 上华盛顿大学正在上这门[《机器学习规范》](https://www.class-central.com/certificate/machine-learning-specialization)。

[《从 0 到 1：机器学习和NLP，使用 Python 切入正题》](https://click.linksynergy.com/fs-bin/click?id=SAyYsTvLiGQ&subid=&offerid=323058.1&type=10&u1=medium-career-guide-machine-learning&tmpid=14538&RD_PARM1=https%3A%2F%2Fwww.udemy.com%2Ffrom-0-1-machine-learning%2F)（Loony Corn 于 Udemy）：“一种脚踏实地，害羞但自信的机器学习技巧”；由具有数十年工业经验的四人小组授课；使用 Python；价格根据 Udemy 账户级别进行折扣，这在 Udemy 很常见；494 条评论，4.2 星。

[《机器学习的原则》](https://www.class-central.com/mooc/6511/edx-principles-of-machine-learning)（微软于 edX）：使用 R、Python 和 微软 Azure 机器学习工具；是微软数据科学专业课程认证的一部分；6 周，每周 3-4 小时；可自愿购买经过认证的证书；11 条评论，4.09 星。

[《大数据：统计推断与机器学习》](https://www.class-central.com/mooc/5421/futurelearn-big-data-statistical-inference-and-machine-learning)（昆士兰科技大学于 FutureLearn）：一门聚焦于大数据、漂亮而又简洁的机器学习探索课程；覆盖了诸如 R、H20 流和 WEKA 等工具；推荐三周就学完，每周 2 课时；有免费和收费版本；4 条评论，4 星。

[《基因组数据科学与聚类》](https://www.class-central.com/mooc/3556/coursera-genomic-data-science-and-clustering-bioinformatics-v)（生物信息学第五部）（加利福尼亚大学和 San Diego 于 Coursera）：面向对计算机科学和生物学的交叉学科感兴趣的人，并展示这门交叉学科如何代表现代科学的重要前沿；关注聚类和数据降维；加州大学圣地亚哥分校（UCSD）生物信息学专业的一部分；有免费和收费版本；3 条评论，4 星。

[《机器学习简介》](https://www.class-central.com/mooc/2996/udacity-intro-to-machine-learning)（Udacity）：在深度和理论上优先考虑学习宽度和实用工具主题（使用 Python）；两位老师 —— Sebastian Thrun 和 Katie Malone —— 让课程充满趣味；课程视频是刚好能够消化的大小；每节课的小项目后面都有测验；目前是 Udacity 数据分析师纳学位的一部分（**译者注**：纳学位，或者说 Nanodegree，是优达学院和企业推出的系列联合认证课程,一般可在 12 个月内结业。“纳”模仿自“微学院”中的“微”，都表示模仿自高校。“纳”和“微”都是度量单位，“纳”比“微”更小）；估计 10 周；免费；19 条评论，3.95 星。

* YouTube 视频链接：https://youtu.be/lL16AQItG1g

Sebastian Thrun 和 Katie Malone 讲授的 Udacity [《机器学习简介》](https://www.class-central.com/mooc/2996/udacity-intro-to-machine-learning)介绍视频。

[《用于数据分析的机器学习》](https://www.class-central.com/mooc/4354/coursera-machine-learning-for-data-analysis)（卫斯理大学于 Coursera）：对机器学习及几个选择算法的简单介绍；覆盖决策树、随机森林、LASSO 回归和 K 均值聚类；是卫斯理大学数据分析和解释专业的一部分；估计 4 周；有免费和付费版本；5 条评论，3.6 星。

[《数据科学：使用 Python 编程》](https://www.class-central.com/mooc/6471/edx-programming-with-python-for-data-science)（微软于 edX）：微软和 Coding Pojo 联合出品；使用 Python；6 周，每周 8 小时；有免费和付费版本；37 条评论，3.46 星。

[《用于交易的机器学习》](https://www.class-central.com/mooc/1026/udacity-machine-learning-for-trading)（佐治亚科技大学于 Udacity）：专注于将概率机器学习方法应用于交易决策；使用 Python；是 Udacity 机器学习工程师纳学位和佐治亚科大在线硕士学位（OMS）的一部分；估计 4 个月；免费；14 条评论，3.29 星。

[《实用机器学习》](https://www.class-central.com/mooc/1719/coursera-practical-machine-learning)（约翰霍普金斯大学于 Coursera）：简洁、实用的介绍了一些机器学习算法；一些一星二星的评论表达了对课程的各种担忧；是该校数据科学专业的一部分；4 周，每周 4-9 小时；有免费和收费版本；37 条评论，3.11 星。

[《用于数据科学和数据分析的机器学习》](https://www.class-central.com/mooc/4912/edx-machine-learning-for-data-science-and-analytics)（哥伦比亚大学于 edX）：介绍了机器学习的广泛主题；一些负面评论对课程内容的选择、缺少编程作业和缺乏有灵感的展示提出了担忧；超过 5 周，每周 7-10 小时；36 条评论，2.74 星。

[《推荐系统规范》](https://www.coursera.org/specializations/recommender-systems)（明尼苏达大学于 Cou）：重点关注了一种特定的机器学习类型 —— 推荐系统；4 节专业课加一节顶点课程，这是一个案例研究；使用 LensKit（推荐系统的一个开源工具集） 上课；有免费和收费版本；2 条评论，2 星。

[《使用大数据进行机器学习》](https://www.class-central.com/mooc/4238/coursera-machine-learning-with-big-data)（加利福尼亚大学和 San Diego 于 Coursera）：严重负面的评论突出了课程糟糕的教学和评估；一些评论说完成整个课程只需要几小时；是该校大数据专业的一部分；有免费和收费版本；14 条评论，1.86 星。

[《实用预测分析：模型和方法》](https://www.class-central.com/mooc/4341/coursera-practical-predictive-analytics-models-and-methods)（华盛顿大学于 Coursera）：对机器学习的核心概念进行了简单介绍；有条评论说课程没有测验，作业也没有挑战；是该校数据科学扩展专业的一部分；超过 4 周，每周 6 - 8 小时；有免费和收费版本；4 条评论，1.75 星。

下面是截止到 2017 年 5 月不超过一条评论的课程。

[《给音乐家和艺术家的机器学习》](https://www.class-central.com/mooc/3768/kadenze-machine-learning-for-musicians-and-artists)（Goldsmiths 和 伦敦大学于 Kadenze）：独一无二的课程；学员学习算法、软件工具和机器学习最佳实践来让机器识别人类手势、音频和其他实时数据；一共 7 课；有旁听（免费）和收费（每月 10 美元）版本；有一条 5 星评论。

* YouTube 视频链接：https://youtu.be/pSnRmBt0pXI

Kadenze 上 Goldsmiths 和伦敦大学[《给音乐家和艺术家的机器学习》](https://www.class-central.com/mooc/3768/kadenze-machine-learning-for-musicians-and-artists)的宣传视频。

[《应用机器学习（使用 Python）》](https://www.class-central.com/mooc/6673/coursera-applied-machine-learning-in-python)（密歇根大学于 Coursera）：使用 Python 和 scikit 学习工具集上课；是应用机器学习（使用 Python）专业的一部分；计划 5 月 29 号开课；有免费和收费版本。

[《应用机器学习》](https://www.class-central.com/mooc/6406/edx-applied-machine-learning)（微软于 edX）：使用了包括 Python、R 和微软 Azure 机器学习工具上课（注意：这是微软出品的课程）。包括动手实验室来强化课程内容；超过 6 周，每周 3-4 小时；可自愿购买经过认证的证书。

[《使用 Python 进行机器学习》](https://bigdatauniversity.com/courses/machine-learning-with-python/)（大数据大学）：使用 Python 上课；目标受众是入门者；预估 4 小时完成；大数据大学隶属于 IBM；免费。

[《使用 Apache SystemML 进行机器学习》](https://bigdatauniversity.com/courses/machine-learning-apache-systemml/)（大数据大学）：使用 Apache SystemML 上课，这是一种为大规模机器学习而设计的声明式语言；预估 8 小时完成；大数据大学隶属于 IBM；免费。

[《给数据科学的机器学习》](https://www.class-central.com/mooc/8216/edx-machine-learning-for-data-science)（加利福尼亚大学和 San Diego 于 edX）：要到 2018 年一月才开课；程序例子和作业都是 Python的，用的 Jupyter 教材（**译者注**：Jupyter 教材是一个开源的在线应用，用户可以自己制作教材并共享给别人）；10 周，每周 8 小时；可自愿购买经过认证的证书。

[《分析模型入门》](https://www.class-central.com/mooc/8217/edx-introduction-to-analytics-modeling)（佐治亚科技大学于 edX）：课程通告说使用 R 做为其首选语言；10 周，每周 5-10 小时；可自愿购买经过认证的证书。

[《预测分析：洞察大数据》](https://www.class-central.com/mooc/7645/futurelearn-predictive-analytics-gaining-insights-from-big-data)（昆士兰科技大学于 FutureLearn）：简述了一些算法；使用 Hewlett Packard Enterprise 的 Vertica Analytics 平台做为应用工具；开课时间还未公布；4 周，每周 2 小时；可自愿购买成就证书。

[《机器学习简介》](https://miriadax.net/web/introduccion-al-machine-learning)（西班牙电信大学于 Miríada X）：西语授课；覆盖了监督和无监督学习的机器学习简介；预估 4 周共 20 小时。

[《机器学习登堂入室》](https://www.dataquest.io/path-step/machine-learning)（Dataquest）：使用 Dataquest 的浏览器内置交互式平台通过 Python 上课；多个导引项目和一个你使用你自己数据构建的 “+” 项目；需要订阅。

* * *

下面的 6 门课程由 [DataCamp](https://www.datacamp.com/courses/topic:machine_learning?tap_a=5644-dce66f&tap_s=93618-a68c98) 提供。DataCamp 的混合授课风格使用了基于视频和文本并通过一个浏览器内置的代码编辑器穿插大量的例子；每门课都需要完整订阅。

![](https://cdn-images-1.medium.com/max/1000/1*eRUPgszpDHzEUpvXhFMeUg.png)

[DataCamp](https://www.datacamp.com/courses/topic:machine_learning?tap_a=5644-dce66f&tap_s=93618-a68c98) 提供了几门机器学习的课程。

[《机器学习简介》](https://www.datacamp.com/courses/introduction-to-machine-learning-with-r?tap_a=5644-dce66f&tap_s=93618-a68c98)（DataCamp）: 覆盖了分类算法、回归算法和聚类算法；使用 R；15 段视频，81 次练习，预估 6 小时。

[《使用 scikit-learn 进行监督学习》](https://www.datacamp.com/courses/supervised-learning-with-scikit-learn?tap_a=5644-dce66f&tap_s=93618-a68c98)（DataCamp）：使用 Python 和 scikit-learn；覆盖了分类算法和回归算法；17 段视频，54 次练习，预估 4 小时。

[《使用 R 进行非监督学习》](https://www.datacamp.com/courses/unsupervised-learning-in-r?tap_a=5644-dce66f&tap_s=93618-a68c98)（DataCamp）：简单介绍了通过 R 进行聚类和降维；16 段视频，49 次练习，预估 4 小时。

[《机器学习工具箱》](https://www.datacamp.com/courses/machine-learning-toolbox?tap_a=5644-dce66f&tap_s=93618-a68c98)（DataCamp）：讲授机器学习中的“大主意”；使用 R；24 段视频，88 次练习，预估 4 小时。

[《和专家一起机器学习：学校预算案例》](https://www.datacamp.com/courses/machine-learning-with-the-experts-school-budgets?tap_a=5644-dce66f&tap_s=93618-a68c98)（DataCamp）：是 DrivenData 上面的一个机器学习案例研究；涉及建造机器学习模型对学校的预算项自动分类；先修课程是 DataCamp 的课程《使用 scikit-learn 进行监督学习》；15 段视频，51 次练习，预估 4 小时。

[《使用 Python 进行非监督学习》](https://www.datacamp.com/courses/unsupervised-learning-in-python?tap_a=5644-dce66f&tap_s=93618-a68c98)（DataCamp）：使用 Python、scikit-learn 和 scipy 讲解了一些非监督学习的算法；课程最后是学员构造一个推荐系统来推荐流行音乐歌手；13 段视频，52 次练习，预估 4 小时。

* * *

[《机器学习》](http://www.cs.cmu.edu/~ninamf/courses/601sp15/index.html)（Tom Mitchell 和卡耐基梅隆大学）： 该校的研究生机器学习入门课程；它们的第二个研究生课程要求具备“统计机器学习”知识背景；在线发布带有练习题、家庭作业和期中考试（都有答案）的大学课程；还有一个 [2011 版](http://www.cs.cmu.edu/~tom/10701_sp11/)；卡耐基梅隆大学是学习机器学习最好的研究生学校，它有一个系专门研究 ML；免费。

[《统计机器学习》](https://www.class-central.com/mooc/8509/statistical-machine-learning)（Larry Wasserman 和卡耐基梅隆大学）：和本文其他高级课程一样；是卡耐基梅隆大学机器学习课程的后续课程；在线发布带有练习题、家庭作业和期中考试（都有答案）的大学课程；免费。

![](https://cdn-images-1.medium.com/max/1000/1*umqMeqC5Ch-kR1i4hPBTrw.png)

卡耐基梅隆大学是学习机器学习最好的研究生学校。[《机器学习》](http://www.cs.cmu.edu/~ninamf/courses/601sp15/index.html)和[《统计机器学习》](https://www.class-central.com/mooc/8509/statistical-machine-learning)都在线上可免费学习。

[《本科生机器学习》](http://www.cs.ubc.ca/~nando/340-2012/index.php)（Nando de Freitas 和不列颠哥伦比亚大学）：本科生的机器学习课程；上课被录像并和发布在课程网站的 PPT 一起放在了油管上；课程作业也一起上传了（不过没答案）；de Freitas 现在是牛津大学的全职教授，各个论坛都对他的教学能力表达了赞美；研究生版本也要（见下面）。

[Machine Learning](http://www.cs.ubc.ca/~nando/540-2013/lectures.html) (Nando de Freitas/University of British Columbia): A graduate machine learning course. The comments in de Freitas’ undergraduate course (above) apply here as well.

### 要结束了

本文是我们推荐最好在线课程来让你步入数据科学领域的六部分中的第五部分。我们的[第一部分](https://medium.freecodecamp.com/if-you-want-to-learn-data-science-start-with-one-of-these-programming-classes-fb694ffe780c#.fhrn45v3c)涵盖了编程课程，[第二部分](https://medium.freecodecamp.com/if-you-want-to-learn-data-science-take-a-few-of-these-statistics-classes-9bbabab098b9#.p7pac546r)是概率统计，[第三部分](https://medium.freecodecamp.com/i-ranked-all-the-best-data-science-intro-courses-based-on-thousands-of-data-points-db5dc7e3eb8e)是数据科学入门，[第四部分](https://medium.freecodecamp.com/an-overview-of-every-data-visualization-course-on-the-internet-9ccf24ea9c9b)是数据可视化。

* [**我基于数千个数据点对网络上的所有数据科学入门课程进行了排名**：一年以前，我退出了加拿大最好的计算机科学课程之一。](https://medium.freecodecamp.com/i-ranked-all-the-best-data-science-intro-courses-based-on-thousands-of-data-points-db5dc7e3eb8e "https://medium.freecodecamp.com/i-ranked-all-the-best-data-science-intro-courses-based-on-thousands-of-data-points-db5dc7e3eb8e")

最后一部分将会是前面部分的总结，加上其他主题的最好课程，如数据整理、数据库，甚至还有软件工程。

如果你在寻找数据科学在线课程的完整列表，可以来 Class Central 的[数据科学和大数据](https://www.class-central.com/subject/data-science)主题页面。

如果你读完了还欲罢不能，可以看一下 [Class Central](https://www.class-central.com/) 的其他主题：

* [**这里有 250 所常春藤联盟高校的在线课程现在**：250 门 MOOC 课程包括布朗大学、哥伦比亚大学、康内尔大学、达特茅斯大学、哈佛大学、宾夕法尼亚大学、普林斯顿大学和耶鲁大学。](https://medium.freecodecamp.com/ivy-league-free-online-courses-a0d7ae675869 "https://medium.freecodecamp.com/ivy-league-free-online-courses-a0d7ae675869")

* [**根据数据统计的 50 门最好的免费在线大学课程**：当我 2011 年十一月初创 Class Central 的时候只有大约 18 门免费在线课程，几乎都来自斯坦福大学。](https://medium.freecodecamp.com/the-data-dont-lie-here-are-the-50-best-free-online-university-courses-of-all-time-b2d9a64edfac "https://medium.freecodecamp.com/the-data-dont-lie-here-are-the-50-best-free-online-university-courses-of-all-time-b2d9a64edfac")

如果你对我遗漏的课程有建议，请回复我让我知道！

如果你觉得有帮助，点击 💚 会让更多 Medium 板块的用户看到本文。

**本文是我发布在 Class Central 的[原始文章](https://www.class-central.com/report/best-machine-learning-courses/)的缩减版，原文包含了详细的课程介绍。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
